/**
 * Created by 三宝爹
 *
 *  四则运算函数
 *
 */


import FU from './FuncUtil.js';
import Util from '../../util/Util.js';
import AJAX from '../../util/ajax.js';

var $rpc = AJAX.rpc;


/**
 * http://miikio.gitee.io/numgeneral.js/
 *
 * numGeneral  (数字一般化)
 *
 * Made by MiiKio (2020/5/12)
 *
 *
 * ---- numGeneral (val, mand, type)
 *
 *    * val  <输入文本> : 字符串 | 纯数字
 *      mand <检查多个数字> (默认fasle,多个数字时返回数组) : false | true
 *      type <输出类型> (空为自动选择,输出内容不带科学计数法时为数字类型,反之为字符串类型) : "string" | "number"
 *
 *      功能完整的代码函数，不限制字符数量。
 *      示例 “ numGeneral(12.345e+2) => 1234.5 ” “ numGeneral("www.123.4a.com/555#", true, "number") => [123.4, 555] ”
 *      注意：无数字的情况下返回原来的内容；当<mand>为"string"或"number" <type>不存在时，原<mand>将继承<type>的功能, 其它不变。
 *
 *
 * ---- Number.toGeneral()
 *
 *      嵌入进数字对象的通用法则。
 *      示例 “ 123.45e-2.toGeneral() => 1.2345 ” “ (520).toGeneral() => 520 ”
 *      注意：整数值需要用括号括起来再执行；NaN或Infinity则返回原值无法计算；输入数值过大或者过小有可能会返回Infinity；输入数值精度大于16位可能会省略掉后面的数值。
 *
 *
 * ---- String.toNumGeneral(mand, type)
 *
 *      对字符串对象进行函数包装后的通用法则，该功能需要有函数支持 numGeneral 或 Number.prototype.toGeneral 之一，指令与 numGeneral(val, mand, type) 同理。
 *      示例 “ ".987abc".toNumGeneral() => 0.987 ” “ "a1,b2,c3e2".toNumGeneral(true, "string") => ["1", "2", "300"] ”
 *
 */

function numGeneral (val, mand, type) {
    var matCheck = function (v) { return String(v).match(/^([\D\-(?!\d)\.(?!\d)]*?)((\-?\d*\.?\d+)((e|E)(\+|\-)?(\d+))?)(.*)$/) };
    var reVal = matCheck(val);
    if (reVal) {
        if (typeof mand == "string" && !type) type = mand;
        var reMatch = function (matchs) {
            var num = matchs[2], res = "", last = matchs[8] || "", isF = Number.isFinite || isFinite;
            if (type === "number") {
                return [Number(num), last];
            } else if (matchs[4]) {
                var p1 = "", p2 = "", pm = 1;
                if (num.indexOf("-") === 0) pm = 0, num = num.substr(1);
                num = num.replace(/^0+/, "").replace(/^\./, "0.");
                var dot = num.indexOf("."),
                    power = Number(matchs[7]) || 0,
                    ONnum = num.replace(/(e|E).+$/, "").replace(/(\.\d+?)0+$/, "$1").replace(/\.0+$|\./g, "");
                if (dot != -1) {
                    p1 = ONnum.substring(0, dot),
                        p2 = ONnum.substring(dot, ONnum.length);
                }
                if (matchs[6] == "-") {
                    if (dot == -1) {
                        ONnum = ONnum.replace(/^0+/, "");
                        if (power < ONnum.length) {
                            res = ONnum.substr(0, ONnum.length - power) + "." + ONnum.substr(-power);
                        } else {
                            for (var i = 0, le = power - ONnum.length; i < le; i++) ONnum = "0" + ONnum;
                            res = "0." + ONnum;
                        }
                    } else {
                        if (!(/[^0]/.test(p1))) {
                            p1 = "0."; for (var i = 0; i < power; i++) p1 += "0";
                        } else if (power < p1.length) {
                            p1 = p1.substr(0, p1.length - power) + "." + p1.substr(-power);
                        } else {
                            for (var i = 0, le = power - p1.length; i < le; i++) p1 = "0" + p1;
                            p1 = "0." + p1;
                        }
                        res = p1 + p2;
                    }
                } else {
                    if (dot == -1) {
                        res = ONnum.replace(/^0+/, "");
                        for (var i = 0; i < power; i++) res += "0";
                    } else {
                        if (power < p2.length) {
                            p2 = p2.substr(0, power) + "." + p2.substr(power);
                        } else {
                            for (var i = 0, le = power - p2.length; i < le; i++) p2 += "0";
                        }
                        res = p1 + p2;
                    }
                }
                res = res.replace(/^0+(?!\.)/, "").replace(/(\.\d+?)0+$/, "$1").replace(/\.0+$|\.$/, "");
                if (isF(Number(res)) && !String(Number(res)).match(/e|E/)) {
                    res = pm < 1 ? -Number(res) : Number(res);
                } else {
                    res = pm < 1 ? "-" + res : res
                }
            } else {
                res = matchs[3] && isF(Number(matchs[3])) && !matCheck(Number(matchs[3]))[4] ? Number(matchs[3]) : num;
            }
            return [type === "string" ? String(res) : res, last];
        };
        if (reVal[8] && mand == true) {
            var has = true, matARR = [reMatch(reVal)]; var numARR = [matARR[0][0]];
            while (has == true) {
                var lastMat = matCheck(matARR[matARR.length - 1][1]);
                if (lastMat) {
                    var last = reMatch(lastMat);
                    matARR.push(last), numARR.push(last[0]);
                }
                else has = false;
            }
            return numARR.length > 1 ? numARR : matARR[0][0];
        } else {
            return reMatch(reVal)[0];
        }
    } else {
        return val;
    }
}



//强行转成不使用科学计数法的字符串
function toNonExponential(num)
{
    var m = num.toExponential();
    return numGeneral(m , false, "string");

}


function round(num, n)
{


    if (num == null) return 0;
    if (n == null) return 0;
    if (n < 0) return num;
    try
    {
        if (isNaN(num)) num = parseFloat(num);
        return new Number(num.toFixed(n));

    } catch (err)
    {
        return null;
    }

    /*
    return $div(Math.round($mul(num, Math.pow(10, n))), Math.pow(10, n));
     //2019.08.24 上面这个搞法也仍然不对
     */


}

//     + 不一定是数字相加，所以允许直接+，但是-*/不可能对非数字型进行运算
function $add(a, b)
{
    if (a == null && b == null) return null;
    if (b == null && a != null) return a;
    if (a == null && b != null) return b;


    if (typeof (a) != 'number' || typeof (b) != 'number') return a + b;

    var c, d, e;
    try
    {
        c = toNonExponential(a).split(".")[1].length;
    } catch (f)
    {
        c = 0;
    }
    try
    {
        d = toNonExponential(b).split(".")[1].length;
    } catch (f)
    {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), ($mul(a, e) + $mul(b, e)) / e;
}

function $sub(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;

    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);

    var c, d, e;
    try
    {
        c = toNonExponential(a).split(".")[1].length;
    } catch (f)
    {
        c = 0;
    }
    try
    {
        d = toNonExponential(b).split(".")[1].length;
    } catch (f)
    {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), ($mul(a, e) - $mul(b, e)) / e;
}

function $mul(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;


    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);


    var c = 0,
        d = toNonExponential(a),
        e = toNonExponential(b);
    try
    {
        c += d.split(".")[1].length;
    } catch (f)
    {}
    try
    {
        c += e.split(".")[1].length;
    } catch (f)
    {}
    return Number(d.replace(".", "")) * Number(e.replace(".", "")) / Math.pow(10, c);
}

function $div(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;

    if (b == 0) return null;

    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);

    let c, d, e = 0, f = 0;
    try
    {
        e = toNonExponential(a ).split(".")[1].length;
    } catch (g)
    {}
    try
    {
        f = toNonExponential(b ).split(".")[1].length;
    } catch (g)
    {}

    c = new Number(  toNonExponential(a ).replace(".", ""));
    d = new Number(toNonExponential(b).replace(".", ""));
    let ret = $mul(c / d, Math.pow(10, f - e));
    return ret;

}


function random(n)
{

    var ret = $rpc("script", "debug.ScriptAgent", "mathFunction",
        {
            method: 'random',
            n: n
        }
    );
    return ret.value;
}


function abs(n)
{
    if (isNaN(n)) return 0;
    if (n > 0) return n;
    return -n;
}

function mod(a, b)
{
    if (b == 0) return null;
    return a % b;
}


var MathFunc = {

    round: round,
    add: $add,
    sub: $sub,
    div: $div,
    mul: $mul,
    random: random,
    abs: abs,
    mod: mod


};

export default MathFunc;

