/**
 * Created by 三宝爹
 *
 * 对参数的一些处理
 *
 */


import Util from '../../util/Util.js';


/**
 * 参数中任意一个是数组，则返回true
 */
function theOneIsArray(argArray)
{
    for (var i = 0; i < argArray.length; i++)
    {
        var p = argArray[i];
        if (p==null ) continue;
        if (Util.isArray(p)) return true;
    }
    return false;
}

/**
 * 当参数中任意一个为数组时，把各个参数 都整成数组，并且元素个素搞成一样多，如果个数不一样多，那么每个参数都用自已
 * 最后一个元素补齐缺少的部分，
 * 必须保证参数中至少有一个为数组
 *
 * 示例：
 * argumentsNormalize( [1,2,3], null)  = [ [1,2,3],[null,null, null] ];
 * argumentsNormalize( [1,2,3], 1)  = [ [1,2,3],[1,1, 1] ];
 * argumentsNormalize( [1,2,3],[ 1,2])  = [ [1,2,3],[1,2, 2] ];
 *
 */
function argumentsNormalize(argArray)
{
    var ret = [];
    var len = 0;
    for (var i = 0; i < argArray.length; i++)
    {
        var p = argArray[i];
        if (p==null ) continue;
        if (!Util.isArray(p)) continue;
        len = Math.max(len, p.length);
    }

    for (var i = 0; i < argArray.length; i++)
    {
        var p = argArray[i];
        if (p==null) //当参数为null时，那么转换成一个数组，插入len个null
        {
            p = [];
            for (var j = 0; j < len; j++)
            {
                p.push(null);
            }
            ret.push(p);
            continue;
        }

        if (!Util.isArray(p)) //当不是数组时，创建一个数组 ，插入len个p
        {
            var q = [];
            for (var j = 0; j < len; j++)
            {
                q.push(p);
            }
            ret.push(q);
            continue;
        }

        var lastV = p[p.length - 1]; //个数不够len个时，用最后一个元素补齐
        for (var j = p.length; j < len; j++)
        {
            p.push(lastV);
        }
        ret.push(p);
    }
    return ret;
}

/**
 *
 * 第一个参数是真正需要执行的函数， 之后的参数，是真正执行函数执行时代入的参数 ，当这些参数中的任意一个为数组时
 * ，把参数取出来循环调用真正执行的函数，并把结果再组装成一个数组
 */
function $call()
{
    var realFunc = arguments[0];
    var realArg = [];
    for (var i = 1; i < arguments.length; i++)
    {
        realArg.push(arguments[i]);
    }
    // 如果没有运行参数 ，那么函数直接运行即可，并返回
    if (realArg.length == 0) return realFunc();

    //如果有参数，但是参数没有一个是数组，那么直接运行函数，并返回
    if (!theOneIsArray(realArg)) return realFunc.apply(realFunc, realArg);

    //参数中元素个数对齐
    realArg = argumentsNormalize(realArg);

    var ret = [];
    var paramCount = realArg.length;//有几个参数
    var retLength = realArg[0].length; //每个参数的元素个数
    for (var i = 0; i < retLength; i++)
    {
        var p = [];
        for (var j = 0; j < paramCount; j++)
        {
            p.push(realArg[j][i]);//把每个参数 的第i个参数 取出来，拼一个数组，便于调用Function.apply
        }
        ret.push(realFunc.apply(realFunc, p));
    }
    return ret;
}


//输出
var FuncUtil = {
    theOneIsArray: theOneIsArray,
    argumentsNormalize: argumentsNormalize,
    $call: $call

};

export default  FuncUtil;


