/**
 * Created by 三宝爹 on 2017/10


 PC端，使用 https://github.com/stefangabos/Zebra_Datepicker/
 移动端使用 https://github.com/weijhfly/rolldate

 2020.03.29 增加对移动设备的适配，移动端改用 rolldate ，PC端使用 Zebra_Datepicker

 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';
import Edit from './Edit.js';
import Point from '../gdi/Point.js';
import ObjectTool from '../db/ObjectTool.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';


import UniformDataType from '../core/UniformDataType.js';

var DatetimeEdit = BasicEdit.extend({


        constructor: function (domObj, editStyle) {
            //2020.03.30 修正 ，如果是移协设备，那么日期编辑不要侦听焦点获取及失去，因为日期在弹出面板中选择
            this.$uper.constructor(domObj ,!Tools.isMobile(), false );
            this.ES = editStyle;
            this.m_strMask = editStyle.datetimeFormat;
        },


        // 构造编辑框显示的内容
        buildEditText: function (value) {
            var s;
            if (value == null || value == '')
            {
                s = this.valueWhenBeginEdit();
            }
            else
            {
                s = value;
            }
            this.setDateTime(s);

            //稳动设备上， 不需要编辑
            if (Tools.isMobile()) this.domObj[0].readOnly = true;


        },

        // 回填的值
        getWriteBackValue: function () {
            var s = this.getDateTime();

            var v = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
                [this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow]);
            if (v == undefined) v = s;
            if (v == null) return null;


            return ObjectTool.changeType(s, UniformDataType.$Datetime);
        }
        ,


        /**
         *  日期在得到焦点时，光标应放在最前面
         */
        focusGained: function (e) {
            this.$uper.focusGained.call(this, e);
            this.setCaretPosition(0);
        },


        setFormat: function (mask) {
            this.m_strMask = mask;


        },


        //v可能是 hh:mm 或 mm:ss ，它不能转换成完整的日期，需要补上年月，才行
        completeDate: function (v) {
            if (v == null) return v;

            var  f = this.ES.datetimeFormat;  //  yyyy.MM.dd HH:mm:ss

            if (f.indexOf('y')<0 && f.indexOf('M')<0 && f.indexOf('d')<0  ) //没有年月日，只有时间
            {
                if (f.toLocaleLowerCase().indexOf('hh') < 0) //没有时
                {
                    v = new Date().Format("yyyy-MM-dd HH:") + v;
                }

                if (f.toLocaleLowerCase().indexOf('ss') < 0) //没有秒
                {
                    v = new Date().Format("yyyy-MM-dd") + " " + v + ":00";
                }
            }


            return v;
        },

        Date2String: function (d, mask) {
            if (d == null) return '';
            return d.Format(mask);
        },

        validateDate: function (vDate) {
            vDate= this.completeDate(vDate);//可能是 hh:mm 或  mm:ss，需要补齐成一个日期

            var d = ObjectTool.changeType(vDate, UniformDataType.$Datetime);
            if (Util.isDate(d)) return d;
            return null;
        },


        setDateTime: function (v) {


            v= this.completeDate(v);//可能是 hh:mm 或  mm:ss，需要补齐成一个日期
            //alert("setDateTime:  v="+v);

            var d = ObjectTool.changeType(v, UniformDataType.$Datetime);

            //alert( "setDateTime:  d="+ d);

            var p = this.getCaretPosition();
            var t=this.Date2String(d, this.m_strMask);
            //alert( 'setText  t='+t);
            this.setText(t);
            this.setCaretPosition(p);


        },

        getDateTime: function () {
            return this.validateDate(this.getText());
        }
        ,

        datePicker: function () {

            let that = this;

            var x = this.domObj.position().left;
            var y = this.domObj.position().top;
            //[标记：绝对定位]
            if (this.Sheet.pSheetContainer)
            {

                //得到本sheet的DOM对象在浏览器可视窗口上的绝对坐标，注意，不是相对父DOM的坐标，是相对浏览器可视窗口的left,top 点的坐标
                var p = this.Sheet.View.viewContainer.getBoundingClientRect();

                x = x + p.x;
                y = y + p.y;
            }


            var newDOM = $(`<input type="text" 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green;
                            ">
                         `);
            newDOM.attr('tabindex', 1);
            newDOM.css("outline", "none"); // 不要显示 焦点框
            newDOM.css("border", 0); // 不要显示 焦点框
            newDOM.css("background-color", this.domObj.css("background-color"));


            newDOM.css({
                    "border": 0, // 不要显示 焦点框
                    "outline": "none",// 不要显示 焦点框
                    "background-color": this.domObj.css("background-color"),
                    "left": x + "px",
                    "top": y + "px",

                    "width": this.domObj.css("width"),
                    "height": this.domObj.css("height")
                }
            );


            //当sheet被popup显示时， 它的父容器是独立的一个，此时，编辑控件不应加到默认的父容器中，
            //但如果加到当前父容器中，日期控件，会被限制在弹出面板之内而被裁剪。所以此时应该直接把控件加到
            //当前页的body中， 坐标使用绝对定位，参看 [标记：绝对定位]
            var container = this.Sheet.Book.View.getViewContainerDOM();
            if (this.Sheet.pSheetContainer != null) container = document.body;

            var t = this.domObj.val();
            t = t.replace(/年/g, '.');
            t = t.replace(/月/g, '.');
            t = t.replace(/日/g, ' ');
            t = t.replace(/时/g, ':');
            t = t.replace(/分/g, ':');
            t = t.replace(/秒/g, '');
            if (t.endsWith(":")) t = t.substring(0, t.length - 1);

            t = t.trim();

            newDOM.val(t);
            newDOM.appendTo(container);
            newDOM[0].focus();
            //格式转换，本系统中使用的是yyyy.MM.dd HH:mm:ss等占位符与DataPicker控件的占位符格式是不一样的
            let format = this.ES.datetimeFormat;
            format = format.replace(/秒/g, '');
            format = format.replace(/分/g, ':');
            format = format.replace(/时/g, ':');
            format = format.replace(/日/g, ' ');
            format = format.replace(/月/g, '.');
            format = format.replace(/年/g, '.');

            format = format.replace(/(s)+/g, 's'); //秒
            format = format.replace(/(m)+/g, 'i'); //分钟
            format = format.replace(/(H)+/g, 'H'); //
            format = format.replace(/(d)+/g, 'd'); //
            format = format.replace(/(M)+/g, 'm'); //月
            format = format.replace(/(y)+/g, 'Y'); //

            format = format.trim();

            if (format.endsWith(":")) format = format.substring(0, format.length - 1);

            console.info(format);


            $(newDOM).Zebra_DatePicker({
                format: format,
                days: ['日', '一', '二', '三', '四', '五', '六'],
                months: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
                show_select_today: '今天',
                lang_clear_date: '清除',
                default_position: 'below',


                onClose: function (dp) {

                    //2019.08.26 当这样的场景下， 一个日期型编辑格式，在输入值后，在CellValueChanged事件中
                    //执行操作把该单元格清空，并提示信息。 然后，切换工作台的tab 页，此时 Zebra_DatePicker的hide又被触发，然后onClose 又被触发
                    // 于是 上一次选择的日期又被回填到单元整中，于是在CellValueChanged事件又被触发一次（可能是多次）
                    // 临时解决办法： 在 newDOM中增加一个属性，removed ，当设置 为true后，onClose不再执行。临时解决了问题，但是
                    // 从根本上来说，还是没有完全搞清楚问题所在
                    if (newDOM.removed) return;
                    var t = dp.val();

                    //format 已经规整过了
                    if (format == 'y.m') t = t + ".01";
                    if (format == 'y') t = t + ".01.01";


                    console.info(t);
                    //关闭的时候，把值回设置，并删除相关控件，恢复清爽
                    that.setDateTime(t);
                    that.focusLost();
                    $('.Zebra_DatePicker_Icon_Wrapper').remove();
                    $('.Zebra_DatePicker').remove();
                    $(newDOM).remove();
                    newDOM.removed = true;
                }

            });


            newDOM.trigger('click');

        },

        datePickerOnMobile: function () {
            var t = this.domObj.val();


            var formatConvert = function (t, h2H) {
                t = t.replace(/年/g, '.');
                t = t.replace(/月/g, '.');
                t = t.replace(/日/g, ' ');
                t = t.replace(/时/g, ':');
                t = t.replace(/分/g, ':');
                t = t.replace(/秒/g, '');

                t = t.replace(/y/g, 'Y');
                t = t.replace(/d/g, 'D');
                t = t.replace(/H/g, 'h');
                t = t.replace(/[.]/g, '-');


                if (t.endsWith(":")) t = t.substring(0, t.length - 1);


                t = t.trim();
                return t;
            }


            //格式转换，本系统中使用的是yyyy.MM.dd HH:mm:ss等占位符与DataPicker控件的占位符格式是不一样的
            let format = this.ES.datetimeFormat;


            if (t == '') t = new Date().Format(format); //注意 format中的小时，必须是HH大写
            //清除掉格式，变成 YYYY-MM-DD hh:mm:ss 格式
            t = formatConvert(t); // 这个控件中的小时必须是hh 小写

            t= this.completeDate(t);//可能是 hh:mm 或  mm:ss，需要补齐成一个日期


            //这个日期控件格式， 年月日必须是大写字母， YYYY-MM-DD hh:mm:ss 这样的
            format = formatConvert(format);


            console.info(format);

            let that = this;

            let rd = new Rolldate({
                format: format,
                value: t,
                confirm: function (val) {

                    that.setDateTime(val);
                    that.focusLost();
                },

                cancel: function (val) {

                    that.Escape=true;
                    that.focusLost();
                }

            });
            rd.show();

        },

        mouseClicked: function (e) {

            //移动端
            if (Tools.isMobile())
            {

                this.datePickerOnMobile();
                return;
            }


            //桌面端

            var rc = this.getBounds();
            if (e.target == this.domObj[0])//此时是直接点击在input内，所以此时的offsetX是相对于input的
            {
                if (e.offsetX > rc.width - 16)
                {
                    this.datePicker();

                }

            } else//当鼠标在canvas上点击，此时  e.target是canvas ,此时的 e.offsetX是相对于canvas左上角的
            //所以要加上单元格的x后再比较
            {

                if (e.offsetX > this.editRC.x + rc.width - 16)
                {
                    this.datePicker();
                }


            }


        },

        mouseMoved: function (e) {

            var rc = this.getBounds();
            if (e.offsetX > rc.width - 16)//此时的e.target只会是 input ,因为canvas上的mouseMove不可能传到这里来
            {
                var cur = "js/spreadsheet/mouse/cursor/hand.gif";
                this.domObj.css("cursor", "url(" + cur + ") 10 10,pointer");

            } else
            {
                this.domObj.css("cursor", "text");

            }
        },

        keyTyped: function (e) {
            e.preventDefault(); // 完全接管；

            var old = this.getText();

            var pos;
            var nChar = e.key;
            pos = this.getSelectionPosition().start;

            switch (e.keyCode)
            {
                case Edit.VK_BACK_SPACE :
                case Edit.VK_UP :
                    pos--;
                    break;
                case Edit.VK_TAB :
                    break;
                case Edit.VK_ENTER :

                    break;
            }

            switch (nChar)
            {
                case '0' :
                case '1' :
                case '2' :
                case '3' :
                case '4' :
                case '5' :
                case '6' :
                case '7' :
                case '8' :
                case '9' :
                    if (pos >= this.m_strMask.length) break;
                    var c = this.m_strMask.charAt(pos);
                    if (pos < old.length && pos < this.m_strMask.length && old.charAt(pos) != nChar
                        && (c == 'd' || c == 'M' || c == 'y' || c == 'H' || c == 'm' || c == 's'))
                    {
                        var str = old.substring(0, pos) + nChar + old.substring(pos + 1);

                        var d = this.validateDate(str);
                        if (d != null) this.setDateTime(d);
                        //对日期进行自动修正 ，修正的原则是：假设输入的值的有效的，而与它组合后的日期无效，那么修改其它位上的数据
                        //以保证日期是有效的
                        //如果是在月份上输入，并且是MM中的第一个M
                        var cLeft = ' ';
                        var cRight = ' ';

                        if (pos > 0) cLeft = this.m_strMask.charAt(pos - 1);
                        if (pos + 1 < this.m_strMask.length) cRight = this.m_strMask.charAt(pos + 1);

                        if (d == null && c == 'M')
                        {
                            //如果输入了1，那么后面只能是0，1，2，因此第二位月强制改还0
                            if (cRight == 'M' && nChar == '1') old = old.substring(0, pos + 1) + "0" + old.substring(pos + 2);   //如果是月份中的第一位
                            //如果是月份中的第2位,并用输入的月3，那么把月的第一位设置成0
                            if (cLeft == 'M' && nChar > '2') old = old.substring(0, pos - 1) + "0" + old.substring(pos);

                            str = old.substring(0, pos) + nChar + old.substring(pos + 1);
                            d = this.validateDate(str);
                            if (d != null)
                            {
                                this.setDateTime(d);
                            } else //对月做了修正，还不行，那可能是日太大， 比如月是2，日是30，因此强制把日设置成1
                            {
                                //找到第一个日的位置
                                var pi = -1;
                                for (var i = 0; i < this.m_strMask.length; i++)
                                {
                                    if (this.m_strMask.charAt(i) == 'D')
                                    {
                                        pi = i;
                                        break;
                                    }
                                }

                                if (pi >= 0)
                                {
                                    str = str.substring(0, pi) + "01" + str.substring(pi + 2);
                                    d = this.validateDate(str);
                                    if (d != null) this.setDateTime(d);
                                }
                            }

                        }

                        //如果是在日上做编辑
                        if (d == null && c == 'd')
                        {
                            //当输入天为 2X或3X时， 如果日期不对，那么强制把天的第二位改成0
                            if (cRight == 'd' && nChar >= '2') old = old.substring(0, pos + 1) + "0" + old.substring(pos + 2);
                            //如果是日中的第2位,并用输入的>1，那么把日的第一位设置成0
                            if (cLeft == 'd' && nChar > '1') old = old.substring(0, pos - 1) + "0" + old.substring(pos);
                            str = old.substring(0, pos) + nChar + old.substring(pos + 1);
                            d = this.validateDate(str);
                            if (d != null)
                            {
                                this.setDateTime(d);
                            }
                        }


                    }

                    var maskLength = this.m_strMask.length;
                    if (++pos < maskLength)
                    {
                        for (; pos < maskLength; pos++)
                        {
                            c = this.m_strMask.charAt(pos);
                            if (c == 'd' || c == 'M' || c == 'y' || c == 'H' || c == 'm' || c == 's') break;
                        }
                    }
                    break;

                default :

                    break;
            }

            this.setCaretPosition(pos);

        }
        ,


        keyPressed: function (e) {
            var old = this.getText();
            // 当按下非回车键时，如果当前被编辑的日期非法，那么就赋予为当前日期
            if (this.validateDate(old) == null && e.keyCode != Edit.VK_ENTER) this.setDateTime(new Date());

            switch (e.keyCode)
            {

                case Edit.VK_DELETE :
                    if (e.ctrlKey)
                    {
                        this.$uper.keyPressed.call(this, e);
                        return;
                    }
                //否则继续做　	Edit.VK_BACK_SPACE 相同的判断，所以不要加break,
                //也不要在这中间再加其它的case判断
                case Edit.VK_BACK_SPACE :
                    e.preventDefault();
                    // 如果是再全选状态下按下 delete , 和backspace那么清空
                    //if (this.getSelectionStart() == 0 && this.getSelectionEnd() == this.getText().length())
                    this.setDateTime(null);
                    break;
                case Edit.VK_INSERT :
                    e.preventDefault();
                    break;
                case Edit.VK_UP :
                case Edit.VK_DOWN :

                    if (e.ctrlKey)
                    {
                        this.$uper.keyPressed.call(this, e);
                        return;
                    }

                    e.preventDefault();
                    var pos = this.getCaretPosition();
                    var d = this.validateDate(old);
                    if (d == null) return;

                    if (pos < this.m_strMask.length)
                    {
                        var c = this.m_strMask.charAt(pos);
                        if (c != 'd' && c != 'M' && c != 'y' && c != 'H' && c != 'm' && c != 's')
                        {

                            if (--pos >= 0) c = this.m_strMask.charAt(pos);
                        }


                        d.add(c, e.keyCode == Edit.VK_UP ? 1 : -1);
                        this.setDateTime(d);
                    }

                    return; // 不能让 pView 再处理 up, down

                case Edit.VK_TAB :
                case Edit.VK_ENTER :

                    this.$uper.keyPressed.call(this, e);
                    break;

            }


        }
    }
);


export default DatetimeEdit;

