/**
 * Created by zengjun on 2017/5
 *
 * 将SQL语句拆分成多个部分，并提供在Select中拼接where条件的功能，当语句中有union时，是每个union都拼上相同的where
 */


import Class from '../base/Class.js';
import Util from '../util/Util.js';

const Logger = console;

 var SqlParse = Class.extend({

    properties: {
        "sql": {
            get: function () { return this.m_SQL;},
            set: function (val) { this.constructor(val);}
        },

        "verb": {
            get: function () { return this.m_Verb;},
            set: function (val) { this.m_Verb = val;}

        },

        "tables": {
            get: function () { return this.m_Tables;},
            set: function (val) {
                this.m_Tables = val;
                this.assemble();
            }
        },
        "columns": {
            get: function () { return this.m_Columns;},
            set: function (val) {
                this.m_Columns = val;
                this.assemble();
            }
        },
        "values": {
            get: function () { return this.m_Values;},
            set: function (val) {
                this.m_Values = val;
                this.assemble();
            }
        },
        "where": {
            get: function () { return this.m_Where;},
            set: function (val) {
                this.m_Where = val;
                this.assemble();
            }
        },
        "orderBy": {
            get: function () { return this.m_Order;},
            set: function (val) {
                this.m_Order = val;
                this.assemble();
            }
        },
        "groupBy": {
            get: function () { return this.m_Group;},
            set: function (val) {
                this.m_Group = val;
                this.assemble();
            }
        },

        "having": {
            get: function () { return this.m_Having;},
            set: function (val) {
                this.m_Having = val;
                this.assemble();
            }
        }
    },

    constructor: function (sql) {

        //把order by 中的多个空格替换成一个空格
        sql = sql.replace(/(\s)+[Oo][Rr][Dd][Ee][Rr](\s)+[Bb][Yy](\s)+/g, ' order by ');
        sql = sql.replace(/(\s)+[Gg][Rr][Oo][Uu][Pp](\s)+[Bb][Yy](\s)+/g, ' group by ');
        sql = sql.replace(/(\s)+[Ii][Nn][Ss][Ee][Rr][Tt](\s)+[Ii][Nn][Tt][Oo](\s)+/g, ' insert into ');
        sql = sql.replace(/(\s)+[Dd][Ee][Ll][Ee][Tt][Ee](\s)+[Ff][Rr][Oo][Mm](\s)+/g, ' delete from ');


        this.m_UnionAll = "";
        this.m_SQL = sql;
        this.m_Verb = "";
        this.m_Tables = "";
        this.m_Columns = "";
        this.m_Values = "";
        this.m_Where = "";
        this.m_Order = "";
        this.m_Group = "";
        this.m_Having = "";


        this.parse();
    },


    parse: function () {
        var Pos, i;
        var SQL, SQLUpper, Keyword = [], Clause = [];

        for (i = 0; i < 7; i++)
        {
            Keyword.push("");
            Clause.push("");
        }
        // Remove Carriage returns, Newlines, and Tabs
        SQL = this.m_SQL;
        SQL = SQL.replace(/[\r\n\t]/g, "");
        // 去掉头尾的空格
        SQL = SQL.trim();
        // 转换为大写
        SQLUpper = SQL.toUpperCase();

        //  增加对Union {ALL} 的支持
        if (SQLUpper.substring(0, 4) == ("ALL "))
        {
            this.m_UnionAll = " ALL ";
            SQLUpper = SQLUpper.substring(4).trim(); // 去掉前面的all
            SQL = SQL.substring(4).trim(); // 去掉前面的all
        }

//	   判断SQL语句的类型,并设置相应的关键字

        if (SQLUpper.substring(0, 7) == (  "SELECT " ))
        {// Parse the SELECT statement
            Keyword[0] = "SELECT ";
            Keyword[1] = " FROM ";
            Keyword[2] = " WHERE ";
            Keyword[3] = " GROUP BY ";
            Keyword[4] = " HAVING ";
            Keyword[5] = " ORDER BY ";
        } else if (SQLUpper.substring(0, 7) == ( "UPDATE "))
        {// Parse the UPDATE statement
            Keyword[0] = "UPDATE ";
            Keyword[1] = " SET ";
            Keyword[2] = " WHERE ";
            Keyword[5] = " ORDER BY ";
        } else if (SQLUpper.substring(0, 12) == ( "INSERT INTO " ))
        {// Parse the INSERT statement (test before 'insert')
            Keyword[0] = "INSERT INTO ";
            Keyword[6] = " VALUES ";
        } else if (SQLUpper.substring(0, 7) == ( "INSERT "))
        {// Parse the INSERT statement (test after 'insert to')
            Keyword[0] = "INSERT ";
            Keyword[6] = " VALUES ";
        } else if (SQLUpper.substring(0, 12) == ( "DELETE FROM "))
        {// Parse the DELETE statement (test before 'delete')
            Keyword[0] = "DELETE FROM ";
            Keyword[2] = " WHERE ";
        } else if (SQLUpper.substring(0, 7) == ( "DELETE " ))
        {// Parse the DELETE statement (test after 'delete from')
            Keyword[0] = "DELETE ";
            Keyword[2] = " WHERE ";
        }


        // There is a maximum of 7 keywords
        for (i = 6; i >= 0; i--)
        {
            if (!Keyword[i] == ( ""))
            {// Find the position of the Keyword

                var Pos = SQLUpper.indexOf(Keyword[i]);
                //对where要做特别处理:
                // 显然第一个select ,第一个from 肯定就是语句的select 和from 但是第一个where不一定是整个语句的
                //的where ,比如 select id from a left join b on ( a.id=b.pid and exists (select .... from .... where ...)) where a.id>10
                //这其中的第一个where就不是整个语句的where ,但是并不是说最后一个where就是整个语句的where ,比如上面示例中把 where a.id>10 去掉后
                // 整个语句并不存在where，再比如：select * from a where exists( select id from b where id=a.id)
                // 那么如果确定哪个where是整个语句的where呢：
                // 规则：如果 where 后面的左括号与右括号数目相等，这个where它就是整个语句的where
                //否则这个where 应该是子查询的where

                // 同理  order by , group by , having 都是同理处理
                if (Keyword[i] == (" WHERE ") ||
                    Keyword[i] == (  " GROUP BY ") ||
                    Keyword[i] == ( " HAVING ") ||
                    Keyword[i] == (  " ORDER BY "   ))
                {

                    var keyLen = Keyword[i].length;
                    Pos = SQLUpper.indexOf(Keyword[i]);
                    while (Pos > 0)  //继续判断左括号与右括号数是不是相同
                    {
                        //注意 Pos后面的子串不什会包括group by , order by having等内容了，因为已经倒序按关键字作了截取了
                        var t = SQL.substring(Pos + keyLen);

                        //现在看其中的左括号和右括号数据相不相同,注意引号中的括号

                        // 把语句中的所有字符串常数去掉比如把  a.id=b.id and  name<>'abc' 把其中的'abc'换成空格
                        // 目的是去掉字符串中的括号如 String s="  ( a>b and  'ab''c('+ 'bc)' +'()' <>col1 and c ) " ;
                        // 把引号括起来的部份(可能含有括号)去掉
                        // 这又引出一个问题,引号中又有引号,所以先要引号中的引号去掉.
                        // 值得注意的是:sql中的引号是用单引号,双引号引起来的部份是当作字段,而不是字符串
                        // 所以第一步:去掉单引号字符(2个连续的单引号
                        t = t.replace(/([']){2}/g, '');
                        //第二步：去掉字符串常数
                        t = t.replace(/[']([^'])*[']/g, ""); // 表示由单引号开头，接着是任意个除单引号外的任意字符，最后以单引号结束

                        //此时的t 中的括号就应该是真正的括号，而不会存在字符串的括号了
                        var n1 = t.match(/[(]/g) ? t.match(/[(]/g).length : 0;//左括号的数量
                        var n2 = t.match(/[)]/g) ? t.match(/[)]/g).length : 0;// 右括号的数量

                        if (n1 == n2) break;

                        //到这里表示这个where后的左右括号不相同，
                        // 可能原因是：1 sql语句本身有错 2 这个where是子查询中的where，不是整个语句的where
                        // 继续找下一个
                        Pos = SQLUpper.indexOf(Keyword[i], Pos + keyLen);
                    }

                }


                if (Pos >= 0)
                {
                    Clause[i] = SQL.substring(Pos + Keyword[i].length);
                    SQL = SQL.substring(0, Pos);
                } else
                {
                    Clause[i] = "";
                }
            }
        }
        //语句的类型
        this.m_Verb = Keyword[0].trim();

        if (this.m_Verb.indexOf("SELECT") >= 0)
        {
            this.m_Columns = Clause[0].trim();
            this.m_Tables = Clause[1].trim();
        }
        else
        {
            this.m_Tables = Clause[0].trim();
            if (this.m_Verb.indexOf("INSERT") >= 0)
            {
                Pos = m_Tables.indexOf(" ");
                if (Pos >= 0)
                {
                    this.m_Columns = m_Tables.substring(Pos).trim();
                    this.m_Tables = m_Tables.substring(0, Pos - 1);
                } else
                {
                    this.m_Columns = Clause[1].trim();
                }
            }
        }
        this.m_Where = Clause[2].trim();
        this.m_Group = Clause[3].trim();
        this.m_Having = Clause[4].trim();
        this.m_Order = Clause[5].trim();
        this.m_Values = Clause[6].trim();

    },

    assemble: function () {
        this.m_SQL = "";
        this.m_SQL += this.m_UnionAll; // 增加对union all 的支持
        if (this.m_Verb.trim() == ("") || this.m_Tables.trim() == ( "")) return;
        this.m_SQL += this.m_Verb;
        if (this.m_Verb == ( "SELECT"))
        {
            if (this.m_Columns.trim() == ( "")) return;
            this.m_SQL += " " + this.m_Columns + " FROM " + this.m_Tables;
        } else
        {
            this.m_SQL += " " + this.m_Tables;
            if (this.m_Verb == ( "UPDATE"))
            {
                this.m_SQL += " SET " + this.m_Columns;
            } else
            {
                if (!this.m_Columns.trim() == ("")) this.m_SQL += " " + this.m_Columns;
            }
        }

        if (!this.m_Values.trim() == ("")) this.m_SQL += " VALUES " + this.m_Values;
        if (!this.m_Where.trim() == ("")) this.m_SQL += " WHERE " + this.m_Where;
        if (!this.m_Group.trim() == ("")) this.m_SQL += " GROUP BY " + this.m_Group;
        if (!this.m_Having.trim() == ("")) this.m_SQL += " HAVING " + this.m_Having;
        if (!this.m_Order.trim() == ("")) this.m_SQL += " ORDER BY " + this.m_Order;

    }
    ,

    // 不是用来判断是不是合法的SQL语句的，只是用来判断语句中的单引号是不是偶数个
    // 注意如下事实：SQL中用一对单引号括起来的部分表示字符串，且如果字符串中如果有单引号
    // 是用两个单引号表示一个单引号字符
    //   增加判断，左右括号是不是相同
    //  去掉了括号的判断，因为可能在字符串中存在 括号 ，比如  name = ' abc(defg'  不能说这个是不对的
    //  再次恢复了对括号的判断，因为对于 select * from ( select * from a union  select * from b )  a 这样的语句
    // 在union处会切开，此时前半部分不是合法的语句，所以不会分成两部分SQL
    // 而对于  select * from a union select * from b 则是可以分成两部分，并分别拼上where
    // 为解决  前面说的问题， 增加了把字符串只内容清空后再判断，这样就不会有问题了
    isValidSQL: function (sql) {
        if (sql.match(/[']/g))
        {
            var n = sql.match(/[']/g).length;//引号的数量
            if (n % 2 != 0) return false; //如果引号数不是偶数，那么不是合法的SQL
        }

        var t = sql;

        //现在看其中的左括号和右括号数据相不相同,注意引号中的括号

        // 把语句中的所有字符串常数去掉比如把  a.id=b.id and  name<>'abc' 把其中的'abc'换成空格
        // 目的是去掉字符串中的括号如 String s="  ( a>b and  'ab''c('+ 'bc)' +'()' <>col1 and c ) " ;
        // 把引号括起来的部份(可能含有括号)去掉
        // 这又引出一个问题,引号中又有引号,所以先要引号中的引号去掉.
        // 值得注意的是:sql中的引号是用单引号,双引号引起来的部份是当作字段,而不是字符串
        // 所以第一步:去掉单引号字符
        // 所以第一步:去掉单引号字符(2个连续的单引号
        t = t.replace(/([']){2}/g, '');
        //第二步：去掉字符串常数
        t = t.replace(/[']([^'])*[']/g, ""); // 表示由单引号开头，接着是任意个除单引号外的任意字符，最后以单引号结束

        //此时的t 中的括号就应该是真正的括号，而不会存在字符串的括号了
        var n1 = t.match(/[(]/g) ? t.match(/[(]/g).length : 0;//左括号的数量
        var n2 = t.match(/[)]/g) ? t.match(/[)]/g).length : 0;// 右括号的数量

        if (n1 != n2) return false; //如果左右括号数不相等，那么不是合法的SQL

        return true;

    },

    /**
     *
     * @param sqlSource
     * @param whereToLink
     * @param replaceWithCount
     *            把　列替换成　count(*) 　比如把　select c1, c2 from t1 　变成 select count(*)
     *            from t1
     *
     *              增加了对 select * from ( select * from t1 union  select * from t2  )  a  格式的支持
     *                                        是通过修改  isValidSQL 实现的。基于这样一个事实，如果union 分隔出来的部分是一个
     *                                        完整的SQL，那么其中的左右括号数据应该是相等的
     *                                        因此也完美地支持了
     *                                          select * from ( select * from t1 union  select * from t2  )  a union all
     *                                          select * from ( select * from t3 union  select * from t4  )  b 这样的结构
     *
     * @return
     */
    linkUpWhere: function (sqlSource, whereToLink, replaceWithCount) {
        if (whereToLink == undefined) return sqlSource;
        //2019.07.16 如果 whereToLink是一个条件数组，那么把它用and串联直接，
        if (Util.isArray(whereToLink)) whereToLink = Util.joinWhere(whereToLink);
        replaceWithCount = replaceWithCount || false;

        // 如果不是换成 count(*) 且附加的where=="" ，那么直接返回
        if (!replaceWithCount && whereToLink.trim() == ("")) return sqlSource;

        var oldWhere;
        var ret;
        var t;
        var sql = sqlSource;

        var s = sql;
        var UNION = " UNION "; // 注意前后各有一个空格
        s = s.toUpperCase() + UNION;
        var sqlList = [];

        var p = s.indexOf(UNION);
        var q = 0;
        var r = 0;
        //首先对SQL进行union拆分
        while (p >= 0)
        {
            var temp = sql.substring(r, p);

            if (this.isValidSQL(temp))
            {
                sqlList.push(temp);
                r = p + 7;
            }
            q = p + 7;
            p = s.indexOf(UNION, q);
        }

        //再对SQL进行结构细分
        try
        {

            var sb = [];
            for (var i = 0; i < sqlList.length; i++)
            {

                sql = sqlList[i];
                this.sql = sql;
                oldWhere = this.where;

                // 如果附加条件不为"" 才需要拼接
                if (whereToLink != (""))
                {
                    if (oldWhere.trim() == (""))
                    {
                        this.where = whereToLink;
                    } else
                    {
                        t = "(" + oldWhere + ") and (" + whereToLink + ")";
                        this.where = t;
                    }
                }

                if (replaceWithCount)
                {
                    sp.columns = " count (*)  ";
                    // 当字段全换成count*后，因为order by 中的字段必须出现在select中，所以把order by 删除
                    sp.orderBy = "";
                }

                this.assemble();
                sql = this.sql;
                if (i > 0) sb.push("  UNION ");
                sb.push(sql);

            }
            return sb.join(' ');

        } catch (e)
        {
            Logger.error(e);
            return sqlSource;
        }

    }

});


export default SqlParse ;
