/**
 * Created by zengjun on 2017/4
 *
 */

import util from '../util/Util.js';
import UniformDataType from '../core/UniformDataType.js';


const ObjectTool = {};

ObjectTool.ObjectClone = function (obj) {
    return util.clone(obj);
};


ObjectTool.changeType = function (value, uniformDataType) {
    var ret;
    if (value == null) return null;
    if (value == undefined) return null;

    switch (uniformDataType)
    {
        case UniformDataType.$Integer :
            //如果value是整数，那么parseInt 会原样返回
            //如果是小数，那么小数部分会去掉，且不会四舍五入
            //如果value是字符串，那么只中的非数字字符会被丢掉，剩下的数字字母会被转换成整数
            if (util.isInteger(value)) return value;
            if ((value + '').equalsIgnoreCase('true')) return 1;
            if ((value + '').equalsIgnoreCase('false')) return 0;

            ret = parseInt(value);
            if (isNaN(ret)) ret = 0;
            return ret;

        case UniformDataType.$Numeric :
            if (typeof(value) == 'number') return value;

            if ((value + '').equalsIgnoreCase('true')) return 1;
            if ((value + '').equalsIgnoreCase('false')) return 0;

            if (typeof(value) == 'string') value = value.replace(/,/g, ''); //千分位符号去掉

            if (isNaN(value)) return 0;
            ret = parseFloat(value);
            if (isNaN(ret)) ret = 0;
            return ret;

        case UniformDataType.$String :
            if (util.isDate(value)) return value.Format('yyyy.MM.dd HH:mm:ss');
            return '' + value;

        case UniformDataType.$Boolean:

            var t = '' + value;
            t = t.toLowerCase();
            if (t == '1' || t == 'true' || t == 'yes' || t == 't') return true;
            return false;


        case UniformDataType.$Datetime :
            //通常只存在把字符串转换成日期的情况，所以把value转成字符串，直接用
            // Date的自已的构造函数来转换，支持 'yyyy.MM.dd hh:mm:ss'或 'yyyy.MM.dd'格式
            if (util.isDate(value)) return value;

            if (util.isNumber(value) &&
                ('' + value).indexOf('.') < 0 &&
                ('' + value).indexOf('-') < 0 &&
                ('' + value).indexOf('/') < 0)  //时间戳 ,且没有小数点，-，/等
            {
                ret = '' + value;
                if (ret.length == 10) ret += "000";
                ret = new Date(new Number(ret));
                return ret;
            }
            ret = '' + value;
            ret = ret.replace(/年/g, '.');
            ret = ret.replace(/月/g, '.');
            ret = ret.replace(/日/g, ' ');
            ret = ret.replace(/时/g, ':');
            ret = ret.replace(/分/g, ':');
            ret = ret.replace(/秒/g, '');
            ret = ret.replace(/::/g, ':'); //比如  12时34分可能会被拼成 12时34分:00,替换汉字后变成12:34::00  多拼了一个:
            ret = ret.replace(/-/g, '.');


            var t = ret;
            ret = ret.trim();
            if (ret.endsWith(":")) ret = ret + "00";
            //alert(" ret="+ret);
            ret = new Date(ret);
           // alert(" 转成日期 后 ret=" + ret);
           // alert( util.isDate( ret));
            //2020.03.29 修正， 之前用  2020.01.01 23:23:44 这样的格式是可以new Date成功的，但是
            //在手机上，是不能转换的，必须换成 / 后才能转换
            if (!util.isDate(ret))
            {
                ret = t; //  对于 2019.01.01 这样的格式，在safari中不支持，需要换成2019/01/01的格式
                if (ret.substring(4, 5) == '.') ret = ret.substring(0, 4) + "/" + ret.substring(5);
                if (ret.substring(7, 8) == '.') ret = ret.substring(0, 7) + "/" + ret.substring(8);
                var dotP = ret.indexOf('.');
                if (dotP > 0) ret = ret.substring(0, dotP); //毫秒去掉， 不safari不识别
                ret = new Date(ret);
                //alert("换成/后 的ret= " +ret);
                if (!util.isDate(ret)) ret = null;
            }

            return ret;
        case UniformDataType.$Binary :
            return ObjectTool.ObjectClone(value);

        case UniformDataType.$Other :
            return "" + value;
        default:
            return value;


    }

}


export default ObjectTool;


