/**
 *
 * 数据库方言
 * Created by zengjun on 2017/5/6.
 */


import Class from '../base/Class.js';
import UniformDataType from '../core/UniformDataType.js';
import ObjectTool from "./ObjectTool.js";

var  Dialect = Class.extend({

    properties: {
        "DBProvider": {
            get: function () {return this.m_DBProvider;}
        }
    },

    constructor: function (ds, dbProvider) {

        this.m_DateSeparator = ".";
        this.m_DBProvider = dbProvider;
        this.m_DS = ds;
    },


    /*String*/ getDateSeparator: function () {
        return this.m_DateSeparator;
    },

    /*String*/ getDBProvider: function () {
        return this.m_DBProvider;
    },

    /*boolean*/ caseSensitive: function () {
        return false;
    },

    /**
     *
     * @param v
     * @param dataType
     * @param decimalCount
     * @returns { string}
     */
    getFormatedTextValue: function (/*Object*/ v, /*UniformDataType*/ dataType, /*int*/ decimalCount) {
        var bstr = "";  //
        var sp = this.m_DateSeparator;

        if (v == null) return "NULL";


        switch (dataType)
        {

            case UniformDataType.$Integer:
                bstr = '' + v;
                break;
            case UniformDataType.$String:
                // 如果有单引号.那么将被替换成双单引号 ,因为在SQL中用双单引号表示单个单引号字符
                // 回车不用特别处理，即使字符串中有回车，在构建的SQL语句中也会有回车，但语句是能
                // 正常执行的，并且保存后的数据中的回车也是正常的
                bstr = '' + v;
                bstr = "'" + bstr.replace(/'/g, "''") + "'";
                break;

            case UniformDataType.$Datetime:
                var t = ObjectTool.changeType(v, UniformDataType.$Datetime);
                if (t == null) return "NULL";
                bstr = "'" + t.Format("yyyy" + sp + "MM" + sp + "dd HH:mm:ss") + "'";
                break;


            case UniformDataType.$Numeric :
                var t = ObjectTool.changeType(v, UniformDataType.$Numeric);
                if (t == null) return "NULL";
                bstr = t.toFixed(decimalCount);
                break;
            default :

                bstr = '' + v;
                break;
        }


        return bstr;

    },

    toLocalSyntax: function (sql) {
        return sql;
    },

    isH2: function () {
        return false;
    },
    isHSQL: function () {
        return false;
    },
    isMySQL: function () {
        return false;
    },
    isMSSqlServer: function () {
        return this.m_DBProvider == "SQLServer";
    },
    isOracle: function () {
        return false;
    },
    isPostgres: function () {
        return false;
    },
    isSybase: function () {
        return false;
    }


});

export default Dialect ;
