/**
 * Created by 三宝爹
 */


import Class from '../base/Class.js';

import Color from '../gdi/Color.js';
import Point from '../gdi/Point.js';

import Graphics2D from '../gdi/Graphics2D.js';
import Rectangle from '../gdi/Rectangle.js';

import EventManage from './EventManage.js';

import ALIGNMENT from './ALIGNMENT.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';

import Map from '../util/Map.js';

import ISize from './ISheetView/ISize.js';
import IFocus from './ISheetView/IFocus.js';
import IEditFocusJump from './ISheetView/IEditFocusJump.js';

import IEdit from './ISheetView/IEdit.js';
import IMouseListener from './ISheetView/IMouseListener.js';
import ITouchListener from './ISheetView/ITouchListener.js';
import IKeyListener from './ISheetView/IKeyListener.js';
import ICoordinate from './ISheetView/ICoordinate.js';
import IDraw from './ISheetView/IDraw.js';
import IResize from './ISheetView/IResize.js';

//鼠标动态的处理
import SelectTool from '../mouse/SelectTool.js';
import RowHeadTool from '../mouse/RowHeadTool.js';
import ColumnHeadTool from '../mouse/ColumnHeadTool.js';

var selectTool = new SelectTool();
var columnHeadTool = new ColumnHeadTool();
var rowHeadTool = new RowHeadTool();

const /* Color*/  NormalHeaderBackgroundColor = new Color('#ece9d8');
const /*Color*/  SelectedHeaderBackgroundColor = new Color('#dcd9c8');

const /* Color*/  NormalHeaderTextColor = new Color('#404040');
const /*Color*/  SelectedHeaderTextColor = new Color(51, 108, 51);

const HeadFontSize = 14;


/**
 *
 *   popper.js  可用于弹出提示，随动提示等
 *
 */

var WorkSheetView = Class.extend({

    components: [

        ISize,//尺码相关
        IFocus, //焦点相关
        IEditFocusJump,//编辑焦点跳转
        IMouseListener, //鼠标路由
        ITouchListener,//移动设备支持
        IKeyListener,//按键路由
        IEdit, //进入编辑,
        IDraw, //绘制相关
        IResize,// 弹性行列自动计算
        ICoordinate // 坐标相关
    ],

    static:
        {
            selectTool: selectTool,
            columnHeadTool: columnHeadTool,
            rowHeadTool: rowHeadTool

        },


    properties:
        {

            "graphics2d":
                {
                    get: function () {
                        if (this.graphics != null) return this.graphics;
                        this.graphics = new Graphics2D(this.canvas);
                        // this.graphics.ctx.translate(0.5, 0.5); 这个反而引起绘制紊乱，会出现一些多余的线条及坐标偏差
                        //2018.09.27 注： 如果不加0.5 那么在画线时，就无法画出1px的线。如果加0.5，那么在fillRect上，就会出现1px的重叠
                        //解决办法是，不要在这里统一偏移，而是在Grapcics的 moveTo , lineTo 两函数中加0.5 ，其它画图函数不要加
                        //就可以完美解决上面的两个冲突
                        this.graphics.ratio = this.graphics.ctx.ratio; //ratio是高清比例，直接在graphics中加上属性，便于访问
                        this.devicePixelRatio = this.graphics.ratio;

                        return this.graphics;
                    },
                    //通常不会用此函数，此函数更多地是把graphics设置成null
                    //当 size变化时， 需要重新设置canvas的尺寸，并把graphcis设置成null
                    set: function (val) {this.graphics = val;}
                },
            "CPM":
                {
                    get: function () { return this.Sheet.CPM;}
                }
            ,
            "RPM":
                {
                    get: function () { return this.Sheet.RPM;}
                }
            ,

            "EM": //事件管理器
                {
                    get: function () { return this.Sheet.EM;}
                }

        }
    ,

    /**
     *
     * @param {WorkSheet}sheet
     */
    constructor: function (sheet) {


        // 初始化相关对象

        this.Sheet = sheet;
        this.Book = sheet.Book;

        // 画边框的任务

        this.drawBorderMap = new Map();
        /*<Shape, ArrayList<DrawBorderTask>>*/
        //当一个单元格绑定到含有多行数据的字段时，为每行数据画边框的任务
        this.drawBindBorderMap = new Map();
        /*<Shape, ArrayList<DrawBorderTask>>*/

        this.CurrentEditControlBounds = null;//Rectangle

        this.currentEditingEdit = null; // Edit
        this.currentEditintDSN = ""; //String

        this.lastToolTipShowOnCellRow = -1;
        this.lastToolTipShowOnCellCol = -1;
        this.lastToolTipShowOnCellInnerRow = -1;
        this.lastToolTipText = "";


        this.splashOn = false; //boolean

        this.snapShot = null; //当前快照


        //创建DOM对象


        this.background = document.createElement('div');//背景
        this.background.id = 'background' + this.Sheet.guid;


        this.canvas = document.createElement('canvas');
        this.canvas.id = this.Sheet.guid;
        $(this.canvas).attr('tabindex', 1);  //让它可以用keyXXXX 事件
        $(this.canvas).attr('workbook', true);  //

        //把背景层，渲染层加入到容器中，之后容器会被加到bookView中， 背景层渲染层的尺寸会在bookView中初始化，并在resize中重新设置
        this.viewContainer = document.createElement('div');//视图对象的容器，它用来盛放背景，渲染层，控件对象
        $(this.viewContainer).css({
            position: 'absolute',
            left: 0,
            top: 0,
            width: '100%',
            height: '100%',
            'z-index': 0,
            'overflow': 'hidden'

        });

        this.viewContainer.id = 'workSheetView_contentContainer_' + this.Sheet.guid;

        $(this.viewContainer).append(this.background);
        $(this.viewContainer).append(this.canvas);


        this.graphics = null;
        this.invalidateRectList = [];

        //事件的侦听
        this.addMouseListener();
        this.addTouchListener();
        this.addKeyListener();


    }
    ,



    addMouseListener: function () {
        var me = $(this.canvas);
        var that = this;

        me.click({clickCount: 1}, this.mouseClicked.bind(this));
        me.dblclick({clickCount: 2}, this.mouseClicked.bind(this));
        me.mousedown(this.mousePressed.bind(this));
        me.mouseup(this.mouseReleased.bind(this));
        me.mouseenter(this.mouseEntered.bind(this));
        me.mouseout(this.mouseExited.bind(this));
        me.mousemove(this.mouseMoved.bind(this));

        //需要jqyery.mousewheel 插件的支持
        me.bind('mousewheel', this.mouseWheel.bind(this));

        //拖拽对象的支持
        me.bind('dragover', that.dragOver.bind(this));
        me.bind('drop', that.drop.bind(this));
    },

    addTouchListener: function () {


        var me = this.canvas;
        var that = this;


        me.addEventListener('touchstart', that.touchStart.bind(that)
            , false);

        me.addEventListener('touchmove', that.touchMove.bind(that)
            , false);

        me.addEventListener('touchend', that.touchEnd.bind(that), false);


        /*
                       touch.on(me, 'touchstart', function(e)
                       {
                           e.preventDefault();

                       });

                       touch.on(me,'swiperup' ,function(e)
                       {
                           var sheet=that.Sheet;
                           sheet.hScroll(5 * that.devicePixelRatio);
                       });

                       touch.on(me,'swiperdown' ,function(e)
                       {
                           var sheet=that.Sheet;
                           sheet.hScroll( -5 * that.devicePixelRatio);
                       });
       */

        /*   document.body.addEventListener('touchstart', function(e)
           {
               e.preventDefault();
               that.touchStart(e);

           }, { passive: false });


           document.body.addEventListener('touchmove', function(e)
           {
               e.preventDefault();
               that.touchMove(e);

           }, { passive: false });


           document.body.addEventListener('touchend', function(e)
           {
               e.preventDefault();
               that.touchEnd(e);

           }, { passive: false });


           me.addEventListener("touchstart", function(e) {

               that.touchStart(e);
           }, {
               passive: false //  禁止 passive 效果
           });

           me.addEventListener("touchend", function(e) {

               that.touchEnd(e);
           }, {
               passive: false //  禁止 passive 效果
           });



            me.addEventListener("touchmove", function(e) {

               that.touchMove(e);
          }, {
               passive: false //  禁止 passive 效果
            });

*/
    },

    addKeyListener: function () {
        var me = $(this.canvas);
        me.keydown(this.keyPressed.bind(this));//按下任意键
        me.keyup(this.keyReleased.bind(this));//松开
        me.keypress(this.keyTyped.bind(this));//按了一个可显示的字符
    },


    setActive: function (active) {

        this.viewContainer.style.display = active ? "" : "none";


        this.invalidate();
    }
    ,


    setCursor: function (curName) {

        if (this.cursorName)
        {
            if (this.cursorName == curName) return;
        }

        var cur = "js/spreadsheet/mouse/cursor/" + curName;
        this.cursorName = curName;

        $(this.canvas).css("cursor", "url(" + cur + ") 10 10,pointer");
    },

    setToolTipText: function (info) {
        if (info == undefined) info = "";
        $(this.canvas).title = info;
    },

    getCurrentSnapShot: function () {

        //得到当前快照
        if (!this.visible) return;
        if (this.snapShot != null) return; //如果上次快照还没有失效，那么不要重复取快照，因为快照也就是临时显示一下，并不需要太实时
        //在 setParintPermit(true)时，会把快照作废
        /*Rectangle*/
        let rc = this.getBounds();
        if (rc.width <= 0 || rc.height <= 0) return;
        this.snapShot = null;


    }
    ,


    /**
     * 强制某个区域（或整个区域）失效而重绘
     * @param rc
     */
    invalidate: function (rc, asyncDraw) {


        if (!rc)
        {
            rc = this.getBounds();
            if (this.Sheet.paintPermit) console.info(" 画全部");

            this.invalidateRectList.clear();
            this.invalidateRectList.push(rc);
        } else
        {

            var include = false;
            for (var i = 0; i < this.invalidateRectList.length; i++)
            {
                let clip = this.invalidateRectList[i];
                let rc2 = clip.intersection(rc);
                if (rc2.equals(rc) || rc2.equals(clip))
                {
                    include = true;
                    break;
                }

            }

            if (!include) this.invalidateRectList.push(rc);

        }

        if (!this.Sheet.paintPermit)
        {
            return;
        }

        let that = this;

        if (asyncDraw == undefined) asyncDraw = true;

        if ((this.Book.designMode || this.Sheet.designMode) || !asyncDraw)
        {
            this.paint();

        } else
        {

            if( Tools.isMobile() || true ) ////延迟画，虽然看上去降低了CPU占用，但是实际效果有卡顿，体验不好
            {
                this.paint();
            }
            else
            {//延迟画，虽然看上去降低了CPU占用，但是实际效果有卡顿，体验不好
                Tools.delayRun("sheetView-draw", function () {

                    that.paint();
                }, 50);
            }

        }

    },

    paint: function () {

        var g = this.graphics2d;

        var client = this.getBounds();
        //循环绘制需要重绘的区域
        for (var i = 0; i < this.invalidateRectList.length; i++)
        {
            let clip = this.invalidateRectList[i];

            g.invalidateRect = clip;
            this.onDraw(g, client, g.invalidateRect);
        }

        this.invalidateRectList = [];


    }
    ,

    /**
     * 重绘
     * @param g
     */
    repaint: function (rect) {

        if (rect == undefined)
        {
            this.graphics2d = null;
            this.invalidate(rect, true);
            return;
        }

        this.invalidate(rect);
    }
    ,


    /**
     * 通知表的行头及列头重绘
     */

    repaintHeader: function () {
        var rc = this.getBounds();
        var /*Rectangle*/  RowHeadRc = new Rectangle();
        RowHeadRc.x = 0;
        RowHeadRc.y = 0;
        RowHeadRc.width = this.RPM.getRowHeadWidth();
        RowHeadRc.height = rc.height;

        this.repaint(RowHeadRc);


        var /*Rectangle*/  ColHeadRc = new Rectangle();
        ColHeadRc.x = 0;
        ColHeadRc.y = 0;
        ColHeadRc.height = this.CPM.getColumnHeadHeight();
        ColHeadRc.width = rc.width;
        this.repaint(ColHeadRc);
    },

    onPrintPageHeader: function (g, rc) {
        var cell = this.Sheet.pageHeader;
        cell.setInvalid();
        cell.draw(true, g, rc);
    },

    onPrintPageFooter: function (g, rc) {
        var cell = this.Sheet.pageFooter;
        cell.setInvalid();
        cell.draw(true, g, rc);
    },

    forceCurrentEditControlGiveUpFocus:function ()
    {
        this.removeLastEdit();
    }

});

export default WorkSheetView ;
