/**
 * Created by zengjun on 2017/6/21.
 */


import Class from '../base/Class.js';
import ObjectPool from '../util/ObjectPool.js';
import Evaluate from '../eval/Evaluate.js';
import EventManager from '../core/EventManage.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';
import RowPropertyManage from './RowPropertyManage.js';
import EditStyle from '../core/EditStyle.js';
import NormalEdit from '../edit/NormalEdit.js';
import NumericEdit from '../edit/NumericEdit.js';
import DatetimeEdit from '../edit/DatetimeEdit.js';
import CheckboxEdit from '../edit/CheckboxEdit.js';
import DropDownListEdit from '../edit/DropDownListEdit.js';
import RadioAndMultiCheckEdit from '../edit/RadioAndMultiCheckEdit.js';
import TreeEdit from "../edit/TreeEdit.js";


function tabOnClick(li)
{
    li = $(li)[0];
    if (li.classList.contains('active')) return;
    var parent = li.parentNode;
    var innerTabs = parent.querySelectorAll('li');
    for (var index = 0, iLen = innerTabs.length; index < iLen; index++)
    {

        innerTabs[index].classList.remove('active');
    }

    li.classList.add('active');

}

var WorkBookView = Class.extend({

    static:
        {
            scrollBarSize: 18
        },

    properties: {

        "workBook": {
            get: function () {return this.Book;},
        }

    },

    constructor: function (book) {

        this.Book = book;
        this.containerID = this.Book.containerID;

        this.workSheetViews = [];
        this.domCache = {}; //

        //注意：

        //
        // 为什么要设计成所有的SheetView共用一对卷滚条？ 应该是参考Excel的设计，它的水平卷滚条与Tab页放在一个水平行内，所以
        // 是各个SheetView共用水平卷滚条。
        //现在看来，共用一组卷滚条是多么愚蠢的设计，当切换WorkSheetView时，要重新计算卷滚条状态 ，当workSheetView内嵌到Cell
        //中，或弹出显示时， 需要提供一个带卷滚条的容器来放View，并且Resize Column或Row时，也不对，总之很麻烦。
        //但是已经这么整了，麻烦基本上也解决了，留待有时间再优化


        let scrollBarSize = this.Clas$.scrollBarSize;

        var template = `
            
            <div class="tabbed  round  skin-asbestos  tabContainerDIV "  style="position:absolute;height:30px ;bottom:0; ">
			    <div style="position:absolute; left:0;width:100%;top:0px;height:1px; background-color:lightgray;">
			    </div>
			 
			    <ul class="tabContainer" id="${this.containerID}_tabContainer">
			    </ul>
			</div>
			  
			<div class="viewContainser  workBookViewContainer " id=${this.containerID}_bookViewContainer 
			   
			    style="position:absolute;
			                        left:0; 
			                        top:0px;
			                        bottom:30px;
			                        height:auto; 
			                        right:0px; 
			                        background-color:#ffffff;
			                        overflow:hidden; ">
            
                <!--用来做显示提示信息的坐标定位DOM --> 
                <div class="tooltipBasePoint" 
                        style="position:absolute;
                                left:0;
                                top:0;
                                width:1px;
                                height:1px; 
                                background-color:red;z-index:-91;">
                </div>
                
                <!--用来显示卷滚条   如果 width<18px ,卷滚条可能出不来 -->
                <div class="vScrollBar" style="position:absolute; 
                                                display:none;
                                                right:0; 
                                                width:${scrollBarSize}px; 
                                                opacity:0.5;
                                                top:0px; 
                                                bottom:0px; 
                                                height:auto;
                                                overflow-y:auto;
                                                z-index:2;">
                    <!--  用来控制卷滚条高度  -->              
                    <div class="content" style="width:0; background-color: transparent; " ></div>
                    </div>
               
                <!--用来显示水平卷滚条  如果 height<18px ,卷滚条可能出不来 -->
                <div class="hScrollBar" style="position:absolute;display:none;
                                              left:0; right:0px; 
                                              bottom:0; 
                                              height:${scrollBarSize}px; 
                                              opacity:0.5;
                                              overflow-x:auto; 
                                              z-index:2;">
                    <!--  用来控制卷滚条高度  ，如果不指定一个高度，那么，hScrollBar的卷滚条出不来-->              
                    <div class="content" style="background-color:white;height:20px;">
                    </div>
                    
                 </div>
                
            
            </div>
            
           
            `;


        $('#' + this.containerID).html(template);

        var vScrollBar = $('#' + this.containerID + ' .viewContainser .vScrollBar');
        vScrollBar.scroll(this.onVscroll.bind(this));//注意要强制切换到本View的上下文中执行
        vScrollBar.on('mouseover',function(){ vScrollBar.css("opacity",0.9);});
        vScrollBar.on('mouseout',function(){ vScrollBar.css("opacity",0.5);});



        var hScrollBar = $('#' + this.containerID + ' .viewContainser .hScrollBar');
        hScrollBar.scroll(this.onHscroll.bind(this));
        hScrollBar.on('mouseover',function(){ hScrollBar.css("opacity",0.9);});
        hScrollBar.on('mouseout',function(){ hScrollBar.css("opacity",0.5);});


        //resize处理
        $('#' + this.containerID + '_bookViewContainer').resize(this.resize.bind(this));


        this.vScrollingHandle = 0;
        this.hScrollingHandle = 0;

        //提示信息框，用在 showInfoPane中

        this.tipDOM = $(` 
                    <div  style=" position:fixed;
                                color: #fff;
                                padding:10px;
                                border-radius:5px;
                                z-index: 999999;
                                top:100px;
                                left:100px;
                                font-size:14px;
                                background-color:rgba(60, 60, 20, 0.65); 
                                display:none;
                                " 
                         id="${this.containerID}_tipinfo_container">
                                
                               
                    </div> 
                `).appendTo('body');

        this.tipDOM.on("mouseout", function (e) {

        }.bind(this));

        //2020.03.29 增加划屏到顶或到底时，显示提示信息，这需要一个绝对定位的DIV


        this.loadMoreDOM = $(` 
                    <div  style=" position:absolute;
                                z-index: 999999;
                                color:white;
                                top:-100px;
                                left:0px;
                                width:100%;
                                height:40px;
                                line-height:40px;
                                text-align:center;
                                vertical-align: middle;
                                font-size:14px;
                                background-color:rgba(60, 60, 20, 0.65); 
                              
                                " 
                         id="${this.containerID}_loadmore_info_container">
                                松开后刷新
                               
                    </div> 
                `).appendTo('body');


        this.dragToolDOM = $(` 
                    <div  style=" position:absolute;
                                z-index: 999999;
                                color:white;
                                top:100px;
                                left:-10000px;
                                width:100px;
                                height:40px;
                                line-height:40px;
                                text-align:center;
                                vertical-align: middle;
                                font-size:14px;
                                background-color:rgba(60, 255, 20); 
                                -webkit-appearance:none ;   " 
                         id="${this.containerID}_dragtoolbar_container">
                                工具工具
                               
                    </div> 
                `).appendTo('body');

    },

    setVisible:function(v)
    {
        $('#' + this.containerID).css("display",v?"":"none");
    },
    showInfoPane: function (info, left, top) {
        this.tipDOM.html(info);

        if (!left) left = (window.innerWidth - this.tipDOM.width() ) / 2;
        if (!top) top = ( window.innerHeight - this.tipDOM.height()) / 2;

        this.moveInfoPane(left, top);


    },

    /**
     *
     * @param left  相对窗口的坐标
     * @param top
     */
    moveInfoPane: function (left, top) {


        let scrollBarSize = this.Clas$.scrollBarSize;

        var w = this.tipDOM.width();
        var h = this.tipDOM.height();

        var ww = window.innerWidth;
        var wh = window.innerHeight;

        if (left + w > ww - scrollBarSize - 5) left = ww - scrollBarSize - 5 - w;

        if (top + h > wh - scrollBarSize - 5) top = wh - scrollBarSize - 5 - h;

        this.tipDOM.css({"left": left + "px", "top": top + "px", "display": ""});


    },

    hideInfoPane: function () {
        this.tipDOM.css("display", "none");
    },

    setShowTabOnWhere: function (val) {
        var tabContainer = $('#' + this.containerID + " .tabContainerDIV");
        //2020.06.18 排除嵌入Sheet，因为它们不在主界面中，不需要为Tab留空间
        var viewContainer = $('#' + this.containerID + " .viewContainser").not('.subSheetViewContainer');

        if (val == 'none')
        {
            tabContainer.css('display', 'none');
            viewContainer.css("top", "0");
            viewContainer.css("bottom", "0");
            viewContainer.css("height", "auto");
        }
        if (val == 'top')
        {
            tabContainer.css('display', '');
            tabContainer.css('top', '0');
            tabContainer.css('bottom', 'auto');

            viewContainer.css("top", "30px");
            viewContainer.css("bottom", "0");


            tabContainer.removeClass('tabbed');
            tabContainer.addClass('tabbed_top');
            // tabContainer.css("padding-top", "2px");


        }
        if (val == 'bottom')
        {
            tabContainer.css('display', '');
            tabContainer.css('top', '');
            tabContainer.css('bottom', '0');
            viewContainer.css("top", "0");
            viewContainer.css("bottom", "30px");
            viewContainer.css("height", "auto");

            tabContainer.removeClass('tabbed_top');
            tabContainer.addClass('tabbed');


        }



    },


    resize: function (forceDoIt) {

        console.info("resize   " + new Date());
        var viewContainer = $('#' + this.containerID + " .viewContainser");

        var w = viewContainer.width();
        var h = viewContainer.height();

        console.info(" last size: " + this.lastWidth + "," + this.lastHeight);
        console.info(" current size: " + w + "," + h);

        if (w == this.lastWidth && h == this.lastHeight)
        {
            console.info(" but  size  isn't changed ,  do nothing.  " + new Date());
            if(forceDoIt)
            {
                console.info("but force do it ");
            }else
            {
                return;
            }
        }

        this.lastWidth = w;
        this.lastHeight = h;


        Tools.delayRun("bookView-resize", function () {


            var viewContainer = $('#' + this.containerID + " .viewContainser");

            var w = viewContainer.width();
            var h = viewContainer.height();
            var activeView = this.Book.activeSheet.View;

            for (var i = 0; i < this.workSheetViews.length; i++)
            {
                let sheetView = this.workSheetViews[i];

                //2018.09.04 如果sheet被嵌入到面板中，那么它的size 不应再受当前bookview的影响
                if (sheetView.Sheet.pSheetContainer) continue;
                if (sheetView.Sheet.popupDialog) continue; //在弹窗中， 不受影响


                sheetView.viewContainer.style.width = w + "px";
                sheetView.viewContainer.style.height = h + "px";


                //背景的坐标从第一个单元格开始
                // 所以left , top 要以行头列头坐标为起始坐标，
                var chh = sheetView.CPM.getColumnHeadHeight();
                var rhw = sheetView.RPM.getRowHeadWidth();
                $(sheetView.background).css
                ({
                    width: (w - rhw) + 'px',
                    height: (h - chh) + 'px',
                    "top": `${chh}px`,
                    "left": `${rhw}px`,
                });


                sheetView.canvas.style.width = w + "px";
                sheetView.canvas.style.height = h + "px";

                sheetView.canvas.width = w;
                sheetView.canvas.height = h;

                //弹性列宽， 行高的重新计算
                sheetView.reCalcuColumnsWidth();
                sheetView.reCalcuRowsHeight();
                //重新显隐控件
                sheetView.Sheet.bricksShowOrHideWithWorkSheet();

                if (sheetView != activeView)
                {
                    setTimeout(function () {
                        sheetView.repaint();
                    }, 20);

                }

            }

            this.resetHScrollBarScrollRange();
            this.resetVScrollBarScrollRange();

            console.info("repaint after resize");
            activeView.repaint();
        }.bind(this), 100);
    },

    /**
     * 把 sheetView 添加到workBookView相应的DOM中
     * @param sheetView
     */
    addWorkSheetView: function (sheetView) {
        this.workSheetViews.push(sheetView);

        var viewContainer = $('#' + this.containerID + " .viewContainser");


        viewContainer.append(sheetView.viewContainer);

        var canvas = $(sheetView.canvas);

        var w = viewContainer.width();
        var h = viewContainer.height();


        var background = $(sheetView.background);


        var chh = sheetView.CPM.getColumnHeadHeight();
        var rhw = sheetView.RPM.getRowHeadWidth();


        background.css({
            'position': 'absolute',
            'z-index': 0,
            width: (w - rhw) + 'px',
            height: (h - chh) + 'px',
            "top": `${chh}px`,
            "left": `${rhw}px`,
            'display': '',
            'background-color': 'transparent',
            'outline': 'none' //让它不显示焦点外框
        });


        canvas.css({
            'position': 'absolute',
            'z-index': 0,
            'left': '0',
            'top': '0',
            'width': w + "px",
            'height': h + "px",
            'display': '',
            'outline': 'none' //让它不显示焦点外框
        });


        let sheet = sheetView.Sheet;
        //增加tab
        var tabContainer = $('#' + this.containerID + " .tabContainer");
        var html = ` <li   id="${sheet.guid}" >${sheet.name}</li> `;
        tabContainer.prepend(html);

        //在Tab的标签上双击进入改名状态
        $('#' + sheet.guid).dblclick(function () {

            if (!sheet.designMode) return; //设计状态下不允许修改名称

            $('#' + sheet.guid).html(`<div style="width:100%; padding-left:3px; padding-right:3px; ">
                           <input id=${sheet.guid}_rename type='text' value="${sheet.name}" style='width:100%;outline:none;border:0;'></div>
                           `
            );

            var input = $('#' + sheet.guid + '_rename');
            input.keydown(function (event) {
                if (event.keyCode == 13)
                {
                    var newName = $('#' + sheet.guid + '_rename').val();
                    sheet.name = newName;
                    $('#' + sheet.guid).html(sheet.name);
                }

                if (event.keyCode == 27) $('#' + sheet.guid).html(sheet.name);

            });

            input.blur(function (event) {

                var newName = $('#' + sheet.guid + '_rename').val();
                sheet.name = newName;
                $('#' + sheet.guid).html(sheet.name);


            });

            input[0].focus();

        });


        $("#" + this.containerID + '_tabContainer').sortable({
            axis: "x",
            cursor: "move",
            forcePlaceholderSize: true,
            opacity: 0.75,

            stop: this.reSortSheet.bind(this)
        });

        $("#" + this.containerID + '_tabContainer').disableSelection();


        let book = this.Book;
        let sheetGUID = sheet.guid;
        $('#' + sheetGUID).on('click', function () {
            book.setActiveSheet(sheetGUID);
        });


    },

    reSortSheet: function (event, ui) {
        if (!this.Book.designMode) return;

        var tabs = $("#" + this.containerID + '_tabContainer li');

        //注意，tab元素顺序与sheet是反的，
        for (var i = tabs.length - 1, si = 0; i >= 0; i--, si++)
        {
            var sheetGuid = tabs[i].id;
            this.Book.setWorkSheetIndex(this.Book.getWorkSheet(sheetGuid), si);
        }


    },

    removeWorkSheetView: function (sheetView) {

        var viewContainer = $('#' + this.containerID + " .viewContainser");
        $(sheetView.canvas).remove();
        //TODO  可能还需要移除实体的brick
        this.workSheetViews.remove(sheetView);
    },


    setActiveTab: function (sheetGUID) {
        var tabs = $('#' + this.containerID + " .tabContainer li");
        for (var i = 0; i < tabs.length; i++)
        {
            var li = tabs[i];
            if (li.id == sheetGUID)
            {
                li.classList.add('active');
            } else
            {
                li.classList.remove('active');
            }
        }
    },

    removeTab: function (sheetGUID) {
        var tab = $('#' + this.containerID + " .tabContainer");
        $('#' + sheetGUID).remove();

    },

    setTabVisible: function (sheetGUID, visible) {
        var tabs = $('#' + this.containerID + " .tabContainer li");
        for (var i = 0; i < tabs.length; i++)
        {
            var li = tabs[i];
            if (li.id == sheetGUID)
            {
                $(li).css("display", visible ? "" : "none");
                break;
            }
        }
    },

    setTabTitle: function (sheetGUID, title) {
        var tabs = $('#' + this.containerID + " .tabContainer li");
        for (var i = 0; i < tabs.length; i++)
        {
            var li = tabs[i];
            if (li.id == sheetGUID)
            {
                $(li).text(title);
                break;
            }
        }
    },

    /**
     * 当sheet激活后， 根据sheet 的size,pos 调整卷滚条
     * @constructor
     */
    resetVScrollBarScrollRange: function () {
        var sheet = this.Book.getActiveSheet();
        var h = sheet.RPM.getAllRowsHeight();// - sheet.RPM.getFixedRowHeight();
        var vScrollBar = $('#' + this.containerID + ' .viewContainser .vScrollBar');
        vScrollBar.css('top', sheet.CPM.getColumnHeadHeight() + "px");


        if (h <= vScrollBar.height() + this.Clas$.scrollBarSize)
        {

            vScrollBar.hide();
            sheet.yOffset = 0;
        } else
        {
            //当有嵌入的SheetContainer时，
            vScrollBar.find('.content').height(h + 1);
            vScrollBar.show();
            this.vScrollTo(sheet.yOffset);
        }


    },

    resetHScrollBarScrollRange: function () {

        var sheet = this.Book.getActiveSheet();
        var w = sheet.CPM.getAllColumnsWidth() //- sheet.CPM.getFixedColumnWidth();
        //console.info(" width:" + w);
        var hScrollBar = $('#' + this.containerID + ' .viewContainser .hScrollBar');

        hScrollBar.css('left', sheet.RPM.getRowHeadWidth() + "px");


        if (w <= hScrollBar.width() + this.Clas$.scrollBarSize)
        {

            hScrollBar.hide();
            sheet.xOffset = 0;
        } else
        {
            hScrollBar.find('.content').width(w + 1);
            hScrollBar.show();
            this.hScrollTo(sheet.xOffset);
        }


    },

    onVscroll: function () {
        if (this.vScrollingHandle != 0)
        {
            clearTimeout(this.vScrollingHandle);
            this.vScrollingHandle = 0;
        }

        //  this.vScrollingHandle = setTimeout(function () {
        var vScrollBar = $('#' + this.containerID + ' .viewContainser .vScrollBar');
        if (vScrollBar.length == 0) return;

        var offset = vScrollBar[0].scrollTop;
        var sheet = this.Book.getActiveSheet();


        sheet.yOffset = offset;

        if (sheet.justScrolledToBottom) //这个是当前卷滚条是不是已经卷到最下面
        {
            if (sheet.loadMoreWhenScrollToBottom) //这个是开关项
            {
                sheet.Book.EM.fire("loadMoreWhenScrollToBottom", [sheet]);

            }

        }

    },

    onHscroll: function () {
        var hScrollBar = $('#' + this.containerID + ' .viewContainser .hScrollBar');
        if (hScrollBar.length == 0) return;

        var offset = hScrollBar[0].scrollLeft;
        var sheet = this.Book.getActiveSheet();
        sheet.xOffset = offset;


    },


    vScrollTo: function (pos) {
        var vScrollBar = $('#' + this.containerID + ' .viewContainser .vScrollBar');
        if (vScrollBar.length == 0) return;

        var offset = vScrollBar[0].scrollTop;
        if (pos == offset) return;
        vScrollBar.scrollTop(pos);

    },

    hScrollTo: function (pos) {
        var hScrollBar = $('#' + this.containerID + ' .viewContainser .hScrollBar');
        if (hScrollBar.length == 0) return;

        var offset = hScrollBar[0].scrollLeft;
        if (pos == offset) return;
        hScrollBar.scrollLeft(pos);

    },


    /**
     * 创建编辑控件
     * @param es
     * @returns {NormalEdit}
     */
    createEditComponent: function (es) {

        if (es == null) return new NormalEdit(this.createNormalDOM());
        if (es.ET == EditStyle.$Normal) return new NormalEdit(this.createNormalDOM(),es);
        if (es.ET == EditStyle.$MultiLine) return new NormalEdit(this.createMultiLineDOM(),es);
        if (es.ET == EditStyle.$Numeric) return new NumericEdit(this.createNumericDOM(), es);
        if (es.ET == EditStyle.$Datetime) return new DatetimeEdit(this.createDatetimeDOM(), es);
        if (es.ET == EditStyle.$CheckBox) return new CheckboxEdit(this.createCheckboxDOM(), es);
        if (es.ET == EditStyle.$DDLB) return new DropDownListEdit(this.createDropDownListDOM(), es);
        if (es.ET == EditStyle.$RadioButton) return new RadioAndMultiCheckEdit(this.createCheckboxDOM(), es);
        if (es.ET == EditStyle.$MultiCheckBox) return new RadioAndMultiCheckEdit(this.createCheckboxDOM(), es);
        if (es.ET == EditStyle.$Tree) return new TreeEdit(this.createTreeDOM(), es);


    },


    createDOM: function (name, html) {

        var key = name;
        var dom = this.domCache[key];
        if (!dom)
        {
            dom = $(html);
            this.domCache[key] = dom;
            //console.info("new dom");
        } else
        {
            //console.info(" from cache");
        }


        return dom;
    },

    createNormalDOM: function () {

        var key = 'normal';
        var dom = this.domCache[key];
        if (!dom)
        {
            dom = $(`<input type="text" 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green; 
                            -webkit-appearance:none ;
                            ">
                        `);
            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;
            //console.info("new dom");
        } else
        {
            //console.info(" from cache");
        }

        $(dom).val('');
        return dom;
    },

    getViewContainerDOM: function () {
        var container = $($('#' + this.containerID + ' .workBookViewContainer')[0]);
        return container;
    },

    createMultiLineDOM: function () {

        var key = 'multiline';
        var dom = this.domCache[key];
        if (!dom)
        {
            dom = $(`<textarea 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green; 
                            "></textarea>
                        `);
            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;
            console.info("new dom");
        } else
        {
            console.info(" from cache");
        }

        $(dom).val('');
        return dom;
    },

    createNumericDOM: function () {

        var key = 'numeric';
        var dom = this.domCache[key];
        if (!dom)
        {
            dom = $(`<input type="text" 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green; 
                            text-align:right;
                            -webkit-appearance:none ;
                            ">
                        `);
            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;

        }
        $(dom).val('');
        return dom;
    },


    createDatetimeDOM: function () {

        var key = 'datetime';
        var dom = this.domCache[key];
        var bkImg = 'js/spreadsheet/img/cal32.png';
        var readonly =  Tools.isMobile()? 'readonly="readonly" ' : '';

        if (!dom)
        {
            dom = $(`<input type="text" 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green;
                            background-image:url(${bkImg});
                            background-repeat:no-repeat no-repeat;
                            background-size:16px 16px ;
                            background-position:right center;
     
                            " ${readonly} >
                        `);
            if( Tools.isMobile())
            {
                dom.attr('tabindex', 0);

            }else
            {
                dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            }
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;


        }


        dom.css("position", 'absolute'); //

        dom.val('');
        return dom;
    },

    createCheckboxDOM: function () {

        var key = 'checkbox';
        var dom = this.domCache[key];
        var cur = 'js/spreadsheet/mouse/cursor/hand.gif';
        if (!dom)
        {
            dom = $(`<canvas 
                            style="position:absolute;
                              cursor:url(${cur}) 10 10,pointer ;
           
                            "></canvas>
                        `);
            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.attr('workbook', true);  //表示需要自适应高清屏

            dom.css({
                    "outline": "none",// 不要显示 焦点框
                    "border": 0,  // 不要显示 焦点框
                    "background-color": 'white'
                } // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            );
            this.domCache[key] = dom;

        }

        return dom;
    },

    createDropDownListDOM: function () {

        var key = 'ddlb';
        var bkImg = 'js/spreadsheet/img/close48.png';
        var dom = this.domCache[key];
        if (!dom)
        {
            if( Tools.isMobile())
            {
                dom = $(`<input type="text"   style="position:absolute;   "> `);
            }else
            {
                dom = $(`<input type="text" 
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green; 
                            background-image:url(${bkImg});
                            background-repeat:no-repeat no-repeat;
                            background-size:16px 16px ;
                            background-position:right top;
                            
                            ">
                        `);
            }

            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;

        }

        return dom;
    },

    createTreeDOM: function () {

        var key = 'tree';
        var bkImg = 'js/spreadsheet/img/close48.png';
        var dom = this.domCache[key];
        if (!dom)
        {
            dom = $(`<input type="text" readonly="readonly" value="请选择："  
                            style="position:absolute;
                            border-radius:2px;
                            -moz-box-shadow:0px 0px 3px green; 
                            -webkit-box-shadow:0px 0px 3px green; 
                            box-shadow:0px 0px 3px green;
                            background-image:url(${bkImg});
                            background-repeat:no-repeat no-repeat;
                            background-size:16px 16px ;
                            background-position:right top;
                            -webkit-appearance:none ;
                             
                            ">
                        `);
            dom.attr('tabindex', 1);  //让它可以用keyXXXX 事件
            dom.css("outline", "none"); // 不要显示 焦点框
            dom.css("border", 0); // 不要显示 焦点框
            dom.css("background-color", 'white'); // 编辑框是直接盖在被编辑的单元格上， 不能透明，不然就透过去看见canvas上的内容了
            this.domCache[key] = dom;

        } else
        {

        }

        return dom;
    },


    forceCurrentEditControlGiveUpFocus: function () {
        this.Book.getActiveSheet().View.forceCurrentEditControlGiveUpFocus();

    },

    forceCurrentEditControlFillBack: function () {
        this.Book.getActiveSheet().View.forceCurrentEditControlFillBack();

    },

    tooltipBasePoint: function () {
        return $('#' + this.containerID + ' .tooltipBasePoint');
    }

});

export default WorkBookView;
