/**
 * Created by zengjun
 */


import Class from '../base/Class.js';
import Tools from '../util/Tools.js';
import Util from '../util/Util.js';
import ObjectTool from '../db/ObjectTool.js';
import UniformDataType from '../core/UniformDataType.js';


var  Property = Class.extend({

    static: {


        border_left_style: 'border-left-style',
        border_left_width: 'border-left-width',
        border_left_color: 'border-left-color',
        border_top_style: 'border-top-style',
        border_top_width: 'border-top-width',
        border_top_color: 'border-top-color',
        border_right_style: 'border-right-style',
        border_right_width: 'border-right-width',
        border_right_color: 'border-right-color',
        border_bottom_style: 'border-bottom-style',
        border_bottom_width: 'border-bottom-width',
        border_bottom_color: 'border-bottom-color',
        //边距
        padding_left: 'padding-left',
        padding_top: 'padding-top',
        padding_right: 'padding-right',
        padding_bottom: 'padding-bottom',
        //背景
        background_attachment: 'background-attachment',
        background_color: 'background-color',//支持表达式
        background_color_expression: 'background-color-expression',//支持表达式

        background_image: 'background-image',
        background_position: 'background-position',
        background_repeat: 'background-repeat',
        background_clip: 'background-clip',
        background_origin: 'background-origin',
        background_size: 'background-size',
        //字体
        font_family: 'font-family',
        font_size: 'font-size',
        font_italic: 'font-italic',
        font_underline: 'font-underline',
        font_bold: 'font-bold',

        color: 'color',//支持表达式
        color_expression: 'color-expression',
        //对齐
        word_wrap: 'word-wrap',
        text_align: 'text-align',
        vertical_align: 'vertical-align',
        //显示
        display: 'display',
        border_raduis: 'border-raduis'


    },
    properties: {

        "propertyCount": {
            get: function () {
                return
                Object.getOwnPropertyNames(this.property).length;
            }
        }
    },


    constructor: function (needInit , guid, propertyConfig) {

        this.property = {};
        if (needInit)
        {
            this.property = {

                //边框
                'border-left-style': 0,
                'border-left-width': 0,
                'border-left-color': '',

                'border-top-style': 0,
                'border-top-width': 0,
                'border-top-color': '',

                'border-right-style': 0,
                'border-right-width': 0,
                'border-right-color': '',

                'border-bottom-style': 0,
                'border-bottom-width': 0,
                'border-bottom-color': '',
                //边距
                'padding-left': 1,
                'padding-top': 1,
                'padding-right': 1,
                'padding-bottom': 1,

                //背景
                //http://www.w3school.com.cn/cssref/index.asp#background
                'background-attachment': 'scroll',
                'background-color': 'transparent', //   支持表达式
                'background-color-expression': '',
                'background-image': '',
                'background-position': 'left top',
                'background-repeat': 'repeat-x repeat-y',
                'background-clip': 'border-box',
                'background-origin': '',
                'background-size': '',

                //字体
                'font-family': '宋体',
                'font-size': 14,
                'font-italic': false,
                'font-underline': false,
                'font-bold': false,
                'word-wrap': '',  // none , normal
                'color': 'black',  //   支持表达式
                'color-expression': '',

                //对齐
                'text-align': 999,  //left ,right ,center
                'vertical-align': 2, // top  middle  bottom


                //显示
                //2020.09.30 去掉了这个属性，不适合放在这里，而是应该放到单元格自已的属性中，
                //'display': ''  //  ''或none   支持表达式
            };
        }
        this.refCount = 0;
        this.GUID =  guid || Tools.newGUID();

        if(propertyConfig )
        {
             Util.merge(  this.property , propertyConfig ,true);

        }

    }
    ,



    get: function (propName, defaultValue) {
        var v = this.property[propName];
        if (v == undefined)
        {
            if (defaultValue != undefined) return defaultValue;
            try
            {
                v = this.Clas$.propertyDefaultValue[propName];
                return v;
            } catch (e)
            {
                return null;
            }

        }

        //类型转换
        if (defaultValue != null)
        {
            if (Util.isInteger(defaultValue)) v = ObjectTool.changeType(v, UniformDataType.$Integer);


        }
        return v;
    },

    /**
     * 等价于set
     * @param propName
     * @param value
     * @returns {*}
     */
    put: function (propName, value) {
        return this.set(propName, value);
    },

    set: function (propName, value) {
        this.property[propName] = value;
    },


    addRef: function () {
        this.refCount++;
    },


    releaseRef: function () {
        this.refCount--;
    },


    /**
     * 判断两个属性对象是否相等
     * 　当包含相同个数的相同名称的属性，且各个属性的值也是相同的，此时才能认定两个属性对象是相等的
     */

    equals: function (p) {
        if (p == null) return false;

        if (this.propertyCount != p.propertyCount) return false;

        for (var propName in this.property)
        {
            var v1 = this.property[propName];
            var v2 = p.get(propName);
            if (v1 != v2) return false;
        }
        return true;
    },


    //把自己克隆一份
    copyTo: function (toObj) {
        for (var propName in this.property)
        {
            var v = this.property[propName];
            toObj.set(propName, v);
        }
    },

    toString: function () {
        return JSON.stringify(this.property);
    },

    serializeFrom: function (p) {
        p = JSON.parse(p);

        if (p.property) this.property = p.property;
        if (p.GUID) this.GUID = p.GUID;
        if (p.refCount) this.refCount = p.refCount;
    },

    serializeTo: function () {
        return JSON.stringify({property: this.property, GUID: this.GUID, refCount: this.refCount});
    }

});

export default Property ;
