/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';

import Range from './Range.js';
import Cell from './Cell.js';
import WorkSheet from './WorkSheet.js'


var MergedRange = Class.extend({

    constructor: function (p1, p2) {



        if (p1.instanceOf(Cell) && p2.instanceOf(Cell))
        {
            this.mergeStart = p1;
            this.mergeEnd = p2;
        }

        if (p1.instanceOf(WorkSheet) && p2.instanceOf(Range))
        {
            this.mergeStart = p1.cells(p2.startRow, p2.startCol);
            this.mergeEnd = p1.cells(p2.endRow, p2.endCol);
        }
    },


    getMergedRange: function () {
        if (this.mergeStart == null) return new Range(-1, -1, -1, -1);
        if (this.mergeEnd == null) return new Range(-1, -1, -1, -1);

        return new Range(this.mergeStart.rowIndex, this.mergeStart.columnIndex,
            this.mergeEnd.rowIndex, this.mergeEnd.columnIndex);

    }


});
export default MergedRange;
