/**
 * Created by 三宝爹 on 2017/10/14.
 */


import DrawTool from '../../mouse/DrawTool.js';
import Tools from '../../util/Tools.js';
import Util from '../../util/Util.js';
import Range from '../../core/Range.js';
import DataSourceConfig from '../../core/DataSourceConfig.js';


var IMouseListener = {
    mouseClicked: function (/*Event*/ e) {



        //TODO 停止闪烁
        //this.splash(false);

        var /*Cell*/  cell = null;

        //TODO 编辑强制失去焦点
        /*
        var  lastEdit = this.$getCurrentEditingEdit();
        if (lastEdit != null) lastEdit.giveUpFocus();
        */

        if (e.which == 2)
        { // 在水平滚动和垂直滚动之间切换
            // m_pView.m_WheelV = !m_pView.m_WheelV;
        }

        if (e.which == 1)//左键按下
        {
            //console.info(" click count"+ e.data.clickCount);
            if (e.data.clickCount == 1)
            {
                var pTool = DrawTool.CurrentTool();
                if (pTool != null) pTool.OnLButtonClick(this, e);
            }

            if (e.data.clickCount == 2)
            {
                var pTool = DrawTool.CurrentTool();
                if (pTool != null) pTool.OnLButtonDblClk(this, e);

            }
        }



        // TODO 点右键菜单后，应阻止继续处理鼠标，可能导致明细绑定的当前行变掉，尚未 测试
        //e.consume();
        // 触发事件
        // EM.FireMouseClicked(e);


    },

    mousePressed: function (/*Event*/ e) {
        //console.info('mousePressed');
        var pTool = DrawTool.CurrentTool();
        if (pTool != null)
        {
            if (e.which == 1)
            {
                pTool.OnLButtonDown(this, e);
            }
            if (e.which == 3)
            {
                pTool.OnRButtonDown(this, e);
            }


        }
    },

    mouseReleased: function (/*Event*/ e) {

        //console.info('mouseReleased');
        var pTool = DrawTool.CurrentTool();
        if (pTool != null)
        {
            if (e.which == 1) pTool.OnLButtonUp(this, e);
        }

    },

    mouseEntered: function (/*Event*/ e) {

        var pTool = DrawTool.CurrentTool();
        if (pTool != null) pTool.OnMouseEntered(this, e);
    },

    mouseExited: function (/*Event*/ e) {
        var pTool = DrawTool.CurrentTool();
        if (pTool != null) pTool.OnMouseExited(this, e);

    },

    mouseDragged: function (e) {

        var pTool = DrawTool.CurrentTool();
        if (pTool != null) pTool.OnMouseDrag(this, e);

    },

    mouseMoved: function (e) {
        // console.info('mouseMoved');
        var pTool = DrawTool.CurrentTool();
        if (pTool != null) pTool.OnMouseMove(this, e);
    },

    mouseWheel: function (e) {

        e.preventDefault();
        //2020.05.01修正，当在手机上，一个单元格正在编辑时，此时划屏，应该放弃编辑，不然输入框浮在界面上
        this.forceCurrentEditControlGiveUpFocus();

        var sheet=this.Sheet;

        var delta = event.deltaY;

        var scrolled = sheet.vScroll(delta);

        if (Math.abs(delta) <= 2 || !scrolled)  //如果步进为0，或者已经划到头了，那么停止
        {

            //向下划，只要到底就触发刷新


            if (sheet.releaseDragToLoadMoreBottom) //这个是当前划动动作是不是划到底
            {
                if (sheet.loadMoreWhenScrollToBottom) //这个是开关项
                {
                    sheet.Book.EM.fire("loadMoreWhenScrollToBottom", [sheet]);

                }

            }
        }

        /*

        // 不能直接退出， 因为如果滚得很快，那么this.Sheet.yOffset + delta会一下子变负数，如果 退出，就滚不到头上了
        var yOffset = this.Sheet.yOffset + delta;
        if (yOffset <= 0) yOffset = 0;


        this.Sheet.yOffset = yOffset;
        */


    },

    drop: function (e) {

        if( e.originalEvent) e=e.originalEvent;

        console.dir(e);
        e.preventDefault();

        this.Sheet.setMovingSelection(null);

        var data = e.dataTransfer.getData("Text");
        try
        {
            if (data) data = JSON.parse(data);
        } catch (err)
        {
            console.info(err);
            return;
        }

        if (data.action)
        {
            if (data.action == 'dblClickSort') //选择双击排序的字段名
            {
                var row = this.GetRowAtPoint(false, e.offsetY);

                if (Util.isObject(row)) row = row.row;
                var col = this.GetColAtPoint(false, e.offsetX, row);
                var cell = this.Sheet.cells(row, col);
                if (cell)
                {
                    if (cell.merged) cell = cell.leftTopCorner;
                    if (cell.Bind == null)
                    {
                        toastr.info("选择的单元格没有绑定数据库");
                        return;
                    }


                    var /*DataSourceConfig*/   dsc = this.Sheet.Book.getDataSource(cell.Bind.dataSource);

                    var dst = dsc.dataSourceType;
                    if (dst != DataSourceConfig.MultiRowDataSource)
                    {
                        toastr.info("选择的结果集不是多行结果集，不需要排序");
                        return;
                    }

                    var r = this.Sheet.getSelection();
                    var sourceCell = this.Sheet.cells(r.startRow, r.startCol);
                    sourceCell.dblClickSort = cell.Bind.dataSource + "." + cell.Bind.DBCol;

                    //强制设置一下，触发selection改变事件，让属性设置功能重新加载单元格的属性
                    this.Sheet.setSelection(sourceCell.rowIndex, sourceCell.columnIndex,
                        sourceCell.rowIndex, sourceCell.columnIndex, true);

                }

            }


            if (data.action == 'bind')
            {
                var row = this.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row)) row = row.row;
                var col = this.GetColAtPoint(false, e.offsetX, row);
                var cell = this.Sheet.cells(row, col);
                if (cell)
                {
                    if (cell.merged) cell = cell.leftTopCorner;


                    cell.setBind(data.table, data.col, 0); //0表示自动判断

                    //自动设置别名

                    if (this.Sheet.cells(data.col) == null)
                    {
                        this.Sheet.cells(row, col).alias = data.col;
                    } else if (this.Sheet.cells(data.table + '_' + data.col) == null)
                    {
                        this.Sheet.cells(row, col).alias = data.table + '_' + data.col;
                    } else
                    {

                    }

                    //强制设置选中区域，并强制触发事件
                    cell.Sheet.setSelection(cell.rowIndex, cell.columnIndex, cell.rowIndex, cell.columnIndex, true);

                    var alias = cell.alias;

                    cell = this.Sheet.cells(row - 1, col);

                    if (cell != null)
                    {
                        if (cell.merged) cell = cell.leftTopCorner;
                        var v = cell.getValue();
                        if (v == null) v = '';
                        if (v == '' && cell.bind == null)
                        {
                            cell.setValue(data.label);
                            cell.alias = 't_' + alias;
                        }
                    }

                }


            }
            var columnDOM = $(document.getElementById(data.id)); //用 $('#'+data.id) 无法得到该对象，非常奇怪
            if (columnDOM.length > 0) columnDOM.remove();
        }


        return false;
    },

    dragOver: function (e) {

        if( e.originalEvent) e=e.originalEvent;

        e.preventDefault();


        var row = this.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = this.GetColAtPoint(false, e.offsetX, row);

        var ms = this.Sheet.getMovingSelection();
        if (ms == null) ms = new Range(-1, -1, -1, -1);

        if (!(row == ms.startRow && col == ms.startCol))
        {
            this.Sheet.setMovingSelection(new Range(row, col, row, col));
        }


        return false;
    }


};

export default IMouseListener;
