/**
 * Created by 三宝爹 on 2017/10/26.
 */


import Rectangle from '../../gdi/Rectangle.js';
import Range from '../Range.js';
import DataSourceConfig from '../DataSourceConfig.js';

import Point from '../../gdi/Point.js';


var IEditFocusJump = {

    /**
     * 寻找某行中第一个绑定到指定数据源的列号
     *
     *
     * @return
     */
    findFirstColumnWhichBindToSomeDataSource: function (row, dataSource, startCol, endCol, /*boolean*/forEdit) {
        var start = startCol;
        var end = endCol;
        if (dataSource == null) dataSource = "";
        for (let col = start; col <= end; col++)
        {
            var cell = this.Sheet.$cells(row, col);
            if (cell == null) continue;
            if (!cell.editable && forEdit) continue;
            var /*DBBindConfig*/ bind = cell.Bind;
            if (bind == null) continue;
            if (dataSource.equals("")) return col; //如果没有指定绑定到哪个数据源，那么只要是绑定的，那么就返回
            if (bind.dataSource.equalsIgnoreCase(dataSource)) return col;
        }
        return -1;
    },

    findLastColumnWhichBindToSomeDataSource: function (row, dataSource, startCol, endCol, /*boolean*/ forEdit) {
        var start = endCol;
        var end = startCol;
        if (dataSource == null) dataSource = "";
        for (let col = start; col >= end; col--)
        {
            var cell = this.Sheet.$cells(row, col);
            if (cell == null) continue;
            if (!cell.editable && forEdit) continue;
            var /*DBBindConfig*/ bind = cell.Bind;
            if (bind == null) continue;
            if (dataSource.equals("")) return col; //如果没有指定绑定到哪个数据源，那么只要是绑定的，那么就返回
            if (bind.dataSource.equalsIgnoreCase(dataSource)) return col;
        }
        return -1;

    },


//运行模式下跳到下一列可编辑单元中
// 但本函数不保证选中区域处于可见区
    JumpToNextColumnEditableObject: function (row, col) {

        // 下面需要找row行中第一个绑定到数据源的单元格的列号
        //但由于col可能为-1 ,所以要注意row,col不一定是定位到合法的单元格

        var leftTopCornerRow = row;
        var leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);

        if (leftTopCornerOfCurrentCell != null)
        {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.rowIndex;
        }

        var /*Range*/  focusRange = this.Sheet.getCurrentFocusRange();

        //   _____________________________________________________________
        //                 |................|................|....b..... |
        //	       A1      |................|................|...........|
        //	               |................|................|...........|
        //	_______________|________________|________________|___________|

        //		 如果已经是焦点区的最后一列 ,比如处于b这个位置
        //或者处于焦点区之外　，比如用鼠标在非编辑区点了一下
        if (col >= focusRange.endCol)
        {
            // 如果这个单元格是绑定到一个MultiRow的数据源，那么
            //找到同行的最后一个绑定到数据源的单元格中的列，得到它的数据源名称

            var lastCol = this.findLastColumnWhichBindToSomeDataSource(
                leftTopCornerRow,
                this.$getCurrentEditintDSN(),
                focusRange.startCol,
                focusRange.endCol,
                true);

            var cell = this.Sheet.$cells(leftTopCornerRow, lastCol);
            if (cell != null)
            {
                // 在运行时，需要看这个单元格的左上角的单元格
                cell = cell.getLeftTopCorner();
                var /*DBBindConfig*/ bind = cell.Bind;
                if (bind != null)
                {
                    var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(bind.dataSource);
                    //如果是绑定到多行DataStore上
                    if (bind.dataSourceType == DataSourceConfig.MultiRowDataSource)
                    {
                        var ds = dsc.dataStore;
                        if (ds.rowCount > 0)
                        {
                            var currentRow = dsc.currentBindRow + 1;
                            // 如果有下一个数据行，那么就把该数据源的当前行设置成下一行
                            var RC = ds.rowCount;
                            if (currentRow < RC)
                            {
                                //寻找同一行中第一个绑定到指定数据源的列号
                                var firstCol = this.findFirstColumnWhichBindToSomeDataSource(
                                    leftTopCornerRow,
                                    bind.dataSource,
                                    focusRange.startCol,
                                    focusRange.endCol,
                                    true);

                                if (firstCol >= 0)
                                {

                                    this.Sheet.setSelection(row, firstCol, row, firstCol);
                                    dsc.setCurrentBindRow(currentRow);

                                    return;
                                }
                            }
                        }
                    }
                }
            }

            // 2 那么就跳到下一个焦点区的开始位置

            if (row == focusRange.endRow ||
                row == this.Sheet.rowCount - 1 ||
                leftTopCornerRow == focusRange.endRow ||
                leftTopCornerRow == this.Sheet.rowCount - 1)
            {
                // 如果已经是最后一行，那么无处可去了,那么就跳到下一个焦点分区吧
                if (this.Sheet.isInLastFocusRange())
                {
                    console.info(" no way to jump");
                    return;
                }
                this.Sheet.moveToNextFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                this.JumpToNextColumnEditableObject(focusRange.startRow, focusRange.startCol - 1); //注意列要减一
                return;
            }

            //Tools.log("到第"+row+"行");
            row++;
            col = focusRange.startCol - 1; //先退一格，
            //在递归调用时会向前进一格
            this.JumpToNextColumnEditableObject(row, col);
            return;

        } else
        // 不是最后一个列，那就跳到下一个列
        {
            col++;
            var cell = this.Sheet.$cells(row, col);
            if (cell != null) // 如果下一个单元格
            {
                cell = cell.getLeftTopCorner();
                //Tools.log("cell "+row+":"+col+"  编辑属性："+ cell.editable);
                if (cell.editable)
                {
                    var /*DBBindConfig*/ dbc = cell.Bind;
                    if (dbc == null) // 如果没有绑定到数据库
                    {
                        this.Sheet.setSelection(row, col, row, col);
                        return;
                    } else
                    //如果绑定到了数据库，
                    {
                        //如果有数据
                        if (this.Sheet.Book.getDataSource(dbc.dataSource).dataStore.rowCount > 0)
                        {
                            this.Sheet.setSelection(row, col, row, col);
                            var /*String*/ dsn = dbc.dataSource;
                            var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                            //如果不是同一个数据源，那么设置第０行为当前编辑行
                            if (!dsn.equals(this.$getCurrentEditintDSN()))
                            {
                                if (dbc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                                {
                                    dsc.setCurrentBindRow(0);

                                }
                            }
                            return;
                        }
                    }
                }
            }
            // 到这里，说明下一个单元格是不可编辑的，那么继续下一个
            this.JumpToNextColumnEditableObject(row, col);

        }

    },

    JumpToPriorColumnEditableObject: function (row, col) {

        // 下面需要找row行中第一个绑定到数据源的单元格的列号
        //但由于col可能为columnCount  ,所以要注意row,col不一定是定位到合法的单元格

        var leftTopCornerRow = row;
        var leftTopCornerCol = col;

        var leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);

        if (leftTopCornerOfCurrentCell != null)
        {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();

            leftTopCornerRow = leftTopCornerOfCurrentCell.rowIndex;
            leftTopCornerCol = leftTopCornerOfCurrentCell.columnIndex;
        }


        var /*Range*/  focusRange = this.Sheet.getCurrentFocusRange();

        //   _____________________________________________________________
        //                   |...............|................|.......... |
        //	       A1        |...............|................|.......... |
        //	                 |....b .........|................|.......... |
        //	_________________|_______________|________________|___________|

        //		 如果已经是焦点区的最前一列 ,比如处于b这个位置
        //或者处于焦点区之外　，比如用鼠标在非编辑区点了一下
        if (col <= focusRange.startCol)
        {
            // 如果这个单元格是绑定到一个MultiRow的数据源，那么
            //找到同行的第一个绑定到数据源的单元格中的列，得到它的数据源名称

            var lastCol = this.findLastColumnWhichBindToSomeDataSource(
                leftTopCornerRow,
                this.$getCurrentEditintDSN(),
                focusRange.startCol,
                focusRange.endCol,
                true);

            var cell = this.Sheet.$cells(leftTopCornerRow, lastCol);
            if (cell != null)
            {
                // 在运行时，需要看这个单元格的左上角的单元格
                cell = cell.getLeftTopCorner();
                var /*DBBindConfig*/ bind = cell.Bind;
                if (bind != null)
                {
                    var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(bind.dataSource);
                    //如果是绑定到多行DataStore上
                    if (bind.dataSourceType == DataSourceConfig.MultiRowDataSource)
                    {
                        var ds = dsc.dataStore;
                        var RC = ds.rowCount;
                        if (RC > 0)
                        {
                            var currentRow = dsc.currentBindRow - 1;
                            // 如果有上一个数据行，那么就把该数据源的当前行设置成上一行
                            if (currentRow >= 0)
                            {
                                //寻找同一行中最后一个绑定到指定数据源的列号
                                lastCol = this.findLastColumnWhichBindToSomeDataSource(
                                    leftTopCornerRow,
                                    bind.dataSource,
                                    focusRange.startCol,
                                    focusRange.endCol,
                                    true);

                                if (lastCol >= 0)
                                {

                                    this.Sheet.setSelection(row, lastCol, row, lastCol);
                                    dsc.setCurrentBindRow(currentRow);

                                    return;
                                }
                            }
                        }
                    }
                }
            }

            // 2 那么就跳到下一个焦点区的开始位置

            if (row == focusRange.startRow ||
                leftTopCornerRow == focusRange.startRow ||
                row == 0 ||
                leftTopCornerRow == 0)
            {
                // 如果已经是最前一行，那么无处可去了,那么就跳到下一个焦点分区吧
                if (this.Sheet.isInFirstFocusRange())
                {

                    return;
                }
                this.Sheet.moveToPriorFocusRange();
                focusRange = this.Sheet.getCurrentFocusRange();
                this.JumpToPriorColumnEditableObject(focusRange.endRow, focusRange.endCol + 1); //注意列要加一
                return;
            }

            //Tools.log("到第"+row+"行");
            row = leftTopCornerRow;
            row--;
            col = focusRange.endCol + 1; //先进一列，
            //在递归调用时会向前进一格
            this.JumpToPriorColumnEditableObject(row, col);
            return;

        } else
        // 不是最前一个列，那就跳到前一个列
        {
            //  ______________________________
            //  _a__|___b_____:___c_____|_____
            // 如上图，b,c被合并，

            col = leftTopCornerCol; // 如果要往回跳，显然应该先定位到本单元格的有效单元格
            col--;
            var cell = this.Sheet.$cells(row, col);
            if (cell != null) // 如果前一个单元格
            {
                cell = cell.getLeftTopCorner();
                //Tools.log("cell "+row+":"+col+"  编辑属性："+ cell.editable);
                if (cell.editable)
                {
                    var /*DBBindConfig*/ dbc = cell.Bind;
                    if (dbc == null) // 如果没有绑定到数据库
                    {
                        this.Sheet.setSelection(row, col, row, col);
                        return;
                    } else
                    //如果绑定到了数据库，
                    {
                        //如果有数据
                        if (this.Sheet.Book.getDataSource(dbc.dataSource).dataStore.rowCount > 0)
                        {
                            this.Sheet.setSelection(row, col, row, col);
                            var /*String*/ dsn = dbc.dataSource;
                            var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                            var rc = dsc.dataStore.rowCount;
                            if (rc > 0)
                            {
                                //如果不是同一个数据源，那么设置最后一行为当前编辑行
                                if (!dsn.equals(this.$getCurrentEditintDSN()))
                                {
                                    dsc.setCurrentBindRow(rc - 1);
                                }
                                return;
                            }
                        }
                    }
                }
            }
            // 到这里，说明下一个单元格是不可编辑的，那么继续下一个
            this.JumpToPriorColumnEditableObject(row, col);

        }

    },

    /**
     *  跳到指定行列位置的下一个可编辑点　但本函数不保证选中区域处于可见区
     *
     *  如果    指定的坐标是一个多行绑定，那么
     *           如果   该绑定的数据源是第一次跳上来，
     *           那么   强制跳到第0行上
     *           否则   跳到当前绑定行的下一行
     *
     *   如果  已经跳到焦点区的最后一行，或者是工作本的最后一行
     *   那么    跳到下一个焦点分区的第一个可编辑点上
     *
     *   把 newrow= row  + 1
     *
     *   如果  (newRow , col) 可以编辑，
     *   那么  跳到它上面
     *   否则  在newRow找col 后第一个可编辑的点，
     *
     *   如果　没找到就从第０列开始再找到col列
     *   如果找到了，那么就跳到它上面，
     *   注意，这个编辑点所绑定的数据源被认为是需要把第０行设置为当前行
     *
     */
    JumpToNextRowEditableObject: function (row, col) {

        var leftTopCornerRow = row;
        var leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null)
        {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();

            leftTopCornerRow = leftTopCornerOfCurrentCell.rowIndex;
        }

        var /*Range*/  focusRange = this.Sheet.getCurrentFocusRange();
        // 先看看这个单元格是不是绑定到一个有多行数据的字段上
        var cell = this.Sheet.$cells(leftTopCornerRow, col);
        if (cell != null)
        {
            var /*DBBindConfig*/ bind = cell.Bind;
            if (bind != null)
            {
                var /*String*/ dsn = bind.dataSource;
                var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                //如果是绑定到多行DataStore上
                if (bind.dataSourceType == DataSourceConfig.MultiRowDataSource)
                {
                    var ds = dsc.dataStore;
                    var rc = ds.rowCount;
                    if (rc > 0)
                    {
                        var RPM = this.Sheet.RPM;
                        if (dsn.equals(this.$getCurrentEditintDSN()))
                        {
                            var currentRow = dsc.currentBindRow + 1;
                            // 如果有下一个数据行，那么就把该数据源的当前行设置成下一行
                            var RC = ds.rowCount;
                            if (currentRow < RC)
                            {
                                this.Sheet.setSelection(row, col, row, col);
                                dsc.setCurrentBindRow(currentRow);

                                return;
                            }else
                            {
                                //如果sheet.entkeyAsArrowDown 那么当在某列最后一行按回车后，
                                //如果本列的右边还有列，那么跳到下一列的第一行上，而不是下一行上
                                // 即：即使回车跳下一行，那么也是同一列上是从上到下，并且同一结果集内同时还保留从左到右的顺序，而不是一列完成 后跳到不搭关系的下一行

                                if( this.findLastColumnWhichBindToSomeDataSource(row, dsn,col,this.Sheet.columnCount-1,true)>col)
                                {
                                    dsc.setCurrentBindRow(0);

                                    // 如果本单元格是有合并 的，那么要处理一下。
                                    let fromCol= col ;
                                    if( cell.isMerged())
                                    {
                                        fromCol= cell.getMergedRange().endCol  ;
                                    }

                                    // 2021.09.10 fromCol 这个不应该在上面修正 ，应该直接在 JumpToNextColumnEditableObject 中修正
                                    // 但是象上面这样处理一下， 它也正常跳了，算了，以后再改吧

                                    this.JumpToNextColumnEditableObject(row, fromCol);
                                    return;
                                }
                            }
                        } else
                        {
                            this.Sheet.setSelection(row, col, row, col);
                            dsc.setCurrentBindRow(0);

                            return;
                        }

                    }
                }
            }
        }

        // 2 那么就跳到下一行上
        //如果已经是焦点区的最后一行，注意这里有三种情况都是这种情况
        if (row == (this.Sheet.rowCount - 1) ||
            row == focusRange.endRow ||
            leftTopCornerRow == focusRange.endRow)
        {
            // 如果已经是最后一行，那么无处可去了,那么就跳到下一个焦点分区吧
            if (this.Sheet.isInLastFocusRange())
            {

                return;
            }
            this.Sheet.moveToNextFocusRange();
            focusRange = this.Sheet.getCurrentFocusRange();
            this.JumpToNextRowEditableObject(focusRange.startRow - 1, focusRange.startCol); //注意行要减一
            return;

        }

        row++;

        var findCol = col;
        var /*boolean*/ find = false;

        //在下一行中从col的位置向右找第一个可编辑的列
        // 2021.05.20 注意，如果是回车进入下一行模式，那么不能往col右边找

        for (findCol = col; findCol <= ( this.Sheet.enterKeyAsArrowDown? col:focusRange.endCol); findCol++)
        {
            cell = this.Sheet.$cells(row, findCol);
            if (cell == null) continue;
            //如果单元格是被合并的，并且不是左上角对象，那么不需要判断了，肯定是不能跳转到其上
            if (cell.isMerged()) if (cell.getLeftTopCorner() != cell) continue;
            if (cell.editable)
            {
                find = true;
                break;
            }
        }

        //		如果没有找到，那么找左边第一个可编辑的字段
        if (!find)
        {

            for (findCol = 0; findCol < col; findCol++)
            {
                cell = this.Sheet.$cells(row, findCol);
                if (cell == null) continue;
                if (cell.isMerged()) if (cell.getLeftTopCorner() != cell) continue;
                if (cell.editable)
                {
                    find = true;
                    break;
                }
            }
        }

        if (find)
        {
            cell = this.Sheet.$cells(row, findCol);
            var /*DBBindConfig*/ dbc = cell.Bind;
            if (dbc == null) // 如果没有绑定到数据库
            {
                this.Sheet.setSelection(row, findCol, row, findCol);

                return;
            } else
            //如果绑定到了数据库，
            {
                //如果有数据
                if (this.Sheet.Book.getDataSource(dbc.dataSource).dataStore.rowCount > 0)
                {
                    //由于是向下滚，而且这个单元格是刚得到编辑焦点，所以把绑定行复位成0
                    this.Sheet.setSelection(row, findCol, row, findCol);
                    var /*String*/ dsn = dbc.dataSource;
                    var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                    //如果是绑定到多行DataStore上
                    if (dbc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                    {
                        dsc.setCurrentBindRow(0);
                        this.Sheet.RPM.setRowScrolledRowCount(row, 0);
                    }
                    return;
                }
            }
        }

        // 到这里，说明下一行中整个就没有一个单元格是可编辑的，那么继续下下行

        this.JumpToNextRowEditableObject(row, col);

    },

//	运行模式下跳到上一行可编辑单元中
// 但本函数不保证选中区域处于可见区
//  当从一个焦点区跳到另一个焦点区时，如果新焦点区是多行绑定，并且当前行＝0
//那么它在把当前行-1后，显示无法再处于编辑状态，所以这是个问题，暂时没有解决
    JumpToPriorRowEditableObject: function (row, col) {

        var leftTopCornerRow = row;
        var leftTopCornerOfCurrent
        var leftTopCornerOfCurrentCell = this.Sheet.cells(row, col);
        if (leftTopCornerOfCurrentCell != null)
        {
            leftTopCornerOfCurrentCell = leftTopCornerOfCurrentCell.getLeftTopCorner();
            leftTopCornerRow = leftTopCornerOfCurrentCell.rowIndex;
        }
        var /*Range*/  focusRange = this.Sheet.getCurrentFocusRange();

        // 先看看这个单元格是不是绑定到一个有多行数据的字段上
        var cell = this.Sheet.$cells(leftTopCornerRow, col);
        if (cell != null)
        {
            var /*DBBindConfig*/ bind = cell.Bind;
            if (bind != null)
            {
                var /*String*/ dsn = bind.dataSource;
                var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                //如果是绑定到多行DataStore上
                if (bind.dataSourceType == DataSourceConfig.MultiRowDataSource)
                {

                    var ds = dsc.dataStore;
                    var rc = ds.rowCount;
                    if (rc > 0)
                    {
                        if (dsn.equals(this.$getCurrentEditintDSN()))
                        {
                            var currentRow = dsc.currentBindRow - 1;
                            // 如果有下一个数据行，那么就把该数据源的当前行设置成上一行
                            if (currentRow >= 0)
                            {
                                this.Sheet.setSelection(row, col, row, col);
                                dsc.setCurrentBindRow(currentRow);

                                return;
                            }
                        } else
                        {

                            this.Sheet.setSelection(row, col, row, col);
                            dsc.setCurrentBindRow(rc - 1);
                            return;
                        }

                    }
                }
            }
        }

        // 2 那么就跳到上一行上

        if (row == 0 ||
            row == focusRange.startRow ||
            leftTopCornerRow == focusRange.startRow)
        {

            // 如果已经是最后一行，那么无处可去了,那么就跳到下一个焦点分区吧
            if (this.Sheet.isInFirstFocusRange())
            {

                return;
            }
            this.Sheet.moveToPriorFocusRange();
            focusRange = this.Sheet.getCurrentFocusRange();
            this.JumpToPriorRowEditableObject(focusRange.endRow + 1, focusRange.endCol); //注意行要加一
            return;
        }

        //向上回一行，因此上一行应该是当前单元格（如果有合并的话，取左上角单元格）的前一行
        row = leftTopCornerRow;
        row--;

        var findCol = col;
        var /*boolean*/ find = false;

        //在上一行中从col向右找第一个可编辑的行
        for (findCol = col; findCol >= focusRange.startCol; findCol--)
        {
            cell = this.Sheet.$cells(row, findCol);
            if (cell == null) continue;
            //如果单元格是被合并的，并且不是左上角对象，那么不需要判断了，肯定是不能跳转到其上
            if (cell.isMerged()) if (cell.getLeftTopCorner() != cell) continue;
            if (cell.editable)
            {
                find = true;
                break;
            }
        }

        if (!find)
        {

            // 如果没有找到，那么找从右到左找第一个可编辑的字段
            for (findCol = focusRange.endCol; findCol > col; findCol--)
            {
                cell = this.Sheet.$cells(row, findCol);
                if (cell == null) continue;
                //如果单元格是被合并的，并且不是左上角对象，那么不需要判断了，肯定是不能跳转到其上
                if (cell.isMerged()) if (cell.getLeftTopCorner() != cell) continue;
                if (cell.editable)
                {
                    find = true;
                    break;
                }
            }
        }

        if (find)
        {
            cell = this.Sheet.$cells(row, findCol);
            var /*DBBindConfig*/ dbc = cell.Bind;
            if (dbc == null) // 如果没有绑定到数据库
            {
                this.Sheet.setSelection(row, findCol, row, findCol);

                return;
            } else
            //如果绑定到了数据库，
            {
                //如果有数据
                if (this.Sheet.Book.getDataSource(dbc.dataSource).dataStore.rowCount > 0)
                {
                    //由于是向上滚，而且这个单元格是刚得到编辑焦点，所以把绑定行复位成最后一行
                    this.Sheet.setSelection(row, findCol, row, findCol);
                    var /*String*/ dsn = dbc.dataSource;
                    var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dsn);
                    //如果是绑定到多行DataStore上
                    if (dbc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                    {
                        dsc.setCurrentBindRow(dsc.dataStore.rowCount - 1);
                    }
                    return;
                }
            }
        }

        // 到这里，说明下一行中整个就没有一个单元格是可编辑的，那么继续下下行

        this.JumpToPriorRowEditableObject(row, col);

    }


};

export default IEditFocusJump;
