/**
 * Created by 三宝爹 on 2017/10/24.
 */


import Range from '../Range.js';


import Color from '../../gdi/Color.js';
import Point from '../../gdi/Point.js';

import Graphics2D from '../../gdi/Graphics2D.js';
import Rectangle from '../../gdi/Rectangle.js';

import EventManage from '../EventManage.js';

import ALIGNMENT from '../ALIGNMENT.js';
import Util from '../../util/Util.js';
import Tools from '../../util/Tools.js';

import Map from '../../util/Map.js';


const /*Color*/  NormalHeaderBackgroundColor = new Color('#ece9d8');
const /*Color*/  SelectedHeaderBackgroundColor = new Color('#dcd9c8');
const /*Color*/  NormalHeaderTextColor = new Color('#404040');
const /*Color*/  SelectedHeaderTextColor = new Color(51, 108, 51);

const HeadFontSize = 14;


var IDraw = {

    /**
     * 本函数不应该被其它类显示调用来进制绘制，而是使用  invalidate函数来触发重绘操作。
     * 因为本函数需要调用 g.invalidateRect 来获取失效区域
     * @param {Graphics2D} g
     * @param {Rectangle} client
     * @param {Rectangle} clipRC
     *
     */
    onDraw: function (/*Graphics2D*/ g, /*Rectangle*/ client, /*Rectangle*/ clipRC) {

        if (!this.Sheet.paintPermit)
        {
            return;
        }


        if (clipRC.width == 0 || clipRC.height == 0) return;

        //println("drawing  begin    " + clipRC.toString());

        this.drawBorderMap.clear();
        this.drawBindBorderMap.clear();

        if (!client) client = this.getBounds();


        if (!clipRC) clipRC = g.invalidateRect;
        if (!clipRC) return;


        //缩放
        var scale = this.Sheet.viewScale;
        g.scale(scale, scale);


        g.clearRect(clipRC.x, clipRC.y, clipRC.width, clipRC.height);

        //先画背景色

        var background_color = this.Sheet.paperColor;
        if (background_color != '' && background_color != 'transparent')
        {
            g.setFillColor(this.Sheet.paperColor);
            g.fillRect(clipRC);
        }

        //画自已的背景
        this.DrawBackGroundImageInRect(false, clipRC, client, g);


        // 画单元格
        this.DrawObjectInRect(false, clipRC, client, g);


        //画冻结线
        this.DrawFreezeLine(client, g);

        // 画选中区域
        this.DrawSelection(g);
        //画选中区域
        this.DrawMovingSelection(g);


        //console.info("drawing  end    " + new Date());

    },

    onPrint: function (/*Graphics*/ g, /*Rectangle*/ client, range, pageIndex) {


        this.drawBorderMap.clear();
        this.drawBindBorderMap.clear();


        var isPrint = true;
        // 打印时，裁剪区就是整个打印区
        var clipRC = client.clone();

        //缩放
        //   var scale = this.Sheet.viewScale;
        //   g.scale(scale, scale);

        //去掉打不下的边余
        clipRC.height = clipRC.height - range.rowBlank;
        clipRC.width = clipRC.width - range.colBlank;


        // 裁剪掉无法完整打印的部分
        g.clip(clipRC);
        g.setInvalidateRect(clipRC);

        //先画背景色
        g.setFillColor(this.Sheet.paperColor);
        g.fillRect(clipRC);

        // 画单元格
        this.DrawObjectInRect(isPrint, clipRC, client, g);


    },


    ////画焦点区域
    DrawFocusRange: function (/*Graphics2D*/ g) {
        //TODO
    },


    /**
     * 亮显选中区域
     *
     */
    DrawSelection: function (/*Graphics2D*/ g) {

        //如果是运行模式，那么不要亮显示选中区
        if (!this.Sheet.designMode) return;

        //如果选中区域正在编辑中，那么不需要画
        let /*Range*/  r = this.Sheet.getSelection();


        let rc = this.getRectangleOfSelection();
        let clip = this.getClipRectangleOfRange(r);
        clip.x = Math.max(this.RPM.getRowHeadWidth(), clip.x);
        clip.y = Math.max(this.CPM.getColumnHeadHeight(), clip.y);


        try
        {
            // 设置裁剪区
            g.save();
            //2018.02.07 如果在设计状态，在选中单元格上单击，此时，选区并没有改变，单元格不需要重绘，之前画上的选区背景，也不会被清除
            //此时再画，选区背景就重复画了， 导致颜色变深。所以需要把 clip与当前脏区做交集后，裁剪，
            g.clip(clip.intersection(g.invalidateRect));

            g.setColor(new Color(51, 102, 51, 0.1));
            g.fillRect(rc);

            g.setColor(new Color(51, 102, 51, 0.75));
            g.setLineWidth(3 * this.devicePixelRatio); //在高清显示器上，要加粗
            g.drawRect(rc);

            // 画右下角的Resize按钮
            // 仅当右下角是可见时，才绘制Resize按钮，因为有可能选中单元区的右下角被滚动到不可见了，
            // 但左上角却是可见的（比如左上角在冻结区，右下角在滚动区，且被滚动到不可见）

            let p = this.getRightBottomPointOfSelection();

            if (rc.x + rc.width == p.x && rc.y + rc.height == p.y)
            {

                let rect = new Rectangle();
                rect.x = rc.x + rc.width - 3.5;
                rect.y = rc.y + rc.height - 3.5;
                rect.width = 6;
                rect.height = 6;
                g.setColor(Color.WHITE);

                g.fillRect(rect);

                rect.x += 1;
                rect.y += 1;
                rect.width = 5;
                rect.height = 5;
                g.setColor(new Color(92, 108, 150));
                g.fillRect(rect);

            }

        } catch (e)
        {
            console.dir(e);
        }
        finally
        {
            // 恢复系统裁剪区
            g.restore();
        }
    },


    DrawMovingSelection: function (/*Graphics2D*/ g) {

        //如果是运行模式，那么不要
        if (!this.Sheet.designMode) return;

        // 如果选中区域正在编辑中，那么不需要画
        var /*Range*/  r = this.Sheet.getMovingSelection();
        if (r == null) return;

        var rc = this.getRectangleOfRange(false, r);
        var clip = this.getClipRectangleOfRange(r);
        try
        {
            // 设置裁剪区
            g.save();
            g.clip(clip);

            g.setColor(new Color(147, 215, 0, 0.1));
            g.fillRect(rc);

            g.setColor(new Color(147, 215, 0, 0.5));
            g.setLineWidth(3 * this.devicePixelRatio); //在高清显示器上，要加粗
            g.drawRect(rc);


        } catch (e)
        {
        }
        finally
        {
            // 恢复系统裁剪区

            g.restore();
        }
    },


    DrawBorder: function (map, /*Graphics2D*/ g) {


        var tasks = map.get('-');

        try
        {
            g.save();


            for (var ti = 0; ti < tasks.length; ti++)
            {
                var task = tasks[ti];

                Tools.drawCellBorderLine(g, task.border_style, task.border_width, task.border_color,
                    task.x1, task.y1, task.x2, task.y2, task.border_raduis_enabled, task.border_raduis, task.position);


            }
        } catch (e)
        {
        } finally
        {

            g.restore();
        }


    },

    DrawFreezeLine: function (client, /*Graphics2D*/ g) {

        g.clip(client);
        g.beginPath();
        g.setColor(new Color(0, 200, 0, 0.5));

        if (this.Sheet.RPM.getFixedRowCount() > 0 && this.Sheet.designMode)
        {
            var y = this.RPM.getFixedRowHeight() + this.CPM.getColumnHeadHeight();

            g.drawLine(0, y, client.width, y);

        }

        //如果是设计模式或者在运行模式且有x偏移
        if (this.CPM.getFixedColumnCount() > 0 && this.Sheet.xOffset > 0 ||
            this.CPM.getFixedColumnCount() > 0 && this.Sheet.designMode)
        {
            var rc = this.Sheet.rowCount;
            var col = this.CPM.getFixedColumnCount();
            var y2 = client.height;
            var frc = this.RPM.getFixedRowCount();

            for (let row = frc; row < rc; row++)
            {

                if (this.Sheet.cells(row, col).Bind == null)
                {
                    y2 = this.RPM.getRowY(row);

                    var rect = this.getRectangleOfCell(false, row, col);
                    y2 = rect.y;

                    break;
                }
            }


            var x = this.CPM.getFixedColumnWidth() + this.RPM.getRowHeadWidth();
            var y = this.RPM.getFixedRowHeight() + this.CPM.getColumnHeadHeight();


            g.drawLine(x + 1, y, x + 1, Math.max(y, y2)); //可能 y2<y 比如向上滚


        }
        g.closePath();
        g.stroke();
    }
    ,

    DrawContainerCellImageInRect: function (/*boolean*/ isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g) {
        //TODO

    }
    ,


    DrawBackGroundImageInRect: function (/*boolean*/ isPrint, /*Rectangle*/ rect, /*Rectangle*/ client,
                                         /*Graphics2D*/ g, xOffset, yOffset) {

        //TODOs
    }
    ,

    /**
     *
     * @param {Rectangle} rect  裁剪区
     *
     * @param {Rectangle}  client  整个View的客户区 ,或打印有效区
     *            基于这样一个假设：如果是显示在屏幕上，那么 client.x =0 , client.y=0
     *            如果是打印，那么 client.x = 左边距...
     * @param {Graphics2D} g
     */
    DrawObjectInRect: function (/*boolean*/ isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g) {

        //得到冻结点的坐标
        //	得到冻结点的坐标,如果是打印，因为不打印行号，列号，所以不需要加上行头列头的尺寸
        var x = isPrint ? 0 : this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth();
        var y = isPrint ? 0 : this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight();

        var startRow = this.GetRowAtPoint(isPrint, Math.max(y, rect.y)); //y);
        var startCol = this.GetColAtPoint(isPrint, Math.max(x, rect.x));//x);
        var endRow = this.GetRowAtPoint(isPrint, rect.y + rect.height);//client.height);
        var endCol = this.GetColAtPoint(isPrint, rect.x + rect.width);//client.width);
        // 可能右下角是空的，没有需档显示的对象
        if (endRow == -1) endRow = this.Sheet.rowCount - 1;
        if (endCol == -1) endCol = this.Sheet.columnCount - 1;

        var rowBlank = 0;

        /**
         * +----------------------------------------------------------+
         *  | 00区       |                  10区                      |
         * +-------------+--------------------------------------------|
         *  | 01区       |                  11区                       |
         * +-------------+--------------------------------------------+
         *
         * 00区是固定行和固定列的交叉区 10区是列头及固定行区 01区是行标及固定列区 11区是可滚动单元格区
         */

        // 画11区
        this.drawCells(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        // 画10区
        this.DrawColumnHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        // 画01区
        this.DrawRowHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);
        // 画00区
        this.DrawColumnRowHeader(isPrint, rect, client, g, startRow, startCol, endRow, endCol);

    }
    ,


    /**
     * 画列头    /**
     * +----------------------------------------------------------+
     *  | 00区                  |                  10区                      这里                               |
     * +-------------+--------------------------------------------|
     *  | 01区                  |                  11区                                                               |
     * +-------------+--------------------------------------------+
     *
     * 00区是固定行和固定列的交叉区 10区是列头及固定行区 01区是行标及固定列区 11区是可滚动单元格区

     *
     * @param rect
     *            系统裁剪区
     * @param client
     *            整个客户区
     * @param g
     */
    DrawColumnHeader: function (/*boolean*/ isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g,
                                startRow, startCol, endRow, endCol) {


        var forceDraw = false;

        for (var i = 0; i <= this.RPM.getFixedRowCount(); i++)
        {
            if (!this.RPM.isColumnScrollEnabled(i))
            {
                startCol = this.CPM.getFixedColumnCount();
                forceDraw = true;
                break;
            }
        }

        // 屏幕分还四部分，计算10 区所占的区域
        var /*Rectangle*/rcClip = new Rectangle();
        rcClip.x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth() - 1;
        rcClip.y = 0;
        rcClip.width = client.width - rcClip.x;
        rcClip.height = this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight() + 1; // 高度是列标的高度＋固定行的高度 +1个边界点

        //2019.12.17 支持打印忽略
        if (isPrint)
        {
            if (this.Sheet.ignoreBeforeRowWhenPrinting > 0)
            {
                rcClip.height -= this.Sheet.RPM.getRowY(this.Sheet.ignoreBeforeRowWhenPrinting);
            }
        }

        // （裁剪是不包尾的，所以要多加一个点 ）
        // 把裁剪区与10区取并集，再次裁剪
        var realClip = rcClip.clone();

        // 如果不需要画，直接退出
        if (!forceDraw && !rcClip.intersects(rect)) return;

        try
        {
            g.save();
            g.clip(rect);


            this.drawBorderMap.clear();
            this.drawBindBorderMap.clear();

            var x0 = (isPrint ? 0 : this.RPM.getRowHeadWidth())
                + this.CPM.getColumnX(startCol)
                - (isPrint ? this.Sheet.xPrintOffset : this.Sheet.xOffset );

            var y0 = (isPrint ? 0 : this.CPM.getColumnHeadHeight());

            var /*Rectangle*/ cellRect = new Rectangle();
            var y = y0;

            // 处于头部的固定行的单元格
            for (var row = 0; row < this.RPM.getFixedRowCount(); row++)
            {

                var h = this.RPM.getRowHeight(row);
                var x = x0;
                // 增加对整行列坐标不卷滚的支持
                if (!this.RPM.isColumnScrollEnabled(row))
                {
                    x = (isPrint ? 0 : this.RPM.getRowHeadWidth())
                        + this.CPM.getColumnX(startCol)
                        - (isPrint ? this.Sheet.xPrintOffset : 0);
                }

                for (var col = startCol; col <= endCol; col++)
                {
                    var needDraw = true;
                    var drawRow = row;
                    var drawCol = col;
                    var /*Cell*/  drawCell = this.Sheet.$cells(row, col);

                    var w = this.CPM.getColumnWidth(col);
                    cellRect.setBounds(x, y, w, h);

                    // 如果是被合并的单元格，那么仅最左上角的单元格需要绘制
                    if (drawCell != null && drawCell.isMerged())
                    {

                        var /*Range*/  r = this.Sheet.getMergeMap().get(drawCell).getMergedRange();
                        drawRow = r.startRow;
                        drawCol = r.startCol;
                        drawCell = this.Sheet.cells(drawRow, drawCol);

                        needDraw = false;
                        // 这时就需要即绘制，又不能重复绘制。所以仅当是如下情形时：
                        // 如果这个单元格是合并区的最左上角单元格，那么是需要绘制的
                        if (drawRow == row && drawCol == col) needDraw = true;
                        // 除非是合并区域被卷滚形成部分被卷滚到不可见，部分可见时，那么需要绘制

                        // 在列头部分（即固定行所在区），所有行是可见的，当部分列被卷滚到不可见时，仅当行列是( drawRow , startCol)需要绘制
                        if (row == drawRow && col == startCol) needDraw = true;

                        cellRect = this.getRectangleOfRange(isPrint, r);

                    } else
                    {
                        cellRect = this.getRectangleOfCell(isPrint, drawRow, drawCol);
                    }


                    if (needDraw || forceDraw)
                    {
                        //  那么只要单元格的部分在裁剪区内就需要画
                        if (forceDraw || realClip.intersects(cellRect))
                        {
                            this.drawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }

                    }

                    x += w;
                }

                y = y + h;

            }
            // 画列标
            if (!isPrint)
            {
                var x = x0;
                y = 0;
                var h = y0;

                var SelectedStartCol = this.Sheet.getSelection().startCol;
                var SelectedEndCol = this.Sheet.getSelection().endCol;

                var that = this;

                for (var col = startCol; col <= endCol && h > 0; col++)
                {
                    var w = this.CPM.getColumnWidth(col);
                    cellRect.setBounds(x, y, w, h);
                    if (realClip.intersects(cellRect))
                    {
                        g.setColor((col >= SelectedStartCol && col <= SelectedEndCol ?
                            SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor));

                        g.fillRect(cellRect);

                        g.setColor(Color.GRAY);
                        g.drawRect(cellRect);

                        if (col >= SelectedStartCol && col <= SelectedEndCol)
                        {
                            var focusLine = cellRect.clone();
                            focusLine.y = focusLine.height - 2;
                            focusLine.height = 2;
                            g.setColor(SelectedHeaderTextColor);
                            g.fillRect(focusLine);
                        }

                        g.drawStringSingleRow(cellRect, this.CPM.getColumnShowText(col), 0, null,
                            (col >= SelectedStartCol && col <= SelectedEndCol ?
                                SelectedHeaderTextColor : NormalHeaderTextColor),
                            "", HeadFontSize, false, false, false, ALIGNMENT.Center, ALIGNMENT.Center);


                        var sign = "";

                        if (that.CPM.getColumnStretchWidth(col) > 0) sign += "\ue801";
                        if (that.CPM.getColumnWidth2(col) == 0) sign += "\ue804";

                        if (sign != '')
                        {
                            g.drawStringSingleRow(cellRect, sign + ' ', 0, null,
                                Color.black,
                                "junz", 9, false, false, false, ALIGNMENT.Right, ALIGNMENT.Center);
                        }


                    }
                    x += w;
                }
            }

            // 集中画单元格的边框
            this.DrawBorder(this.drawBindBorderMap, g);
            this.DrawBorder(this.drawBorderMap, g);

        } catch (e)
        {
            console.dir(e);
        }
        finally
        {
            // 恢复系统裁剪区
            g.restore();
        }

    }
    ,

    /**
     * 画行头
     *
     * @param rect
     * @param client
     * @param g
     */
    DrawRowHeader: function (isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g,
                             startRow, startCol, endRow, endCol) {

        if (Util.isObject(startRow))
        {
            startRow = startRow.startRow;
        }

        if (Util.isObject(endRow))
        {
            endRow = endRow.endRow;
        }

        // 屏幕分还四部分，计算01 区所占的区域
        var /*Rectangle*/ rcClip = new Rectangle();
        rcClip.x = 0;
        rcClip.y = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight();
        // 宽度是行标的宽度＋固定列的宽度 +1个边界点 （裁剪是不包尾的，所以要多加一个点 ）
        rcClip.width = this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth() + 1;
        rcClip.height = client.height - rcClip.y;
        // 把系统裁剪区与01区取并集，再次裁剪

        //2019.12.17 支持打印忽略
        if (isPrint)
        {
            if (this.Sheet.ignoreBeforeRowWhenPrinting > 0)
            {
                var ignoreHeight = this.Sheet.RPM.getRowY(this.Sheet.ignoreBeforeRowWhenPrinting);
                rcClip.y -= ignoreHeight;
                rcClip.height += ignoreHeight;
            }
        }

        // 如果不需要画，直接退出
        if (!rcClip.intersects(rect)) return;

        var /*Rectangle*/ realClip = rcClip.intersection(rcClip);

        try
        {
            g.save();
            g.clip(realClip);
            g.beginPath();


            this.drawBorderMap.clear();
            this.drawBindBorderMap.clear();

            var x0 = isPrint ? 0 : this.RPM.getRowHeadWidth();
            var y0 = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getRowY(startRow)
                - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset );

            var /*Rectangle*/ cellRect = new Rectangle();
            var x = x0;

            // 处于头部的固定行的单元格
            for (var col = 0; col < this.CPM.getFixedColumnCount(); col++)
            {

                var w = this.CPM.getColumnWidth(col);
                var y = y0;
                for (var row = startRow; row <= endRow; row++)
                {
                    var needDraw = true;
                    var drawRow = row;
                    var drawCol = col;
                    var /*Cell*/  drawCell = this.Sheet.$cells(row, col);

                    var h = this.RPM.getRowHeight(row);
                    cellRect.setBounds(x, y, w, h);

                    // 如果是被合并的单元格，那么仅最左上角的单元格需要绘制
                    if (drawCell != null && drawCell.isMerged())
                    {
                        var /*Range*/  r = this.Sheet.getMergeMap().get(drawCell).getMergedRange();

                        drawRow = r.startRow;
                        drawCol = r.startCol;
                        drawCell = this.Sheet.cells(drawRow, drawCol);

                        needDraw = false;
                        // 这时就需要即绘制，又不能重复绘制。所以仅当是如下情形时：
                        // 如果这个单元格是合并区的最左上角单元格，那么是需要绘制的
                        if (drawRow == row && drawCol == col) needDraw = true;
                        // 除非是合并区域被卷滚形成部分被卷滚到不可见，部分可见时，那么需要绘制
                        // 在行头上，包含固定列区域，这里的合并区的所有列肯定是在可见区，当部分行被卷滚到不可见时，
                        // 即仅当行列是( startRow , drawCol)需要绘制
                        if (row == startRow && col == drawCol) needDraw = true;

                        cellRect = this.getRectangleOfRange(isPrint, r);

                    } else
                    {
                        cellRect = this.getRectangleOfCell(isPrint, drawRow, drawCol);
                    }


                    if (needDraw)
                    {
                        //  那么只要单元格的部分在裁剪区内就需要画
                        // if (realClip.intersects(cellRect))
                        {
                            this.drawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                        }

                    }
                    y += h;
                }

                x = x + w;

            }

            // 画行标
            if (!isPrint)
            {

                x = 0;
                var w = isPrint ? 0 : this.RPM.getRowHeadWidth();

                var SelectedStartRow = this.Sheet.getSelection().startRow;
                var SelectedEndRow = this.Sheet.getSelection().endRow;
                var that = this;

                for (var row = startRow; row <= endRow && w > 0; row++)
                {
                    cellRect = this.getRectangleOfCell(isPrint, row, 0);
                    cellRect.x = 0;
                    cellRect.width = w;


                    function $drawRowHeader(rc, title, x)
                    {
                        if (x == undefined) x = 0;

                        g.setColor((row >= SelectedStartRow && row <= SelectedEndRow ?
                            SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor));
                        g.fillRect(rc);

                        g.setColor(Color.GRAY);
                        var rc2 = rc.clone();

                        rc2.x = x;
                        rc2.width -= x;
                        g.drawRect(rc2);

                        if (row >= SelectedStartRow && row <= SelectedEndRow)
                        {
                            var focusLine = rc.clone();
                            focusLine.x = focusLine.width - 2;
                            focusLine.width = 2;
                            g.setColor(SelectedHeaderTextColor);
                            g.fillRect(focusLine);
                        }

                        g.drawStringSingleRow(rc, title, 0, null,
                            (row >= SelectedStartRow && row <= SelectedEndRow ?
                                SelectedHeaderTextColor : NormalHeaderTextColor),
                            "", x == 0 ? HeadFontSize : HeadFontSize - 4, false, false, false,
                            ALIGNMENT.Center, ALIGNMENT.Center);


                        var sign = "";

                        if (that.RPM.getRowStretchHeight(row) > 0) sign += "\ue800";
                        if (!that.RPM.isColumnScrollEnabled(row)) sign += "\ue803";

                        if (sign != '')
                        {

                            g.drawStringSingleRow(rc, sign + ' ', 0, null, Color.black,
                                "junz", 9, false, false, false, ALIGNMENT.Right, ALIGNMENT.Center);


                        }


                    }

                    var mrdsn = this.RPM.getMultiRowDataSourceName(row);

                    if (mrdsn == '') //如果本行中没有单元格绑定到数据源,或数据源只有一行数据
                    {
                        if (realClip.intersects(cellRect)) $drawRowHeader(cellRect, '' + (row + 1));

                    } else
                    // 如果有绑定，那么显示子行号
                    {

                        var dataRC = Math.max(1, this.Book.getDataSource(mrdsn).dataStore.rowCount);

                        var dbRowHeight = 0;
                        //如果绑定到多行数据源，那么看看整个多行绑定区的总高度，
                        var firstSameBindRow = this.Sheet.RPM.findFirstRowWhichBindToMultiRowDataSource(mrdsn);
                        var lastSameBindRow = this.Sheet.RPM.findLastRowWhichBindToMultiRowDataSource(mrdsn);
                        //如果当前已经不在多行绑定区了，那么如果一行一行循环计算判断，就慢了，所以先直接全高比较，确定y是否落在多行绑定区之内
                        //数据行数，默认需要有一行数据的高度


                        var oneDataRowHeight = 0;//多行数据源区，一行数据的高度
                        for (let di = firstSameBindRow; di <= lastSameBindRow; di++)
                        {
                            oneDataRowHeight += this.Sheet.RPM.getRowHeight(di);
                        }

                        var textRect = cellRect.clone();
                        for (let i = 0; i < dataRC; i++)
                        {

                            //y坐标需加再加上分类汇总行所占据的调度
                            textRect.y = cellRect.y + i * oneDataRowHeight;


                            //如果在显示区的上面，并且不用管汇总行
                            if (textRect.y + textRect.height < realClip.y)
                            {


                                continue;
                            }

                            if (realClip.intersects(textRect)) // 如果在裁剪区内，这画这个数据
                            {

                                // console.info( ' row head :' + '' + (row + 1) + "." + (i + 1));
                                $drawRowHeader(textRect, '' + (row + 1) + "." + (i + 1), 5);
                            } else
                            {
                                if (textRect.y > realClip.y + realClip.height) break;
                            }


                        }

                    }


                }
            }

            // 集中画单元格的边框
            this.DrawBorder(this.drawBindBorderMap, g);
            this.DrawBorder(this.drawBorderMap, g);

        } catch (e)
        {
            console.dir(e);
        }
        finally
        {
            g.closePath();
            g.stroke();
            // 恢复系统裁剪区
            g.restore();
        }
    }
    ,

    DrawColumnRowHeader: function (isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g,
                                   startRow, startCol, endRow, endCol) {

        // 屏幕分还四部分，计算00 区所占的区域


        var rcClip = new Rectangle();
        rcClip.x = 0;
        rcClip.y = 0;
        // 宽度是行标的宽度＋固定列的宽度 +1个边界点 （裁剪是不包尾的，所以要多加一个点 ）
        rcClip.width = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth();
        // 高度是列标的高度＋固定行的高度 +1个边界点 （裁剪是不包尾的，所以要多加一个点 ）
        rcClip.height = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight();

        //2019.12.17 支持打印忽略
        if (isPrint)
        {
            if (this.Sheet.ignoreBeforeRowWhenPrinting > 0)
            {
                rcClip.height -= this.Sheet.RPM.getRowY(this.Sheet.ignoreBeforeRowWhenPrinting);
            }
        }

        // 如果不需要画，直接退出
        if (!rcClip.intersects(rect)) return;

        var that = this;

        // 把裁剪区与00区取并集，再次裁剪
        var /*Rectangle*/ realClip = rect.intersection(rcClip);

        try
        {
            g.save();
            g.clip(realClip);

            g.beginPath();

            this.drawBorderMap.clear();
            this.drawBindBorderMap.clear();


            var w, h;
            var x, y;

            var /*Rectangle*/ cellRect = new Rectangle();

            var x0 = isPrint ? 0 : this.RPM.getRowHeadWidth();
            var y0 = isPrint ? 0 : this.CPM.getColumnHeadHeight();

            y = y0;
            for (var row = 0; row < this.RPM.getFixedRowCount(); row++)
            {

                h = this.RPM.getRowHeight(row);
                x = x0;
                for (var col = 0; col < this.CPM.getFixedColumnCount(); col++)
                {

                    var needDraw = true;
                    var drawRow = row;
                    var drawCol = col;
                    var /*Cell*/  drawCell = this.Sheet.$cells(row, col);

                    w = this.CPM.getColumnWidth(col);
                    cellRect.setBounds(x, y, w, h);

                    // 如果是被合并的单元格，那么仅最左上角的单元格需要绘制
                    if (drawCell != null && drawCell.isMerged()
                    )
                    {

                        var /*Range*/  r = this.Sheet.getMergeMap().get(drawCell).getMergedRange();
                        drawRow = r.startRow;
                        drawCol = r.startCol;
                        drawCell = this.Sheet.cells(drawRow, drawCol);


                        needDraw = false;
                        // 在行列固定区，不存在卷滚，所以仅当是合并区最左上角单元格时，才需要绘制
                        if (drawRow == row && drawCol == col) needDraw = true;

                        cellRect = this.getRectangleOfRange(isPrint, r);

                    } else
                    {
                        cellRect = this.getRectangleOfCell(isPrint, drawRow, drawCol);
                    }


                    if (needDraw && realClip.intersects(cellRect))
                    {
                        this.drawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);
                    }

                    x += w;
                }
                y = y + h;

            }

            // 画列标

            if (!isPrint)
            {
                x = this.RPM.getRowHeadWidth();
                y = 0;
                h = this.CPM.getColumnHeadHeight();

                var SelectedStartCol = this.Sheet.getSelection().startCol;
                var SelectedEndCol = this.Sheet.getSelection().endCol;

                for (var col = 0; col < this.CPM.getFixedColumnCount(); col++)
                {
                    w = this.CPM.getColumnWidth(col);
                    cellRect.setBounds(x, y, w, h);
                    if (realClip.intersects(cellRect))
                    {
                        g.setColor((col >= SelectedStartCol && col <= SelectedEndCol ?
                            SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor));
                        g.fillRect(cellRect);
                        g.setColor(Color.GRAY);
                        g.drawRect(cellRect);
                        g.drawStringSingleRow(cellRect, this.CPM.getColumnShowText(col), 0, null, Color.BLACK, "",
                            HeadFontSize, false, false, false, ALIGNMENT.Center, ALIGNMENT.Center);

                        var sign = "";

                        if (that.CPM.getColumnStretchWidth(col) > 0) sign += "\ue801";
                        if (that.CPM.getColumnWidth2(col) == 0) sign += "\ue804";

                        if (sign != '')
                        {
                            g.drawStringSingleRow(cellRect, sign + ' ', 0, null,
                                Color.black,
                                "junz", 9, false, false, false, ALIGNMENT.Right, ALIGNMENT.Center);
                        }

                    }
                    x += w;
                }

                // 画行标
                y = this.CPM.getColumnHeadHeight();
                x = 0;
                w = this.RPM.getRowHeadWidth();

                var SelectedStartRow = this.Sheet.getSelection().startRow;
                var SelectedEndRow = this.Sheet.getSelection().endRow;

                for (var row = 0; row < this.RPM.getFixedRowCount(); row++)
                {//在肯定区绑定多行数据的数据源很少，也不建议使用，所以不处理了
                    h = this.RPM.getRowHeight(row);
                    cellRect.setBounds(x, y, w, h);
                    if (realClip.intersects(cellRect))
                    {
                        g.setColor((row >= SelectedStartRow && row <= SelectedEndRow ?
                            SelectedHeaderBackgroundColor : NormalHeaderBackgroundColor));

                        g.fillRect(cellRect);
                        g.setColor(Color.GRAY);
                        g.drawRect(cellRect);
                        g.drawStringSingleRow(cellRect, '' + (row + 1), 0, null, Color.BLACK, "",
                            HeadFontSize, false, false, false, ALIGNMENT.Center, ALIGNMENT.Center);
                    }

                    var sign = "";

                    if (that.RPM.getRowStretchHeight(row) > 0) sign += "\ue800";
                    if (!that.RPM.isColumnScrollEnabled(row)) sign += "\ue803";

                    if (sign != '')
                    {

                        g.drawStringSingleRow(cellRect, sign + ' ', 0, null, Color.black,
                            "junz", 9, false, false, false, ALIGNMENT.Right, ALIGNMENT.Center);


                    }

                    y += h;
                }

                //左上角，行列都不管的地方
                cellRect.setBounds(0, 0, x0, y0);
                g.setColor(NormalHeaderBackgroundColor);
                g.fillRect(cellRect);
                g.setColor(Color.GRAY);
                g.drawRect(cellRect);
            }

            //  如果不加下面这句， 会在(0,0)坐标处画一个gray色的点
            if (this.CPM.getColumnHeadHeight() == 0 && this.RPM.getRowHeadWidth() == 0)
            {
                g.setColor(Color.white);
                g.drawLine(0, 0, 0, 0);
            }

            // 集中画单元格的边框
            this.DrawBorder(this.drawBindBorderMap, g);
            this.DrawBorder(this.drawBorderMap, g);

        } catch (e)
        {
            console.dir(e);
        }
        finally
        {
            g.closePath();
            g.stroke();

            // 恢复系统裁剪区
            g.restore();
        }
    }
    ,

    /**
     *
     * @param rect
     *            裁剪区
     * @param client
     *            整个客户区
     * @param g
     * @param startRow
     *            需要显示的第一个非固定行
     * @param startCol
     *            需要显示的第一个非固定列
     * @param endRow
     *            需要显示的右下角的行
     * @param endCol
     *            需要显示的右下角的列
     *  @rowBlank 　仅当打印时有效，    表示最下面的打印不了的留白
     */
    drawCells: function (isPrint, /*Rectangle*/ rect, /*Rectangle*/ client, /*Graphics2D*/ g,
                         startRow, startCol, endRow, endCol) {


        if (Util.isObject(startRow))
        {
            startRow = startRow.startRow;
        }

        if (Util.isObject(endRow))
        {
            endRow = endRow.endRow;
        }


        // 屏幕分还四部分，计算11 区所占的区域
        /*Rectangle*/
        var rcClip = new Rectangle();
        rcClip.x = (isPrint ? 0 : this.RPM.getRowHeadWidth()) + this.CPM.getFixedColumnWidth();
        rcClip.y = (isPrint ? 0 : this.CPM.getColumnHeadHeight()) + this.RPM.getFixedRowHeight();
        rcClip.width = client.width - rcClip.x;
        rcClip.height = client.height - rcClip.y;

        //2019.12.17 支持打印忽略
        if (isPrint)
        {
            if (this.Sheet.ignoreBeforeRowWhenPrinting > 0)
            {
                var ignoreHeight = this.Sheet.RPM.getRowY(this.Sheet.ignoreBeforeRowWhenPrinting);
                rcClip.y -= ignoreHeight;
                rcClip.height += ignoreHeight;
            }
        }

        // 如果不需要画，直接退出
        if (!rcClip.intersects(rect)) return;

        var /*Rectangle*/ realClip = rcClip.intersection(rect);


        try
        {
            g.save();
            g.clip(realClip);

            this.drawBorderMap.clear();
            this.drawBindBorderMap.clear();


            for (var row = startRow; row <= endRow; row++)
            {
                for (var col = startCol; col <= endCol; col++)
                {
                    var needDraw = true;
                    var drawRow = row;
                    var drawCol = col;
                    var drawCell = this.Sheet.$cells(row, col);
                    var cellRect = null;

                    if (drawCell != null && drawCell.isMerged())
                    {

                        var /*Range*/  r = this.Sheet.getMergeMap().get(drawCell).getMergedRange();
                        drawRow = r.startRow;
                        drawCol = r.startCol;
                        drawCell = this.Sheet.cells(drawRow, drawCol);

                        needDraw = false;
                        // 这时即需要绘制，又不能重复绘制。所以仅当是如下情形时：
                        // 如果这个单元格是合并区的最左上角单元格，那么是需要绘制的
                        if (drawRow == row && drawCol == col) needDraw = true;
                        // 除非是合并区域被卷滚形成部分被卷滚到不可见，部分可见时，那么需要绘制
                        // 当合并区的所有列都在可见区，但部分行被卷滚到不可见时，仅当行列是( startRow , drawCol)需要绘制
                        if (row == startRow && col == drawCol) needDraw = true;
                        // 当合并区的所有行都在可见区，但部分列被卷滚到不可见时，仅当行列是( drawRow , startCol)需要绘制
                        if (row == drawRow && col == startCol) needDraw = true;

                        cellRect = this.getRectangleOfRange(isPrint, r);

                    } else
                    {
                        cellRect = this.getRectangleOfCell(isPrint, drawRow, drawCol);
                    }


                    if (needDraw)
                    {
                        // 只要单元格的部分在裁剪区内就需要画
                        //因为在分页时已经考虑到了不会把半个Cell画在纸上，所以这里不用特别考虑

                        this.drawCell(isPrint, drawCell, cellRect, rect, client, g, drawRow, drawCol);


                    }


                }


            }

            // 集中画单元格的边框
            this.DrawBorder(this.drawBindBorderMap, g);
            this.DrawBorder(this.drawBorderMap, g);

        } catch (e)
        {
            console.dir(e);
        }
        finally
        {
            // 恢复系统裁剪区
            g.restore();
        }
    }
    ,

    /**
     *
     * @param map
     * @param g
     * @param border_style
     * @param border_width
     * @param border_color
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @param tip
     * @param border_raduis_enabled  true表示要画圆角，false表示不画圆角但， 要留出border_raduis的空白
     * @param border_raduis
     */
    addDrawCellBorderLine: function (map, /*Graphics2D*/ g, border_style, border_width, border_color,
                                     x1, y1, x2, y2, tip, border_raduis_enabled, border_raduis, position) {

        if (border_width == 0) return;
        if (border_style == 0) return;

        //var clip = g.currentClipRect;

        var clip = "-";
        var taskList;
        if (map.containsKey(clip))
        {
            taskList = map.get(clip);
        } else
        {
            taskList = [];
            map.put(clip, taskList);
        }


        var task = {};
        task.border_style = border_style;
        task.border_width = border_width;
        task.border_color = border_color;
        task.x1 = x1;
        task.y1 = y1;
        task.x2 = x2;
        task.y2 = y2;
        task.tip = tip;
        task.border_raduis_enabled = border_raduis_enabled || false;
        task.border_raduis = border_raduis || 0;
        task.position = position || 0;

        if (!taskList.contains(task)) taskList.push(task);


    }
    ,


    //当一个单元格绑定到含有多行数据的字段时，为每行数据画边框的任务
    addDrawRectangle: function (/*Graphics2D*/ g, border_style, border_width, border_color, /*Rectangle*/ rect) {
        this.addDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color,
            rect.x, rect.y, rect.x, rect.y + rect.height);
        this.addDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color,
            rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        this.addDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color,
            rect.x + rect.width, rect.y + rect.height, rect.x + rect.width, rect.y);
        this.addDrawCellBorderLine(this.drawBindBorderMap, g, border_style, border_width, border_color,
            rect.x + rect.width, rect.y, rect.x, rect.y);

    }
    ,

    /**
     *
     * @param isPrint
     * @param cell
     * @param cellRect
     * @param rect
     * @param client
     * @param g
     * @param row
     * @param col
     */
    drawCell: function (isPrint, /*Cell*/ cell, /*Rectangle*/ cellRect, /*Rectangle*/ rect, /*Rectangle*/ client,
                        /*Graphics2D*/ g, row, col) {


        if (this.Sheet.gridLineVisible)
        {
            g.setColor(this.Sheet.gridLineColor);
            g.drawRect(cellRect);
        }


        if (cell == null) return; // 对于空的单元格，可能只需要画表格线。

        //console.info(cell.name + '  ');
        // 能到这里 cell 是不为空的
        cell.drawBackground(g, cellRect);
        cell.drawBorder(g, cellRect);
        // 具体的内容交给单元格自己去画
        cell.draw(isPrint, g, cellRect);

    }

};

export default IDraw ;
