/**
 * Created by 三宝爹 on 2017/10/22.
 *
 *   坐标计算
 */


import Rectangle from '../../gdi/Rectangle.js';
import Point from '../../gdi/Point.js';
import Util from '../../util/Util.js';


var ICoordinate = {

    /**
     * 特别注意： 当是用鼠标点选，并得到点选的单元格时用此函数。当直接用坐标代入，求正常的列号时，将row用-1代入
     * 得到点 (x )处的单元格的列坐标,注意 ，row 行可能是禁止列卷滚的，所有同一个x ,以不同的行，可能返回不同的列
     *
     * @param x
     *            注意 x 是设置坐标，就是相对于View顶点的坐标。
     *
     * @retur 列号
     */
    GetColAtPoint: function (isPrint, x, atRow) {

        var row = atRow;
        if (!row) row = -1;
        if (Util.isObject(row)) row = row.row;//atRow可能是一个对象，参看GetRowAtPoint
        // 注意判断上是包头不包尾

        var w = isPrint ? 0 : this.RPM.getRowHeadWidth();
        // 如果X小于行标，那么
        if (x < w) return -1;

        var FCC = this.CPM.getFixedColumnCount();
        for (var i = 0; i < FCC; i++)
        { // 包头，不包尾
            if (x >= w && x < w + this.CPM.getColumnWidth(i)) return i;
            w += this.CPM.getColumnWidth(i);

        }
        // 到这里来了，肯定就不是在固定区

        var CC = this.CPM.columnCount;
        for (var i = FCC; i < CC; i++)
        {
            if (x >= w - (isPrint ? this.Sheet.xPrintOffset : this.Sheet.xOffset )
                && x < w + this.CPM.getColumnWidth(i) -
                (isPrint ? this.Sheet.xPrintOffset : (this.RPM.isColumnScrollEnabled(row) ? this.Sheet.xOffset : 0)))
            {
                return i;
            }
            w += this.CPM.getColumnWidth(i);
        }

        return -1;
    }
    ,

    /**
     * 得到点 (x,y)处的单元格的行坐标
     *
     * @param y
     *            注意 y 是相对于View顶点的坐标。
     *
     * @retur 行号
     */
    GetRowAtPoint: function (isPrint, y) {
        // 注意判断上是包头不包尾

        var h = isPrint ? 0 : this.CPM.getColumnHeadHeight();
        // 如果y小于行标，那么
        if (y < h) return -1;

        //在固定区中，通常是不允许绑定到多行数据源中的，
        var FRC = this.RPM.getFixedRowCount();
        for (var i = 0; i < FRC; i++)
        { // 包头，不包尾
            if (y >= h && y < h + this.RPM.getRowHeight(i)) return i;
            h += this.RPM.getRowHeight(i);

        }
        // 到这里来了，肯定就不是在固定区

        var RC = this.RPM.rowCount;

        for (var i = FRC; i < RC; i++)
        {

            var mrdsn = this.RPM.getMultiRowDataSourceName(i);
            //如果 i 行没有绑定到多行数据源,那么只需要简单地加上i行的高度进行比较就可以了
            if (mrdsn == '')
            {
                if (y >= h - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset )
                    && y < h + this.RPM.getRowHeight(i) - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset ))
                {
                    return i;
                }
                h += this.RPM.getRowHeight(i);
                continue;

            }
            //如果绑定到多行数据源，那么看看整个多行绑定区的总高度，
            var firstSameBindRow = this.RPM.findFirstRowWhichBindToMultiRowDataSource(mrdsn);
            var lastSameBindRow = this.RPM.findLastRowWhichBindToMultiRowDataSource(mrdsn);
            //如果当前已经不在多行绑定区了，那么如果一行一行循环计算判断，就慢了，所以先直接全高比较，确定y是否落在多行绑定区之内
            //数据行数，默认需要有一行数据的高度
            var dbRC = Math.max(1, this.Book.getDataSource(mrdsn).dataStore.rowCount);

            var oneDataRowHeight = 0;//多行数据源区，一行数据的高度
            for (let di = i; di <= lastSameBindRow; di++)
            {
                oneDataRowHeight += this.RPM.getRowHeight(di);
            }

            var totalDataRowHeight = oneDataRowHeight * dbRC;

            //落在多行数据区吗
            let inThisArea = (
                y >= h - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset ) &&
                y < h - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset ) + totalDataRowHeight
            );

            if (!inThisArea)
            {
                h += totalDataRowHeight;
                i = lastSameBindRow; //直接跳到此多行数据源区的最后一行，继续循环，进入下一行判断
                continue;
            }

            //再计算是落在第几个数据行上，
            let offset = y - ( h - (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset ));

            let dbRow = Math.floor(offset / oneDataRowHeight);  //在第几个数据行上
            let left = offset - dbRow * oneDataRowHeight;

            let h1 = 0;
            for (let di = i; di <= lastSameBindRow; di++)
            {
                if (left >= h1 && left < h1 + this.RPM.getRowHeight(di))
                {

                    return {
                        multiRowDataSourceName: mrdsn,  //数据源名称
                        row: di, //Y点所在的单元格行号
                        startRow: firstSameBindRow,  //同绑定是从哪一行开始的，
                        endRow: lastSameBindRow,//相同绑定是到哪行结束的
                        dbRow: dbRow  //处于哪个明细行
                    };
                }
                h1 += this.RPM.getRowHeight(di);
            }

        }

        return -1;
    }

};

export default ICoordinate ;
