import ALIGNMENT from '../ALIGNMENT.js';


function css2localBorderStyle(bs)
{
    if (bs == 'none') return 0;
    if (bs == 'hidden') return 0;
    if (bs == 'dotted') return 3;
    if (bs == 'dashed') return 4;
    if (bs == 'double') return 5;


    return 1;
}

var ISheetPaste = {


    pasteFromExcel: function () {


        var theSheet = this;

        $.confirm({
            title: '',
            useBootstrap: false,
            boxWidth: '500px',
            content: ` 
                     <form action="" class="formName"> 
                     <label >在下面的框中按下 Ctrl + v </label>
                     <div style="overflow:auto; height:300px;">
                     <div class="form-group" id="pasteFromExcel" 
                     style=" border:1px dotted darkgray;
                     width:6000px;
                     height:6000px;
                      " 
                     contenteditable="true"> 
                    
                     
                    </div> 
                    </div>
                    </form> `,
            buttons: {
                formSubmit: {
                    text: '确定',
                    btnClass: 'btn-green',
                    action: function () {

                        var table = this.$content.find('table');
                        if (table.length == 0)
                        {
                            toastr.info("没有可以粘贴的表格");
                            return false;
                        }

                        theSheet.pasteFromTable(table);

                    }
                },
                cancel: {
                    text: '取消',
                    btnClass: 'btn-warning',
                    action: function () {

                    }
                }
            },


            onContentReady: function () {
                // bind to events
                var jc = this;
                this.$content.find('#pasteFromExcel').focus();

            }
        });


    },

    //
    pasteFromTable: function (table) {
        try
        {
            this.paintPermit = false;
            table = table[0];
            var cols = table.children[0].children;
            var colCount = cols.length;
            var rows = table.rows;
            var rowCount = rows.length;
            var startRow = this.selection.startRow;
            var startCol = this.selection.startCol;
            var IRC = rowCount - ( this.rowCount - startRow ); //需要插入行数
            var ICC = colCount - ( this.columnCount - startCol);//需要插入列数
            //检测行数，列数，试设置行高列宽
            for (let i = 0; i < IRC; i++) this.insertMultiRow(this.rowCount, this.rowCount);
            for (let i = 0; i < ICC; i++) this.insertMultiColumn(this.columnCount, this.columnCount);

            //行高
            for (let i = 0; i < rowCount; i++)
            {
                this.setRowHeight(startRow + i, Math.floor(1.0 * parseInt(rows[i].getAttribute('height'))));
            }

            //列宽
            for (let i = 0; i < colCount; i++)
            {
                //理论上是 /3*4 , 实际效果太大了，
                this.setColumnWidth(startCol + i, Math.floor(1.217 * parseInt(cols[i].width)));
            }

            //单元格

            for (let i = 0; i < rowCount; i++)
            {
                var rowIndex = startRow + i;
                var colIndex = startCol - 1; //左移一格，下面会再右移
                var TR = rows[i];
                var C = TR.cells.length;
                for (let j = 0; j < C; j++)
                {
                    var TD = TR.cells[j];
                    var rowSpan = TD.rowSpan || 1;
                    var colSpan = TD.colSpan || 1;
                    //定位Sheet中的坐标
                    colIndex++;

                    var cell;
                    while (true)
                    {
                        cell = this.cells(rowIndex, colIndex);
                        //是否被合并
                        if (!cell.isMerged()) break;

                        var leftTop = cell.getLeftTopCorner();
                        if (leftTop == cell) break; // 虽然合并了，但是自已就是左上角

                        var range = cell.getMergedRange();

                        colIndex = range.endCol + 1;
                    }
                    //到这里 cell就是对应的单元格了
                    if (rowSpan > 1 || colSpan > 1)
                    {
                        this.merge(rowIndex, colIndex, rowIndex + rowSpan - 1, colIndex + colSpan - 1);
                    }
                    //设置内容
                    cell.setValue(TD.innerText);


                    var $TD = $(TD);

                    //字体
                    var fontSize = $TD.css('font-size');
                    fontSize = parseInt(fontSize.replace(/px/g, ''));
                    cell.setPropertyValue("font-size", fontSize);

                    //对齐格式

                    var vAlign = $TD.css("vertical-align");
                    if (vAlign == 'top') cell.setPropertyValue("vertical-align", ALIGNMENT.Top);
                    if (vAlign == 'middle') cell.setPropertyValue("vertical-align", ALIGNMENT.Center);
                    if (vAlign == 'bottom') cell.setPropertyValue("vertical-align", ALIGNMENT.Bottom);
                    var hAlign = $TD.css("text-align");
                    if (hAlign == 'center') cell.setPropertyValue("text-align", ALIGNMENT.Center);
                    if (hAlign == 'right') cell.setPropertyValue("text-align", ALIGNMENT.Right);

                    //边框，只处理有无，不处理风格
                    var borderStyle = css2localBorderStyle($TD.css('border-left-style'));

                    if (borderStyle != 0)
                    {
                        cell.setPropertyValue("border-left-style", borderStyle);
                        var w = Math.ceil($TD.css('border-left-width').replace(/px/g, ''));
                        cell.setPropertyValue("border-left-width", w);
                    }

                    borderStyle = css2localBorderStyle($TD.css('border-right-style'));
                    if (borderStyle != 0)
                    {
                        cell.setPropertyValue("border-right-style", borderStyle);
                        var w = Math.ceil($TD.css('border-right-width').replace(/px/g, ''));

                        cell.setPropertyValue("border-right-width", w);
                    }

                    borderStyle = css2localBorderStyle($TD.css('border-top-style'));
                    if (borderStyle != 0)
                    {
                        cell.setPropertyValue("border-top-style", borderStyle);
                        var w = Math.ceil($TD.css('border-top-width').replace(/px/g, ''));

                        cell.setPropertyValue("border-top-width", w);
                    }

                    borderStyle = css2localBorderStyle($TD.css('border-bottom-style'));
                    if (borderStyle != 0)
                    {
                        cell.setPropertyValue("border-bottom-style", borderStyle);
                        var w = Math.ceil($TD.css('border-bottom-width').replace(/px/g, ''));

                        cell.setPropertyValue("border-bottom-width", w);
                    }


                }

            }
        } catch (err)
        {

        } finally
        {
            this.paintPermit = true;
        }


    }


};


export default ISheetPaste ;
