/**
 * Created by 三宝爹 on 2017/7/9.
 *
 * worksheet中与尺寸相关的操作
 */

import MergedRange from "../MergedRange.js";
import DataSourceConfig from '../DataSourceConfig.js';
import Util from '../../util/Util.js';
import Property from "../Property.js";
import TextUtil from "../../gdi/text.js";
import Tools from "../../util/Tools.js";


let ISheetDimension = {
    //设置列宽
    $setColumnWidth: function (colindex, width) {

        this.CPM.setColumnWidth(colindex, width);

        this.resetHScrollBarScrollRange();

    },


    $setWidthBetweenTwoColumn: function (col1, col2, delta) {
        let w1 = this.CPM.getColumnWidth(col1); // 临时保存原有宽度
        let w2 = this.CPM.getColumnWidth(col2);// 临时保存原有宽度
        let delta2 = delta - w1; // 宽度的增量
        this.CPM.setColumnWidth(col2, this.CPM.getColumnWidth(col2) - delta2); // 减去增量
        if (this.CPM.getColumnWidth(col2) == 0) // 如果宽度减去增量后小于0
        {
            this.CPM.setColumnWidth(col1, w1 + w2); // 强制为两列的宽度
        } else
        {
            this.CPM.setColumnWidth(col1, Math.max(0, delta));
        }

        this.resetHScrollBarScrollRange();

    },

    $setHeightBetweenTwoRow: function (row1, row2, delta) {
        let w1 = this.RPM.getRowHeight(row1); // 临时保存原有高度
        let w2 = this.RPM.getRowHeight(row2);// 临时保存原有高度
        let delta2 = delta - w1; // 高度的增量
        this.RPM.setRowHeight(row2, this.RPM.getRowHeight(row2) - delta2); // 减去增量
        if (this.RPM.getRowHeight(row2) == 0) // 如果高度减去增量后小于0
        {
            this.RPM.setRowHeight(row1, w1 + w2); // 强制为两列的高度
        } else
        {
            this.RPM.setRowHeight(row1, Math.max(0, delta));
        }

        this.resetVScrollBarScrollRange();

    },

    $setRowHeight: function (rowIndex, height) {
        this.RPM.setRowHeight(rowIndex, height);

        this.resetVScrollBarScrollRange();

    },


    getInnerRowAtPoint: function (cell, /*Point*/    p, /*boolean*/    setAsCurrentBindRow) {


        setAsCurrentBindRow = setAsCurrentBindRow || true;

        if (cell != null)
        {
            if (cell.Bind != null)
            {
                let dsc = this.Book.getDataSource(cell.Bind.dataSource);
                if (dsc.dataStore.rowCount == 0) return -1;

                if (cell.Bind.dataSourceType == DataSourceConfig.SingleRowDataSource) return 0;
                if (cell.Bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource) return dsc.currentBindRow;
            }
        }

        //没有绑定，或者绑定到多行时，
        let row = this.View.GetRowAtPoint(false, p.y);

        let dbRow = row.dbRow ? row.dbRow : 0;
        if (Util.isObject(row)) row = row.row;
        let mrdsn = this.RPM.getMultiRowDataSourceName(row);

        if (mrdsn == '') return -1;

        let dsc = this.Book.getDataSource(mrdsn);

        if (setAsCurrentBindRow)
        {
            dsc.currentBindRow = dbRow;

        }
        return dbRow;

    },


    //自已内部，也可能需要在尺寸变化后，做一点什么
    rowHeightChanged: function (row) {
        let CC = this.columnCount;
        for (let col = 0; col < CC; col++)
        {
            let cell = this.$cells(row, col);
            if (cell == null) continue;
            if (cell.merged) cell = cell.leftTopCorner;
            if (['html', 'image'].contains(cell.viewAs))
            {
                cell.clearInternalData();
            }
        }
    },

    //自已内部，也可能需要在尺寸变化后，做一点什么
    columnWidthChanged: function (col) {
        let RC = this.rowCount;

        for (let row = 0; row < RC; row++)
        {
            let cell = this.$cells(row, col);
            if (cell == null) continue;
            let leftTopCell = cell;
            if (cell.merged) leftTopCell = cell.leftTopCorner;
            if (['html', 'image'].contains(leftTopCell.viewAs))
            {
                leftTopCell.clearInternalData();
            }

            //2021.06.09


            let leftTopCellCol = leftTopCell.columnIndex;
            if (this.CPM.isRowHeightAutoFit(leftTopCellCol)) this.resetRowHeightWhenColumnWidthChanged(row, leftTopCellCol, cell, leftTopCell);


        }
    },

    //自已内部，也可能需要在尺寸变化后，做一点什么
    resetRowHeightWhenColumnWidthChanged: function (row, col, cell, leftTopCell) {
        let RC = this.rowCount;


        //如果是合并的单元格，并且不是合并行的第一行，而是中间行，那么不要管它
        if (cell.rowIndex != leftTopCell.rowIndex) return;

        //如果是绑定行多行结果集，忽略（暂时不支持）
        if (leftTopCell.Bind != null)
        {
            if (leftTopCell.Bind.dataSourceType == DataSourceConfig.MultiRowDataSource) return;
        }

        //如果不是自动折行的，继续下一行
        let /*Property*/ prop = leftTopCell.getPropertyObject();// 不要直接用成员变量this.property,因为它可能为空

        let /*boolean*/ word_wrap = prop.get(Property.word_wrap, false);
        if (!word_wrap) return
        //得到单元格占据的宽度，注意不仅仅col列的宽度
        let width = this.CPM.getColumnWidth(leftTopCell.columnIndex); // cell.columnndex 不一定等于  col
        let otherHeight = 0;
        if (cell.isMerged())
        {

            for (let i = leftTopCell.getMergedRange().startCol + 1; i <= leftTopCell.getMergedRange().endCol; i++)
            {
                width += this.CPM.getColumnWidth(i);
            }

            for (let i = leftTopCell.getMergedRange().startRow + 1; i <= leftTopCell.getMergedRange().endRow; i++)
            {
                otherHeight += this.RPM.getRowHeight(i);
            }


        }
        //计算内容高度
        let text = leftTopCell.getShowText(0);
        let /*String*/ font_family = prop.get(Property.font_family, "宋体");
        if (font_family.equals("自动")) font_family = cell.getAppropriateFontName();
        let /*int*/ font_size = parseInt(prop.get(Property.font_size, 12))+ (Tools.isMobile()?2:0) ; //2021.06.24 移动设备上字体偏小，所以自动放大一点
        let /*boolean*/ font_bold = prop.get(Property.font_bold, false);
        let /*boolean*/ font_italic = prop.get(Property.font_italic, false);
        let /*boolean*/ font_underline = prop.get(Property.font_underline, false);
        let /*int*/ padding_left = prop.get(Property.padding_left, 0);
        let /*int*/ padding_rigt = prop.get(Property.padding_right, 0);
        let /*int*/ padding_top = prop.get(Property.padding_top, 0);
        let /*int*/ padding_bottom = prop.get(Property.padding_bottom, 0);

        let lineSpacing = 2;
        let height = TextUtil.getTextHeightInWidth(width, text, font_family, font_size, font_bold, font_italic, font_underline, lineSpacing) +
            padding_top + padding_bottom - otherHeight;

        let minHeight = this.RPM.getRowMinHeight(cell.rowIndex);
        if (height < minHeight) height = minHeight;

        this.RPM.setRowHeight(cell.rowIndex, Math.max(0, height));


    }


};

export default ISheetDimension;
