/**
 * Created by 三宝爹 on 2017/11/15.
 */


import EditStyle from '../EditStyle.js';
import Tools from '../../util/Tools.js';


var ISetEditStyle = {



    /**
     * @api {setEditStyleNormal} 函数   setEditStyleNormal
     *
     * @apiDescription setEditStyleNormal (cell, inputAttribute)
     * <br><br>  设置单元格的编辑格式为普通编辑格式，即使用  input 标签来接收收内容
     *
     * @apiName  setEditStyleNormal
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} inputAttribute  INPUT框的属性
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleNormal( book.sheet0.cells("a1") ,'  type="number" min="1" max="5" ' );


     */
    setEditStyleNormal: function (cell ,inputAttribute) {

        inputAttribute=inputAttribute ||'';
        var key = "normal_"+inputAttribute;
        var es = this.newEditStyle(key, {type: EditStyle.$Normal , inputAttribute:inputAttribute});
        cell.setEditStyle(es);

    },

    /**
     * @api {setEditStyleMultiLine} 函数   setEditStyleMultiLine
     *
     * @apiDescription setEditStyleMultiLine (cell)
     * <br><br>  设置单元格的编辑格式为多行编辑，即使用  textarea 标签来做编辑
     *
     * @apiName  setEditStyleMultiLine
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleMultiLine( book.sheet0.cells("a1")   );


     */
    setEditStyleMultiLine: function (cell) {

        var key = "multiline";
        var es = this.newEditStyle(key, {type: EditStyle.$MultiLine});
        cell.setEditStyle(es);

    },

    /**
     * @api {setEditStyleNumeric} 函数   setEditStyleNumeric
     *
     * @apiDescription setEditStyleNumeric (cell, showComma, decimalCount, zeroVisible)
     * <br><br>  设置单元格的编辑格式为小数编辑格式
     *
     * @apiName  setEditStyleNumeric
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {boolean} showComma 显示千分位
     * @apiParam {int} decimalCount 小数位数
     * @apiParam {boolean} zeroVisible 数字0是否显示
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleNumeric( book.sheet0.cells("a1") , true, 2, true );


     */
    setEditStyleNumeric(cell, showComma, decimalCount, zeroVisible)
    {

        var key = "numeric_" + showComma + "_" + decimalCount + "_" + zeroVisible;
        var es = this.newEditStyle(key, {
            type: EditStyle.$Numeric,
            showComma: showComma,
            decimalCount: decimalCount,
            zeroVisible: zeroVisible

        });

        cell.setEditStyle(es);
        if (cell.Bind)
        {
            var format = Tools.getDecimalPattern(decimalCount, '.', showComma, ',');
            this.getDataSource(cell.Bind.dataSource).dataStore.getColumnProperty(cell.Bind.DBCol).setFormat(format);
        }

    },

    /**
     * @api {setEditStyleDate} 函数   setEditStyleDate
     *
     * @apiDescription setEditStyleDate (cell, format)
     * <br><br>  设置单元格的编辑格式为日期编辑格式
     *
     * @apiName  setEditStyleDate
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} format 日期格式
     *
     * <br> 使用 y 表示年， M表示月，d表示日， H表示小时， m表示分钟, s 表示秒，示例：
     * <ul>
     *     <li>yyyy.MM.dd</li>
     *     <li>yyyy-MM-dd</li>
     *     <li>yyyy.MM.dd HH:mm:ss</li>
     *     <li>yyyy年MM月dd日</li>
     *     <li>yyyy.MM</li>
     *     <li>MM.dd</li>
     *     <li>HH:mm</li>
     *
     *
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleDate( book.sheet0.cells("a1") ,"yyyy.MM.dd" );


     */
    setEditStyleDate(cell, format)
    {

        var key = "date_" + format;
        var es = this.newEditStyle(key, {
            type: EditStyle.$Datetime,
            datetimeFormat: format
        });

        cell.setEditStyle(es);

        if (cell.Bind)
        {
            this.getDataSource(cell.Bind.dataSource).dataStore.getColumnProperty(cell.Bind.DBCol).setFormat(format);
        }

    },

    /**
     * @api {setEditStyleDDLB} 函数   setEditStyleDDLB
     *
     * @apiDescription setEditStyleDDLB (cell, ddlbName, dropDownListEditable, valueMustInDDLB, ddlbFilterBy,ddlbFilterContext, ddlbInnerItems, showRealData)
     * <br><br>  设置单元格的编辑格式为下拉列表编辑格式，
     *
     * @apiName  setEditStyleDDLB
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} ddlbName 列表名称， 即在系统后台设置中的列表设置中的那些列表名称
     * @apiParam {boolean} dropDownListEditable 列表是否可编辑，如果可编辑，那么一边输入，列表项目一边过滤
     * @apiParam {boolean} valueMustInDDLB  当 dropDownListEditable==true时，当输入的内容不在列表中时，是否接受该数据
     * @apiParam {String} ddlbFilterBy 列表的候选项过滤条件
     * @apiParam {String} ddlbFilterContext 列表的候选项过滤条解析时使用的数据包
     * @apiParam {String} ddlbInnerItems 列表的额外的静态列表数据项
     * @apiParam {boolean} showRealData  当选择一个列表项目后， 单元格通常显示的是列表的显示值，当本参数=true时，直接显示数据值
     *
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleDDLB( book.sheet0.cells("a1") ,"列表1", false,true,"",“”,"",false);


     */
    setEditStyleDDLB(cell, ddlbName, dropDownListEditable, valueMustInDDLB, ddlbFilterBy,ddlbFilterContext, ddlbInnerItems, showRealData)
    {

        if(ddlbFilterBy==undefined) ddlbFilterBy='';

        ddlbName = ddlbName.trim();
        //ddlbName可能是空字符串，因此在拼key时，需要把ddlbInnerItems也拼上

        var key = "ddlb_" + ddlbName + ddlbInnerItems + "_" + dropDownListEditable + "_" +
            valueMustInDDLB + "_" + ddlbFilterBy + "_" + ddlbFilterContext + ddlbInnerItems + '_' + showRealData;

        var es = this.newEditStyle(key, {
            type: EditStyle.$DDLB,
            ddlbName: ddlbName,
            dropDownListEditable: dropDownListEditable,
            valueMustInDDLB: valueMustInDDLB,
            ddlbFilterBy: ddlbFilterBy,
            ddlbFilterContext:ddlbFilterContext,
            ddlbInnerItems: ddlbInnerItems,
            showRealData: showRealData,
            dropDownData: {dataValue: [], showText: [], inited: false}
        });

        cell.setEditStyle(es);


        //有动态过滤条件，那么把它注册到表达式中，并增加cell对这个表达式的订阅，当表达式的值有变化时，cell会收到通知来重绘

        if (ddlbFilterBy != '')
        {
            var expressionName =ddlbFilterContext+ ddlbFilterBy;
            var expressionDefine= this.contextDefine2Expression( ddlbFilterContext);
            cell.Sheet.addExpression(expressionName, expressionDefine);
            var expression = cell.Sheet.getExpression(expressionName);
            expression.addSubscriber(cell);

        }

        if (!es.dropDownData.inited) this.EM.fire("getDropDownData", [es, cell]);

    },

    /**
     * @api {setEditStyleCheckbox} 函数   setEditStyleCheckbox
     *
     * @apiDescription setEditStyleCheckbox (cell, checkOnValue, checkOffValue)
     * <br><br>  设置单元格的编辑格式为开关编辑格式，
     *
     * @apiName  setEditStyleCheckbox
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} checkOnValue 勾选上时的数据
     * @apiParam {String} checkOffValue 不勾选上时的数据
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleCheckbox( book.sheet0.cells("a1") ,"1","0"  );


     */
    setEditStyleCheckbox: function (cell, checkOnValue, checkOffValue ,checkCaption) {

        var key = "switch_" + checkOnValue + "_" + checkOffValue+"_"+checkCaption;
        var es = this.newEditStyle(key, {
            type: EditStyle.$CheckBox,
            ddlbFilterBy: '',
            checkOnValue: checkOnValue,
            checkOffValue: checkOffValue,
            checkCaption:checkCaption
        });

        cell.setEditStyle(es);

    },

    /**
     * @api {setEditStyleRadio} 函数   setEditStyleRadio
     *
     * @apiDescription setEditStyleRadio (cell, ddlbName, ddlbFilterBy, ddlbFilterContext,ddlbInnerItems, columnCount)
     * <br><br>  设置单元格的编辑格式为单选编辑格式，
     *
     * @apiName  setEditStyleRadio
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} ddlbName 列表名称， 即在系统后台设置中的列表设置中的那些列表名称
     * @apiParam {String} ddlbFilterBy 列表的候选项过滤条件
     * @apiParam {String} ddlbFilterContext 列表的候选项过滤条解析时使用的数据包
     * @apiParam {String} ddlbInnerItems 列表的额外的静态列表数据项
     * @apiParam {int} columnCount  分几列显示
     *
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleRadio( book.sheet0.cells("a1") ,"列表1", "","","",2);


     */
    setEditStyleRadio: function (cell, ddlbName, ddlbFilterBy, ddlbFilterContext,ddlbInnerItems, columnCount) {

        ddlbName = ddlbName.trim();
        //ddlbName可能是空字符串，因此在拼key时，需要把ddlbInnerItems也拼上
        var key = "radio_" + ddlbName + ddlbInnerItems + "_" + ddlbFilterBy + "_" + ddlbFilterContext + "_" + ddlbInnerItems + '_' + columnCount;
        var es = this.newEditStyle(key, {
            type: EditStyle.$RadioButton,
            ddlbName: ddlbName,
            ddlbFilterBy: ddlbFilterBy,
            ddlbFilterContext:ddlbFilterContext,
            ddlbInnerItems: ddlbInnerItems,
            columnCount: columnCount,
            dropDownData: {dataValue: [], showText: [], inited: false}
        });

        cell.setEditStyle(es);

        //有动态过滤条件，那么把它注册到表达式中，并增加cell对这个表达式的订阅，当表达式的值有变化时，cell会收到通知来重绘

        if (ddlbFilterBy != '')
        {
            var expressionName =ddlbFilterContext+ ddlbFilterBy;
            var expressionDefine= this.contextDefine2Expression( ddlbFilterContext);
            cell.Sheet.addExpression(expressionName, expressionDefine);
            var expression = cell.Sheet.getExpression(expressionName);
            expression.addSubscriber(cell);

        }

        if (!es.dropDownData.inited) this.EM.fire("getDropDownData", [es, cell]);


    },

    /**
     * @api {setEditStyleMultiCheckbox} 函数   setEditStyleMultiCheckbox
     *
     * @apiDescription setEditStyleMultiCheckbox (cell, ddlbName, ddlbFilterBy, ddlbFilterContext, ddlbInnerItems, columnCount)
     * <br><br>  设置单元格的编辑格式为多选编辑格式，
     *
     * @apiName  setEditStyleMultiCheckbox
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} ddlbName 列表名称， 即在系统后台设置中的列表设置中的那些列表名称
     * @apiParam {String} ddlbFilterBy 列表的候选项过滤条件
     * @apiParam {String} ddlbFilterContext 列表的候选项过滤条解析时使用的数据包
     * @apiParam {String} ddlbInnerItems 列表的额外的静态列表数据项
     * @apiParam {int} columnCount  分几列显示
     *
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleMultiCheckbox( book.sheet0.cells("a1") ,"列表1", "","",2);


     */
    setEditStyleMultiCheckbox: function (cell, ddlbName, ddlbFilterBy, ddlbFilterContext, ddlbInnerItems, columnCount) {

        ddlbName = ddlbName.trim();
        //ddlbName可能是空字符串，因此在拼key时，需要把ddlbInnerItems也拼上
        var key = "checkbox_" + ddlbName + ddlbInnerItems + "_" + ddlbFilterBy + "_" + ddlbFilterContext + "_" + ddlbInnerItems + '_' + columnCount;
        var es = this.newEditStyle(key, {
            type: EditStyle.$MultiCheckBox,
            ddlbName: ddlbName,
            ddlbFilterBy: ddlbFilterBy,
            ddlbFilterContext: ddlbFilterContext,
            ddlbInnerItems: ddlbInnerItems,
            columnCount: columnCount,
            dropDownData: {dataValue: [], showText: [], inited: false}
        });

        cell.setEditStyle(es);

        //有动态过滤条件，那么把它注册到表达式中，并增加cell对这个表达式的订阅，当表达式的值有变化时，cell会收到通知来重绘

        if (ddlbFilterBy != '')
        {
            var expressionName =ddlbFilterContext+ ddlbFilterBy;
            var expressionDefine= this.contextDefine2Expression( ddlbFilterContext);
            cell.Sheet.addExpression(expressionName, expressionDefine);
            var expression = cell.Sheet.getExpression(expressionName);
            expression.addSubscriber(cell);

        }

        if (!es.dropDownData.inited) this.EM.fire("getDropDownData", [es, cell]);

    },
    /**
     * @api {setEditStyleTree} 函数   setEditStyleTree
     *
     * @apiDescription setEditStyleTree (cell, treeName, treeWidth, treeHeight, treeSelectMulti, treeFilterBy, treeFilterContext)
     * <br><br>  设置单元格的编辑格式为树编辑格式，
     *
     * @apiName  setEditStyleTree
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Cell} cell 单元格
     * @apiParam {String} treeName 树定义中的名称
     * @apiParam {int} treeWidth 树控件的显示宽度
     * @apiParam {int} treeHeight 树控件的显示高度
     * @apiParam {boolean} treeSelectMulti 是否多选
     * @apiParam {String} treeFilterBy  数据过滤条件
     * @apiParam {String} treeFilterContext 过滤条解析时使用的数据包
     *
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *


     book.setEditStyleTree( book.sheet0.cells("a1") ,"tree1",300，400,false, '',''  );


     */
    setEditStyleTree: function (cell, treeName, treeWidth, treeHeight, treeSelectMulti, treeExpandOnLoad,treeFilterBy ,treeFilterContext ) {
        var key = "tree_" + treeName + "_" + treeWidth + "_" +
            treeHeight + "_" + treeFilterBy + "_" + treeFilterContext + "_" + treeSelectMulti +"_"+ treeExpandOnLoad ;

        var es = this.newEditStyle(key, {
            type: EditStyle.$Tree,
            treeName: treeName,
            treeSelectMulti: treeSelectMulti,
            treeExpandOnLoad:treeExpandOnLoad,
            treeWidth: treeWidth,
            treeHeight: treeHeight,
            treeFilterBy: treeFilterBy,
            treeFilterContext:treeFilterContext,
            treeNodes: [],
            treeNodesInited: false

        });

        cell.setEditStyle(es);
        //有动态过滤条件，那么把它注册到表达式中，并增加cell对这个表达式的订阅，当表达式的值有变化时，cell会收到通知来重绘
        if (treeFilterBy != null && treeFilterBy != '')
        {
            var expressionName =treeFilterContext+treeFilterBy;
            var expressionDefine=  this.contextDefine2Expression( treeFilterContext);
            cell.Sheet.addExpression(expressionName, expressionDefine);
            var expression = cell.Sheet.getExpression(expressionName);
            expression.addSubscriber(cell);

        }

        if (!es.treeNodesInited) this.EM.fire("getTreeNodes", [es, cell]);

    },

    /**
     * 数据包的定义拼接成一个表达式，用于在这个表达式上增加订阅，当依赖的数据变化后，触发编辑格式变化刷新
     * @param context   是一个字符串， 用回车分隔每一个数据包定义，数据变量定义格式   变量名:值或表达式
     */
    contextDefine2Expression:function( context)
    {
        //把所有变量定义的表达式部分，用 + 拼成一个表达式，目的不是为了计算，而是为了合并所有依赖的单元格信息
        let contextDefine = context ||'';
        let contexts = contextDefine.split('\n');
        let list = [];
        for (let i = 0; i < contexts.length; i++) {
            if (contexts[i].trim() == '') continue;
            list.push(contexts[i]);
        }

        return  list.join(' + ');

    }
};

export default ISetEditStyle;
