/**
 * 修改Sheet的名称
 * Created by zengjun on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetValue = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        this.Scene.put("oldname", this.Sheet.name);
        var row = this.Scene.get("row");
        var col = this.Scene.get("col");
        var cell = this.Scene.get("cell");
        var dbRow = this.Scene.get("dbrow", 0);

        if (cell.isFormula(cell.Define) || cell.isFormulaContained(cell.Define))
        {
            this.Scene.put("oldvalue", cell.Define);
        } else
        {
            this.Scene.put("oldvalue", cell.getValue(dbRow));
        }

    },

    $execute: function () {
        var cell = this.Scene.get("cell");
        var value = this.Scene.get("value");
        var dbRow = this.Scene.get("dbrow", -1);
        var repaint= this.Scene.get("repaint",true);
        return cell.$setValue(value, dbRow ,true,repaint);

    },

    $undo: function () {
        var cell = this.Scene.get("cell");
        var dbRow = this.Scene.get("dbrow", -1);
        var value = this.Scene.get("oldvalue");

        return cell.$setValue(value, dbRow);
    }


});


export default CMD_SetValue;
