/**
 * Created by 三宝爹 on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetColumnWidth = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var /*ColumnPropertyManage*/ CPM = this.Sheet.CPM;
        var col = this.Scene.get("col", 0);
        var oldWidth = CPM.getColumnWidth(col);
        this.Scene.put("oldwidth", oldWidth);
    },

    $execute: function () {
        var col = this.Scene.get("col", 0);
        var width = this.Scene.get("width", 0);
        this.Sheet.$setColumnWidth(col, width);
        return true;

    },

    $undo: function () {
        var col = this.Scene.get("col", 0);
        var oldwidth = this.Scene.get("oldwidth", 0);
        this.Sheet.$setColumnWidth(col, oldwidth);
        return true;
    }

});

export default CMD_SetColumnWidth;