/**
 * Created by 三宝爹 on 2017/7/13.
 */


import Command from './Command.js';
import CMD_DeleteMultiRow from './CMD_DeleteMultiRow.js';
import RedefineBecause from '../core/RedefineBecause.js';


var  CMD_InsertMultiRow = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        //need do nothing
    },

    $execute: function () {

        var startRow = this.Scene.get("startrow", 0);
        var endRow = this.Scene.get("endrow", 0);

        var ret = this.Sheet.$insertMultiRow(startRow, endRow);

        // 如果本命令是第一次执行，那么只需要插入空行就可以了,否则还要还原数据
        if (ret && this.Scene.get("first", true) == false)
        {
            CMD_DeleteMultiRow.RestoreData(this.Scene, this.Sheet, this.startRow, this.endRow);
        }
        //自动更新公式
        if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow())
        {
            var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseInsertRow, startRow, 0, endRow, 0);
            this.Sheet.Book.RebuildAllDefine(this.Sheet, why);
        }
        return ret;

    },

    $undo: function () {
        var startRow = this.Scene.get("startrow", 0);
        var endRow = this.Scene.get("endrow", 0);

        // 当插入空行后，可能又做了一些操作 ，比如为新加的行设置了属性等
        // 此时Undo 这是删除这个新加的行，但不能直接一删了事，还需要保存新加的行的现在的信息
        CMD_DeleteMultiRow.SaveScene(this.Scene, this.Sheet, startRow, endRow);
        this.Scene.put("first", false);
        var ret = this.Sheet.$deleteMultiRow(startRow, endRow);
        //自动更新公式

        if (ret)
        {
            if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow())
            {
                var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseDeleteRow, startRow, 0, endRow, 0);
                this.Sheet.Book.RebuildAllDefine(this.Sheet, why);
            }
        }
        return ret;
    }


});

export default CMD_InsertMultiRow ;

