/**
 * Created by 三宝爹 on 2017/7/13.
 */


import Command from './Command.js';
import RedefineBecause from '../core/RedefineBecause.js';


var CMD_DeleteMultiRow = Command.extend({

    static: {


//	把数据保存到Scene中
        SaveScene: function (Scene, Sheet, startRow, endRow) {
            var /*RowPropertyManage*/ RPM = Sheet.getRowPropertyManage();
            //把将要删除的数据行保存起来,还有行高也保存起来
            for (var i = startRow; i <= endRow; i++)
            {
                var /*Row*/ r = Sheet.getRow(i);
                Scene.put("row:" + i, r);
                Scene.put("rp:" + i, RPM.getRowProperty(i));
            }
        },
        // 从Scene 中还原数据
        RestoreData: function (Scene, Sheet, startRow, endRow) {

            var /*RowPropertyManage*/  RPM = Sheet.getRowPropertyManage();

            for (var i = startRow; i <= endRow; i++)
            {
                var /*Row*/  r = Scene.get("row:" + i);
                Sheet.$setRow(i, r);

                var /*RowProperty*/rp = Scene.get("rp:" + i);
                RPM.$setRowProperty(i, rp);

            }
        }

    },
    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    }
    ,

    $saveScene: function () {
        var startRow = this.Scene.get("startrow", 0);
        var endRow = this.Scene.get("endrow", 0);
        this.Clas$.SaveScene(Scene, Sheet, startRow, endRow);
    }
    ,

    $execute: function () {
        var startRow = this.Scene.get("startrow", 0);
        var endRow = this.Scene.get("endrow", 0);
        var ret = this.Sheet.$deleteMultiRow(startRow, endRow);
        //自动更新公式
        if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow())
        {
            var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseDeleteRow, startRow, 0, endRow, 0);
            this.Sheet.Book.RebuildAllDefine(this.Sheet, why);
        }

        return ret;
    }
    ,

    $undo: function () {
        var startRow = Scene.get("startrow", 0);
        var endRow = Scene.get("endrow", 0);
        this.Sheet.$insertMultiRow(startRow, endRow);

        this.Clas$.RestoreData(this.Scene, this.Sheet, startRow, endRow);

        //自动更新公式
        if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow())
        {
            var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseInsertRow, startRow, 0, endRow, 0);
            this.Sheet.Book.RebuildAllDefine(this.Sheet, why);
        }

        return true;
    }


});

export default CMD_DeleteMultiRow;
