/**
 * Created by 三宝爹 on 2019/06/04.
 *
 * 提供 Tab 内容容器控件，它用来存放tab对应的内容 ， 内容的显示与隐藏由相关的 TabBrick来控制
 */

import HTMLBrick from './HTMLBrick.js';
import Rectangle from '../gdi/Rectangle.js';
import Color from '../gdi/Color.js';
import Tools from '../util/Tools.js';
import Util from '../util/Util.js';
import SheetContainer from './SheetContainer.js';


var TabContentBrick = HTMLBrick.extend({

    properties:
        {

            "activeTab": {
                get: function () {return this.currentActiveTab; },
                set: function (val) { return this.setActiveTab(val, true);}
            }
        },

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = 'tabcontent';

        this.setConfig(config);

    },

    setConfig: function (config) {
        this.config = config;

    },


    createDOM: function () {


        var bookView = this.pSheet.Book.View;

        this.containerDivID= Tools.newGUID();

        var html = [];
        html.push(`<div id="tabContent_${this.containerDivID}" style="width:100%;height:100%">`);


        html.push(`</div>`);

        //内容控制

        this.config.html = html.join('');

        //调用 基类的函数创建DOM对象 ， 以支持设计状态下的单元格选中
        this.$uper.createDOM.call(this,false);//false表示基类中不要触发 brickOnload事件

        this.dom = bookView.createDOM(this.DOMName, html.join(''));
        var container = $(this.pSheet.View.canvas.parentNode);
        this.dom.appendTo(container);

        //每个tab的内容单独放在一个div中

        for (var i = 0; i < this.config.tabs.length; i++)
        {
            var one = this.config.tabs[i];
            this.addTabContentContainer(one);
        }

        let that=this;
        that.pSheet.Book.EM.fire("brickOnload", [that.pSheet,  that]);

    },

    addTabContentContainer:function(one)
    {
        let that=this;


        //每个tab的内容单独放在一个div中


        let html=[];

        html.push(`<div id="tabContent_${this.DOMName}_${one.id}" 
                               style="width:100%;height:100%; display:none; "  class="tabContent_${this.DOMName}">`);

            var type = one.type;
            if (type == 'html') html.push(one.source);

            if (type == 'iframe')
            {

                html.push(`<iframe frameborder="0" src="${one.source}" style="width:100%;height:100%;"></iframe>`);

            }

            html.push(`</div>`);


        $(`#tabContent_${this.containerDivID}`).append( html.join('')); //子容器加入到总容器中




            var container = `#tabContent_${this.DOMName}_${one.id}`;




            if (type == 'worksheet')
            {
                var config = {};
                config.name = this.DOMName + "-" + one.id;
                config.sheetGUID = this.pSheet.Book.getWorkSheet(one.source).guid;

                config.caption = '';
                config.enable = true;
                config.visible = true;
                //---------------------------------------------

                config.x = 0;
                config.y = 0;
                config.width = 0;
                config.height = 0;
                config.appendToContainer = container;// 标记20190605
                config.justInTabContainer=true;

                var sc = new SheetContainer(config.name, config ,0,0,0,0);

                one.sheetContainer = sc;

                var contentCell = this.pSheet.cells(this.config.container);
                contentCell.addBrick(sc);

                contentCell.repaint();

                //  $(`#tabContent_${this.DOMName}_${one.id}`).css('display','none');

                if (one.id == this.currentActiveTab)
                {

                       // that.setActiveTab(one.id, true);

                }

            }


    },


    setActiveTab: function (tabId, force) {
        if (this.currentActiveTab == tabId && !force) return;

        var div = $(`.tabContent_${this.DOMName}`);
        div.css("display", "none");
        this.currentActiveTab = tabId;
        div = $(`#tabContent_${this.DOMName}_${this.currentActiveTab}`);
        div.css("display", "");

        //
        for (var i = this.config.tabs.length - 1; i >= 0; i--)
        {
            let one = this.config.tabs[i];
            if(! one.sheetContainer) continue; //内容不是sheet不用继续了
            if (one.id == tabId   )
            {

                //如果不这么让它resize一下，结果就是第一个Tab页中的Sheet，它的Size不对，卷滚条不对
                //第二个Tab在激活时，显示上有明显的卡顿
                //按下面强制Resize一下后， 上面两个问题解决了,原因不明


                one.sheetContainer.resize();
                one.sheetContainer.innerSheet.VisibleInTabContainer=true;
                one.sheetContainer.innerSheet.visible=true;
                //alert(one.sheetContainer.innerSheet.name+" paint");
                one.sheetContainer.innerSheet.workSheetView.repaint();


            }else
            {
                one.sheetContainer.innerSheet.VisibleInTabContainer=false;
                one.sheetContainer.innerSheet.visible=false;
            }


        }
    }


});

export default TabContentBrick ;

