/**
 * Created by 三宝爹 on 2019/06/04.
 *
 * 提供 Tab控件，将多个Sheet集成显示在一个容器中，并用Tab来控制显示隐藏
 *
 *
 *  BUG： 2019。06.05  已知但未能解决的bug: 如果一个sheet中插入两个Tab控件，那么第一个Tab控件的第一个Tab页中嵌入的Sheet的Size不能正确设置，
 *  需要切换一下Tab页后才正确 。 但只放一个Tab控件，那么这个Tab控件中的多个Tab页中的sheet的Size都能正确设置 。
 *   由于在一个Sheet中，摆多个Tab容器的实际意义不大，此问题暂时搁置
 *
 *  BUG : 2019.06.05  一个Tab控件tab页中的Sheet里，可以再放一个Tab控件，即嵌套2层 tab 没问题，但嵌套3层就有问题 ， 问题出在
 *      HTMLBrick.showOrHide ，同时dom创建时的父对象可能也有问题， 由于超过2层的多层嵌套实际意义不大，此问题暂时搁置
 *
 */


import HTMLBrick from './HTMLBrick.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';
import TabContentBrick from "./TabContentBrick.js";


var TabBrick = HTMLBrick.extend({

    properties:
        {
            /**
             * @api {activeTab} 可读可写属性 [属性]activeTab
             * @apiName  activeTab
             * @apiDescription 当前活动的Tab的ID
             * @apiGroup Tab
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){String} - 活动tab的ID
             * @apiExample {js}(示例：)
             *
             * book.sheet0.getBrick("tab_demo").activeTab="tab1"
             * alert( book.sheet0.getBrick("tab_demo").activeTab);
             */
            "activeTab": {
                get: function () {return this.currentActiveTab; },
                set: function (val) { return this.setActiveTab(val);}
            }
        },

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = 'Tab';

        this.setConfig(config);

        let that = this;

        //TODO 2020.05.30 下面这个是为了确保tab激活第一个页面，并显示内容
        // 不加下面这一段， 结果就是第一个页面有时能显示，有时不刷新显示，原因不想查了，强制切换激活一下
        window[ 'tab' + Tools.newGUID()+'$afterOpen' ] = function () {
            if (that.config.tabs.length > 1)//只有一个tab？ ，那搞什么飞机
            {
                that.setActiveTab(that.config.tabs[1].id, true ,false );
                that.setActiveTab(that.config.tabs[0].id, true);
            }
        }


    },

    setConfig: function (config) {
        this.config = config;

    },


    createDOM: function () {

        var bookView = this.pSheet.Book.View;

        var contentCell = this.pSheet.cells(this.config.container);

        if (contentCell == null)
        {
            alert(this.config.container) + "不是合法的单元格";
            return;
        } else
        {

            //设计状态，不要创建内容容器
            if (this.tabContentBrick == undefined && !this.pSheet.designMode)
            {
                setTimeout(function () {

                    //克隆一份，不然在TabContentBrick中改变了 this.config
                    var cfg = Util.clone(this.config);

                    this.tabContentBrick = new TabContentBrick(this.Name, cfg, 0, 0, 0, 0);
                    contentCell.addBrick(this.tabContentBrick);
                }.bind(this), 10);
            }
        }


        var tabClass = 'tabbed';
        var tabCSS = "width:100%; top:0px;";
        if (this.config.position == 'top')
        {
            tabClass = 'tabbed_top';
            tabCSS = "position:absolute; width:100%; bottom:0px;height:30px; ";
        }

        var html = [];
        html.push(`<div  style="width:100%;height:100%"><div id='tab_${this.DOMName}' style="${tabCSS}" 
                            class="${tabClass} ${this.config.style}  ${this.config.skin}"  >
                        <ul  id='ul_${this.DOMName}'>`);


        for (var i = this.config.tabs.length - 1; i >= 0; i--)
        {
            var one = this.config.tabs[i];

            html.push(`<li id="tab_${this.DOMName}_${one.id}" 
                               tabid="${one.id}"   >&nbsp;&nbsp${one.title}&nbsp;&nbsp </li> 
                                
                            `);

        }
        html.push(`</ul> </div></div>`);

        //内容控制

        this.config.html = html.join('');

        //调用基类的创建函数，增加点击控制，设置当前选中行列，不然在设计状态下无法选中单元格
        this.$uper.createDOM.call(this);


        this.currentActiveTab = '';


        var that = this;

        var tabs = $(`#tab_${this.DOMName}`)[0].querySelectorAll('li');

        for (var i = tabs.length - 1; i >= 0; i--)
        {

            var tab = tabs[i];

            $(tab).on('click', function () {
                if (this.classList.contains('active')) return;
                var tabid = $(this).attr('tabid');
                that.setActiveTab(tabid);

            });

        }


        //激活第一个Tab页
        setTimeout(function () {
            that.setActiveTab(that.config.tabs[0].id, true);

            that.pSheet.Book.EM.fire("brickOnload", [that.pSheet,  that]);

        }, 100);

    },


    /**
     * 增加一个tab
     * @param one
     */
    addTab:function( one   )
    {
        var that=this;

        //Step1 ， 配置项增加
         this.config.tabs.push( one );

         //如果DOM对象还没有创建，那么不用做什么了，等它初始化时，新加的tab与最初的tab被视为一样的进行初始化
         if( ! this.dom) return;

         // Step2：  tab 耳朵增加
        var html=  `<li id="tab_${this.DOMName}_${one.id}" 
                               tabid="${one.id}"   >&nbsp;&nbsp${one.title}&nbsp;&nbsp </li> 
                                
                            `;
        let li=$(html);
        $(`#ul_${this.DOMName}`).prepend( li);

        //点击事件处理
        $(li).on('click', function () {
            if (this.classList.contains('active')) return;
            let tabid = $(this).attr('tabid');
            that.setActiveTab(tabid);

        });

        //Step3  tab内容容器增加
        let tcb=this.tabContentBrick;
        tcb.addTabContentContainer(one);



    },

    setTabVisible:function( tabId , visible)
    {
        if( this.currentActiveTab== tabId )
        {
            alert('只能设置非激活tab的visible属性');
            return ;
        }

        $(`#tab_${this.DOMName}_${tabId}`).css("display", visible?"":"none");

    },

    getActiveTab: function () {
        return this.currentActiveTab;
    },

    setActiveTab: function (tabId, force , triggerEvent) {
        if( triggerEvent==undefined) triggerEvent=true;
        if (this.currentActiveTab == tabId) if (!force) return;
        this.currentActiveTab = tabId;

        var tab = $(`#tab_${this.DOMName}_${tabId}`)[0];

        var ul = tab.parentNode;
        var innerTabs = ul.querySelectorAll('li');
        for (var i = 0, n = innerTabs.length; i < n; i++)
        {
            var one = innerTabs[i];
            if (one.classList.contains('active'))
            {
                one.classList.remove('active');
                var tabid = $(one).attr('tabid');
                this.$active(tabid, force , triggerEvent);
            }
        }

        tab.classList.add('active');
        this.$active(tabId, true , triggerEvent);


    },

    $active: function (tabId, active , triggerEvent) {
        if( triggerEvent==undefined) triggerEvent=true;
        console.info(tabId + "  " + active);
        var that = this;
        if (active && !this.pSheet.designMode)
        {
            //tabContentBrick.activeTab中已经处理了隐藏，所以仅需要对active==true时执行就可以了
            if (this.tabContentBrick)
            {

                setTimeout(function () {
                    that.tabContentBrick.setActiveTab(tabId);

                    //20210.06.19  增加事件支持
                    if( that.config.onActive &&  triggerEvent )
                    {
                        var oneConfig= that.config.tabs [ that.config.tabs.findIndex( item=> item.id== tabId) ] ;
                        that.config.onActive( oneConfig );
                    }
                }, 100);

            } else
            {
                //可能  this.tabContentBrick还没有建好，等它创建完成
                setTimeout(function () {
                    that.$active(tabId, active, triggerEvent);
                }, 100);
            }
        }

    }


});


export default TabBrick;
