/**
 * Created by 三宝爹 on 2017/12/14.
 */


import HTMLBrick from './HTMLBrick.js';
import Util from '../util/Util.js';

var EchartBrick = HTMLBrick.extend({

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = 'echart';

    },

    paint: function (/*boolean */isPrint  /*int*/, /*Graphics2D*/ g, /*Rectangle*/ parentRC) {

        if (!this.Visible) return;

        if (this.dom == null) this.createDOM();


        var rc = this.getBounds(parentRC);

        this.dom.css("position", "absolute");

        this.dom.css("left", rc.x + "px");
        this.dom.css("top", rc.y + "px");
        this.dom.css("width", rc.width + "px");
        this.dom.css("height", rc.height + "px");
        this.dom.css("overflow", "hidden");
        if( this.pSheet.designMode )  this.dom.css("pointer-events", "none");

        //当单元格需要重绘时，echart并不一定需要重绘，仅当size变化时，才需要重绘
        if (this.echart.lastSize.width != rc.width || this.echart.lastSize.height != rc.height)
        {
            this.echart.lastSize = {width: rc.width, height: rc.height};
            this.echart.resize();
        }


    },

    createDOM: function () {

        var html = `<div><div id='${this.DOMName}' style='width:100%;height:100%;'></div></div>`;

        this.config.html = html;

        this.$uper.createDOM.call(this ,false); //false表示基类中不要触发 brickOnload事件


        this.echart = echarts.init(document.getElementById(`${this.DOMName}`));
        if (this.config.option)
        {
            try
            {
                if (Util.isString(this.config.option)) this.config.option = JSON.parse(this.config.option);

                this.echart.setOption(this.config.option);
            } catch (err)
            {
                console.dir(err);
            }
        }

        this.echart.lastSize = {width: 0, height: 0};

        this.pSheet.Book.EM.fire("brickOnload", [this.pSheet,  this]);

    },

    setVisible: function (v) {
        try
        {
            if (v)
            {
                this.dom.css("display", "");
            } else
            {
                this.dom.css("display", "none");
            }
        } catch (err)
        {
            let that = this;
            setTimeout(function () {
                that.setVisible(v);
            }, 200);
        }
    },

    showOrHideWithWorkSheet: function () {

        if (this.pSheet.visible && this.pSheet == this.pSheet.Book.activeSheet && this.visible)
        {
            this.setVisible(true);
        } else
        {
            this.setVisible(false);
        }

    }


});

export default EchartBrick ;
