/**
 * Created by 三宝爹 on 2018/03/12.
 *
 *
 * 更多实现可参考
 * http://www.htmleaf.com/jQuery/Layout-Interface/201711204837.html
 * http://www.htmleaf.com/jQuery/jquery-tools/201711284851.html
 */


import HTMLBrick from './HTMLBrick.js';
import Tools from '../util/Tools.js';

var DBPageBrick = HTMLBrick.extend({

    properties:
        {
            "currentPageIndex":
                {
                    get: function () {return this.getCurrentPageIndex();},
                    set: function (v) {this.setCurrentPageIndex(v);}//该函数中，还要把currentPageIndex显示在input中
                }
        },

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "dbpage";


        this.onceRetrieveRowCount = config.onceRetrieveRowCount || 100;
        this.m_currentPageIndex = -1;
        this.pageCount = 0;
        this.dbRowCount = 0;
        this.dsn = config.dsn;

        this.config = config;
        this.maxButtonCount = config.maxButtonCount;
        this.fontSize = config.fontSize;
        this.fontColor = config.fontColor;
        this.config.html = ` 
                   <style>
                   .workbook_db_tool_button {border-radius: 50%; min-width:24px; width:24px; height:24px; padding:0px;margin-right:5px;}
                   .workbook_db_tool_noborder { border:0px solid #fff; background-color:transparent;}
                   </style>     
                   
        
                <div  class="   "  id="${this.DOMName}"  
                       unselectable="on" onselectstart="return false;"
                       style=" padding:2px;min-width:24px; padding-right:8px;padding-left:8px;  text-align:${this.config.align};">
                        
                       <span class="group1" style="display:none;"><button 
                       type="button"   class="btn   btn-xs btn-default cb_page1 workbook_db_tool_button" >1</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page2 workbook_db_tool_button" >2</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page3 workbook_db_tool_button" >3</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page4 workbook_db_tool_button" >4</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page5 workbook_db_tool_button" >5</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page6 workbook_db_tool_button" >6</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page7 workbook_db_tool_button" >7</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page8 workbook_db_tool_button" >8</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page9 workbook_db_tool_button" >9</button><button 
                       type="button"   class="btn   btn-xs btn-default cb_page10 workbook_db_tool_button" >10</button>
                       </span><span class="group2">
                        <button type="button"   class="btn   btn-xs btn-default cb_First workbook_db_tool_button" >
                        <i class="fa fa-step-backward"></i></button><button type="button"   
                                class="btn   btn-xs btn-default cb_Prior workbook_db_tool_button" >
                        <i class="fa fa-chevron-left"></i></button><button type="button"   
                                class="btn btn-alt btn-xs btn-default  workbook_db_tool_noborder " ><span style="display:inline-block">
                        <input type="tel"  class="pageIndex btn btn-alt btn-xs " 
                               style="width:50px;height:24px; line-height:24px ; border-radius:12px; border:1px dotted #efefef;"> /
                        <span class="pageCountOfDataSource"></span></button><button type="button"   
                                class="btn   btn-xs btn-default cb_Next workbook_db_tool_button" >
                        <i class="fa fa-chevron-right"></i></button><button type="button"   
                                class="btn   btn-xs btn-default cb_Last workbook_db_tool_button" >
                        <i class="fa fa-step-forward"></i></button></span><span 
                         unselectable="on" onselectstart="return false;" style="padding-left:10px; display:inline-block"  
                               class="countPerPageContainer">每页<input type="tel"   class="countPerPage btn btn-alt btn-default"  
                                value="${this.onceRetrieveRowCount}" 
                                style="width:65px;height:24px; line-height:24px;border-radius: 12px; "
                                 
                                >行</span>
                        </span>
                        <span class="dbRowCountContainer" >&nbsp;&nbsp;共<span class="dbrowcount"></span>行
                </div>
            
            `;


    },

    setParentCell: function (parentCell) {


        this.$uper.setParentCell.call(this, parentCell);
        var that = this;
        var book = this.pSheet.Book;
        //设置每次检索的条数
        var dsc = book.getDataSource(this.dsn);
        if (dsc != null)
        {
            var ds = dsc.dataStore;
            ds.setOnceRetrieveCount(this.getOnceRetrieveRowCount());

            ds.EM.addListener(
                {

                    afterReset: function (action) {
                        //如果是检索引起的reset ,那么不需要重设置页码。因为在检索完成后会设置，并且也不能复位，
                        if (action != 'retrieve') that.reset(-1); // 清零
                    },

                    retrieveEnd: function (rowCount, withLastSelect) {
                        //如果不是分页检索，而是重新检索，那么重置分页信息
                        console.info("retrieveEnd 分页处理");
                        // 当改变每页条数后，也需要重新检索，此时是使用上次检索条件进行检索的，此时却需要重新计算页头码信息
                        if (!withLastSelect || that.onceRetrieveRowCountChanged)
                        {

                            that.onceRetrieveRowCountChanged = false; //关闭标记

                            //在初始化表单后，可能关闭了sheet的paint，导致各个控件还没有因显示而创建
                            //此时如果检索了数据，设置控制状态前，需要确保控件已经创建
                            if (!that.dom) that.createDOM();//确保控件已经创建

                            if (ds.rowCount == 0)
                            {
                                that.currentPageIndex = -1;
                            } else
                            {

                                // 检索完成后，当前页面并不一定是1，因为可能是页面不复位，仅仅刷新检索当前页
                                that.currentPageIndex = Math.floor(ds.absolute / parseInt(that.onceRetrieveRowCount));
                            } //先把页码设置上，再异步计算页数

                            that.reset(-1); //先清零

                            ds.getDBRowCount(function (rc) {
                                    that.reset(rc);
                                }
                            );

                        }
                    }


                });
        } else
        {
            alert(this.dsn + "不是合法的结果集，可能的原因：1 SQL不合法法，2 数据库连接不正常");
        }
    },

    /**
     * 创建DOM对象后，初始化
     */
    createDOM: function () {
        this.$uper.createDOM.call(this);

        let that = this;
        var tName = this.DOMName;

        if (!this.config.countPerPagePermitToChange)
        {
            $('#' + tName + " .countPerPageContainer").css("display", "none");
        }


        $('#' + tName + " .dbRowCountContainer").css("display", this.config.showDBRowCount?"":"none");


        $('#' + tName + " .cb_First").on("click", function () {that.gotoFirstPage();});
        $('#' + tName + " .cb_Prior").on("click", function () {that.gotoPriorPage();});
        $('#' + tName + " .cb_Next").on("click", function () {that.gotoNextPage();});
        $('#' + tName + " .cb_Last").on("click", function () {that.gotoLastPage();});
        $('#' + tName + " .pageIndex").on("change", function () {that.gotoSomePage();});


        $('#' + tName + " .countPerPage").on("keydown", function (e) {
            var pp = $('#' + tName + " .countPerPage");
            var w = (pp.val().length + 1) * 8 + 28;
            pp.css("width", w + 'px');
        });

        $('#' + tName + " .countPerPage").on("change", function (e) {
            var pp = $('#' + tName + " .countPerPage");
            var w = pp.val().length * 8 + 28;

            pp.css("width", w + 'px');
            that.resetCountPerPage();
        });

        for (let i = 1; i <= 10; i++)
        {
            $('#' + tName + " .cb_page" + i).on("click", function () {that.gotoPage(i - 1);});
        }

        var book = this.pSheet.Book;
        //设置每次检索的条数
        var dsc = book.getDataSource(this.dsn);
        if (dsc != null)
        {
            var ds = dsc.dataStore;
            this.reset(ds.rowCount);
        }

        book.EM.fire("brickOnload", [that.pSheet,   that]);
    },

    calcuPageCount: function () {
        this.pageCount = Math.max(0, Math.floor((this.dbRowCount - 1) / this.onceRetrieveRowCount) + 1);
        var pc = this.dbRowCount == -1 ? '<i class="fa fa-spinner fa-spin fa-fw"></i>' : this.pageCount;
        $('#' + this.DOMName + " .pageCountOfDataSource").html(pc);


        var ds = book.getDataSource(this.dsn).dataStore;

        if (ds.rowCount == 0)
        {
            this.currentPageIndex = -1;
        } else
        {

            // 检索完成后，当前页面并不一定是1，因为可能是页面不复位，仅仅刷新检索当前页
            this.currentPageIndex = Math.floor(ds.absolute / parseInt(this.onceRetrieveRowCount));
        }


        this.setButtonState();
    },

    reset: function (dbRowCount) {
        this.dbRowCount = dbRowCount;
        this.calcuPageCount();
        $('#' + this.DOMName + " .dbrowcount" ).text( dbRowCount);

    },


    setButtonState: function () {

        $('#' + this.DOMName + " .dbRowCountContainer").css("display", this.config.showDBRowCount?"":"none");

        if (this.pageCount == 0)
        {
            this.setButtonEnabled("cb_First", false);
            this.setButtonEnabled("cb_Prior", false);
            this.setButtonEnabled("cb_Next", false);
            this.setButtonEnabled("cb_Last", false);
            this.setInputEnabled("pageIndex", false);

            for (var i = 1; i < 10; i++)
            {
                $('#' + this.DOMName + " .cb_page" + i).css("display", "none");
            }

            return;
        }

        this.setInputEnabled("pageIndex", true);

        if (this.currentPageIndex == 0)
        {
            this.setButtonEnabled("cb_First", false);
            this.setButtonEnabled("cb_Prior", false);

        } else
        {
            this.setButtonEnabled("cb_First", true);
            this.setButtonEnabled("cb_Prior", true);
        }

        if (this.currentPageIndex == this.pageCount - 1)
        {

            this.setButtonEnabled("cb_Next", false);
            this.setButtonEnabled("cb_Last", false);
        } else
        {
            this.setButtonEnabled("cb_Next", true);
            this.setButtonEnabled("cb_Last", true);

        }


        if (this.pageCount <= 10)
        {
            $('#' + this.DOMName + " .group1").css("display", "");
            $('#' + this.DOMName + " .group2").css("display", "none");

            for (var i = 1; i <= Math.min(10, this.pageCount); i++)
            {
                $('#' + this.DOMName + " .cb_page" + i).css("display", "");
            }
            for (var i = this.pageCount + 1; i <= 10; i++)
            {
                $('#' + this.DOMName + " .cb_page" + i).css("display", "none");
            }
            //只有一页，就不要显示页码
            if (this.pageCount == 1) $('#' + this.DOMName + " .cb_page1").css("display", "none");

        } else
        {
            $('#' + this.DOMName + " .group1").css("display", "none");
            $('#' + this.DOMName + " .group2").css("display", "");

        }
    },

    setButtonEnabled: function (cb, b) {

        $('#' + this.DOMName + " ." + cb).attr("disabled", !b);


    },


    setInputEnabled: function (input, b) {


        $('#' + this.DOMName + " ." + input).attr("disabled", !b);

    },

    retrieve: function () {
        var dsc = this.pCell.Sheet.Book.getDataSource(this.dsn);
        if (!dsc) return;

        var ds = dsc.dataStore;
        ds.ignoreTopRow(this.currentPageIndex * this.onceRetrieveRowCount);
        ds.setOnceRetrieveCount(this.onceRetrieveRowCount);
        ds.retrieveWithLastSelect();

    },

    gotoPage: function (n) {
        $('#' + this.DOMName + " .pageIndex").val(n + 1);
        this.gotoSomePage();

    },
    gotoSomePage: function () {
        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        var p = parseInt($('#' + this.DOMName + " .pageIndex").val());
        if (isNaN(p)) p = 0;

        this.currentPageIndex = p - 1;
        this.setButtonState();
        this.retrieve();


    },

    resetCountPerPage: function () {

        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        var p = parseInt($('#' + this.DOMName + " .countPerPage").val());
        if (isNaN(p)) p = 100;
        if (p == 0) p = 100;
        this.currentPageIndex = 0;
        this.setOnceRetrieveRowCount(p);
        this.setButtonState();
        this.onceRetrieveRowCountChanged = true; // 需要重新分页
        this.retrieve();
    },

    gotoFirstPage: function () {


        if (this.pageCount == 0) return;

        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        this.currentPageIndex = 0;
        this.setButtonState();
        this.retrieve();

    },

    gotoPriorPage: function () {
        if (this.currentPageIndex == 0) return;

        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        this.currentPageIndex--;

        this.setButtonState();
        this.retrieve();
    },

    gotoNextPage: function () {
        if (this.currentPageIndex + 1 == this.pageCount) return;
        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }
        this.currentPageIndex++;
        this.setButtonState();
        this.retrieve();
    },

    gotoLastPage: function () {
        if (this.currentPageIndex == this.pageCount - 1) return;
        if (!this.pCell.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        this.currentPageIndex = this.pageCount - 1;
        this.setButtonState();
        this.retrieve();

    },


    getOnceRetrieveRowCount: function () {

        return this.onceRetrieveRowCount;
    },


    setOnceRetrieveRowCount: function (rc) {
        this.onceRetrieveRowCount = rc;
        if (this.onceRetrieveRowCount == 0) this.onceRetrieveRowCount = 100;
        this.calcuPageCount();

    },

    setPageCount: function (pc) {
        this.pageCount = pc;

    },

    getPageCount: function () {

        return this.pageCount;
    },


    setCurrentPageIndex: function (v) {
        if (v == this.m_currentPageIndex) return;
        if (v < 0) v = 0;
        //if( v> this.pageCount-1) v=this.pageCount-1;  这个判断不要， 因为异步计算页数时，pageCount ==-1

        this.m_currentPageIndex = v;
        $('#' + this.DOMName + " .pageIndex").val(v + 1);

        for (var i = 0; i < 10; i++)
        {
            $('#' + this.DOMName + " .cb_page" + (i + 1)).addClass('btn-default');
            $('#' + this.DOMName + " .cb_page" + (i + 1)).removeClass('btn-primary');
        }

        if (v < 10 && v >= 0)
        {
            $('#' + this.DOMName + " .cb_page" + (i + 1)).removeClass('btn-default');
            $('#' + this.DOMName + " .cb_page" + (v + 1)).addClass('btn-primary');
        }


    },
    setPageIndex: function (pi, forceRetrieve) {
        if (pi < 0) return;
        if (pi > this.pageCount - 1) return;
        if (this.currentPageIndex == pi && !forceRetrieve) return;

        this.currentPageIndex = pi;

        this.setButtonState();
        this.retrieve();

    },

    getCurrentPageIndex: function () {
        return this.m_currentPageIndex;
    }


});

export default DBPageBrick;
