/**
 * Created by 三宝爹 on 2019/05/12.
 */


import HTMLBrick from './HTMLBrick.js';
import Tools from '../util/Tools.js';

//接管文件上传
import   CKEditorUploadAdapter  from './CKEditorUploadAdapter.js'


var   CKEditorBrick = HTMLBrick.extend({

    properties:
        {
            "value":
                {
                    get: function () {return this.getValue();},
                    set: function (v) {this.setValue(v);}
                }
        },

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "ckeditor";
        this.dsn = config.dsn; //绑定的数据源
        this.dbcol = config.dbcol; //绑定的字段
        this.config = config;

        //2021.06.02补丁
        this.config.needMouseWheel=true; //表示自已需要滚轮操作，不能把滚轮操作传给SheetView去处理

        this.config.html = ` 
                     
                        <div class="centered main-container" >
                          <div class="document-editor">
                            <div class="toolbar-container"></div>
                              <div class="content-container">
                                <div id="editor">
                                </div>
                              </div>
                          </div>
                        </div>                  
                   
                    `;
    },

    setParentCell: function (parentCell) {

        this.$uper.setParentCell.call(this, parentCell);
        var that = this;
        var book = this.pSheet.Book;
        //设置每次检索的条数
        var dsc = book.getDataSource(this.dsn);
        if (dsc != null)
        {
            var ds = dsc.dataStore;

            ds.EM.addListener(
                {

                    retrieveEnd: function (rowCount, withLastSelect) {
                        that.reloadValue();
                    },

                    retrieveOnceMoreEnd: function (retrieveTimes, rowCount) {
                        that.reloadValue();
                    },

                    itemChanged: function (row, col, oldValue, newValue) {
                        that.reloadValue();
                    },

                    afterDeleteRow: function (row) {
                        that.reloadValue();
                    },
                    afterReset: function (action) { that.reloadValue();},

                    refreshRetrieveEnd: function (row) {that.reloadValue();},


                });
        } else
        {
            //alert(this.dsn + "不是合法的结果集，可能的原因：1 SQL不合法法，2 数据库连接不正常");
        }
    },

    /**
     * 创建DOM对象后，初始化
     */
    createDOM: function () {
        this.$uper.createDOM.call(this);
        let that = this;

        this.dom.addClass("ckeditor");

        this.timerHandle = 0;

        //Array.from( editor.ui.componentFactory.names() ); 列出所有的plugin

        DecoupledEditor.create($('.ckeditor #editor')[0], {
            // toolbar: [ 'heading', '|', 'bold', 'italic', 'link' ]
            language: 'zh-cn',
            removePlugins: ['imageUpload', 'mediaEmbed']

        })
            .then(editor => {
                let toolbarContainer = document.querySelector('.ckeditor  .toolbar-container');

                toolbarContainer.prepend(editor.ui.view.toolbar.element);

                that.editor = editor;

                //
                if (!that.canFillback())
                {
                    editor.isReadOnly = true;
                }

                // 这个地方加载了适配器
                editor.plugins.get('FileRepository').createUploadAdapter = (loader)=>{

                    var url = that.config.homeURL || "UploadFile";

                    return new CKEditorUploadAdapter(loader, url ,that.pSheet);
                };

                //内容编辑后，回填操作的处理
                editor.model.document.on('change:data', function () {

                    if (that.timerHandle != 0)
                    {
                        window.clearTimeout(that.timerHandle);
                    }

                    // bind(that)是强制fillback执行时，上下文切换到that中，即 fillback中的this 指向的是自己，不然会指向window
                    that.timerHandle = setTimeout(that.fillback.bind(that), 1000);

                });

                that.pSheet.Book.EM.fire("brickOnload", [that.pSheet,   that]);

            })
            .catch(err => {
                console.error(err.stack);
            });


    },

    onSize: function (rc) {


        console.info(" ckeditor resize :" + rc.toString());

        this.dom.find(' .main-container').css({
            width: rc.width + 'px',
            height: (rc.height - 2) + 'px',
            'max-height': (rc.height - 2) + 'px'
        });
        this.dom.find(' .content-container').css({
            height: (rc.height - 42) + 'px',
            'max-height': (rc.height - 42) + 'px'
        });
    },

    //重新从ds中加载内容
    reloadValue: function () {
        var book = this.pSheet.Book;
        var dsc = book.getDataSource(this.dsn);
        if (dsc == null) return;
        var ds = dsc.dataStore;
        var v = ds.getString(dsc.currentBindRow, this.dbcol);
        if (this.dom == null) this.createDOM(); //确保已经创建
        this.editor.setData(v);

    },


    canFillback: function () {
        //简单粗暴 ，以后再优化
        var url = window.location.href;
        if ( ( url.indexOf("billedit.jsp") > 0 || url.indexOf("billedit?") > 0  )&& url.indexOf("action=view") > 0) return false;
        return true;
    },

    //将内容回填回去
    fillback: function () {
        if (this.editor.isReadOnly) return;
        if (!this.canFillback()) return;

        if (this.timerHandle != 0) window.clearTimeout(this.timerHandle);
        this.timerHandle = 0;

        var data = this.editor.getData();
        console.info(data);

        var dsc = book.getDataSource(this.dsn);
        if (dsc == null) return;
        var ds = dsc.dataStore;
        ds.setValue(dsc.currentBindRow, this.dbcol, data);


    }


});


export default CKEditorBrick;
