/**
 * Created by 三宝爹 on 2017/12/14.
 */


import HTMLBrick from './HTMLBrick.js';


var Button = HTMLBrick.extend({


    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "button";

        this.setConfig(config);

    },

    setConfig: function (config) {
        this.config = config;

        var className = '';

        var surround = false;
        if (config.buttonStyle)
        {


            if (config.buttonStyle == 'default') className = "";
            if (config.buttonStyle == 'alt') className = "btn-alt";
            if (config.buttonStyle == 'options') surround = true;
            if (config.buttonStyle == 'options-alt')
            {
                className = "btn-alt";
                surround = true;
            }
            if (config.buttonStyle == 'link') className = "btn-link";

        }
        if (config.buttonColorStyle) className = className + ' btn-' + config.buttonColorStyle;


        if (config.size)
        {
            var t = ['btn-xs', 'btn-sm', '', 'btn-lg'];
            if (config.size > 0 && config.size <= 4) className = className + ' ' + t[config.size - 1];
        }

        var leftIcon = ''; ;
        var rightIcon = ''  ;
        if (config.leftIcon ) leftIcon = `<i class='fa ${config.leftIcon}'></i>`;
        if (config.rightIcon) rightIcon = `<i class='fa ${config.rightIcon}'></i>`;

        this.config.html = ` 
                <button class="btn ${className}" 
                        id="${this.DOMName}">
                       ${leftIcon}${config.caption}${rightIcon}
                </button>
                `;

        if (surround) this.config.html = '<span class="block-options ">' + this.config.html + '</span>';

        if (this.config.x) this.X = this.config.x;
        if (this.config.y) this.Y = this.config.y;
        if (this.config.width) this.Width = this.config.width;
        if (this.config.Height) this.Height = this.config.height;


        if (this.dom != null)
        {
            this.dom.remove();
            this.dom = null;
            this.invalidate();
        }


    },


    createDOM: function () {
        this.$uper.createDOM.call(this);

        //编辑控件加到父容器中


        let book = this.pSheet.Book;
        let that = this;
        $('#' + this.DOMName).click(
            function () {

                if (!book.initOK)
                {
                    toastr.info("初始化中，请稍等...");
                    return
                }

                if (that.pSheet.designMode)
                {
                    that.pSheet.setSelection(that.pCell.rowIndex, that.pCell.columnIndex, that.pCell.rowIndex, that.pCell.columnIndex);
                }
                book.EM.fire("buttonOnClick", [that.pSheet, that.pCell, that]);

            }
        );

        if (this.config.visible != undefined)
        {
            this.visible = this.config.visible;
        }
        if (this.config.enable != undefined)
        {
            this.enable = this.config.enable;
        }

        book.EM.fire("brickOnload", [that.pSheet,   that]);

    },

    setEnable: function (v) {
        this.Enable = v;


        if (this.dom)
        {
            $(this.dom).attr("disabled", v?null:'disabled'); //可能自已就是button也可能是子元素是button
            $(this.dom).find('.btn').attr("disabled", v?null:'disabled');
        }

    }

});

export default Button ;