/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';
import Rectangle from '../gdi/Rectangle.js';
import Tools from '../util/Tools.js';
import WorkBookView from '../core/WorkBookView.js';
import Point from "../gdi/Point.js" ;

var BasicBrick = Class.extend({

    properties:
        {

            /**
             * @api {name} 只读属性 [属性]name
             * @apiName  name
             * @apiDescription 控件的名称，所有控件都有本属性
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){String} - 控制名称
             * @apiExample {js}(示例：)
             * //示例
             *
             *  book.sheet0.cells('a1').getBricks()[0].name
             */
            "name":
                {
                    get: function () {return this.Name;}
                }
            ,

            /**
             * @api {visible} 可读可写属性 [属性]visible
             * @apiName  visible
             * @apiDescription 控件是否可见，所有控件都有本属性
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){boolean} - 控件是否可见
             * @apiExample {js}(示例：)
             * //示例
             *
             *  alert( book.sheet0.getBrick('cb1').visible );
             *  book.sheet0.getBrick('cb1').visible =false;
             */
            "visible":
                {
                    get: function () { return this.Visible;},
                    set: function (val) { this.setVisible(val);}
                },

            /**
             * @api {enable} 可读可写属性 [属性]enable
             * @apiName  enable
             * @apiDescription 控件是否可用，所有控件都有本属性
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){boolean} - 控件是否可用
             * @apiExample {js}(示例：)
             * //示例
             *
             *  alert( book.sheet0.getBrick('cb1').enable );
             *  book.sheet0.getBrick('cb1').enable =false;
             */

            "enable":
                {
                    get: function () { return this.Enable;},
                    set: function (val) { this.setEnable(val);}

                },

            /**
             * @api {caption} 可读可写属性 [属性]caption
             * @apiName  caption
             * @apiDescription 控件上的文字，本属性通常用于修改按钮的文字,可以是任意的文字或HTML片段
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){String} - 控件上的文字
             * @apiExample {js}(示例：)
             * //示例
             *
             *  alert( book.sheet0.getBrick('cb1').caption );
             *  book.sheet0.getBrick('cb1').caption ="Copy";
             *  book.sheet0.getBrick('cb2').caption ="<i class='fa fa-copy'></i> Copy";
             *  book.sheet0.getBrick('cb3').caption ="<span style='color:red'>Copy</span>";
             *
             */
            "caption":
                {
                    get: function () {return this.getCaption()},
                    set: function (val) { this.setCaption(val); }
                },
            /**
             * @api {DOM} 只读属性 [属性]DOM
             * @apiName  DOM
             * @apiDescription 控件对应的DOM做jquery包装后的对象
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){Object} - jquery包装后的DOM对象
             * @apiExample {js}(示例：)
             * //示例
             *
             *   book.sheet0.getBrick('cb1').DOM.css('background-color','red');
             *
             *   book.sheet0.getBrick('cb1').DOM.trigger('click'); // 模拟点击操作
             */
            "DOM":
                {
                    get: function () { return $(this.dom)}
                }


            /**
             * @api {echart} 只读属性 [属性]echart
             * @apiName  echart
             * @apiDescription 得到控件中的echart对象 .详情情参看  Echart 官方文档
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){Echart} - 得到控件中的echart对象
             * @apiExample {js}(示例：)
             * //示例
             *
             *  var echart= book.sheet0.getBrick('cb1').echart ;
             *
             *
             */

            /**
             * @api {editor} 只读属性 [属性] editor
             * @apiName editor
             * @apiDescription 得到控件中的富文本编辑对象 .详情情参看  CKEditor5 官方文档
             * @apiGroup Brick
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){CKEditor} - 得到控件中的富文本编辑对象
             * @apiExample {js}(示例：)
             * //示例
             *
             *  var editor= book.sheet0.getBrick('ckeditor1').editor ;
             *
             *  editor.isReadOnly= true; //设置成只读的,只允许查看，不允许编辑，但仍可以用setData设置内容
             *
             *   editor.setData("<p>aaaaa</p>"); //设置编辑器中的内容
             *
             *   var t= editor.getData(); // 得到编辑器中的内容
             *
             *
             */


            /**
             * @api {zTreeObj} 只读属性 [属性] zTreeObj
             * @apiName zTreeObj
             * @apiDescription 得到树控件中的zTree对象 ,zTree的详细说明
             * 请参看<a href='http://www.treejs.cn/v3/api.php' target='_blank'>zTree</a>
             * @apiGroup Tree
             * @apiVersion 1.0.0
             * @apiSuccess (属性类型){zTree} - 得到控件中的zTree对象
             * @apiExample {js}(示例：)
             * //示例
             *
             *  var tree= book.sheet0.getBrick('tree1').zTreeObj;
             *
             *  var nodes= tree.getSelectedNodes();
             *
             *   if( nodes.length>0)  alert (  JSON.stringify(  nodes[0]));
             *
             *
             *
             *
             */

            /**
             * @api {treeRefresh} 函数   treeRefresh
             *
             * @apiDescription treeRefresh()
             * <br>树控件加截或重新加载数据 。<br>
             *
             * @apiName  treeRefresh
             * @apiGroup Tree
             * @apiVersion 1.0.0
             *
             *
             * @apiSuccess (返回值){void} - 无返回值
             *
             * @apiExample   {js}示例：
             *
             *  var tree= book.sheet0.getBrick('tree1');
             *  tree.treeRefresh(); //加截或重新加载树的数据
             *
             */




            /**
             * @api {treeExpand} 函数   treeExpand
             *
             * @apiDescription treeExpand()
             * <br>树控件展开整个树 。<br>
             *
             * @apiName  treeExpand
             * @apiGroup Tree
             * @apiVersion 1.0.0
             *
             *
             * @apiSuccess (返回值){void} - 无返回值
             *
             * @apiExample   {js}示例：
             *
             *  var tree= book.sheet0.getBrick('tree1');
             *  tree.treeExpand(); //展开树
             *
             */

            /**
             * @api {treeCollapse} 函数   treeCollapse
             *
             * @apiDescription treeCollapse()
             * <br>树控件收拢整个树 。<br>
             *
             * @apiName  treeCollapse
             * @apiGroup Tree
             * @apiVersion 1.0.0
             *
             *
             * @apiSuccess (返回值){void} - 无返回值
             *
             * @apiExample   {js}示例：
             *
             *  var tree= book.sheet0.getBrick('tree1');
             *  tree.treeCollapse(); //收拢树
             *
             */


        },


    constructor: function (name, config, x, y, width, height,rowspan, colspan) {

        this.init(name, config, x, y, width, height,rowspan,colspan);

    },

    init: function (name, config, x, y, width, height,rowspan,colspan) {
        this.Name = name;
        if (config.DOMName || '' == '') config.DOMName = this.Name + '-' + Tools.newGUID();
        this.DOMName = config.DOMName;
        this.config = config || {};
        this.X = x;
        this.Y = y;
        this.Width = width;
        this.Height = height;
        this.rowspan= rowspan ||0;
        this.colspan= colspan ||0;
        this.pCell = null;
        this.pSheet = null;


        this.focused = false;
        this.Visible = true;
        this.Enable = true;


        this.dom = null;

    },

    paint: function (/*boolean */isPrint  /*int*/, /*Graphics2D*/ g, /*Rectangle*/ parentRC) {

        if (!this.Visible) return;
    },


    /**
     *
     * @param pRect
     * @returns {Rectangle}
     */
    getBounds: function (/*Rectangle*/ pRect) {
        var /*int*/ t = 0;
        var /*Rectangle*/ tc = new Rectangle();


        var /*int*/ left = pRect.x;
        var /*int*/ right = pRect.x + pRect.width;
        var /*int*/ top = pRect.y;
        var /*int*/ bottom = pRect.y + pRect.height;



        var /*int*/ viewWidth = pRect.width;
        var /*int*/ viewHeight = pRect.height;

        var /*WorkSheetView*/ view = this.pSheet.View;

        if (view != null)
        {

            var /*Rectangle*/ viewRC = view.getBounds();
            viewWidth = viewRC.width;
            viewHeight = viewRC.height;
        }

        //console.info( "rowspan:"+ this.rowspan+"  colspan:"+ this.colspan);

        //2021.04 增加对 rowspan, colspan的支持
        if( this.rowspan>0 )
        {
            let  endRow =  this.pCell.rowIndex+ this.rowspan ;

            if( endRow > this.pSheet.rowCount-1)
            {
                bottom=  viewHeight;
            }else {
                bottom=  this.pSheet.CPM.getColumnHeadHeight() + this.pSheet.RPM.getRowY(endRow);
            }

        }

        if( this.colspan>0)
        {

            let  endCol=   this.pCell.columnIndex + this.colspan ;


            if( endCol> this.pSheet.columnCount-1)
            {
                right = viewHeight;
            }else {
                right=  this.pSheet.RPM.getRowHeadWidth() + this.pSheet.CPM.getColumnX(endCol);
            }

        }



        t = this.X;
        if (t >= 0)
        {
            tc.x = Math.min(left + t, right);
        }
        else
        {
            tc.x = Math.max(left, Math.max(right + t, 0));
        }

        t = this.Y;
        if (t >= 0)
        {
            tc.y = Math.min(top + t, bottom);
        }
        else
        {
            tc.y = Math.max(top, Math.max(bottom + t, 0));
        }

        t = this.Width;
        if (t == 0) tc.width = right - tc.x;
        if (t > 0) tc.width = t;
        if (t < 0) tc.width = Math.max(0, right + t - tc.x);
        //下面一句，做什么用，忘记了
        if (t <= -10000) tc.width = Math.max(tc.x, Math.max(viewWidth + (t + 10000), 0)) - tc.x;


        t = this.Height;
        if (t == 0) tc.height = bottom - tc.y;
        if (t > 0) tc.height = t;
        if (t < 0) tc.height = Math.max(0, bottom + t - tc.y);
        //下面一句，做什么用，忘记了
        if (t <= -10000) tc.height = Math.max(tc.y, Math.max(viewHeight + (t + 10000), 0)) - tc.y;

        if (tc.height < 0) tc.height = 0;
        if (tc.width < 0) tc.width = 0;
        return tc;
    },

    /**
     * 强制重绘
     */


    invalidate: function () {
        this.pCell.repaint();
    },


    setParentCell: function (parentCell) {
        this.pCell = parentCell;
        this.pSheet = this.pCell.workSheet;

    },


    setBounds: function (/*int*/ x, /*int*/ y, /*int*/ w, /*int*/ h) {

        this.X = x;
        this.Y = y;
        this.Height = h;
        this.Width = w;


    },


    /**
     * 判断自已是不是完全超出了显示区域
     */
    outofScreen: function () {

        var rc = this.pSheet.View.getShowRectangleOfCell(false, this.pCell.rowIndex, this.pCell.columnIndex);
        rc = this.getBounds(rc);

        var x = this.pSheet.RPM.getRowHeadWidth();
        var y = this.pSheet.CPM.getColumnHeadHeight();

        //左上角超出了可视区域
        if (rc.x + rc.width < x) return true;
        if (rc.y + rc.height < y) return true;

        if (this.pCell.columnIndex >= this.pSheet.CPM.getFixedColumnCount())
        {
            var fcw = this.pSheet.CPM.getFixedColumnWidth();
            if (fcw > 0)  //当有固定列宽时，那么只要x小于固定列宽，就隐藏，否则控件就会部分重叠到固定列上
            {
                if (rc.x < fcw) return true;
            }
        }


        if (this.pCell.rowIndex >= this.pSheet.RPM.getFixedRowCount())
        {
            var frh = this.pSheet.RPM.getFixedRowHeight();
            //当有固定行高时，那么只要y小于固定行高，就隐藏，否则控件就会部分重叠到固定行上
            if (frh > 0)
            {
                if (rc.y < frh) return true;
            }
        }


        var /*Rectangle*/ viewRC = this.pSheet.View.getBounds();
        //右下角（去掉卷滚条的尺寸
        var rightBottom = new Point(viewRC.width - WorkBookView.scrollBarSize, viewRC.height - WorkBookView.scrollBarSize);

        if (rc.x > rightBottom.x) return true;


        if (rc.y > rightBottom.y) return true;


        return false;

    },

    //是否包含点
    contains: function (/*Point*/ p) {

        var rc = this.pSheet.View.getShowRectangleOfCell(false, this.pCell.rowIndex, this.pCell.columnIndex);
        rc = this.getBounds(rc);
        return rc.contains(p);
    },


    changed: function () {
        this.invalidate();
    },

    bind: function () {

    },

    unBind: function () {
        if (this.domObj) this.domObj.remove();
    },

    setVisible: function (v) {
        if (this.Visible == v) return;
        this.Visible = v;
        this.pCell.repaint();
    },

    /**
     * workbook initedok to trigger this event
     */
    workBookInitOK: function () {

    },


    setEnable: function (v) {
        this.Enable=v;
    },

    setEnabled:function(v)  //兼容
    {
      this.setEnable(v);
    },

    showOrHideWithWorkSheet: function () {

    },

    keyPressed: function (pView, e) {

    },

    keyReleased: function (pView, e) {

    },

    OnLButtonClick: function (pView, e) {

    },

    OnLButtonDblClk: function (pView, e) {

    },

    // 必须被子类调用
    OnLButtonDown: function (pView, e) {

    },

    // 必须被子类调用
    OnLButtonUp: function (pView, e) {


    },

    OnMouseDrag: function (pView, e) {

    },

    OnMouseEntered: function (pView, e) {

    },

    OnMouseExited: function (pView, e) {

    },

    OnMouseMove: function (pView, e) {

    },

    OnRButtonDown: function (pView, e) {

    },

    setCaption:function(val)
    {
        $(this.dom).html(val);
    }
    ,
    getCaption()
    {
        return $(this.dom).html().trim();
    }


});

export default BasicBrick ;