
/**
 * 工作流受理历史
 */
function work_history()
{
	var url = "h5_work_process_history.jsp?workid=" + form.currentWorkId;
	var height = "500px";
	var width ="100%";

	var p = {
		theme : 'light',
		lazyOpen : true,
		closeIcon : true,
		closeIconClass : 'fa fa-close',
		backgroundDismiss : true,
		draggable : true,
		animation : 'zoom',
		closeAnimation : 'scale',
		title : '工作受理情况',
		content : '<iframe  id="dialogFrame"  name="dialogFrame" frameborder=1  ' + ' style="width:100%; height:'
				+ height + ' ; border:0px solid lightgray; opacity:1;  " ' + ' src="' + url + '"></iframe>',

		onOpenBefore : function()
		{
			$('.jconfirm-title').css('font-size', '16px'); // 
			$('.jconfirm-cell').css('vertical-align', 'bottom'); // 容器靠底边
		 
			$('.jconfirm-holder').css('padding-bottom', "0");

		},
		onOpen : function()
		{

		}

	};

	if ((width + '').indexOf("%") > 0)
	{
		p.boxWidth = width;
		p.useBootstrap = false;
	}
	else if (width <= 12)
	{
		p.columnClass = 'col-md-' + width;
	}
	else
	{
		p.boxWidth = width + "px";
		p.useBootstrap = false;
	}

	var dlg = $.dialog(p);

	dlg.open();

}


var g_currentStepConfig=null; 
/**
 * 工作提交
 */
function work_submit()
{
	 var workid = form.currentWorkId;
	 if(workid<=0)
		 {
		 toastr.info("请先保存");
		 return;
		 }
	 
	  //为空的检测
	    
     var  dbRight= $TemplateConfig.dbRight;
     for( var dsname in dbRight)
     {
     	var oneDS= dbRight[dsname];
     	var dsc= book.getDataSource( dsname);
     	var ds= dsc.dataStore;
     	
     	for( var col in  oneDS)
     	{
     		var oneCol = oneDS[col];
     		var checknull= oneCol.checknull;
     		if( checknull==undefined) continue;
     		if(!checknull) continue;
     	 

			for (var i = 0; i < ds.getRowCount(); i++)
			{
				if( ds.isTheRowHoldNoDataExceptSuchColumns(i) ) continue; 
				if (ds.getString(i, col)  == '')
				 {
					 var label=  ds.getColumnProperty(col).getColumnLabel();
					 var errorInfo=("必须录入【"+label+"】");
					 var cells= dsc.getAllCellsWhichBindTheCol(col);
					 if( cells.length>0)
						 {
						   var cell= cells[0];
						   var sheet= cell.Sheet;
						   book.setActiveSheet( sheet.index);
						   cells[0].grumble(errorInfo, 100, 2000);//气泡提示
						 }
					 return;
				 }
			}
     	}
     }

     form.save(false);
     
     if ( form.isSaveNeeded()) {
          return "";
     }
	 
		axios.post('WorkFlow?action=getWorkNextStepAndUser', {workid:workid})
		.then(res=>{
		    console.dir( res);     
		    
		    var d=res.data.getWorkNextStepAndUser;
		    g_currentStepConfig = d ;
		    
		    if( d.items.length==0)
		    {
				toastr.info("没有可提交的操作");
				return;
		    }
		
		    for( var i= d.items.length-1; i>=0;i--)
		    	{
		    	var oneStep=  d.items[i];
		    	 
		    	console.info( oneStep.name+"路由检测");
		    	if(  (oneStep.script ||'') !='')
		    	{
		    		console.info("执行条件定义为：" +oneStep.script   );
					var v= book.activeSheet.evaluate( oneStep.script);
					console.info("解析结果是："+v );
					
					if( v==null)
					{
						console.info("条件结果为  null,可能是表达式有问题，允许此路由， 避免无路可走");
						continue;
					}
					
					if( typeof(v)=='object' && v.description)
						{
						console.info( "可能是公式有错："+v.description+"允许此路由， 避免无路可走");
						continue; 
						}
					
					
					if( v !=true  &&   v!=1)
					{
						d.items.removeAt(i); 
						console.info("本路由被取消");
						continue;
					}
					
		    	}
		    	
		    	console.info( oneStep.name+"选中检测");
		    	if(  (oneStep.script2 ||'') !='')
		    	{
		    		console.info("选中条件定义为：" +oneStep.script2   );
					var v= book.activeSheet.evaluate( oneStep.script2);
					console.info("解析结果是："+v );
					if( v ==true ||  v==1)
					{
						oneStep.selected=true; 
						console.info("默认选中");
					}
		    	}
		    	
		    	console.info( oneStep.name+"执行人公式定义检测 ");
		    	if(  (oneStep.executoridscript ||'') !='')
		    	{
		    		console.info("执行人公式定义为：" +oneStep.executoridscript   );
					var v= book.activeSheet.evaluate( oneStep.executoridscript);
					console.info("解析结果是："+v );
					if( v ||''  != ''  )
					{
						var ret = $ajax.rpc("script", "debug.ScriptAgent", "userFunction",
						        {
				            method: 'getUserList',
				            ids: v
				        });
						
						if( ret.success)
						{
							var users= ret.data;
							for(var ui=0;ui< users.length;ui++)
							{
								var one= users[ui];
								var found=false;
								for( var m=0;m< oneStep.users.length;m++)
								{
									if( oneStep.users[m].id == one.id )
										{
										found=true;
										break;
										}
								}
								if(!found)  oneStep.users.push(one); // 追加人员
							}
						}else
							{
							$.alert( ret.message);
							}
					}
		    	}
		    	
		    	
		    	
		    }
			
		  
		    
		    
		    
		    show_work_submit_panel(d);
		    
		});
}


var g_passToNextDialog=null; 

function show_work_submit_panel(data)
{
	 
	var height = (150+  Math.min( 2 , data.items.length )*(110+6) );
 
	var width = "860";
	
	if( isMobile() ) width="100%";
	var p = {
		theme : 'light',
		lazyOpen : true,
		closeIcon : true,
		closeIconClass : 'fa fa-close',
		backgroundDismiss : true,
		draggable : true,
		animation : 'zoom',
		closeAnimation : 'scale',
		title : "正在进行："+data.nodename,
		content : 
		`<div  id="submitContainer" style="height:${height}px;  left:0;width:100%; overflow:auto;" >
	
	
	
	    </div>
						 
					  `,

		onOpenBefore : function()
		{
			
			
			if( isMobile())
			{
				$('.jconfirm-title').css('font-size', '16px'); // 
				$('.jconfirm-cell').css('vertical-align', 'bottom'); // 容器靠底边
			
				$('.jconfirm-holder').css('padding-bottom', "0");
			}

		},
		onOpen : function()
		{

		},
		  onContentReady: function () {

			  console.dir( data);
			   var html =TrimPath.processDOMTemplate("template_h5_work_passtonext",data);
	 
			   $("#submitContainer").append( html);
              
          },

          buttons: {
              
        	  ok: {
                  text: "&nbsp;&nbsp;提&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;交&nbsp;&nbsp;",
                  btnClass: 'btn-green',
                  action: function () {
                	  
                	  work_submit_go();
                	  return false; 
                	   
                  }
              },
        		  
        	  cancel:
                  {
                      text: "&nbsp;&nbsp;取&nbsp;&nbsp;消&nbsp;&nbsp;",
                   
                      action: function () {
                      }
                  }
          }

	};
	
	if( data.nodeConfig.multisubmitpermit=='0') // 单路提交，不需要提交按钮
	{
		var multi =false;
		for( var i=0;i<data.items.length;i++)
		{
			var oneNode= data.items[i];
			if( oneNode.multiprocess ==1 ||  oneNode.multisession ==1 ) 
			{
				multi=true;
				break; 
			}
		}
		// 在单路模式下，如果所有节点，都是单选一个人，那么，不需要递交按钮 ，点人就递交了
		 if(!multi) delete p.buttons['ok'];
	}

	if ((width + '').indexOf("%") > 0)
	{
		p.boxWidth = width;
		p.useBootstrap = false;
	}
	else if (width <= 12)
	{
		p.columnClass = 'col-md-' + width;
	}
	else
	{
		p.boxWidth = width + "px";
		p.useBootstrap = false;
	}

	g_passToNextDialog = $.confirm(p);

	g_passToNextDialog.open();

}


/**
 * 
 * @param processid
 * @param toguid
 * @param touserid
 * @param multiSubmitPermit
 *            可以多路递交
 * @param multiprocess
 *            toguid这一步骤是会签，可以选多人，但是受理好之后，只能都提交给同一个候选人做同一个件事
 * @param multisession
 *            toguid这一步骤是多会话，可以选多人，多个人可以随意再递交给任何人
 * @returns
 */
function selectOrNot(processid, toguid , touserid , multiSubmitPermit , multiprocess , multisession )
{
	var div= $('#'+toguid+"-"+ touserid)  ;
	var selected= div.hasClass('selected');
	
	if(multiSubmitPermit) // 多路模式
	{
		
		
	    if(  multiprocess || multisession) // 人员多选模式
	    {
		
	    }else  // 是人员单选模板
	    {
	    	// 取消本步的所有其它选中的人
	    	var divs= $('.'+toguid);
	    	divs.removeClass('selected');
			divs.addClass('unselected');
	    	
		 
	    }
	    
		
		if( selected)
		{
			div.removeClass('selected');
			div.addClass('unselected');
			
		}else
		{
			div.addClass('selected');
			div.removeClass('unselected');
			
		}
		
	    
	}else  //
	{
		   if(  multiprocess || multisession) // 单路模式下，如果当前要递交的节点，它是人员多选模式
		    {
		 
	
			   	//把不是本步骤的其它步骤选中的取消选中
			   // 比如 点击B步骤的某个，进行 提交，然后放弃了提交，此时B步骤中有一个选中的人，然后再选择A步骤，且A步骤是允许选多人的
			   // 此时就需要清除B步骤中选中的人
			   
			    var all=  $('.passtouser');
		    	for( var i=0;i<all.length; i++)
		    	{
		    		var one= $(all[i]);
		    		if( one.hasClass(toguid) ) continue;
		    		one.removeClass('selected');
		    		one.addClass('unselected');
		    	}
				
				
				if( selected)
				{
					div.removeClass('selected');
					div.addClass('unselected');
					
				}else
				{
					div.addClass('selected');
					div.removeClass('unselected');
					
				}
				
		    }else  // 单路模式下，节点是单人模式，那么直接递交了
		   	{
		    	var all=  $('.passtouser');
		    	all.removeClass('selected');
				all.addClass('unselected');
				
				
				// 单选中
				div.addClass('selected');
				div.removeClass('unselected');
				
				work_submit_go();
		 
		    	 
		   	}
	}
	
}

var  selectUserDlg=null; 
// 点击+ 弹出选择人员的面板
function selectUserForNode(processid, toguid ,  multiSubmitPermit , multiprocess , multisession )
{
	
 
	 	
	selectUserDlg=$.dialog({
		lazyOpen : true,
	    title: '选择人员',
	    useBootstrap:false,
	    boxWidth: isMobile()?"100%":"600px",
	    content: `
	    <form action="" class="formName">
	    <div class="form-group">
	    <input type="text"  id="userSearchInput" placeholder="输入登录名或姓名"  onkeyup="searchUser('${toguid}' , ${multiSubmitPermit} , ${multiprocess} , ${multisession})" class="name form-control" required />
	    <div id=userSearchResult style="width:100%; height:500px; border:1px solid #eefef;  overflow:auto;">
	    
	    </div>
	    </div>
	    </form>
	    
	    `
	        ,
	    	onOpenBefore : function()
			{
	    		if( isMobile())
	    		{
	    			$('.jconfirm-title').css('font-size', '16px'); // 
	    			$('.jconfirm-cell').css('vertical-align', 'bottom'); // 容器靠底边
			 		$('.jconfirm-holder').css('padding-bottom', "0");
	    		}
			}
			
	  	});
	
	selectUserDlg.open();
	
}
// 当输入内容后，检索人员，并刷新人员清单
function searchUser( toguid ,  multiSubmitPermit , multiprocess , multisession)
{
	var key= $('#userSearchInput').val();
	if( key=='') return ; 
	
	
	$ajax.rpc("script", "debug.ScriptAgent", "userFunction",
		        {
            method: 'searchUser',
            key: key
        }, function(ret)
        {
        	ret= JSON.parse(ret);
        	
        	ret.toguid=toguid; 
        	ret.multiSubmitPermit=multiSubmitPermit;
        	ret.multiprocess =multiprocess ;
        	ret.multisession =multisession;
        	
        	var html =TrimPath.processDOMTemplate("template_h5_work_passtonext_selectuser",ret);        		 
			$("#userSearchResult").html( html);
        	
        });
	
}

// 选中了一个人，把这个人员信息插入到候选人列表中
function  selectUserOnOK( toguid, userid, showname , user_image , multiSubmitPermit , multiprocess , multisession)
{
	if(  $(`#${toguid}-${userid}`).length>0)
		{
		   toastr.info( showname+"已在人员列表中");
		   return; 
		}
	var data={item:{toguid:toguid ,  multiprocess:multiprocess , multisession:multisession},
					user:{ id:userid, showname:showname , user_image:user_image},
					processid: g_currentStepConfig.processid,
					nodeConfig: g_currentStepConfig.nodeConfig
	}
	
	
	var div= $(`.${toguid}_selectUser`);
	var html=  TrimPath.processDOMTemplate("template_h5_work_passtonext_appenduser",data);       
	
	// 在选择人员的按钮前面插入刚才选中的人员
	div.before( html); 
	selectUserDlg.close();
	
	// 然后模拟点击了这个人
	selectOrNot(data.processid, toguid , userid ,multiSubmitPermit ,multiprocess , multisession );
}


// 提交
function work_submit_go( )
{
	var config= getPassConfig();
	var comment= getComment();
	if( config==null ) return false; 
	
	work_passTo(  g_currentStepConfig.processid,  g_currentStepConfig.nodeConfig.guid , config, comment); 
}


function  work_passTo( processid, processNodeGuid, config , comment)
{
	
	var passTo=config.passTo; 
	
	//事件的串接
	var  beforeSubmitWork=  form.handleEvent('beforeSubmitWork', null, [ processNodeGuid , JSON.stringify( passTo) ], true);
	if( beforeSubmitWork==null) beforeSubmitWork=true;
	if(! beforeSubmitWork) return ;
		
	
	$confirm("提示","确信要提交吗?" , function() 
	{
   
		
		if( g_passToNextDialog!=null) 
		{
			g_passToNextDialog.close();
			g_passToNextDialog =null; 
		}
		
		let  commentFillback= window.commentFillback; //参看 loadTemplate.js 中的处理
		if( commentFillback) commentFillback( comment);
		form.save(false); //再强制保存 一下
		
		axios.post('WorkFlow?action=workPassToNext2', 
				{processid:  processid,
				passTo:config.param, 
				comment:comment
				
				})
		.then(res=>{
		    console.dir( res);     
		    
		    if( res.data.success)
		    {
		    	
		    	
		    	var d=res.data.workPassToNext2;
		    
		    	form.loadBill (  currentGUID()); // 重新加载数据，权限控制等
		    
		    	
		    }else
		    {
		    	toastr.error( res.data.message);
		    }
		    
		});
	});
	
	 
}

function getComment()
{
	if(  $('#content_ok')[0].checked) return '同意';
	if(  $('#content_cancel')[0].checked) return '不同意';
	if(  $('#content_other')[0].checked) 
	{
		var t=  $('#content').val();
		if( t=='')  t='同意';
		return t; 
	}
	
}

function  getPassConfig()
{
	var all=  $('.passtouser.selected');
	var ret={};
	var passTo=[ ];
	
	if( all.length==0)
	{
		toastr.error('请选择提交给谁');
		return null; 
	}
	for( var i=0;i< all.length;i++)
	{
		var one= $(all[i]);
		var toguid=  one.attr('data-toguid');
		var touserid= one.attr('data-touserid');
		
		if(! ret[toguid]) ret[toguid] =[];
		
		ret[toguid].push( touserid); 
	}
	
	var t=[];
	for( var p in ret)
	{
		 var one= {};
		 one.nodeguid= p;
		 one.code= work_nodeguid2code( p);
		 one.passto= ret[p];
		 passTo.push( one); 
		 
		t.push( p+',' + ret[p].join(','));
	}
	
	t = t.join(' '); 
	console.info(t);
	return { passTo: passTo, param:t} ; 
}

function work_nodeguid2code( guid)
{
	for( var i=0;i< g_currentStepConfig.items.length; i++)
	{
		var one= g_currentStepConfig.items[i];
		if( one.toguid==guid) return one.code ||''; 
	}	
	return '';  
	
}

/**
 * 退回
 */
function work_withdraw()
{
	axios.post('WorkFlow?action=getWorkUntreadList', 
			{
				workid:currentWorkId()
			})
	.then(res=>{
	    console.dir( res);     
	    
	    if( res.data.success)
	    {
	    	 
	    	var d=res.data.getWorkUntreadList;
	    	showWithDrawPanel( d); 
	    	
	    }else
	    {
	    	toastr.error( res.data.message);
	    }
	    
	});
	
}

function showWithDrawPanel(data)
{
	
	if( data.items.length==0)
		{
		toastr.info("当前您没有可退回的操作。");
		return ;
		}
	
	 
	var width = "600";

	if( isMobile() ) width="100%";

	var p = {
		theme : 'light',
		lazyOpen : true,
		closeIcon : true,
		closeIconClass : 'fa fa-close',
 	    useBootstrap:false,
	    boxWidth: isMobile()?"100%":"500px",
		backgroundDismiss : true,
		draggable : true,
		animation : 'zoom',
		closeAnimation : 'scale',
		title : "退回" ,
		content : 
		`
		<form action="" class="formName">
	    <div class="form-group">
	    <label>输入退回原因：</label>
	    <input type="text" id="withdrawReason" placeholder="退回原因" class="name form-control" required />
	    </div>
	    </form>
						 
		  `,

		onOpenBefore : function()
		{
			if( isMobile())
			{
				$('.jconfirm-title').css('font-size', '16px'); // 
				$('.jconfirm-cell').css('vertical-align', 'bottom'); // 容器靠底边			
				$('.jconfirm-holder').css('padding-bottom', "0");
			}

		} 
	};
 

    var buttons={};
    
    for( var i=0;i<data.items.length;i++)
    {
    	var oneStep= data.items[i];
    	buttons['button'+i]={
    		text:"退给【"+oneStep.username+"】做【"+oneStep.nodename+"】" ,
    		btnClass:'btn-green btn100',
    		action:function()
    		{
    			return  work_withdraw_go(oneStep.passid);
    		}
    	};
    }
       
	p.buttons=buttons;
	
	 var dlg = $.confirm(p);

	dlg.open();
	
	

}


function work_withdraw_go( passid)
{
	var reason= $('#withdrawReason').val();
	if( reason=='')
	{
		toastr.info("必须输入退回原因");
		$('#withdrawReason')[0].focus();
		return false;
	}
	
	
	axios.post('WorkFlow?action=workUntreadTo', 
			{
			passid: passid ,
			reason:reason
			})
	.then(res=>{
	    console.dir( res);     
	    
	    if( res.data.success)
	    {
	    	 form.loadBill( currentGUID()); //刷新加载
	    	 	    	
	    }else
	    {
	    	toastr.error( res.data.message);
	    }
	    
	});
	
	return true;
	
	
}


function work_freeStep()
{
	axios.post('WorkFlow?action=getFreeSubmitList', 
			{
		  'workid'          :   currentWorkId() 
			})
	.then(res=>{
	    console.dir( res);     
	    
	    if( res.data.success)
	    {
	    	showFreeStepPanel(res.data.getFreeSubmitList);
	    	 	    	
	    }else
	    {
	    	toastr.error( res.data.message);
	    }
	    
	});
	 
	  
}


 
function showFreeStepPanel(data)
{
	
	if( data.data.length==0)
		{
		toastr.info("当前您没有可自由提交的操作。");
		return ;
		}
	
	 
	var width = "600";

	if( isMobile() ) width="100%";

	var p = {
		theme : 'light',
		lazyOpen : true,
		closeIcon : true,
		closeIconClass : 'fa fa-close',
 	    useBootstrap:false,
	    boxWidth: isMobile()?"100%":"500px",
		backgroundDismiss : true,
		draggable : true,
		animation : 'zoom',
		closeAnimation : 'scale',
		title : "自由流转" ,
		content : 
		`
		<form action="" class="formName">
	    <div class="form-group">
	    <label>输入原因"：</label>
	    <input type="text" id="freeStepReason" placeholder="原因" class="name form-control" required />
	    </div>
	    </form>
						 
		  `,

		onOpenBefore : function()
		{
			if( isMobile())
			{
				$('.jconfirm-title').css('font-size', '16px'); // 
				$('.jconfirm-cell').css('vertical-align', 'bottom'); // 容器靠底边			
				$('.jconfirm-holder').css('padding-bottom', "0");
			}

		} 
	};
 

    var buttons={};
    
    for( var i=0;i<data.data.length;i++)
    {
    	var oneStep= data.data[i];
    	buttons['button'+i]={
    		text: oneStep.title ,
    		btnClass:'btn-green btn100',
    		action:function()
    		{
    			return  work_freeStep_go( oneStep.processid  , oneStep.processNodeGuid, oneStep.toNodeGuid , oneStep.toNodeGuidCode ,oneStep.executorid  );
    		}
    	};
    }
       
	p.buttons=buttons;
	
	 var dlg = $.confirm(p);

	dlg.open();
	
}


function  work_freeStep_go( processid, processNodeGuid, toguid, code, touserid)
{
	var reason= $('#freeStepReason').val();
	if( reason=='')
	{
		toastr.info("必须输入原因");
		$('#freeStepReason')[0].focus();
		return false;
	}
	
	var  buildFreeStepConfig=function()
	{
	 
	
		var ret={};
		var passTo=[ ];
		
	 
		ret[toguid] =[];
			
		ret[toguid].push( touserid); 
		 
		
		var t=[];
		for( var p in ret)
		{
			 var one= {};
			 one.nodeguid= p;
			 one.code= code;
			 one.passto= ret[p];
			 passTo.push( one); 
			 
			t.push( p+',' + ret[p].join(','));
		}
		
		t = t.join(' '); 
		console.info(t);
		return { passTo: passTo, param:t} ; 
	}
	
	
	work_passTo(  processid,  processNodeGuid, buildFreeStepConfig() , reason);
	
	
}

