
function  simpleUploadInit(   bucketName , path , tableName , gguid , fileTypes , maxSize , callback_uploaded )
{


    var uploadInit= function() {
        var log = function (info) {
            console.info(info);
        }

        if (maxSize == null) maxSize = "400mb";

        if (fileTypes == null) {
            fileTypes = [

                {title: "*", extensions: "*"}


            ];
        }



        var uploader = new plupload.Uploader({
            // General settings
            runtimes: 'silverlight,html4',
            browse_button: 'cb_quickupload' , // you can pass in id...
            url: 'UploadFile?bucketName=' + bucketName + "&tableName=" + tableName + "&gguid=" + gguid,
            chunk_size: '40mb',
            unique_names: true,

            // Resize images on client-side if we can
            resize: {width: 320, height: 240, quality: 90},

            filters: {
                max_file_size: maxSize, // '40mb',

                // Specify what files to browse for
                mime_types: fileTypes
            },

            flash_swf_url: '../js/Moxie.swf',
            silverlight_xap_url: '../js/Moxie.xap',

            // PreInit events, bound before the internal events
            preinit: {
                Init: function (up, info) {
                    log('[Init]', 'Info:', info, 'Features:', up.features);
                },

                UploadFile: function (up, file) {
                    log('[UploadFile]', file);

                    // You can override settings before the file is uploaded
                    // up.setOption('url', 'upload.php?id=' + file.id);
                    // up.setOption('multipart_params', {param1 : 'value1', param2 : 'value2'});
                }
            },

            // Post init events, bound after the internal events
            init: {
                PostInit: function () {
                    // Called after initialization is finished and internal event handlers bound
                    log('[PostInit]');


                },

                Browse: function (up) {
                    // Called when file picker is clicked
                    log('[Browse]');
                },

                Refresh: function (up) {
                    // Called when the position or dimensions of the picker change
                    log('[Refresh]');
                },

                StateChanged: function (up) {
                    // Called when the state of the queue is changed
                    log('[StateChanged]', up.state == plupload.STARTED ? "STARTED" : "STOPPED");
                },

                QueueChanged: function (up) {
                    // Called when queue is changed by adding or removing files
                    log('[QueueChanged]');
                },

                OptionChanged: function (up, name, value, oldValue) {
                    // Called when one of the configuration options is changed
                    log('[OptionChanged]', 'Option Name: ', name, 'Value: ', value, 'Old Value: ', oldValue);
                },

                BeforeUpload: function (up, file) {
                    // Called right before the upload for a given file starts, can be used to cancel it if required
                    log('[BeforeUpload]', 'File: ', file);


                    showInfoPane("* 准备上传");


                },

                UploadProgress: function (up, file) {
                    // Called while file is being uploaded
                    log('[UploadProgress]', 'File:', file, "Total:", up.total);
                    setTimeout(function () {
                        //    showInfoPane("* 上传中，已完成" + up.total.percent + '%');
                    }, 17);
                },

                FileFiltered: function (up, file) {
                    // Called when file successfully files all the filters
                    log('[FileFiltered]', 'File:', file);

                },

                FilesAdded: function (up, files) {
                    // Called when files are added to queue
                    log('[FilesAdded]');

                    var err = false;
                    for (var i = 0; i < files.length; i++) {
                        var file = files[i];

                        if (file.name.indexOf('+') > 0) {
                            err = true;
                            $.alert("文件名中有+号，无法上传，请修改文件名");


                            break;
                        }
                    }


                    if (!err) uploader.start();

                },

                FilesRemoved: function (up, files) {
                    // Called when files are removed from queue
                    log('[FilesRemoved]');

                    plupload.each(files, function (file) {
                        log('  File:', file);
                    });
                },

                FileUploaded: function (up, file, info) {
                    // Called when file has finished uploading
                    log('[FileUploaded] File:', file, "Info:", info);
                    var t = info.response;
                    var p1 = t.indexOf('>');
                    var p2 = t.indexOf('<', p1 + 1);
                    var t = t.substring(p1 + 1, p2);
                    console.info(t);


                    toastr.info("上传完成");


                    var file = JSON.parse(t);

                    if (callback_uploaded) callback_uploaded(file);

                },

                ChunkUploaded: function (up, file, info) {
                    // Called when file chunk has finished uploading
                    log('[ChunkUploaded] File:', file, "Info:", info);
                },

                UploadComplete: function (up, files) {
                    // Called when all files are either uploaded or failed
                    log('[UploadComplete]');
                    setTimeout(function () {
                        hideInfoPane();
                    }, 100);

                },

                Destroy: function (up) {
                    // Called when uploader is destroyed
                    log('[Destroy] ');
                },

                Error: function (up, args) {
                    // Called when error occurs
                    log('[Error] ', args);
                }
            }
        });


        uploader.init();


        setTimeout( function() {
            var a = $('#cb_quickupload');
            a.trigger();

        },300);
    }

    uploadInit();

}

