/**
 * 把表单另存为excel文件， 然后填写数据后，再导入
 *
 * 要求：导出的文件，只允许填写数据，不允许插入删除行列，即保持各个单元格的坐标不能变
 *
 */


define(function (require) {

    const Class = spreadsheet.base.Class;
    const Util =  spreadsheet.util.Util;
    const Tools = spreadsheet.util.Tools;


    function getCellValue(sheet, row, col) {
        if (row > sheet.length - 1)
            return null;
        var dataRow = sheet[row];
        if (dataRow == null)
            return null;
        if (col > dataRow.length - 1)
            return null;
        var v = dataRow[col];
        return v;
    }


    function setValueToBook(book, dsn, row, col, value) {
        if (value == null) return;
        var dsc = book.getDataSource(dsn);
        if (dsc == null) return;
        var ds = dsc.dataStore;
        if (row < 0) row = 0;
        if (row > 0 && dsc.dataSourceType != 2) return; //如果行号大于0，但是结果集却是单行的，那么放弃操作

        if (ds.rowCount <= row) ds.insertRow(row); //如果没有行，那么插入行

        ds.setValue(row, col, value);

    }

    var importUtil = Class.extend({


        constructor: function () {

        }
        ,

        importXLSX: function (data ,book, callback) {

            const sign = "spreadsheet.junzeng.";
            var fileValid = false;
            var bindInfo = '';

            showInfoPane("*正在导入数据...");
            //在数据填充过程中，再关闭显示
            book.setAllSheetsPaintPermit(false);
            try {

                for (var sheetName in data) {
                    var sheet = data[sheetName];
                    var t = getCellValue(sheet, 0, 1); //B1单元格
                    //读取单元格的绑定信息
                    if (t.startsWith(sign)) {
                        fileValid = true;
                        bindInfo = t.substring(sign.length);
                        for (var col = 2; col < sheet[0].length; i++) {
                            var t = getCellValue(sheet, 0, col);
                            if (t == null) continue;
                            bindInfo = bindInfo + t;
                        }

                        //绑定信息取出来 ，按它的配置把数据填到表单中

                        bindInfo= Tools.unzip( bindInfo);

                        bindInfo = JSON.parse(bindInfo)


                        for (var p in bindInfo) {

                            var bind = bindInfo[p];
                            var row = parseInt(p.substring(1, p.indexOf("C")));
                            var col = parseInt(p.substring(p.indexOf("C") + 1));
                            var t = bind.split('.');
                            var value = getCellValue(sheet, row, col);
                            if( value==null) continue;//如果不忽略，假设表单上要取数功能，或脚本取数，那么可能会被此处的nul覆盖
                            setValueToBook(book, t[0], parseInt(t[2]), t[1], value);
                        }
                    }
                    else {
                        continue;
                    }

                }
            } catch (err) {
                return JSON.stringify(err);
            } finally {
                //在数据填充过程中，再关闭显示
                hideInfoPane();
                book.setAllSheetsPaintPermit(true);

                if( callback) callback();
            }

            return "";
        }


    });


    return importUtil;
})
;



