/**
 * @apiDefine   FormGroup 表单功能函数
 */




define(function (require) {

        const ItemStatus = spreadsheet.db.ItemStatus;
        const ajax = spreadsheet.util.ajax;
        const Util = spreadsheet.util.Util;
        const Tools = spreadsheet.util.Tools;

        const ExortUtil = require('../form/exportUtil');
        const ImportUtil = require('../form/importUtil');


        window.g_eventHancleCache = {};

        var queryString = window['queryString'];


        /**
         * 查找 funcName 事件名对应的响应函数组。
         * 可能是多个响应函数，系统允许加载多个模板，此时响应函数同名就会造成函数的互相覆盖。因此增加
         * 了响应函数前后增加前后缀的方式来解决。
         * @param funcName
         * @returns {*}
         */
        function findEventHandle(funcName) {

            var ret = g_eventHancleCache[funcName];
            if (ret != null) return ret;

            var handleBefore = [];
            var handle = null;
            var handleAfter = [];

            for (var p in window) {
                if (p == funcName) {
                    handle = window[p];
                    continue;
                }

                if (p.endsWith('$' + funcName)) {
                    handleBefore.push(window[p]);
                    continue;
                }

                if (p.startsWith(funcName + '$')) {
                    handleAfter.push(window[p]);
                    continue;
                }
            }

            if (handle != null) handleBefore.push(handle);

            g_eventHancleCache[funcName] = handleBefore.concat(handleAfter);

            return g_eventHancleCache[funcName];


        }

        /**
         * 本函数参照了 EventManage
         * @param funcName
         * @param p1  需要额外增加的一个参数
         * @param args
         * @param returnValueUnEqualToBreak当执行事件后，返回的值与此不相等时，那么提前终止循环
         * @returns {*}
         */
        function handleEvent(funcName, p1, args, returnValueUnEqualToBreak) {
            var param = args ? Array.prototype.slice.apply(args) : [];
            if (p1 != null) param.unshift(p1); //在头上插入一个参数
            var handles = findEventHandle(funcName);
            var retValue = undefined;
            for (var i = 0; i < handles.length; i++) {
                try {
                    var handle = handles[i];
                    retValue = handle.apply(window, param);
                    if (returnValueUnEqualToBreak != undefined) {
                        if (retValue != returnValueUnEqualToBreak) return retValue;
                    }
                } catch (err) {

                }
            }

            return retValue || returnValueUnEqualToBreak;
        }


        function editFormIsActive() {
            var pd = parent.document;
            var v = $(pd.getElementById('billedit')).css("display");
            return v != 'none';
        }

        function listFormIsActive() {
            return !editFormIsActive();
        }

        function newBill(args) {
            var pd = parent.document;

            if (editFormIsActive()) {


                //下面有重复的代码块，懒得优化了，能正常跑就ok了吧
                if (book.uploadingCount > 0) {
                    $confirm("提醒", "有文件正在上传中，等待上传完成，点击“确定” ， 不等待上传完成，点击“取消” ",
                        function () {
                            return;
                        },
                        function () {
                            if (isSaveNeeded()) {

                                billSaveAsk(function () {
                                    $newBill(args);
                                }, "新增");
                            } else {
                                $newBill(args);
                            }
                        });
                } else {
                    if (isSaveNeeded()) {

                        billSaveAsk(function () {
                            $newBill(args);
                        }, "新增");
                    } else {
                        $newBill(args);
                    }
                }
            } else {
                $newBill(args);
            }

        }

        function $newBill(args) {
            var pd = parent.document;

            var  permit = handleEvent('newPermit', '', ['', urlArgs.billtype], true);
            if(!permit) return; 
            
            
            
            
            if (args == undefined) args = "";

            var param = {action: 'new', gguid: ''}; //一定要设置gguid='' 不然下面的merge 会把urlArgs中的gguid复制过来

            Util.merge(param, args, false, true); //同名参数不要用urlArgs覆盖

            var sp = handleEvent('appendNewBillParam', form.GUID, [], null);
            if (sp != null && typeof (sp) == 'object') {
                Util.merge(param, sp, false, true); //同名参数不要用urlArgs覆盖
            }


            Util.merge(param, urlArgs, false, true); //同名参数不要用urlArgs覆盖

            var url = "h5-billedit.jsp?" + JSON2QueryString(param);

            //必须是在列表容器，并且是需要弹出显示编辑窗口时，才弹出
            // 注意，当编辑窗口已经弹出，并在弹出的编辑窗口中点新单据时，此时不要再弹出了，而是就地打开
            if (form.configInfo.popupedit == 'true' && window.location.href.indexOf('billlist.jsp') > 0) {
                var width = form.configInfo.popupwidth || 1000;
                var height = form.configInfo.popupheight || 500;

                popup("", url, width, height);
            } else {
                var frame = pd.getElementById('billedit')
                if (frame) { //使用frame 切换时
                    frame.src = url;
                    $(pd.getElementById('billlist')).css("display", "none");
                    $(pd.getElementById('billedit')).css("display", "");
                } else { //使用弹窗显示时
                    this.location.href = url;
                }
            }

        }


        function editBill(dontTip) {
            if (dontTip == undefined) dontTip = false;
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                toastr.error("列表模板中不存在名为" + form.masterTableName + "结果集");
                return;
            }
            var ds = dsc.dataStore;
            var row = dsc.currentBindRow;
            var gguid = ds.getString(row, "id");
            if (gguid == '') {
                $alert("提示", "无法取得id字段的值，请确保结果集" + form.masterTableName + "中存在 id 字段");
                return;
            }


            if (ds.col2Index("verifierid") < 0) {
                $alert("提示", "无法取得verifierid字段的值，请确保结果集" + form.masterTableName + "中存在 verifierid 字段");
                return;
            }

            if (ds.getInt(row, "verifierid") > 0) {
                if (!dontTip) toastr.info("已审核，禁止再修改，切换为查看");
                setTimeout(viewBill, dontTip ? 10 : 1000);
                return;
            }

            var pd = parent.document;

            var param = {action: 'edit', gguid: gguid};
            Util.merge(param, urlArgs, false, true); //同名参数不要用urlArgs覆盖

            var url = "h5-billedit.jsp?" + JSON2QueryString(param);

            console.info(url);

            if (form.configInfo.popupedit == 'true') {
                var width = form.configInfo.popupwidth || 1000;
                var height = form.configInfo.popupheight || 500;

                popup(`&nbsp;<i class="fa  ${$moduleConfig.icon}"></i>&nbsp; ${$moduleConfig.name}`, url, width, height);
            } else {
                pd.getElementById('billedit').src = url;
                $(pd.getElementById('billlist')).css("display", "none");
                $(pd.getElementById('billedit')).css("display", "");
            }
        }

        function viewBill() {
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                toastr.error("列表模板中不存在结果集：" + form.masterTableName);
                return;
            }
            var ds = dsc.dataStore;
            var row = dsc.currentBindRow;
            var gguid = ds.getString(row, "id");

            if (gguid == '') {
                $alert("提示", "无法取得id字段的值，请确保结果集" + form.masterTableName + "中存在 id 字段");
                return;
            }


            var pd = parent.document;

            var param = {action: 'view', gguid: gguid};
            Util.merge(param, urlArgs, false, true); //同名参数不要用urlArgs覆盖

            var url = "h5-billedit.jsp?" + JSON2QueryString(param);

            console.info(url);


            if (form.configInfo.popupedit == 'true') {
                var width = form.configInfo.popupwidth || 1000;
                var height = form.configInfo.popupheight || 500;

                popup("", url, width, height);
            } else {

                pd.getElementById('billedit').src = url;
                $(pd.getElementById('billlist')).css("display", "none");
                $(pd.getElementById('billedit')).css("display", "");
            }
        }


        /**
         * @api {$popup} 函数   $popup
         *
         * @apiDescription  $popup(  title, url, width, height)
         * <br><br> 在当前模板中弹出显示一个对话框（没有关闭按钮，没有确定取消等按钮）显示单据编辑或查看
         * 界面。 通常用来在报表或单据列表窗口中，显示相关单据详情或弹出编辑相关单据
         * <br>如果是弹出单据编辑或查看而面，则弹框右上角不显示默认的X按钮， 而是使用工具栏上的返回按钮关闭弹框
         *
         * @apiName  $popup
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {String} title 标题
         * @apiParam {String} url 要打开的URL地址
         *@apiParam {int} width 弹窗宽度，单位: px
         *@apiParam {int} height 弹窗高度,单位: px
         *
         *
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *  $popup( "详情" , "billedit.jsp?action=view&gguid=AB9A3030-61DB-4094-B581-2F0EB2E30383&id=rytree", 1000,6000  );
         *
         */
        function popup(title, url, width, height) {
            var p = {
                theme: 'light',
                lazyOpen: true,
                closeIcon: url.indexOf("billedit.jsp") >= 0 ? false : true,
                closeIconClass: 'fa fa-close',
                draggable: true,
                animation: 'zoom',
                closeAnimation: 'scale',
                title: '  ',
                content: '<iframe  id="dialogFrame"  name="dialogFrame" frameborder=1  ' +
                    ' style="width:100%; height:' + height + 'px; border:0px solid lightgray; opacity:1;  " ' +
                    ' src="' + url + '"></iframe>',

                onContentReady: function () {

                    $('.jconfirm-title-c').css({
                        "background-color": "#dedede",
                        "font-size": "1px",
                        "pading": "0px",
                        "height": '5px',
                        "cursor": "move"


                    });


                },
                onOpen: function () {

                    window['junzeng_dialog'] = this;
                }


            };

            if ((width + '').indexOf("%") > 0) {
                p.boxWidth = width;
                p.useBootstrap = false;
            } else if (width <= 12) {
                p.columnClass = 'col-md-' + width;
            } else {
                p.boxWidth = width + "px";
                p.useBootstrap = false;
            }

            var dlg = $.dialog(p);

            dlg.open();

            $('.jconfirm-box').css({'padding': '7px'});

            $('.jconfirm-content-pane').css({'opacity': 1});


        }

        function deleteBill() {
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                toastr.error("列表模板中不存在结果集" + form.masterTableName);
                return;
            }
            var ds = dsc.dataStore;
            var row = dsc.currentBindRow;
            var gguid = ds.getString(row, "id");

            if (gguid == '') {
                $alert("提示", "无法取得id字段的值，请确保结果集" + form.masterTableName + "中存在 id 字段");
                return;
            }

            if (ds.col2Index("verifierid") < 0) {
                $alert("提示", "无法取得verifierid字段的值，请确保结果集" + form.masterTableName + "中存在 verifierid 字段");
                return;
            }

            if (ds.getInt(row, "verifierid") > 0) {
                toastr.info("已审核，禁止删除");
                return;
            }


            $confirm('提示!',
                '确信要删除吗?',
                function () {


                    //2020.03.27 修改， 不要创建长连接，删除并不是经常做的事，
                    //改成 一次性的会话，并且强制30秒后必须断开，避免浪费websocket 连接
                    // 标记20190706-1
                    onPushMessage("billDeleteResult" + form.masterTableName, function (msg) {
                            msg = JSON.parse(msg);


                            //删除无论成功还是失败，都必须回发一个消息给客户端，因为它还等着收到消息后自动关闭chat连接
                            if (msg.deleteOK) {
                                toastr.info("删除成功");
                            } else {
                                var dsc = book.getDataSource(form.masterTableName);
                                dsc.dataStore.retrieve(" id='" + msg.gguid + "'", false);//第二个参数 false表示追加检索，不清除现在的数据
                                dsc.currentBindRow = dsc.dataStore.rowCount - 1; //焦点设置到检索出来数据上
                                $.alert("删除失败，错误信息为：" + msg.message);
                            }

                        }, 'formEngine',
                        true,  //一次性的对话连接
                        30 //  30秒后如果还没有收到回馈的消息，那么强制关闭 chat连接
                    );


                    $rpc("formEngine", "formengine.Bill", "deleteBill",
                        {
                            id: urlArgs.id, //模块的ID
                            gguid: gguid, //数据的ID
                            table: form.masterTableName, //主表名称
                            templateid: form.configInfo.template_edit,//删除单据，使用编辑模板ID来获取单据信息
                            // 下面的是用来权限校验的
                            authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                            authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

                        },

                        function (retValue) {
                            var ret = JSON.parse(retValue);
                            if (ret.success) {
                                ds.deleteRow(row, true); //注意，单据的删除，是在服务器上删除的，这里仅仅是在界面上删除它，并且不需要放到删除缓冲区，避免ds是可更新的，产生多余的删除命令
                                toastr.info("正在后台删除");
                            } else {
                                toastr.error(ret.message);
                            }
                        }
                    );


                }
            );


        }


        function verifyBill() {
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                toastr.error("列表模板中不存在" + form.masterTableName);
                return;
            }
            var ds = dsc.dataStore;
            var row = dsc.currentBindRow;
            var gguid = ds.getString(row, "id");

            if (gguid == '') {
                $alert("提示", "无法取得id字段的值，请确保结果集" + form.masterTableName + "中存在 id 字段");
                return;
            }

            if (ds.col2Index("verifierid") < 0) {
                $alert("提示", "无法取得verifierid字段的值，请确保结果集" + form.masterTableName + "中存在 verifierid 字段");
                return;
            }

            var verifierid = ds.getInt(row, "verifierid");
            var info = verifierid == 0 ? "确信要审核吗?" : "确信要取消审核吗?";
            var action = verifierid == 0 ? "审核" : "取消审核";

            $confirm("提示", info, function () {

                showInfoPane("*正在" + action + "...  ");

                $rpc("formEngine", "formengine.Bill", "verifyBill",
                    {
                        gguid: gguid,
                        table: form.masterTableName,
                        templateid: form.configInfo.template_edit,//审核单据，使用编辑模板ID来获取单据信息
                        // 下面的是用来权限校验的
                        authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                        authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

                    },

                    function (retValue) {
                        var ret = JSON.parse(retValue);
                        hideInfoPane();
                        if (ret.success) {
                            toastr.success(action + "成功");
                            refreshRetrieve(gguid); //刷新检索


                        } else {
                            toastr.error(ret.message);
                        }
                    }
                );
            });


        }


        //返回列表，或新增单据时，检测到当前单据被修改，那么要问一下是否需要保存
        function billSaveAsk(callback, caption) {
            $switch("数据发生修改，需要保存吗?"
                , "[<a  class='button'  href='javascript: $.alert(formDataChangeDetail ); '>查看修改详情</a>]<br>" +
                "<br>点击“保存”，保存并" + caption +
                "<br>点击“不保存”，放弃保存并" + caption +
                "<br>点击“取消”，则取消操作，留在当前表单", "保存", "不保存", "取消",
                function () {
                    var err = save();
                    if (err != '') return;

                    callback();
                },

                function () {
                    callback();
                },

                function () {

                },
                450
            );
        }

        //得到当前
        function currentBillIndex() {
            let dsc = book.getDataSource(form.masterTableName);
            let ds = dsc.dataStore;
            let row = dsc.currentBindRow;
            let rc = ds.rowCount;
            let firstNo = ds.evaluate("=thisrow() ", 0);
            if (rc == 0) return "";
            if (firstNo == 0) return (row + 1) + "/" + rc;
            return (row + 1 + firstNo) + "/[" + (firstNo + 1) + " - " + (firstNo + rc) + "]";
        }

        /**
         * 在单据列表窗口中调用 ， 将当前明细行的焦点行定位到第一行上
         * 返回 第一行的 ID，如果已经是第一行，那么返回  ''
         */
        function focus_firstRecord() {

            let dsc = book.getDataSource(form.masterTableName);
            let ds = dsc.dataStore;
            let row = dsc.currentBindRow;
            if (row == 0) {

                return '';
            } //就是第一行，那么

            dsc.currentBindRow = 0;
            id = ds.getString(dsc.currentBindRow, "id");
            return id;
        }

        /**
         * 在单据列表窗口中调用 ， 将当前明细行的焦点行定位到上一行上
         * 然后返回焦点行的 ID，如果没有上一行，那么 返回 ''
         */
        function focus_priorRecord() {
            let dsc = book.getDataSource(form.masterTableName);
            let ds = dsc.dataStore;
            let row = dsc.currentBindRow;
            if (row == 0) {

                return '';
            } //就是第一行，那么

            dsc.currentBindRow = row - 1;
            id = ds.getString(dsc.currentBindRow, "id");
            return id;
        }

        /**
         * 在单据列表窗口中调用 ， 将当前明细行的焦点行定位到下一行上
         * 然后返回焦点行的 ID，如果没有下一行，那么 返回 ''
         */
        function focus_nextRecord() {
            let dsc = book.getDataSource(form.masterTableName);
            let ds = dsc.dataStore;
            let row = dsc.currentBindRow;
            if (row == ds.rowCount - 1) {

                return '';
            } //就是第一行，那么

            dsc.currentBindRow = row + 1;
            id = ds.getString(dsc.currentBindRow, "id");
            return id;
        }

        /**
         * 在单据列表窗口中调用 ， 将当前明细行的焦点行定位到最后一行上
         * 然后返回焦点行的 ID，如果当前已经是最后一行，那么 返回 ''
         */
        function focus_lastRecord() {
            let dsc = book.getDataSource(form.masterTableName);
            let ds = dsc.dataStore;
            let row = dsc.currentBindRow;
            if (row == ds.rowCount - 1) {

                return '';
            } //就是第一行，那么

            dsc.currentBindRow = ds.rowCount - 1;
            id = ds.getString(dsc.currentBindRow, "id");
            return id;
        }


        function goto_firstRecord() {
            if (isSaveNeeded()) {
                billSaveAsk($goto_firstRecord, "打开第一张");

            } else {
                $goto_firstRecord();
            }
        }


        /**
         * 在编辑窗口中使用
         */
        function $goto_firstRecord() {
            let listWindow = getBillListWindow();
            if (listWindow == null) return;
            let gguid = listWindow.firstBill();
            if (gguid == '') {
                toastr.info("已经是第一张");
                return;
            }
           // listWindow.book.activeSheet.View.insureSelectionOnScreen();
            $("#currentBillIndex").html(listWindow.currentBillIndex());
            loadBill(gguid);
        }

        function goto_priorRecord() {
            if (isSaveNeeded()) {
                billSaveAsk($goto_priorRecord, "打开前一张");

            } else {
                $goto_priorRecord();
            }
        }


        function $goto_priorRecord() {
            let listWindow = getBillListWindow();
            if (listWindow == null) return;
            let gguid = listWindow.priorBill();
            if (gguid == '') {
                toastr.info("没有前一张了");
                return;
            }
         //   listWindow.book.activeSheet.View.insureSelectionOnScreen();
            $("#currentBillIndex").html(listWindow.currentBillIndex());
            loadBill(gguid);
        }

        function goto_nextRecord() {
            if (isSaveNeeded()) {
                billSaveAsk($goto_nextRecord, "打开下一张");

            } else {
                $goto_nextRecord();
            }
        }

        function $goto_nextRecord() {
            let listWindow = getBillListWindow();
            if (listWindow == null) return;
            let gguid = listWindow.nextBill();
            if (gguid == '') {
                toastr.info("没有后一张了");
                return;
            }
          //  listWindow.book.activeSheet.View.insureSelectionOnScreen();
            $("#currentBillIndex").html(listWindow.currentBillIndex());
            loadBill(gguid);
        }


        function goto_lastRecord() {
            if (isSaveNeeded()) {
                billSaveAsk($goto_lastRecord, "打开最后一张");

            } else {
                $goto_lastRecord();
            }
        }

        function $goto_lastRecord() {
            let listWindow = getBillListWindow();
            if (listWindow == null) return;
            let gguid = listWindow.lastBill();
            if (gguid == '') {
                toastr.info("已经是最后一张了");
                return;
            }
         //   listWindow.book.activeSheet.View.insureSelectionOnScreen();
            $("#currentBillIndex").html(listWindow.currentBillIndex());
            loadBill(gguid);
        }


        //2步检测 ，一是看有没有文件在上传中，2是看数据是不是有修改了
        function backToBillList() {

            //下面有重复的代码块，懒得优化了，能正常跑就ok了吧
            if (book.uploadingCount > 0) {
                $confirm("提醒", "有文件正在上传中，等待上传完成，点击“确定” ， 不等待上传完成，点击“取消” ",
                    function () {
                        return;
                    },
                    function () {

                        if (isSaveNeeded()) {
                            billSaveAsk($backToBillList, "返回");

                        } else {
                            $backToBillList();
                        }
                    });
            } else {
                if (isSaveNeeded()) {
                    billSaveAsk($backToBillList, "返回");

                } else {
                    $backToBillList();
                }
            }

        }

        //在单据编辑窗口中获取单据列表窗口对象
        function getBillListWindow() {

            //当编辑窗口是popup打开时，那么parent 就是列表窗口
            if (parent.location.href.indexOf('h5_billl2.jsp') >= 0) return parent;

            //如果列表窗口，编辑窗口都是在 iframe中，那么需要在parent中找到 billlist的 iframe，再取它的 contentWindow
            var pd = parent.document;

            if (pd.getElementById('billlist')) {
                let listWindow = pd.getElementById("billlist").contentWindow;
                return listWindow;
            }
            return null;
        }


        //在单据编辑窗口获取单据列表
        function $backToBillList() {


            var pw = parent;

            

            if (pw.location.href.indexOf('flow_stepframe.jsp')>=0)
            {
            	SwitchToList(); //兼容旧的工作流页面 .此函数在  toolbar_billedit.js中
            	return;
            }
            
            
            if (pw.location.href.indexOf('h5_bill_frame.jsp')>=0) {
            	  try
            	    { 
            	    	pw.billframeset.cols="*,0";
            	    }catch(err)
            	    {
            	        
            	    }

                //从编辑状态切换回列表后， 要修改DingDing菜单

                if (isDD()) {
                    //注意，本函数通常是在billEdit.jsp中调用 ，需要切换调用 billlist.jsp中的设置菜单的函数

                    listWindow.dd_setBillList_menu();

                }
            }
            else {
                if (window.parent != window) {
                    $sentMessageToMainForm({action: 'closeDialogAndRun', script: ""});
                }
            }

        }

        function $parentWindow() {
            try {
                if (jQuery.browser.msie) {
                    return document.parentWindow.parent;
                } else {
                    return document.defaultView.parent;
                }
            } catch (err) {
                alert(err.description);
                return null;
            }
        }


        function handle_isBillNeedToSave() {
            var ret = handleEvent('isBillNeedToSave', form.GUID, arguments, true);
            if (ret == null) ret = true;

            return ret;

        }

        /**
         * @api {save} 函数   save
         *
         * @apiDescription  save( showTipInfo )
         * <br><br> 保存单据表单
         * <br>
         *
         * @apiName  save
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {boolean} showTipInfo   true 表示在保存过程中，如果保存失败，那么显示提示信息， false  表示仅做保存操作，即使有错误也不提示
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *  form.save(false);
         *
         *  if( form.isSaveNeeded()) $alert(''保存失败);
         *
         */
        function save(tip) {
            if (tip == undefined) tip = true;

            if (!book.initOK) {
                toastr.info("请在单据加载完成后再执行");
                return;
            }

            if (!isSaveNeeded()) {
                if (tip) toastr.success("无需保存。");
                return "";
            }


            var sqlMap = {};
            // 得到所有的更新语句
            var err = getUpdateSQL(sqlMap); //

            if (err != '') return err;

            var ret = update(sqlMap);

            if (ret.equals("")) {
                resetUpdate();
                //成功后运行脚本
                if (tip) toastr.success("保存成功");
                
                if( form.action=='new')
                {
                	form.action='edit'; //影响附件上传， new时不允许上传
                	window["getTemplateConfigParameter"].action= 'edit';  // loadBill 会用到这个参数，需要一并同步修改
                }
                handleEvent("afterSaveSuccessful", null, [form.GUID, form.action]);

                //注意，不能异步，在前翻后翻时，如果下面的refreshRetrieveList是异步的，那么焦点行会不对
                refreshRetrieveList();


            } else {
                //不要 alert
                var info = ret;
                if (info.indexOf('Duplicate entry') > 0 ||  // mysql
                    info.indexOf('唯一索引') > 0

                ) { //违反唯一索引限制，那么找到这个索引对应的字段信息，找到第一个绑定到这些字段的单元格，在它上面显示异常提示
                    
                	
                	if( info.indexOf( form.masterTableName+"_btno")>0)
					{
						   var dsc = book.getDataSource(form.masterTableName);
							var dsMaster = null;

						 if (dsc != null) {
								dsMaster = dsc.dataStore;
				
						 dsMaster.setValue(0, "billno", form.LT.getNextBillNo());
						$.alert('单据号重复，系统重新分配了单据号，请再次点击保存');
							
						return; 
						 }
					}

                	
                	info = info.replace(/'/g, '');
                    var p = info.lastIndexOf(' ');
                    var indexName = info.substring(p + 1);
                    for (var i = 0; i < form.uniqueIndexInfo.length; i++) {
                        if (form.uniqueIndexInfo[i].indexName.equalsIgnoreCase(indexName)) {
                            if (tip) {

                                var columns = form.uniqueIndexInfo[i].columns;
                                var foundCell = null;
                                for (var ci = 0; ci < columns.length; ci++) {
                                    var col = columns[ci].name;
                                    var cells = book.getDataSource(form.uniqueIndexInfo[i].tableName).getAllCellsWhichBindTheCol(col);
                                    if (cells.length > 0) {
                                        foundCell = cells[0];
                                        break;
                                    }
                                }

                                if (foundCell) {
                                    foundCell.grumble(form.uniqueIndexInfo[i].errorTip, 100, 2000); //气泡提示)
                                } else {

                                    toastr.error(form.uniqueIndexInfo[i].errorTip);
                                }
                                return;
                            }
                            else {
                                console.info(form.uniqueIndexInfo[i].errorTip);
                            }
                        }
                    }

                }


                if (tip) toastr.error(ret);

                console.error("保存失败" + ret);
            }

            return ret;

        }

//编辑界面保存后，刷新列表界面的数据
//本函数在编辑界面中使用
        function refreshRetrieveList() {

            //2020.04.15调整，不需要用sendMessage来处理 无论是在iframe 中，还是popup 后的，都可以用parent访问到父窗口
            let listWindow = getBillListWindow();
            if (listWindow)    listWindow.reloadBillInfo( form.GUID);


   
        }

//列表界面，刷新指定ID对应的行，如果行不存在，则追加检索
//本函数在列表界面中调用


        /**
         * @api {refreshRetrieve} 函数   refreshRetrieve
         *
         * @apiDescription  refreshRetrieve( id  )
         * <br><br> 当数据库中的数据有变化，需要刷新检索主结果集中 id为指定值的那一行。
         * 本函数正确执行的先决条件是 结果集当前行一定就是 id=指定ID的那行上。如果主结果集中并没有检索出
         * id为指定ID的数据行，那么以追加检索的方式将该行数据追加显示在最后一行。
         * 主结果集是指以单据主表名称来命名的结果集
         * <br>
         *
         * @apiName  refreshRetrieve
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam  {String} id 需要刷新显示的数据的ID字段值
         *
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *  form.refreshRetrieve( id  );
         *
         */
        function refreshRetrieve(id, focusRow) {


            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                //2020.03.02 因此可能存在在一个单据列表模板中以弹出窗口方式
                // 打开另一个单据，当这个弹窗中的单据编辑保存时，会触发它父frame的刷新检索，
                // 此时就会出现这个情况，所以不要提示下面的信息
                //toastr.error("列表模板中不存在结果集：" + form.masterTableName);
                return;
            }
            var ds = dsc.dataStore;
            var row = focusRow;
            if (row == undefined) row = dsc.currentBindRow;
            var gguid = ds.getString(row, "id");

            var where = handleEvent('refreshRetrieveWhereDefine', null, [id]);
            if (where == null) where = "";
            if (where == '') where = " id='" + id + "'";


            if (gguid == id)  //刷新
            {
                ds.refreshRetrieve(row, where); //刷新检索
                if (focusRow == dsc.currentBindRow) dsc.currentBindRow = row;
            } else {  //追加检索
                //再找找是不是ID在其它行上
                let found = false;
                for (let i = 0; i < ds.rowCount; i++) {
                    if (ds.getString(i, "id") == id) {
                        found = true;
                        row = i;
                        break;
                    }
                }

                if (found) {
                    ds.refreshRetrieve(row, where); //刷新检索
                    dsc.currentBindRow = row;
                } else {

                    ds.retrieve(where,
                        false, //追加检索
                        1,  //只检索一条
                        0, // 定位到0 ， 此参数一定要设置，不然如果有翻页时，可能已经翻了几页，此时追加检索一条数据，如果不把 absolute设置成0，
                        //那么本次检索后，又定位到absolute行之后，就无法检索数据了
                        //下面用回调的方式 ，是因为retrieve后会触发 retrieveEnd事件，在单据在retrieveEnd事件中会把第一行设置成当前行
                        //下面的回调将在 retrieveEnd事件之后执行，所以它能够把焦点行再改回来
                        function () {
                            setTimeout(function () {
                                dsc.currentBindRow = ds.rowCount - 1; //设置为当前行
                            }, 100);
                        });
                }
            }

            book.getActiveSheet().View.insureSelectionOnScreen();


        }

        /**
         * 本函数不对外提供访问
         */
        function update(sqlMap) {



            //注意，不是用全局的$rpc ，因为那是异步的， 这里用的是同步的调用
            var ret = $ajax.rpc("formEngine", "formengine.ExecuteBatch", "execute",
                {

                    sql: sqlMap,
                    table: form.masterTableName,
                    // save 调用 本update ,save函数可能在单据列表，单据编辑，报表中调用 ，
                    // 所以就使用当前模板的ID，即单据列表使用的列表模板ID，编辑单据使用的是单据编辑模板ID，报表使用报表模板ID
                    templateid: form.configInfo.templateid,
                    currentGUID: form.currentGUID,
                    // 下面的是用来权限校验的， 防止在客户端随意注入sql
                    authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),

                    authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

                });
            //2020.08 支持工作流
            if( ret.workid!=undefined)  flow.currentWorkId=ret.workid; 

            return ret.message;

        }


// 得到所有的更新语句
        function getUpdateSQL(sqlMap) {
            var ok;
            var i, n;
            var dscs = book.getDataSources();
            n = dscs.length;
            for (i = 0; i < n; i++) {
                var dbpool = dscs[i].DBPoolName;
                if (dbpool == '') dbpool = "default";

                var ds = dscs[i].dataStore;
                var dsName = dscs[i].name;
 
                //oa_mywork 是自动增加到模板中的结果集，但是可能其中某个类型中，没有挂流程，因此，此结果集应忽略
                if(  dsName=='oa_mywork' )
                {
                	if($moduleConfig.flowid==0) continue;
					
					if(window['$workflowSubjectDefine']==null)
					{
						window['$workflowSubjectDefine']= getStringFromSQL("select autotitle from oa_flow where id= " + $moduleConfig.flowid );
					}
					
					let v= book.getActiveSheet().evaluate(window['$workflowSubjectDefine']);
					if( v!=null)  ds.setValue(0,"subject", v);  
						
					
                }
                
                
                if (ds.isUpdatable()) {
                    var list = [];

                    if (!ds.getUpdateSQL(list)) {
                   // if (!ds.getUpdateCommand(list)) {

                        return (dsName + "构建SQL失败:" + ds.error.message);

                    }

                    if (list.length == 0) continue;

                    var listlist = sqlMap[dbpool];
                    if (!listlist) {
                        listlist = [];
                        sqlMap[dbpool] = listlist;
                    }

                    listlist.push(list);

                } else {
                    console.info(dsName + "被设置成不可更新，所以保存时，它被忽略。");
                }
            }
            return "";

        }


        function resetUpdate() {
            var dscs = book.getDataSources();
            var n = dscs.length;
            for (var i = 0; i < n; i++) {

                var ds = dscs[i].dataStore;
                if (ds.isUpdatable()) ds.resetUpdate();
            }

        }

        /**
         * @api {isSaveNeeded} 函数   isSaveNeeded
         *
         * @apiDescription  isSaveNeeded(   )
         * <br><br> 判断当前表单是否需要保存（发生修改后，需要保存）
         * <br>
         *
         * @apiName  isSaveNeeded
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         *
         *
         * @apiSuccess (返回值){boolean} - true 表示需要保存， false表示表单未发生修改，不需要保存
         *
         * @apiExample   {js}示例：
         *
         *  if(  form.isSaveNeeded())
         *  {
         *
         *      $alert("请在保存后，再执行本操作");
         *      return;
         *  }
         *
         */
        function isSaveNeeded() {

            window.formDataChangeDetail = "";

            book.getWorkBookView().forceCurrentEditControlFillBack();

            if (form.billIsVerified) return false; //如果单据已经审核，那么不允许保存
            if (urlArgs.action == 'view') return false;//查看单据，不要保存

            var dscs = book.getDataSources();

            var n = dscs.length;
            for (var i = 0; i < n; i++) {
                var dbpool = dscs[i].DBPoolName;


                var ds = dscs[i].dataStore;
                var name=  dscs[i].name;
                //oa_mywork 是自动增加到模板中的结果集，但是可能其中某个类型中，没有挂流程，因此，此结果集应忽略
                if(  name=='oa_mywork' &&  $moduleConfig.flowid==0) continue;
                
                var dsLabel = ds.label;
                if (ds.isUpdatable()) {


                    if (ds.isSaveNeeded()) {


                        console.info(ds.getUpdatableTable() + "  需要保存");
                        //  下面一段是为了调试到底哪些数据变了
                        if (form.currentUserID == 1 || true) {
                            for (var k = 0; k < ds.columnCount; k++) {
                                for (var r = 0; r < ds.rowCount; r++) {
                                    if (ds.isModified(r, k)) {

                                        var oldv = ds.getPrimaryBuffer().getValue(r, k, true);
                                        var newv = ds.getPrimaryBuffer().getValue(r, k, false);
                                        var label = ds.getColumnProperty(k).getColumnLabel();

                                        if (oldv == null) oldv = "null";
                                        if (newv == null) newv = "null";


                                        var colName = ds.getColumnName(k);
                                        if (['id', 'gguid'].contains(colName)) continue;
                                        console.info(dsLabel + "." + colName + "  " + label + "   oldvalue=" + oldv + "  new value=" + newv);
                                        window.formDataChangeDetail += dsLabel + "." + label + "由“" + oldv + "”" + "修改成" + "“" + newv + "”<br>";

                                    }
                                }
                            }
                        }

                        return handle_isBillNeedToSave(form.GUID);

                    }
                }
            }
            //如果表单不需要保存，问问脚本有没有其它的需要保存
            //console.info("执行：save_IsNeeded");
            // var ret = RunScript("save_IsNeeded", new Object[] {});

            return false;
        }


        /**
         * @api {search} 函数   search
         *
         * @apiDescription  search( someKeys )
         * <br><br> 在单据列表模板中按给定的关键字 someKeys查询单据
         * <br>
         *
         * @apiName  search
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {String} someKeys  关键字
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *   form.search( 'abc');
         *
         */
        function search(someKey) {
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) {
                toastr.error("列表模板中不存在" + form.masterTableName);
                return;
            }
            var ds = dsc.dataStore;

            if (someKey != undefined) $('#keys').val(someKey);
            var key = $('#keys').val();


            var where = "";
            if (key != '') {
                where = handleEvent("buildBillSearchWhere", null, [key], '');
                if (where == undefined) where = "billno like '%" + key + "%' ";
            }

            var where2 = buildSmartRetrieveWhere(book.activeSheet, form.masterTableName, true);
            where = appendWhere(where, where2, "and");
            ds.ignoreTopRow(0); //如果有翻页，归位
            ds.retrieve(where);

        }

        function findDataStoreToExport() {
            if (book.getDataSourceCount() == 0) {
                toastr.success("没有可供导出的数据");
                return null;
            }

            var sheet = book.activeSheet;
            var RC = sheet.rowCount;
            var CC = sheet.columnCount;
            var dsc = null, firstDSC = null;
            for (var row = 0; row < RC; row++) {
                for (var col = 0; col < CC; col++) {
                    var cell = sheet.$cells(row, col);
                    if (cell == null) continue;
                    var bind = cell.Bind;
                    if (bind == null) continue;
                    var dsc = book.getDataSource(bind.dataSource);
                    if (firstDSC == null) firstDSC = dsc;
                    if (dsc.dataSourceType == 2) break;
                }
            }
            //如果没有找到一个多行的数据源，那么就导出能找到的第一个数据源（当然前提是在当前页上的）
            if (dsc == null) dsc = firstDSC;
            if (dsc == null) {
                toastr.success("当前工作表中没有可导出的数据");
                return null;
            }

            var ds = dsc.dataStore;
            if (ds.rowCount == 0) {
                toastr.success("没有数据可导出");
                return null;
            }
            return dsc;
        }

        function export_png() {
            $.alert("todo");
        }

        function export_excel() {

            var fileType = "xlsx";
            var splitChar = '\t';

            var dsc = findDataStoreToExport();
            if (dsc == null) return;
            var ds = dsc.dataStore;

            toastr.info("正在输出, 请静候片刻...");

            var fileName = handleEvent("getExportFileName", null, [fileType, dsc.name], '');
            if (fileName == undefined || fileName == '') fileName = date2str(new Date(), 'yyyyMMdd-hhmm-') + dsc.name + "." + fileType;

            var columns = handleEvent("getExportColumns", null, [fileType, dsc.name], '');
            if (columns == undefined) columns = "*";
            if (columns == '') columns = "*";
            var data = ds.primaryBuffer.saveAsTxtString(true, splitChar, columns);

            var f = $('#form_toexcel')[0];
            f.filename.value = fileName;
            f.data.value = JSON.stringify(data);
            f.submit();


        }


        function justInBillEditPage() {
            return window.location.href.indexOf("h5-billedit.jsp") >= 0;
        }

        function export_excel2(dsRowCountConfig) {


            $.confirm({
                title: '所见所得导出Excel',
                useBootstrap: false,
                boxWidth: '600px',
                content: ` 
                    <form action="" class="formName">
                    <div class="form-group">
                  
                    <label class="col-md-2 control-label"> 文件名称：</label>
                     <div class="col-md-10"><input type="text" placeholder="Your name" class="name form-control" required />
                     <span class="help-block">导出的文件在下载时的文件名</span>
                     </div>
                    
                    </div>
                    </form>`,
                buttons: {
                    formSubmit: {
                        text: '开始导出',
                        btnClass: 'btn-green',
                        action: function () {
                            var name = this.$content.find('.name').val();
                            if (!name) {
                                $.alert('请输入文件名');
                                return false;
                            }

                            var dsRowCountConfig = {};

                            var xml = new ExortUtil().UI2XML(book, dsRowCountConfig);

                            // TODO 数据量大了，压缩有问题，只有暂时不压缩
                            // xml = Tools.zip(xml);


                            toastr.info("正在输出, 请静候片刻...");
                            var f = $('#form_toexcel2')[0];
                            f.toFileName.value = name;
                            f.formData.value = xml;
                            f.submit();


                        }
                    },
                    cancel: {
                        text: '取消',
                        btnClass: 'btn-warning',
                        action: function () {

                        }
                    }
                },
                onContentReady: function () {
                    // bind to events
                    var jc = this;

                    var fileName = handleEvent("getFormExportFileName", null, [], '');
                    if (fileName == undefined || fileName == '') {
                        var defaultFileName = "";
                        if (document.title) defaultFileName += document.title + "-";
                        defaultFileName += date2str(new Date(), 'yyyyMMdd-hhmm');
                        if (form.masterTableName) defaultFileName += "-" + form.masterTableName;


                        if (justInBillEditPage()) {
                            var dsc = book.getDataSource(form.masterTableName);
                            if (dsc != null) {

                                defaultFileName += "-" + dsc.dataStore.getString(0, "billno");
                            }
                        }
                        fileName = defaultFileName + ".xlsx";
                    }

                    this.$content.find('.name').val(fileName);
                }

            });


        }


        function export_pdf() {

            var fileType = "pdf";
            var splitChar = '\t';

            var sheetName = book.getActiveSheet().name;

            toastr.info("正在输出,在出现文件保存提示前不要做其它操作，请静候片刻...");
            var fileName = handleEvent("getExportFileName", null, [fileType, sheetName], '');
            if (fileName == undefined || fileName == '') fileName = sheetName + '-' + date2str(new Date(), 'yyyyMMdd-hhmm') + "." + fileType;


            var data = book.getActiveSheet().exportAsPrintCommand();

            $('#pdf_filename').val(fileName);
            $('#pdf_data').val(JSON.stringify(data));

            $('#form_to_pdf').submit();


        }


        function export_txt(fileType, splitChar) {

            if (fileType == undefined) fileType = "txt";
            if (splitChar == undefined) splitChar = '\t';


            var dsc = findDataStoreToExport();
            if (dsc == null) return;
            var ds = dsc.dataStore;


            var fileName = handleEvent("getExportFileName", null, [fileType, dsc.name], '');
            if (fileName == undefined || fileName == '') fileName = date2str(new Date(), 'yyyyMMdd-hhmm-') + dsc.name + "." + fileType;

            var columns = handleEvent("getExportColumns", null, [fileType, dsc.name], '');
            if (columns == undefined) columns = "*";
            if (columns == '') columns = "*";

            toastr.info("正在输出，请静候片刻...");
            ds.primaryBuffer.saveAsTxt(fileName, true, splitChar, columns);

        }

        function export_csv() {
            export_txt('csv', ',');
        }


        function import_xls(callback) {
            book.readXLS(function (data) {

                importXLSX(data, book, callback);
            });
        }

        function importXLSX(data, book, callback) {
            setTimeout(function () {
                var importUtil = new ImportUtil();
                importUtil.importXLSX(data, book, callback);
            }, 100);
        }

        function enableOrDisableResize() {
            var sheet = book.activeSheet;
            if (sheet.RPM.rowHeadWidth == 0) {
                sheet.RPM.rowHeadWidth = 50;
                sheet.CPM.columnHeadHeight = 25;
            } else {
                sheet.RPM.rowHeadWidth = 0;
                sheet.CPM.columnHeadHeight = 0;
            }
            sheet.View.repaint();
        }


        /**
         * @api {buildRetrieveContext} 函数   buildRetrieveContext
         *
         * @apiDescription  buildRetrieveContext( triggerSheet, dsn )
         * <br><br> 构建动态检索数据上下文。
         * <br>
         *
         * @apiName  buildRetrieveContext
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {WorkSheet} triggerSheet  用来解析公式的worksheet，默认在此WorkSheet上查找公式中的别名
         * @apiParam {String} dsn 结果集名称 ，即在数据库定义中的结果集的名称
         *
         * @apiSuccess (返回值){Object} -  返回一个对象
         *
         * @apiExample   {js}示例：
         *
         *   var data = form.buildRetrieveContext( book.sheet0 , "query1");
         *
         */
        // 本函数与 buildSmartWhere 不同之处在于   buildSmartWhere使用的配置，每行是一个表达式，
        // 而本函数每行是一个 变量名: 表达式， 多了一个变量名，即把结果放到一个命名变量中，多个变量拼成一个对象，传递到后台备用
        function buildRetrieveContext(triggerSheet, dsn) {

            var dsc = book.getDataSource(dsn);
            if (dsc == null) return {};
            var ds = dsc.dataStore;
            var list = ds.dynamicWhereData2;
            if (list == undefined) return {};

            let context = {};
            let parseSheet = triggerSheet;
            for (let i = 0; i < list.length; i++) {
                let one = list[i];

                one = one.split(':');
                if (one.length < 2) {
                    $alert(list[i] + "定义不合法。正确的格式是  变量名:表达式");
                    continue;
                }
                let varName = one[0].trim();
                let expression = one[1].trim();
                let dependList = parseSheet.parseDependList(expression);
                if (dependList == null) continue;
                let ignore = false;
                for (let di = 0; di < dependList.length; di++) {
                    let da = dependList[di];
                    let sheet = parseSheet.Book.getWorkSheet(da.sheetGuid);
                    if (sheet == null) continue; // 当删除Sheet后有可能会出现这样的情况
                    let range = da.mergedRange.getMergedRange();
                    for (let row = range.startRow; row <= range.endRow; row++) {
                        for (let col = range.startCol; col <= range.endCol; col++) {
                            let cell = sheet.cells(row, col);
                            if (cell.getValueString() == '') {
                                ignore = true;
                                break;
                            }
                        }
                        if (ignore) break;
                    }
                    if (ignore) break;
                }

                //一个公式中所有的参数检测完成，如果有一个参数空，那么整个条件忽略
                //ignore=true表示条件中依赖的单元格有为空的，那么该条件就忽略掉
                if (ignore) {
                    console.info(expression + "所依赖的单元格中某些单元格没有数据，本条件被忽略");
                    continue;
                }

                if (expression.indexOf('“') >= 0 ||
                    expression.indexOf('”') >= 0 ||
                    expression.indexOf('‘') >= 0 ||
                    expression.indexOf('’') >= 0) {
                    toastr.error("定义的条件中包含有中文的引号，它可能是错误的，请检查");
                }

                var value = parseSheet.evaluate(expression);
                if (value == null) {
                    console.info(expression + "解析结果为 null ，本条件被忽略");
                    continue;
                }
                if (value == "") continue;  //没有数据，就不要设置
                context[varName] = value;
            }

            return context;
        }


        /**
         * 解析动态检索条件
         * @param triggerSheet
         * @param dsn
         * @param join  boolean   true 表示返回 join('and')后的字符串，false 表示返回条件数组
         *
         * @returns {string}
         */
        /**
         * @api {buildSmartRetrieveWhere} 函数   buildSmartRetrieveWhere
         *
         * @apiDescription  buildSmartRetrieveWhere( triggerSheet, dsn, join )
         * <br><br> 构建动态检索条件
         * <br>
         *
         * @apiName  buildSmartRetrieveWhere
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {WorkSheet} triggerSheet  用来解析公式的worksheet，默认在此WorkSheet上查找公式中的别名
         * @apiParam {String} dsn 结果集名称 ，即在数据库定义中的结果集的名称
         * @apiParam {join}   true 表示把各个动态条件 用  'and'   连接后的字符串，false 表示不用连接，直接返回条件数组
         *
         * @apiSuccess (返回值){variant} -  返回一个字符串，或一个字符串数组
         *
         * @apiExample   {js}示例：
         *
         *   var where= form.buildSmartRetrieveWhere( book.sheet0 , "query1", true);
         *
         */
        function buildSmartRetrieveWhere(triggerSheet, dsn, join) {


            if (join == undefined) join = true;

            var dsc = book.getDataSource(dsn);
            if (dsc == null) return "";
            var ds = dsc.dataStore;
            var list = ds.dynamicWhere;
            if (list == undefined) return "";

            let where = [];
            let parseSheet = triggerSheet;
            for (let i = 0; i < list.length; i++) {
                let expression = list[i];
                let dependList = parseSheet.parseDependList(expression);
                if (dependList == null) continue;
                let ignore = false;
                for (let di = 0; di < dependList.length; di++) {
                    let da = dependList[di];
                    let sheet = parseSheet.Book.getWorkSheet(da.sheetGuid);
                    if (sheet == null) continue; // 当删除Sheet后有可能会出现这样的情况
                    let range = da.mergedRange.getMergedRange();
                    for (let row = range.startRow; row <= range.endRow; row++) {
                        for (let col = range.startCol; col <= range.endCol; col++) {
                            let cell = sheet.cells(row, col);
                            if (cell.getValueString() == '') {
                                ignore = true;
                                break;
                            }
                        }
                        if (ignore) break;
                    }
                    if (ignore) break;
                }


                //一个公式中所有的参数检测完成，如果有一个参数空，那么整个条件忽略
                //ignore=true表示条件中依赖的单元格有为空的，那么该条件就忽略掉
                if (ignore) {
                    console.info(expression + "所依赖的单元格中某些单元格没有数据，本条件被忽略");
                    continue;
                }

                if (expression.indexOf('“') >= 0 ||
                    expression.indexOf('”') >= 0 ||
                    expression.indexOf('‘') >= 0 ||
                    expression.indexOf('’') >= 0) {
                    toastr.error("定义的条件中包含有中文的引号，它可能是错误的，请检查");
                }

                var value = parseSheet.evaluate(expression);
                if (value == null) {
                    console.info(expression + "解析结果为 null ，本条件被忽略");
                    continue;
                }
                if (value == "") continue;
                where.push('(' + value + ')');
            }

            if (join) {
                var ret = where.join(" and ");
                console.info("动态检索条件为：" + ret);
                return ret;
            } else {
                console.dir(where);
                return where;
            }

        }


        /**
         * 动态条件检索
         * @param sheet
         * @param dsn
         */
        /**
         * @api {smartRetrieve} 函数   smartRetrieve
         *
         * @apiDescription  smartRetrieve( sheet, dsn, resetPage )
         * <br><br> 根据动态检索条件查询指定的结果集
         * <br>
         *
         * @apiName  smartRetrieve
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {WorkSheet} sheet  默认使用此WorkSheet来解析公式中的别名
         * @apiParam {String} dsn 要检索的结果集
         *@apiParam {boolean} resetPage  true 表示清空当前查询结果后重新检索， false 表示所检索的结果追加到当前检索结果后
         *
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *   form.smartRetrieve( book.sheet0  ,  "query1", true);
         *
         *
         */
        function smartRetrieve(sheet, dsn, resetPage) {

            showInfoPane("*正在检索...  ");
            setTimeout(function () {
                //2019.07.16  where 不要join起来 以支持在后端脚本中用代理检索数据
                var where = buildSmartRetrieveWhere(sheet, dsn, false);
                var retrieveContext = buildRetrieveContext(sheet, dsn);
                var ds = sheet.Book.getDataSource(dsn).dataStore;
                if (resetPage == undefined) resetPage = true;
                if (resetPage) ds.ignoreTopRow(0);
                // 2020.04.20 增加后台条件数据支持
                ds.retrieveContext = retrieveContext;
                ds.retrieve(where);
                hideInfoPane();
            }, 1);
        }

        function print_pageSetup(sheet) {
            if (sheet == undefined) sheet = book.getActiveSheet();
            sheet.showPageSetupDialog();
        }


        function print_preview(sheet) {
            if (sheet == undefined) sheet = book.getActiveSheet();
            sheet.showPageSetupDialog(function () {
                $print('preview', sheet);
            });

        }

        function print_printout(sheet) {
            $print('printout', sheet);
        }

        function $print(action, sheet) {

            if (sheet == undefined) sheet = book.getActiveSheet();

            var newWindow = null;
            if (action == 'preview') {

                newWindow = window.open('waitForPrint.jsp');
            }

            var fileType = "pdf";
            var splitChar = '\t';

            var sheetName = sheet.name;

            toastr.info("正在输出,在出现文件保存提示前不要做其它操作，请静候片刻...");


            //注意，exportAsPrintCommand返回的是一个Promise对象，用于异步执行
            sheet.exportAsPrintCommand().then(function (data) {


                $rpc("fop", "pdf.createPDF", "createPDFFile",
                    {
                        data: data,
                        bucketName: "pdf",
                        objectName: newGUID() + ".pdf"
                    },

                    function (retValue) {


                        var ret = JSON.parse(retValue);
                        if (ret.success) {
                            var bucketName = ret.bucketName;
                            var objectName = ret.objectName;

                            var url = "fileServer?bucketName=" + bucketName + "&objectName=" + objectName + "&action=preview";

                            if (action == 'printout') {

                                var f = document.getElementById('iframe_print');
                                f.src = url;
                                setTimeout(function () {
                                    f.contentWindow.print();
                                }, 200);


                            } else {

                                newWindow.location = url;

                            }

                        } else {
                            $.alert(ret.message);
                        }
                    }
                );
            });


        }


        function getPrintAgentURL() {
            var serverIP = 'localhost';
            return 'ws://' + serverIP + ':17999/ws';
        }

        function print_preview_byPrintAgent(sheet) {
            if (sheet == undefined) sheet = book.getActiveSheet();

            sheet.printByAgent(getPrintAgentURL(), true, true);

        }

        function print_printout_byPrintAgent(sheet) {
            if (sheet == undefined) sheet = book.getActiveSheet();
            sheet.printByAgent(getPrintAgentURL(), true, false);
        }


        function print_preview_byOtherPrintAgent(sheet) {
            if (sheet == undefined) sheet = book.getActiveSheet();

            inputBox("网络打印", "输入网络打印助手的地址", getPrintAgentURL(), "", function (url) {
                sheet.printByAgent(url, true, true);
            });

        }

//本函数仅在单据编辑界面中使用
        function quick_search() {

            if (isSaveNeeded()) {
                billSaveAsk($quick_search, "快速定位");

            } else {
                $quick_search();
            }

        }

        function $quick_search() {

            let key = $('#quickSearchKey').val();
            if (key.trim() == '') return;
            try {
                getIdByBillQuickSearch(key, function (ret) {
                    if (ret.success) {
                        if (ret.id != '') {
                            loadBill(ret.id, function () {
                                refreshRetrieveList();//列表中可能没有显示出这张单据，那么刷新出来它
                            });
                            return;
                        }
                    } else {
                        showInfoPane(ret.message, null, null, 2000);
                        return;
                    }
                });
            } catch (err)  // 到这里，通常是没有在模板后端脚本中实现 getIdByBillQuickSearch函数，因此默认用单据号去查
            {
            }

            $rpc("formEngine", "formengine.Bill", "findBill",
                {
                    key: key,
                    table: form.masterTableName,
                    templateid: form.configInfo.template_edit,//审核单据，使用编辑模板ID来获取单据信息
                    // 下面的是用来权限校验的
                    authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                    authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')
                },
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {
                        let id = ret.id;
                        loadBill(ret.id, function () {
                            refreshRetrieveList();//列表中可能没有显示出这张单据，那么刷新出来它
                        });
                        return;
                    } else {
                        showInfoPane(ret.message, null, null, 2000);
                    }

                });


        }

        function refreshScriptCache()
        {
        	//主要用于开发时，由于Jre6没有文件变化监控，所以当全局脚本修改，或源程序修改后，它们的版本号不能及时刷新，需要手工刷新一下，
        	//  生产系统中，不需要，除非也做了全局脚本的修改
            $rpc("formEngine", "formengine.Bill", "refreshScriptCache",
                    {
                        
                    },
                    function (retValue) {
                        toastr.info("服务端脚本版本号重建完成 ，请刷新本页面");

                    });
        	
        }
        
        
        /**
         * @api {loadBill} 函数   loadBill
         *
         * @apiDescription  loadBill(  id , callback)
         * <br><br> 在单据编辑界面中，使用本函数加载指定id的单据，加载后，执行回调函数callback
         *<br>细节，本函数仅仅是加载单据数据，并不会重新加载模板UI,初始化绑定等。在加载数据后，执行callback回调函数，
         * 然后再触发 formOpen事件  ， afterFormOpen事件
         *
         * @apiName  loadBill
         * @apiGroup FormGroup
         * @apiVersion 1.0.0
         *
         * @apiParam {String} id 单据的id，即单据主表的id
         * @apiParam {Function} callback 打开后，执行此回调函数

         *
         *
         *
         * @apiSuccess (返回值){void} - 无返回值
         *
         * @apiExample   {js}示例：
         *
         *  form.loadBill(  currentGUID()); // 重新打开当前单据
         *
         */
        function loadBill(gguid, callback) {

            let p = window["getTemplateConfigParameter"];
            //下因的函数，它不会重复初始UI，只会重新加载数据
            form.LT.getTemplateConfig(p.containerID, p.designMode, p.id, gguid, p.type, p.action, callback);
        }

        function loadAttachment(table, id) {

            $rpc("formEngine", "formengine.AttachmentManage", "getAttachmentList", {
                    tableName: table,
                    dataID: id
                },
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        var html = TrimPath.processDOMTemplate("template/template_attachment", ret);
                        $('#attachmentContainer').html(html);
                        $('#attachmentCount').text(ret.data.length);
                        $('#attachmentCount').css("display", ret.data.length > 0 ? "" : "none");
                        $('#icon_attachmentCount').css("display", ret.data.length > 0 ? "none" : "");

                    }

                });

        }

//原来的附件管理， 与文件服务器上传附件需要进行统一整合
        function deleteAttachment(tableName, dataID, attachmentID) {

            $rpc("formEngine", "formengine.AttachmentManage", "deleteAttachment", {
                    id: attachmentID,
                    //模板信息，用于后端脚本做删除的检测
                    authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                    authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

                },
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        loadAttachment(tableName, dataID);
                    } else {
                        toastr.error(ret.message);
                    }

                });

        }

        /**
         * 本函数在 loadTemplate.js中调用 ，用于图片附件重排序后的回调，将新的顺序写到数据库中
         * @param config
         * @param ids
         */
        function attachmentOrderChanged(config, ids) {
            $rpc("formEngine", "formengine.AttachmentManage", "attachmentOrderChanged", {
                    config: config,
                    ids: ids,
                    //模板信息，用于后端脚本做删除前的检测
                    authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                    authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

                },
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                    } else {
                        toastr.error(ret.message);
                    }

                });
        }

        function uploadFileInForm() {
            // 全局有个  uploadFile函数，现在没有用它， 出于兼容，该函数但是仍保留，
            //下面的上传，使用 axios ,更简单
        	
        	if( form.action!='edit')
        		{
        		   toastr.info("请先保存，再上传附件");
        		   return;
        		}
            $uploadFile({
                  
                    tablename: form.masterTableName,
                    id: form.GUID,
                    dbpool: '',
                    logTable: 'oa_bill_attachment'  ,
                    fileType: '*.*'
                },
                function (data) {

                    showInfoPane("*正在上传，完成 100 %");
                    setTimeout( function(){
                        hideInfoPane();
                    },300);

                    var src = $('#attachmentFrame')[0].src;
                    $('#attachmentFrame')[0].src = 'blank.html';
                    $('#attachmentFrame')[0].src = src; //刷新一下
                },

                function (evt) {

                    let percent = Math.round(evt.loaded / evt.total * 100);
                    if( percent=100)  percent=90; //很多时候，一上来就100% ，但是实际还要等一下
                    showInfoPane("*正在上传，完成 "+percent+" %");
                }
            );
        }


        function $uploadFile(configData, callback, onProgress) {

            //临时创建一个 file 选择对象
            var selectFile = $(`<input type="file"  
                            style="display:none;"  
                            multiple="multiple"  
                            accept="*.*" />
                        `);
            //必须加入文档中，不然不能触发事件
            selectFile.appendTo($(document.body));

            //模拟点击
            selectFile.click();
            //确认选择文件后，触发上传操作
            selectFile.unbind().change(function (e) {

                let form = new FormData(); // FormData 对象

                configData.responseType = "JSON"; //表示只需要返回JSON数据
                form.append("uploadData", encodeURI(JSON.stringify(configData))); //不做enodeURI，中文会乱码

                var files = e.target.files;
                for (let i = 0; i < files.length; i++) {
                    form.append("file_" + i, files[i], files[i].name);
                }

                let xhr = new XMLHttpRequest();  // XMLHttpRequest 对象

              /*
                xhr.open("post", "UploadFile", true); //post方式，url为服务器请求地址，true 该参数规定请求是否异步处理。
                xhr.withCredentials = true; // 允许跨域操作
                xhr.setRequestHeader('Content-Type', 'multipart/form-data');
                xhr.onload = callback; //请求完成
                xhr.upload.onprogress = onProgress;
                xhr.upload.onloadstart = callback.onloadstart ;//上传开始执行方法
                xhr.send(form); //开始上传，发送form数据

*/
                // 上面的上传也没问题， 下面也ok，但是都有一个毛病，上传进度不对，一上来就是100%
               axios.post("servlet/wiseoa.bill.rpc.UploadBillAttaichment", form, {
                    timeout: 1000000,
                    headers: {'Content-Type': 'multipart/form-data'},  //没用
                    withCredentials: true,
                    onUploadProgress: function (progressEvent) {
                        if (onProgress) onProgress(progressEvent);
                    }
                }).then(function (res) {
                    callback(res);
                })
                    .catch(function (err) {
                        console.error(err.message);
                    });

            });

        }
        
        /*
        2020.08.20 单据打印方案：

        1 打印模式放在一个iframe中加载 ，iframe坐标处于屏幕之外，等于视觉不可见
        2 仅在需要打印时，才加载打印模板，如果发现没有加载，那么加载它，并在打印模板加载完，并在执行后formOpen后再反调本函数继续打印
        3 打印纸张设置及选择打印机，是否预览等，是在单据列表或单据编辑窗口中进行的，因为打印模板窗口不可见，它里面弹出的面板也不可见
          所以需要在一个可见的地方打开打印设置面板。因此借用当前的book进行打印设置，设置的内容重定向保存到printFormatTemplateId指定的
          路径下，这样就类似于借鸡下蛋
        4 打印设置分两部分， printOption是打印机选择，份数，是否预览等临时选项， printConfig是页面大小，边距，打印比例，打印方向等设置
           这两个设置，以参数形式传出来，传到打印模板iframe中，对sheet0做打印
        5 所以整个过程 ，其实是分两个过程 ，一个是打印设置过程 ，一个是用设置真正打印的过程， 前者在单据列表或单据编辑界面中完成 printBillWithFormat，
          后者在打印格式模板所在的iframe中执行（ printBillWithPageSetup ）

        6  printBillWithPageSetup 是真正进行打印的处理，由于每张单据的打印是异步完成的，所以要处理好循环中的异步执行，必须是打印完一
          张单据后，才能继续下一张单据的打印。
        7 如果打印前需要预览，那么仅预览一张单据后就结束

   */

   //本函数在单据列表界面或单据编辑界面中执行
   function printBillWithFormat(printFormatTemplateId , sheetGUID) {

       var url = 'h5-billprint.jsp?id=' + printFormatTemplateId+"&sheet="+sheetGUID;

       if ($('#billPrintFrame')[0].src.indexOf(url) <0) {
           showInfoPane("*加载打印格式");
           $('#billPrintFrame')[0].src = url;
           // 在上面的页面加载完之后， 会再次调用printBillWithFormat，进入下面的操作中
           hideInfoPane();

           return;
       }

       
       var dsc = book.getDataSource(form.masterTableName);
       if (dsc == null) {
           toastr.error("列表模板中不存在名为" + form.masterTableName + "结果集");
           return;
       }

       //如果要实现多选打印，请在getIdListForBillToPrint事件中返回要打印的ID数组
       //如果没有写本事件，那么就取当前高亮的行
       var ids = handleEvent("getIdListForBillToPrint", null, [], '');

       if (ids == null || ids == '' || ids.length==0) {

           if( form.type=='billlist') {
               var row = dsc.currentBindRow;
               if (row >= 0) {
                   var ds = dsc.dataStore;
                   ids = ds.getString(row, "id");
               }
           }

           if( form.type=='bill')  ids=currentGUID();
       }

       if (ids == null || ids == '' || ids.length==0) {
           toastr.info("请选择一张单据");
           return;
       }

       if (!Util.isArray(ids)) ids = [ids]; //转成数组

       var sheet = book.getActiveSheet();
       //使用当前sheet来做打印设置，注意设置的内容转向到 printFormatTemplateId
       //并且只是显示页面设置对话框，sheet自已并不做打印，
       //在获取打印设置后，把参数传给打印页，再打印
       //之所以要这么处理，是因为打印页面，是不可见的， 在它上面弹出打印设置弹窗，也不可见
       //所以借用当前的界面，当前的Sheet来做打印设置，而设置内容将转向保存到 printFormatTemplateId 中
       //
       sheet.printByAgent(getPrintAgentURL(),
           true/*显示打印设置窗口*/,
           false/*默认打印前不预览，如果需要，可手工在打印设置里勾选*/,
           function (printOption, printConfig) //打印设置确认后的回调
           {
               console.dir(printOption);
               //把打印选项加载到打印页面中
               $('#billPrintFrame')[0].contentWindow.form.printBillWithPageSetup(
                   printFormatTemplateId,
                   sheetGUID,
                   printOption,
                   printConfig,
                   ids
               );
           },
           printFormatTemplateId+"#"+sheetGUID //打印设置保存的重定向
       );

   }


   /**
    * 本函数在单据打印页面中执行
    * 从外部直接传入页面设置，打印设置，及需要打印的单据的ID清单
    * @param printFormatTemplateId  打印模板ID
    * @param printOption   打印选项，打印机名称，份数，
    * @param printConfig  页面设置，边距，比例等
    * @param ids  要打印的单据的ID数组
    */
   function printBillWithPageSetup(printFormatTemplateId,sheetGUID, printOption/*打印机，份数*/, printConfig/*边距，缩放*/, ids) {
       let sheet = book.getWorkSheet( sheetGUID); 
       //加载页面设置
       sheet.setPageConfig(printConfig.paper,
           printConfig.pageWidth, printConfig.pageHeight, //纸张尺寸
           printConfig.leftMargin, printConfig.topMargin, printConfig.rightMargin, printConfig.bottomMargin,//边距
           printConfig.printDir, //打印方向
           printConfig.pageHeaderConfig, //页首设置
           printConfig.pageFooterConfig, //页脚设置
           printConfig.printScale //打印比例
       );

       //printOneBill是一个Promise对象，
       var printOneBill= function( printOption , id) {
           return new Promise(function (resolve, reject) {
               //加载数据
               //先看有没有在事件中定制数据检索


               let load = handleEvent("retrieveBillToPrint", null, [id], false);
               if (!load) //如果没有定制的加载数据，那么直接默认处理
               {
                   let dsCount = book.getDataSourceCount();
                   for (let di = 0; di < dsCount; di++) {
                       let ds = book.getDataSource(di).dataStore;
                       ds.retrieve(" gguid='" + id + "' ");
                   }
               }
               //加载完数据后，打印
               sheet.printByAgent(getPrintAgentURL(), false /*不需要再显示打印设置对话框*/, true,
                   null /*不显示打印设置，也就不需要回调*/, null /*不需要打印设置对话框，本参数也不需要*/,
                   printOption,
                   function () //打印助手在收到全部打印命令后，本回调会被执行
                   {
                       hideInfoPane();
                       resolve();
                   }
               );
           });
       }
       console.info("有"+(ids.length )+"张单据需要打印" );
       var  letsGo  = async function() {
           for (let i = 0; i < ids.length; i++) {
               let id = ids[i];
               showInfoPane("*准备打印第"+(i+1)+"张单据");
               console.info("准备打印第"+(i+1)+"张单据：id="+id);
               await printOneBill(printOption, id);
               if( printOption.previewBeforePrint) break; //如果打印前先预览，那么只预览一张，就终止
           }
       }

       letsGo();

   }


   //***************************************************************************************

    

        var ret = {
            print_preview_byPrintAgent: print_preview_byPrintAgent,
            handleEvent: handleEvent,
            newBill: newBill,
            editBill: editBill,
            viewBill: viewBill,
            deleteBill: deleteBill,
            verifyBill: verifyBill,

            save: save,
            isSaveNeeded: isSaveNeeded,
            backToBillList: backToBillList,
            export_png: export_png,
            export_excel: export_excel,
            export_excel2: export_excel2,
            import_xls: import_xls,

            export_pdf: export_pdf,
            export_txt: export_txt,
            export_csv: export_csv,


            search: search,

            //下面4个函数在billEdit中使用
            goto_firstRecord: goto_firstRecord,
            goto_priorRecord: goto_priorRecord,
            goto_nextRecord: goto_nextRecord,
            goto_lastRecord: goto_lastRecord,

            //下面4个在billlist中使用
            focus_firstRecord: focus_firstRecord,
            focus_priorRecord: focus_priorRecord,
            focus_nextRecord: focus_nextRecord,
            focus_lastRecord: focus_lastRecord,
            currentBillIndex: currentBillIndex,
            //在编辑窗口中快速查询
            quick_search: quick_search,
            //在编辑窗口中加载指定gguid的单据
            loadBill: loadBill,

            print_pageSetup: print_pageSetup,
            print_preview: print_preview,
            print_printout: print_printout,

            print_preview_byPrintAgent: print_preview_byPrintAgent,
            print_printout_byPrintAgent: print_printout_byPrintAgent,
            print_preview_byOtherPrintAgent: print_preview_byOtherPrintAgent,


            enableOrDisableResize: enableOrDisableResize,
            smartRetrieve: smartRetrieve,
            buildSmartRetrieveWhere: buildSmartRetrieveWhere,
            buildRetrieveContext: buildRetrieveContext,
            refreshRetrieve: refreshRetrieve,//刷新行
            refreshRetrieveList: refreshRetrieveList,
            loadAttachment: loadAttachment,
            deleteAttachment: deleteAttachment,
            attachmentOrderChanged: attachmentOrderChanged,
            popup: popup,
            uploadFile: uploadFileInForm ,
            refreshScriptCache:refreshScriptCache,
            
            printBillWithFormat: printBillWithFormat,
            printBillWithPageSetup: printBillWithPageSetup
            
           
        };

        window.$form = ret;

//暴露为全局函数
        window.smartRetrieve = ret.smartRetrieve;
        window.buildSmartRetrieveWhere = ret.buildSmartRetrieveWhere;
        window.$popup = ret.popup;

        return ret;
    }
)
;


/**
 * @api {smartRetrieve} 函数   smartRetrieve
 *
 * @apiDescription  smartRetrieve( sheet, dsn , resetPage )
 * <br><br> 根据动态条件，检索指定的结果集。“检索按钮”点击后，会根据操作者输入的条件，
 * 构建数据检索条件，然后检索指定的结果集，点击这个“检索按钮”与执行本函数是一样的效果。
 * <br>
 *
 * @apiName  smartRetrieve
 * @apiGroup FormGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {WorkSheet} sheet  指定解析动态条件的工作表，通常是结果集绑定显示的工作表
 * @apiParam {String} dsn  结果集名称
 * @apiParam {boolean} resetPage [可选参数，默认是true] true表示页码复位，重新检索第一页，false表示检索当前页码指定的数据
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  smartRetrieve( book.sheet0 , 'query1');
 *
 *   smartRetrieve( book.sheet0 , 'query1' , false);
 */

/**
 * @api {buildSmartRetrieveWhere} 函数   buildSmartRetrieveWhere
 *
 * @apiDescription  buildSmartRetrieveWhere( sheet , dsn  )
 * <br><br> 根据用户输入的数据，构建动态检索条件
 * <br>
 *
 * @apiParam {WorkSheet} sheet  指定解析动态条件的工作表，通常是结果集绑定显示的工作表
 *@apiParam {String} dsn  结果集名称
 *
 * @apiGroup FormGroup
 * @apiVersion 1.0.0
 *
 * @apiSuccess (返回值){String} - 返回构建好的where条件
 *
 * @apiExample   {js}示例：
 *
 *   buildSmartRetrieveWhere( book.sheet0 , 'query1');
 *
 */














