/**
 * 把 workbook 输出成xml，传到后端再转成excel
 * 为什么要先转成xml  ,是因为后端已经做好了xml 转excel
 */

define(function (require) {

    const Class = spreadsheet.base.Class;
    const Util =  spreadsheet.util.Util ;
    const Tools = spreadsheet.util.Tools;
    const EditStyle =  spreadsheet.core.EditStyle;
    const DataSourceConfig = spreadsheet.core.DataSourceConfig;

    const UniformDataType =spreadsheet.core.UniformDataType;

    const XmlWriter = require("../form/XmlWriter");

    const lineSeparator = "\n";

    var exportUtil = Class.extend({

        constructor: function () {

        },


        // 得到一个xml格式的文件，它用来输出到Excel
        UI2XML: function (book,   dsRowCountConfig) {

            if(dsRowCountConfig==null) dsRowCountConfig={};
            var xml = new XmlWriter();

            xml.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            xml.CR();
            xml.S("workbook")
                .A("version", "1.0")
                .A("sheetcount", book.getWorkSheetCount())
                .A("gui", "true")   ;

            for (var i = 0; i < book.getWorkSheetCount(); i++) {

                var sheet = book.getWorkSheet(i);
                // Sheet 常规属性
                xml.CR();
                xml.S("worksheet").A("index", i)
                    .A("rowcount", sheet.rowCount)
                    .A("columncount", sheet.columnCount)
                    .A("guid", sheet.guid)
                    .A("code", sheet.code)
                    .A("name", sheet.name)
                    .A("mode", "run")
                    .A("rowheadervisible", "true")
                    .A("columnheadervisible", "true")
                    .A("visibleInTabContainer", sheet.visibleInTabContainer)
                    .A("visible", sheet.visible);

                // 行高
                var RPM = sheet.RPM;
                var RC = sheet.rowCount;
                for (var ri = 0; ri < RC; ri++) {
                    var h = RPM.getRowHeight(ri);
                    xml.S("row").A("index", ri).A("height", h).E();
                }

                //内部数据行数
                //如果有多行数据源， 记录下多行数据源所在的行号， 以及它的起始行，终止行，跨行数
                //为什么有起始行，终止行：因为允许折行绑定同一个多行数据源
                for (var ri = 0; ri < RC; ri++) {

                    var mrdsn = RPM.getMultiRowDataSourceName(ri);
                    if (mrdsn == '') continue;


                    //如果绑定到多行数据源，那么看看整个多行绑定区的总高度，
                    var firstSameBindRow = RPM.findFirstRowWhichBindToMultiRowDataSource(mrdsn);
                    var lastSameBindRow = RPM.findLastRowWhichBindToMultiRowDataSource(mrdsn);

                    xml.CR();

                    var rc=book.getDataSource(mrdsn).dataStore.rowCount;

                    //可能需要更多的空行，可以强制设置行数
                    if( dsRowCountConfig[mrdsn]!=null)    rc =Math.max( rc,   dsRowCountConfig[mrdsn]);


                    xml.S("innerrow")
                        .A("index", ri)
                        .A("count", rc)
                        .A("lastSameBindRow", lastSameBindRow)
                        .A("firstSameBindRow", firstSameBindRow)
                        .A("rowspan", lastSameBindRow - firstSameBindRow + 1)
                        .E();
                }

                // 列宽
                var CPM = sheet.CPM;
                var CC = sheet.columnCount;
                for (var ci = 0; ci < CC; ci++) {
                    var cw = CPM.getColumnWidth(ci);
                    xml.CR();
                    xml.S("column").A("index", ci).A("width", cw).E();

                }

                // 单元格

                for (var row = 0; row < RC; row++) {
                    for (var col = 0; col < CC; col++) {
                        if (sheet.isCellNull(row, col)) continue;
                        let cell = sheet.cells(row, col);
                        xml.CR();
                        this.SaveCell(xml, cell ,dsRowCountConfig);
                    }
                }

                xml.E(); // close Sheet
            }// end for

            xml.E(); // close Wook


            return xml.toString();
        },


        /**
        *
        *
        * @param xml
        * @param cell
        *
        */
       SaveCell: function (xml, cell, dsRowCountConfig) {


           var rowCount = 0;
           // 合并

           if (cell.isMerged()) {
               var mcell = cell.mergedBy();
               if (cell != mcell) return; // 如果是被合并的，且不是最左上角的单元格，那么忽略它

           }

           if (!cell.visible) return; //  如果不可见，那么不需要处理

           var datatype = "" + UniformDataType.$Auto;

           var s;

           var cellValue = "";
           var multiLine = false;

           var dbc = cell.Bind;
           var bindInfo = "";

           if (dbc != null) {
               bindInfo = dbc.dataSource + '.' + dbc.DBCol;
               var dsc = book.getDataSource(dbc.dataSource);
               var ds = dsc.dataStore;
               datatype = dsc.dataStore.getColumnProperty(dbc.DBCol).getUniformDataType();

               var RPM = cell.Sheet.RPM;
               var rowIndex = cell.rowIndex;

               var dbrow = 0;

               if (dbc.dataSourceType == DataSourceConfig.SingleRowDataSource) {
                   cellValue = ds.getValue(0, dbc.DBCol);
                   s = cell.getTextForExport(0);
                   rowCount = 1;

               } else if (dbc.dataSourceType == DataSourceConfig.AsSingleRowDataSource) {
                   dbrow = dsc.currentBindRow;
                   cellValue = ds.getValue(dbrow, dbc.DBCol);
                   s = cell.getTextForExport(dbrow);
                   rowCount = 1;
               } else {
                   cellValue = [];
                   s = [];
                   rowCount = ds.rowCount;
                   //是不是字符串
                   var isString = ds.getColumnProperty(dbc.DBCol).getUniformDataType() == spreadsheet.core.UniformDataType.$String;
                   for (var row = 0; row < rowCount; row++) {
                       cellValue.push(ds.getValue(row, dbc.DBCol));
                       var t = cell.getTextForExport(row);
                       //2021.09.30 多行绑定的数据中，如果字符型的内容它包含回车，那么去掉它，可能导致输出Excel异常
                       if( isString) t=t.replace(/\r\n/g,'').replace(/\n/g,''); //去掉其中的回车换行

                       s.push(t);
                   }
                   //如果设置了行数，那么补齐不足的行数
                   if (dsRowCountConfig[dbc.dataSource] != null) {
                       var rc = dsRowCountConfig[dbc.dataSource];
                       for (var i = rowCount; i < rc; i++) {
                           s.push('');
                       }
                   }
                   rowCount = Math.max(rowCount, rc);

                   cellValue = JSON.stringify(cellValue);
                   s = JSON.stringify(s);
                   multiLine = true;
               }


           } else {
               cellValue = cell.getValue();
               if (Util.isArray(cellValue)) {
                   s = [];
                   rowCount = cellValue.length;
                   for (var i = 0; i < rowCount; i++) {
                       s.push(cell.getTextForExport(i));
                   }

                   cellValue = JSON.stringify(cellValue);
                   s = JSON.stringify(s);
                   multiLine = true;

               } else {
                   s = cell.getTextForExport();
                   rowCount = 1;
               }
               datatype = cell.getCellValueType();

           }

           xml.S("cell").A("row", cell.rowIndex)
               .A("col", cell.columnIndex)
               //    .A("value", cellValue)
               .A("multiline", multiLine)
               .A("datatype", datatype)
               .A("rowcount", rowCount)
               .A("datatype", datatype);

           if (bindInfo != '') xml.A("bind", bindInfo);

           if (cell.isMerged()) {
               var r = cell.getMergedRange();
               xml.A("rowspan", r.endRow - r.startRow + 1);
               xml.A("colspan", r.endCol - r.startCol + 1);
           }

           //属性

           var p = cell.getPropertyObject();
           //不是缺省属性
           if (p != book.PM[0]) {
               var prop = {};
               for (var pn in p.property) {
                   var v = p.property[pn];
                   if (v == book.PM[0].get(pn)) continue;//如果就是默认值，那么就不需要
                   if (v == null) continue;
                   if (v == "") continue;

                   if (Util.isClas$(v)) {
                       if (v.instanceOf(Color)) {
                           v = v.color;
                       }
                   }

                   prop[pn] = v;
                   xml.A(pn, v);
               }

               var ps = JSON.stringify(prop);
               xml.A("property", Tools.MD5(ps));   //这些属性计算一个MD5，如果MD5相同的，属性肯定是相同，避免在输出时，创建过多的属性对象

           }

           //编辑格式

           var es = cell.getEditStyle();
           if (es != null) {
               var et = es.ET;
               switch (et) {
                   case EditStyle.$Normal:
                       xml.A("edittype", "normal");
                       break;

                   case EditStyle.$MultiLine:
                       xml.A("edittype", "multiline");
                       break;
                   case EditStyle.$Datetime:

                       xml.A("edittype", "datetime");
                       xml.A("datetimeFormat", es.datetimeFormat);
                       break;
                   case EditStyle.$Numeric:
                       xml.A("edittype", "numeric");
                       xml.A("showComma", es.showComma);
                       xml.A("decimalCount", es.decimalCount);
                       xml.A("zeroVisible", es.zeroVisible);

                       break;
                   case EditStyle.$DDLB:
                   case EditStyle.$RadioButton:
                   case EditStyle.$MultiCheckBox:
                       xml.A("edittype", "ddlb");
                       xml.A("ddlbName", es.ddlbName);
                       break;
                   case EditStyle.$CheckBox:
                       xml.A("edittype", "checkBox");
                       xml.A("checkOnValue", es.checkOnValue);
                       xml.A("checkOffValue", es.checkOffValue);
                       break;
                   case EditStyle.$Tree:
                       xml.A("edittype", "tree");

                       break;
               }
           }

           xml.W(s); // text
           xml.E();

       }

    });


    return exportUtil;
});



