define(function (require) {

    const Class = spreadsheet.base.Class ;
    const  lineSeparator = '\n';

    var XmlWriter = Class.extend({

        constructor: function () {
            this.writer = [];
            this.stack = [];
            this.attrs = {};
            this.empty = true;
            this.closed = true;

        },

        write:function(str)
        {
            this.writer.push(str);
            return this;
        },

        CR:function()
        {
            this.writer.push( this.lineSeparator);
            return this;
        },

        toString:function()
        {
            return this.writer.join('');
        },

        S: function (name) {
            return this.writeEntity(name);
        },

        writeEntity: function (name) {

            this.closeOpeningTag();
            this.closed = false;
            this.writer.push("<");
            this.writer.push(name);
            this.stack.push(name);
            this.empty = true;
            return this;

        },

        // close off the opening tag
        closeOpeningTag: function () {
            if (!this.closed) {
                this.writeAttributes();
                this.closed = true;
                this.writer.push(">");
            }
            return this;
        },

        // write out all current attributes
        writeAttributes: function () {
            if (this.attrs != null) {
                for (var p in this.attrs) {

                    this.writer.push(" " + p);
                    this.writer.push("=");
                    this.writer.push('"');
                    this.writer.push(this.attrs[p]);
                    this.writer.push('" ');
                }
                this.attrs = {};
                this.empty = false;
            }
        },

        A: function (attr, value) {
            return this.writeAttribute(attr, value);
        },

        writeAttribute: function (attr, value) {

            if (this.attrs == null) {
                this.attrs = {};
            }
            this.attrs[attr] = this.escapeXml(value);
            return this;
        },

        E: function () {
            return this.endEntity();
        },

        endEntity: function () {

            if (this.stack.length == 0) return;
            var name = this.stack.pop();
            if (this.empty) {
                this.writeAttributes();
                this.writer.push("/>");
            } else {
                this.writer.push("</");
                this.writer.push(name);
                this.writer.push(">");
            }
            this.writer.push(lineSeparator);
            this.empty = false;
            this.closed = true;
            return this;
        },

        close: function () {
            if (this.stack.length != 0) {
                console.error("Tags are not all closed. " + "Possibly, " + this.stack.pop() + " is unclosed. ");
            }
        },

        W: function (text) {
            return this.writeText(text);
        },

        writeText: function (text) {

            this.closeOpeningTag();
            this.empty = false;
            this.writer.push(this.escapeXml(text));
            return this;
        },

        escapeXml: function (str) {
            if( typeof(str)!='string') return str;

            str = str.replace(/[&]/g, "&amp;");
            str = str.replace(/[<]/g, "&lt;");
            str = str.replace(/[>]/g, "&gt;");
            str = str.replace(/[\\]/g, "&quot;");
            str = str.replace(/[']/g, "&apos;");
            str = str.replace(/["]/g, "&quot;");



            return str;
        }
    });

    return XmlWriter;
});
