define(function (require) {

        const RowPropertyMannage =spreadsheet.core.RowPropertyManage;
        const $ES = spreadsheet.core.EditStyle;

 


 

        function saveTemplate(book, id) {

            var s = saveUI(book);


            $rpc("formEngine", "formengine.SaveTemplate", "save",
                {

                    id: id,
                    template: s
                },

                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {
                        toastr.success('保存成功');

                    } else {
                        $.alert(ret.message);
                    }
                }
            );
        }


        function saveUI(book) {
            var workbook = {};

            var checkPoint = {}; //权限控制点

            try {

                workbook.version = "1.0";
                workbook.sheetcount = book.workSheetCount;
                workbook.gui = true;
                workbook.theme = 'default'
                workbook.showTabOnBottom = false;
                //属性缓存先清空
                book.propertyCache={};
                book.propertyIdList=[];

                workbook.sheets = [];

                for (var i = 0; i < book.workSheetCount; i++) {

                    var sheet = book.getWorkSheet(i);
                    var fe = sheet.getFreezedCell();
                    var freezedRow = 0;
                    var freezedCol = 0;
                    if (fe != null) {
                        freezedRow = fe.rowIndex;
                        freezedCol = fe.columnIndex;
                    }

                    var worksheet = {};
                    workbook.sheets.push(worksheet);
                    worksheet.index = i;
                    worksheet.rowCount = sheet.rowCount;
                    worksheet.columnCount = sheet.columnCount;
                    worksheet.guid = sheet.guid;
                    worksheet.name = sheet.name;
                    worksheet.gridLineVisible = sheet.gridLineVisible;
                    worksheet.freezedRow = freezedRow;
                    worksheet.freezedCol = freezedCol;
                    worksheet.ignoreBeforeRowWhenPrinting= sheet.ignoreBeforeRowWhenPrinting; //打印忽略行


                    worksheet.rows = [];
                    // 行高
                    var RPM = sheet.RPM;
                    var rc = sheet.rowCount;
                    for (var ri = 0; ri < rc; ri++) {
                        var h = RPM.getRowHeight(ri);

                        var stretch = RPM.getRowStretchHeight(ri);
                        var isColumnScrollEnabled = RPM.isColumnScrollEnabled(ri);


                        var rowProp = {
                            index: ri,
                            height: parseInt(h),
                            isColumnScrollEnabled: isColumnScrollEnabled,
                            stretchHeight: stretch
                        };
                        worksheet.rows.push(rowProp);


                    }

                    // 列宽
                    var CPM = sheet.CPM;
                    var cc = sheet.columnCount;
                    worksheet.columns = [];
                    for (var ci = 0; ci < cc; ci++) {
                        var cw = CPM.getColumnWidth(ci);
                        var cw2 = CPM.getColumnWidth2(ci);

                        var stretch = CPM.getColumnStretchWidth(ci);

                        var colProp = {
                            index: ci,
                            width: parseInt(cw),
                            width2: parseInt(cw2),
                            stretchWidth: parseInt(stretch)
                        };

                        worksheet.columns.push(colProp);

                    }
                    //焦点区域
                    var fl = sheet.getFocusRangeList();
                    worksheet.focusRange = fl;

                    // 单元格

                    var cells = [];
                    worksheet.cells = cells;
                    for (var row = 0; row < rc; row++) {
                        for (var col = 0; col < cc; col++) {
                            if (sheet.isCellNull(row, col)) continue;
                            var cell = sheet.cells(row, col);
                            var serialize = cell.serialize;
                            if (serialize == null) continue;

                            cells.push(serialize);

                            //权限控制点的处理
                            // 单元格点击的控制
                            if (cell.appData) {
                                if (cell.appData.clickControlEnabled) {
                                    if (checkPoint[sheet.guid] == undefined) checkPoint[sheet.guid] = {name: sheet.name};
                                    if (checkPoint[sheet.guid]['cellClick'] == undefined) checkPoint[sheet.guid]['cellClick'] = [];
                                    checkPoint[sheet.guid].cellClick.push({
                                        name: cell.alias == '' ? cell.name : cell.alias,
                                        title: cell.appData.clickControlTip ||''
                                    });
                                }
                            }

                            if (serialize.bricks) {
                                for (var bi = 0; bi < serialize.bricks.length; bi++) {
                                    var brick = serialize.bricks[bi];
                                    if (['button'].contains(brick.type)) {
                                        if (checkPoint[sheet.guid] == undefined) checkPoint[sheet.guid] = {name: sheet.name};
                                        if (checkPoint[sheet.guid]['buttonClick'] == undefined) checkPoint[sheet.guid]['buttonClick'] = [];
                                        checkPoint[sheet.guid].buttonClick.push({
                                            name: brick.name,
                                            title: brick.config.caption
                                        });
                                    }
                                }
                            }
                        }
                    }


                }


                //在cell.serilizeTo 中下面两个属性会填充起来
                workbook.propertyCache=book.propertyCache;
                workbook.propertyIdList=book.propertyIdList;



            } catch (e) {

                return "";
            }


            return {
                ui: JSON.stringify(workbook),
                rightcheckpoint: JSON.stringify(checkPoint)
            };

        }


        return {
            saveTemplate: saveTemplate,
            saveUI: saveUI
        };

    }
);


