
//本文件用在旧的模板设计界面中，把旧的模板生成新的模板配置 

function Save2(applet) {
    saveTemplate(applet.book, applet.TemplateID);


}


function saveTemplate(book, id) {

    var s = saveUI(book);
    

   //这个rpc是旧版RPC，少一个参数
    $rpc("formengine.SaveTemplate", "save",
        {

            id: id,
            template:{ui: s}
        },

        function (retValue) {
            var ret = JSON.parse(retValue);
            if (ret.success) {
                 

            } else {
                 alert(ret.message);
            }
        }
    );
}


function saveUI(book) {
	
 
    var workbook = {};

    var checkPoint = {}; // 权限控制点

    try {

        workbook.version = "1.0";
        workbook.sheetcount = book.getWorkSheetCount();
        workbook.gui = true;
        workbook.theme = 'default'
        workbook.showTabOnBottom = false;
        // 属性缓存先清空
        // book.propertyCache={};
        // book.propertyIdList=[];

        workbook.sheets = [];

       
        for (var i = 0; i < workbook.sheetcount; i++) {

            var sheet = book.getWorkSheet(i);
            var fe = sheet.getFreezedCell();
            var freezedRow = 0;
            var freezedCol = 0;
            if (fe != null) {
                freezedRow = fe.getRowIndex();
                freezedCol = fe.getColumnIndex();
            }

            var worksheet = {};
            workbook.sheets.push(worksheet);
            worksheet.index = i;
            worksheet.rowCount = sheet.getRowCount();
            worksheet.columnCount = sheet.getColumnCount();
            worksheet.guid = sheet.getGUID();
            worksheet.name = sheet.getName();
            worksheet.gridLineVisible = sheet.getGridLineVisible();
            worksheet.freezedRow = freezedRow;
            worksheet.freezedCol = freezedCol;
            worksheet.ignoreBeforeRowWhenPrinting = 0; // 打印忽略行


            worksheet.rows = [];
            // 行高
            var RPM = sheet.getRowPropertyManage();
            var rc = sheet.getRowCount();
            for (var ri = 0; ri < rc; ri++) {
                var h = RPM.getRowHeight(ri);

                var stretch = RPM.getRowStretchHeight(ri);
                var isColumnScrollEnabled = RPM.isColumnScrollEnabled(ri);


                var rowProp = {
                    index: ri,
                    height: parseInt(h),
                    isColumnScrollEnabled: isColumnScrollEnabled,
                    stretchHeight: stretch
                };
                worksheet.rows.push(rowProp);


            }

            // 列宽
            var CPM = sheet.getColumnPropertyManage();
            var cc = sheet.getColumnCount();
            worksheet.columns = [];
            for (var ci = 0; ci < cc; ci++) {
                var cw = CPM.getColumnWidth(ci);
                var cw2 = CPM.getColumnWidth2(ci);

                var stretch = CPM.getColumnStretchWidth(ci);

                var colProp = {
                    index: ci,
                    width: parseInt(cw),
                    width2: parseInt(cw2),
                    stretchWidth: parseInt(stretch)
                };

                worksheet.columns.push(colProp);

            }
            // 焦点区域
            var fl = sheet.getFocusRangeList();
            worksheet.focusRange = fl;

            // 单元格

            var cells = [];
            worksheet.cells = cells;
            for (var row = 0; row < rc; row++) {
                for (var col = 0; col < cc; col++) {
                    if (sheet.isCellNull(row, col)) continue;
                    var cell = sheet.cells(row, col);
                    var serialize = cellSerialize(cell);
                    if (serialize == null) continue;

                    if( ! isNullCell(serialize))          cells.push(serialize);

                    // 权限控制点的处理
                    // 单元格点击的控制
                    /*
                     * if (cell.appData) { if
                     * (cell.appData.clickControlEnabled) { if
                     * (checkPoint[sheet.guid] == undefined)
                     * checkPoint[sheet.guid] = {name: sheet.name}; if
                     * (checkPoint[sheet.guid]['cellClick'] ==
                     * undefined) checkPoint[sheet.guid]['cellClick'] =
                     * []; checkPoint[sheet.guid].cellClick.push({ name:
                     * cell.alias == '' ? cell.name : cell.alias, title:
                     * cell.appData.clickControlTip ||'' }); } }
                     *
                     * if (serialize.bricks) { for (var bi = 0; bi <
                     * serialize.bricks.length; bi++) { var brick =
                     * serialize.bricks[bi]; if
                     * (['button'].contains(brick.type)) { if
                     * (checkPoint[sheet.guid] == undefined)
                     * checkPoint[sheet.guid] = {name: sheet.name}; if
                     * (checkPoint[sheet.guid]['buttonClick'] ==
                     * undefined) checkPoint[sheet.guid]['buttonClick'] =
                     * []; checkPoint[sheet.guid].buttonClick.push({
                     * name: brick.name, title: brick.config.caption }); } } }
                     */
                }
            }


        }


        // 在cell.serilizeTo 中下面两个属性会填充起来


    } catch (e) {

    	alert("error" + JSON.toString(e));
        return "";
    }

    return JSON.toString(workbook);

}


//如果一个单元格，只有  row,col 两个属性，那么它就是一个空的单元格
function isNullCell(pp)
{
	 
	 for(var p  in pp  ) {
         
     if( p!='row' && p!='col') return false;     
     }
	 return true;
}

var EditStyle = {
    // 编辑类型
    $Normal: 0,
    $Numeric: 1,
    $MultiLine: 2,
    $Datetime: 3,
    $DDLB: 4,
    $CheckBox: 5,
    $RadioButton: 6,
    $RichText: 7,
    $MultiCheckBox: 8,
    $Tree: 9
};

var Brick ={
		BrickAction_Nothing : 0,
		BrickAction_InsertBefore : 1,
		BrickAction_InsertAfter : 2,
		BrickAction_DeleteRow : 3,
		BrickAction_CloneRow : 20,
		BrickAction_NormalButton : 4,
		BrickAction_ShowAsImage : 5,
		BrickAction_ShowAsLine : 6,
		BrickAction_ShowBorder : 7,
		BrickAction_AsButton : 8,
		BrickAction_AsButtonLoadImageToDS : 9,
		BrickAction_AsButtonLoadImageToCell : 10,
		BrickAction_AsButtonCameraToDS : 11, //打开摄像功能，照像，照片放到Cell里
		BrickAction_AsButtonCameraToCell : 12,//打开摄像功能，照像，照片放到数据库里
		BrickAction_RetrieveButton : 13, //触发一个让结果集检索的按钮
		BrickAction_RotatedText : 14, //旋转文字
		BrickAction_Chart : 15, // 图表
		BrickAction_SwitchHandle : 16, // 加号减号切换的按钮
		BrickAction_PageBar : 17, // 分页栏
		BrickAction_ImageButton : 18,
		BrickAction_Tree : 19
};



function cellSerialize(cell) {
    var ret = {};

    try {
        if (cell.isMerged()) {
            var mcell = cell.mergedBy();
            if (cell != mcell) return null; // 如果是被合并的，且不是最左上角的单元格，那么忽略它
        }

        ret.row = cell.getRowIndex();
        ret.col = cell.getColumnIndex();

       // console.info("row:"+ ret.row+", col:"+ ret.col);
        if( ret.row==4 && ret.col==3 )
        	{
        	  var debug;
        	  debug=true;
        	}
        if (cell.getDefine() != '') ret.define = cell.getDefine();
        if (!cell.isVisible()) ret.visible = cell.isVisible();
        if (cell.isEditable()) ret.editable = true;
//        if (cell.getViewAs() != '') ret.viewAs = cell.getViewAs();

        if (cell.getTag() != '' && cell.getTag()!=null ) ret.tag = cell.getTag();
        // TODO
        // if (cell.appData) ret.appData = cell.appData;


        var vt = cell.getCellValueType();

        if (vt !=99) ret.cellValueType = vt;

        if (cell.isMerged()) {
            var r = cell.getMergedRange();
            ret.rowSpan = r.getEndRow() - r.getStartRow() + 1;
            ret.colSpan = r.getEndCol() - r.getStartCol() + 1;
        }

        // 别名
        var alias = cell.getAlias();
        if (alias != '') ret.alias = alias;


        // 下面是旧的属性导出代码，常规的不需要这么导出
        // 但是当跨模板进行超级复制粘贴时，不可能再用book.propertyCache 和 propcertyIdList来共享，
        // 这种情况下， 属性必须直接输出
        // 不是缺省属性

        var p = cell.getProperty();
        var prop = {"font-size":12};
        if( ret.define)  if( ret.define.indexOf("\\n")>0)  prop['word-wrap']='normal' ;// 强制多行
        var pc=0;
     

        var it = p.getPropertyNames().iterator();
        while (it.hasNext()) {
            var propName =''+ it.next();
          

            var v = cell.getPropertyValue(propName);
            if (v == null) continue;
    
            if (cell.isPropertyDefault(propName) &&  propName!='font-size') {

                continue; // 是缺省的属性，不要记录
            }

            if( propName=='align-h')  propName='text-align';
            if( propName=='align-v')  propName='vertical-align';
            
            if( propName=='font-name') propName='font-family';
            if( propName=='font-color') propName='color';
          
            if( propName=='font-color-expression')  propName='color-expression';
            
     
            
             if (  isJavaColor( v ) )  v= color2Hex( v);
            prop[propName] = v;
            pc++;

        }

        //如果都是默认属性，那么不要保存属性设置
        if( pc >0)    ret.property = prop;
        

        if (cell.getBind() != null) {
            var bind = cell.getBind();
            ret.bind = {
                dataSource: bind.getDataSource(),
                DBCol: bind.getDBCol(),
                dsType: bind.getDataSourceType()
            };

        }

        if (cell.getEditStyle() != null) {
            var es = cell.getEditStyle();

            var et = es.getEditType();
            var one = {
                editType: et
            };

            ret.editstyle = one;

            switch (et) {
                case EditStyle.$Normal:
                    one.inputAttribute = "";
                    break;
                case EditStyle.$MultiLine:
                    break;
                case EditStyle.$Datetime:
                     var f= ''+es.getDatetimeFormat();
                     f=f.replace(/YYYY/g , 'yyyy');
                     f=f.replace(/DD/g , 'dd');
                     f=f.replace(/hh/g , 'HH');
                      
                     one.datetimeFormat=f;
                    break;
                case EditStyle.$Numeric:
                    one.showComma = es.isShowComma();
                    one.decimalCount = es.getDecimalCount();
                    one.zeroVisible = es.isZeroVisibleWhenUneditable();
                    break;
                case EditStyle.$DDLB:
             
                	one.editType = et;
                	if( es.isListShowAsDDLB()) one.editType =  EditStyle.$DDLB;
                	if( es.isListShowAsRadioButton()) one.editType =  EditStyle.$RadioButton;
                	if( es.isListShowAsCheckBox()) one.editType =  EditStyle.$MultiCheckBox;
                	if( es.isListShowAsDropdownCheckBox())
                		{
                		alert(cell.getName()+"下拉多选编辑格式，在新系统中不支持");
                		one.editType =  EditStyle.$DDLB;
                		}
                	
                	
                    one.ddlbName = es.getDDLBName();
                    one.dropDownListEditable = es.isDropDownListEditable();
                   
                    one.valueMustInDDLB = es.isValueMustInDDLB();
                    try
                    { 
                    	one.ddlbFilterBy =JSON.parse( es.getDDLBFilterBy()).filterby;
                    }catch(err)
                    {
                    	one.ddlbFilterBy="";
                    }
                    if( one.ddlbFilterBy==undefined)  one.ddlbFilterBy="";
                    one.ddlbInnerItems = '';
                    one.showRealData = es.isShowRealData();
                    one.columnCount = es.getColumnCountOnRow();
                    break;
                case EditStyle.$CheckBox:
                    one.checkOnValue = es.getCheckOnValue();
                    one.checkOffValue = es.getCheckOffValue();
                    one.checkCaption = es.getCheckBoxTipText();

                    break;
                case EditStyle.$Tree:
                    one.treeName = es.treeName;
                    one.treeFilterBy = es.treeFilterBy;
                    one.treeWidth = es.treeWidth;
                    one.treeHeight = es.treeHeight;
                    one.treeSelectMulti = es.treeSelectMulti;
                    break;
            }

        }

        // 控件
        var bricks = cell.getBricks();
        if (bricks.length > 0) {
            var bs = [];
            ret.bricks = bs;
            for (var i = 0; i < bricks.length; i++) {
                var b = bricks[i];
                var action = b.getAction();
                if (action == 0) continue; //不需要保存的动态生成的brick

    			if (action == Brick.BrickAction_ShowBorder)
    			{
    				var bname= b.getName() ||'';
    				if( bname=="EditableHightLight" ) continue;
    			}
    			var one ={"name" : b.getName(), "x" :  b.getX()+1,  "y": b.getY()+1, "width": b.getWidth()-1,"height":b.getHeight()-1 };
    			
    			switch (action)
    			{

    			case Brick.BrickAction_NormalButton:
    				one.type="button";
    				one.config={name:b.getName(), caption: b.getCaption(), enable:true,visible:true,size:1,
    						 "x" :  b.getX()+1,  "y": b.getY()+1, "width": b.getWidth()-1, "height":b.getHeight()-1,
    						 "buttonStyle":"default", "buttonColorStyle":"primary", "leftIcon":"", "rightIcon":""
    				}
    				break;
    			case Brick.BrickAction_RetrieveButton:
    				one.type="button";
    				one.config={name:b.getName(), caption: b.getCaption(), enable:true,visible:true,size:1,
    						action:"retrieve",
    						dsn:b.getDataSource(),
    						"x" :  b.getX()+1,  "y": b.getY()+1, "width": b.getWidth()-1, "height":b.getHeight()-1,
    						 "buttonStyle":"default", "buttonColorStyle":"primary", "leftIcon":"", "rightIcon":""
    				}
    				break;
    			 
    			}
    			                
                bs.push( one);
            }
        }


    } catch
        (e) {

        alert( JSON.toString(e));
    }
    return ret;
}
 


function  isJavaColor( obj)
{
	try
	{
		var c= obj.getClass();
		if( c==undefined) return false;
		var n= c.getName();
		if( n==undefined) return false;
		if( n=='java.awt.Color') return true;
	}catch(err)
	{
		return false;
	}
}

function color2Hex(   c)
{
	var ret;
	var r = ("00" +  (new Number(c.getRed())).toString(16));
	r = r.substring(r.length - 2, r.length);
	
	var g = ("00" +  (new Number(c.getGreen())).toString(16));
	g = g.substring(g.length - 2, g.length);
	
	var b = ("00" +  (new Number(c.getBlue())).toString(16));
	b = b.substring(b.length - 2, b.length);

	return "#" + r + g + b;
}


