//加载模板
// 特别注意：  所有与数据相关的初始化，必须放在  getTemplateConfig 中，因为 单据编辑允许 前翻后翻，所以与单据相关的数据必须统一在一个地方初始化
//  如果是与 gguid 单据不相关的数据，可以任意位置初始化。


define(function (require) {

        const WorkBook = spreadsheet.core.WorkBook;
        const DataStore = spreadsheet.db.DataStore;
        const ItemStatus = spreadsheet.db.ItemStatus;
        const ajax = spreadsheet.util.ajax;
        const $form = require('../form/form');
        const $ES = spreadsheet.core.EditStyle;
        const Property = spreadsheet.core.Property;
        const Tools = spreadsheet.util.Tools;


        var g_dbConfig = {};
        var g_dsb2colselect = {};// 数据源中的字段列表
        var g_ddlbNameList = []; // 列表名称清单
        var g_treeNameList = []; // 树名称清单
        var handleEvent = $form.handleEvent;


        /*
		 * 代码流程撸一下
		 * 
		 * 先是创建两个Promise ，一个负责UI的初始化， 一个负责从后台加载一些信息
		 * 
		 * 等它们两个都执行完成后， 再进行数据的检索（多个结果集，也是异步检索的 ， 同样用 Promise.ALL 来协调
		 * 
		 * 等所有结果集都检索好之后， 再对表单数据做一些自动填充， url参数填充到表单的操作
		 * 
		 * 注意两点： 函数getTemplateConfig会在 form.js中用loadBIll 多次调用来实现不关闭页面，加载不同的单据信息
		 * 因此 ui是不需要重复初始化的，但是一些标记要复位。 同时由于要反复加载单据，所以其中的一些数据 比如 form.gguid
		 * 等，它不能设置成只读的。因为一旦设置成只读的，它就不能再改变
		 * 
		 */

        function getTemplateConfig(containerID, designMode, id, gguid, type, action, afterLoadCallback) {

            // 参数备份下来 ，为单据编辑界面中单据前后翻留下参数备份
            window["getTemplateConfigParameter"] = {
                containerID: containerID, designMode: designMode, id: id,
                gguid: gguid, type: type, action: action,
                afterLoadCallback: null // 单据编辑窗口中不需要此回调，所以也无需备份它
            };


            console.info(" form load start:" + (new Date()).Format("yyyy.MM.dd HH:mm:ss"));
            
            
            

            // 到这里， 脚本相关的内容应该都已经加载好了，那么开始画UI吧，不需要等getTemplateConfig完成后再初始化UI ，此时
            // ui配置，db配置， script配置，都已经在上面加载好了，开干
            // 但是也不要等UI初始化完成后，再去 getTemplateConfig , 这两件事其实是可以同时开干的，
            // 但是需要等这两件事都做完后，再进行数据的检索，典型的 Promiss.all 模式
            // https://blog.csdn.net/qq_36742720/article/details/86534116?depth_1-utm_source=distribute.pc_relevant.none-task&utm_source=distribute.pc_relevant.none-task


            let uiPromise = new Promise(function (resolve, reject) {

                if (book != null)  // 当UI已经初始化时，不需要重复初始化UI
									// ，这种情况出现在单据打开后，通过前一张，后一张翻页时
                {

                    // 注意， 相关的状态，必须还原到UI刚加载完成
                    book.initOK = false; // 还原成没有完成的状态
                    form.relativeDataQueryAndFillEnable = false; // 相关取数暂停

                    resolve('');
                    return;
                }

                let startTime = new Date().getTime();
                console.info("uiPromise开始于：" + startTime);
                let ret = window.$TemplateConfig;
                
            	//2021.12.26  spreadsheet  的DefaultDataProviderf需要用到下面的属性，本系统中并没有，所以必须初始化一下、
            	window.$rightConfig={};
                window.$rightConfig.roles_encrypted='';
                window.$rightConfig.flowDefineId_encrypted="";
                window.$rightConfig.taskDefinitionKeyEncrypted="";
                //end 2021.12.26


                try {

                    form.uniqueIndexInfo = JSON.parse(ret.uniqueindexinfo);
                    if (!form.uniqueIndexInfo) form.uniqueIndexInfo = [];
                } catch (err) {
                    form.uniqueIndexInfo = [];
                }

                // 禁止前端修改的字段，当前也肯定是不允许在前端编辑的

                try {
                    form.updatedisabledcolumns = JSON.parse(ret.updatedisabledcolumns);
                    if (!form.updatedisabledcolumns) form.updatedisabledcolumns = [];
                } catch (err) {
                    form.updatedisabledcolumns = [];
                }


                let ui = ret.ui;
                if (ui != '') {
                    try {
                        ui = JSON.parse(ui);
                    } catch (err) {
                        alert(err);
                        alert("UI解析异常，无法构建界面");
                        ui = "";
                    }
                }

                // 没有模板时，创建一个默认的空模板
                if (ui == '') {
                    ui = {
                        sheets:
                            [
                                {
                                    index: 0, rowCount: 20, columnCount: 10, name: 'Sheet1', gridLineVisible: true,
                                    rows: [], columns: [], cells: []
                                }
                            ]
                    }
                }

             
                
                // 创建workbook
                createBook(type, containerID, designMode, ui, ret);

                // 注意，此时界面初始化完成，数据老早已经取到浏览器中一直放着没有做“检索”
                // 是要等界面绑定完成后，再做数据检索，然后触发卷滚条重新初始化

                handleEvent('uiInited', null, arguments);

                // 让界面显示一下
                book.setAllSheetsPaintPermit(true);

                let endTime = new Date().getTime();

                console.info("uiPromise结束于：" + endTime + "  耗时：" + (endTime - startTime));
                resolve(''); // 完成


            });


            let getConfigPromise = new Promise(function (resolve, reject) {

                var startTime = new Date().getTime();
                console.info("getConfigPromise 开始于：" + startTime);
                $rpc("formEngine", "formengine.FormEngine", "getTemplateConfig",
                    {

                        id: id,  // 模板的Id
                        moduleID: urlArgs.id,  // 模块的Id或Code
                        type: type,  // bill, billlist , report ,design
                        action: action,
                        billtype:urlArgs.billtype || -999999,
                        gguid: gguid,
                        wiseoainnerparam:urlArgs.wiseoainnerparam,
                        moduleConfig: window.$moduleConfig, //单据的配置 ，对应的流程的配置，都传过去，避免重新取
                        flowid: $moduleConfig.flowid==undefined?0:$moduleConfig.flowid // 工作流类型的ID
                        		
                    },

                    function (retValue) {

                        var ret = JSON.parse(retValue);
                        if (!ret.success) {
                            $.alert(ret.message);

                        }

                        for (var p in ret) {
                            window.$TemplateConfig[p] = ret[p];
                        }

                        let endTime = new Date().getTime();

                        console.info("getConfigPromise 结束于：" + endTime + "  耗时：" + (endTime - startTime));

                        resolve("");
                    }); // end for $rpc
            });// end for Promise


            // 2020.04.10 非常遗憾， Promise.all不是这样用的，
			// 当其中的某个Promise不是异步操作时，它执行的过程中，仍是
            // 卡住所有其它的promise的执行。
            // Promise.all 的核心在于等待多个异步执行完成后，再继续下面的操作。 js本质是单线程的，如果在一个Promise中
            // 它所有代码都是同步执行的，那么它是不会释放对CPU的占用让给其它Promise执行的。
            // 结论： uiPromise 实质上没有任何异步操作，所以它肯定是需要先执行完成 后， getConfigPromise才会开始执行
            // 好在 uiPromise 执行很快，并且也没有更好的办法一让它们两个同时执行，先这么着吧

            Promise.all([getConfigPromise, uiPromise]).then(function (results) {


                    let ret = window.$TemplateConfig;
                    
                    
                    
                    let wiseoaDialogParameter= urlArgs.wiseoaDialogParameter;
                    if( wiseoaDialogParameter!=undefined)
                    	{
                    	wiseoaDialogParameter= JSON.parse( base32Decode(wiseoaDialogParameter));
                    	form.wiseoaDialogParameter= wiseoaDialogParameter;
                    	}

                    // 一些参数保存起来
                    form.action = ret.action; // action是可变的，所以不需要定义为只读的


                    
                    // 下面两个参数用于book.newDataStore中 ，客户端创建dataStore时，需要进行安全的校验
                    // 需要templateId 中的安全配置信息。 newQueryId与
					// templateId都做了加密处理，防止客户端伪造。
                    book.newQueryId = ret.newQueryId;
                    book.templateId = ret.templateId;
                    book.currentGUID = ret.currentGUID;

                    $('meta[name="currentGUID"]').attr('content', ret.currentGUID); // 后端脚本，动态检索等可以使用此数据
                    $('meta[name="AuthorizationKey"]').attr('content', ret.AuthorizationKey); //
                    $('meta[name="AuthorizationTemplate"]').attr('content', ret.AuthorizationTemplate); //


                    // region 设置一些常量，不可修改
                    Object.defineProperty(form, "GUID", {writable: true, value: ret.GUID});
                    Object.defineProperty(form, "currentGUID", {writable: true, value: ret.currentGUID});
                    Object.defineProperty(form, "type", {writable: true, value: ret.type});
                    Object.defineProperty(form, "templateId", {writable: true, value: id});


                    if (form['masterTableName'] == undefined) {
                        Object.defineProperty(form, "masterTableName", {writable: false, value: ret.masterTableName});
                        Object.defineProperty(form, "MasterTableName", {writable: false, value: ret.masterTableName}); // 兼容
                        form.getMasterTableName= function(){ return form.masterTableName;}; // 兼容
                    }

                    if (form.currentUserID == null) Object.defineProperty(form, "currentUserID", {
                        writable: false,
                        value: ret.currentUserID
                    });
                    if (form.currentUserName == null) Object.defineProperty(form, "currentUserName", {
                        writable: false,
                        value: ret.currentUserName
                    });
                    if (form.currentUserCode == null) Object.defineProperty(form, "currentUserCode", {
                        writable: false,
                        value: ret.currentUserCode
                    });

                    if (form.currentUserShowName == null) Object.defineProperty(form, "currentUserShowName", {
                        writable: false,
                        value: ret.currentUserShowName
                    });
                    if (form.billType == null) Object.defineProperty(form, "billType", {writable: false, value: ret.billType});

                    // endregion


                    // 截获 Ctrl + S 保存模板
                    $(window).keydown(function (e) {

                        if ((e.metaKey || e.ctrlKey) && e.keyCode == 83) {
                            if (form.type == 'bill') form.save();  // 单据编辑，增加保存的快捷键
                            e.stopPropagation();
                            e.preventDefault();
                            return false;
                        } else {
                            return true;
                        }
                    });

                    
                    //到这里已经加载了配置，但是还没有加载数据，正是权限校验的好时机
                    
                    if( form.action=='new')
                    { 
                    	var  permit = form.handleEvent('newPermit', '', ['', urlArgs.billtype], true);
                    	if(!permit)
                    	{
                    		$('#workBookContainer').html(`<div  style= 'text-align:center;padding-top:100px;font-size:26px;'>您无此权限。</div>`);
                    		return;
                    	}
                    	
                    }
                    
                    if( form.action=='view')
                    { 
                    	var  permit = form.handleEvent('viewPermit', '', [ form.GUID , urlArgs.billtype], true);
                    	if(!permit)
                    	{
                    		$('#workBookContainer').html(`<div  style= 'text-align:center;padding-top:100px;font-size:26px;'>您无此权限。</div>`);
                    		return;
                    	}
                    	
                    }
                    
                    if( form.action=='edit')
                    { 
                    	var  permit = form.handleEvent('editPermit', '', [ form.GUID , urlArgs.billtype], true);
                    	if(!permit)
                    	{
                    		$('#workBookContainer').html(`<div  style= 'text-align:center;padding-top:100px;font-size:26px;'>您无此权限。</div>`);
                    		return;
                    	}
                    	
                    }
                    
                    

                    // 上传功能的初始化
                    if (ret.type == 'bill') {


                        if ($('#attachmentFrame').length > 0) {  // 在
																	// dialog中就没有附件窗口，所以要先判断一下
                            $('#attachmentFrame')[0].src = 'attachmentlist.jsp?dbpool=default&logTable=oa_bill_attachment&gguid=' + form.GUID +
                                '&tableName=' +form.masterTableName +
                                "&readOnly=" + (ret.action == 'view' ? 'true' : 'false');
                         	
                        }

                    }

                    
                    //sheet的可见性
                    for( var i=0;i<book.getWorkSheetCount();i++)
                    {
                    	var sheet =book.getWorkSheet(i);
                    	var guid= sheet.guid;
                    	var v=  $TemplateConfig.rightmap[guid+'.visible' ];
                    	if(v !=undefined)
                    	 {
                    		if(!v)
                    		{
                    			if( book.getActiveSheet()==sheet  ) book.setActiveSheet(i+1);
                    			sheet.visible=v;
                    		}
                    	 }
                    }
                    
                    //字段的编辑属性
                    var  dbRight= $TemplateConfig.dbRight;
                    for( var dsname in dbRight)
                    {
                    	var oneDS= dbRight[dsname];
                    	var dsc= book.getDataSource( dsname);
                    	
                    	for( var col in  oneDS)
                    	{
                    		var oneCol = oneDS[col];
                    		
            				var cells= dsc.getAllCellsWhichBindTheCol(col);
            				for(var ci =0;ci<cells.length;ci++)
            				{
            					var cell= cells[ci];
            					//可见
            					var visible= true;
            					if( oneCol.visible!=undefined) visible=   oneCol.visible;
            					if(! visible) cell.viewAs='password';
                        		   
                        		//可编辑
            					var editable =true;
            					
                        		if( oneCol.editable!=undefined) 	editable=  oneCol.editable ;
                        		//不可见，也就不可编辑
                        		if( !editable || !visible) 		cell.editable=false;
                        		 
                        		
                        		
            				}
                    			 
                    		 
                    	}
                    }
               

                    // 在数据填充过程中，再关闭显示
                    book.setAllSheetsPaintPermit(false);


                    var promiseAll = [];

                    var dataSource = g_dbConfig.dataSource;

                    // 让各个表，异步加载数据，如果有多个formEngine服务，下面的rpc可能会由不同的formEngine响应
                    // 要注意这一点，不能假设它们是在同一个服务上运行的，因此各个表在加载数据时，不要有什么牵扯，也不能假设它们加载完成的顺序
                    // 这个顺序也是不可测的
                    for (let dsc  in  dataSource) {
                        var moreInfo = dataSource[dsc].moreInfo;
                        if (moreInfo != null) toastr.info(moreInfo);
                        let one = dataSource[dsc].dsconfig;// dscofig 是数据库
															// db配置中的一个表或一个结果集的配置信息，注意不是DataStore配置信息
                        if (one.type != 'table') continue;

                        var promise = new Promise(function (resolve, reject) {

                                $rpc("formEngine", "formengine.FormEngine", "getTableData",
                                    {
                                        dsconfig: one,
                                        action: action,
                                        gguid: gguid || '',
                                        flowid: $moduleConfig.flowid==undefined?0:$moduleConfig.flowid // 工作流类型的ID
                                    },
                                    function (v) {
                                        var r = JSON.parse(v);
                                        if (!r.success) {
                                            $.alert(r.message);
                                            return;
                                        }
                                        let ds = book.getDataSource(dsc).dataStore;

                                        // 2020.04.15 增加 ，因为单据打开后，可以前后翻，此时ds
										// 中是有数据的，需要把它清空
                                        ds.reset();
                                         
                                        //retrieveFromData 并不会先做清空操作，虽然第一次打开编辑窗口，ds都是空的，但是前后翻后，就有数据了，所以上面的reset是有必要的
                                        //2020.07.10 patch:  保存下最后一次检索的SQL，备查及翻页时要用到
                                        // 如果ds上有绑定的分页控件，那么分页控件需要用到 m_SelectLastRetrieved来异步获取总页数
                                        ds.m_SelectLastRetrieved = r.selectLastRetrieved;
                                        ds.retrieveFromData(r.value, r.where , true, r.name2column );
                                         
                                        // 表示自已异步处理好了
                                        resolve(ds);  // 随意带一个参数
                                    }
                                )
                            }
                        );
                        promiseAll.push(promise);
                    }

                    
                    
                    showInfoPane("*加载数据中...");

                    if (promiseAll.length == 0) {
                        afterLoadData();

                    } else {
                        Promise.all(promiseAll)
                            .then(function (result) {
                                afterLoadData();
                            });
                    }


                    // region afterLoadData 后续处理，放在一个函数中，便于上面的执行
                    function afterLoadData() {

                    
                        
                        
                        // 如果没有“表”需要加载数据，那么就直接进入后续处理
                        // 否则，必须等待所有“表”异步加载完数据后，再进入后续处理


                        // 2019.04 重大调整
                        // 由于模板的初始化，与数据的加载现在分离，异步完成
                        // 可能出现数据没有加载完成时，模板上的计算列，按钮等已经初始化完成了，如果此时进行计算，或操作，
                        // 是没有意义的，所以增加了一个开关变量initOK 来做同步控制

                        // 数据已经加载好了，再根据审核标记，及权限控制，再控制一下字段的编辑属性

                    	// 2020.07.25 当前工作ID
						form.currentWorkId=0;

						if( window['$oa_mywork_ds'] !=null) form.currentWorkId= $oa_mywork_ds.getString(0,"id");
                        

                        form.billIsVerified = billIsVerified();
                        // 单据已审核，那么不显示保存按钮
                        if (form.billIsVerified) {
                            if ($('#cb_save').length > 0) $('#cb_save').hide();


                        }

                        // 2020.04.11 增加对DingDing的处理
                        // alert( form.type+" "+ form.action+" " +
						// form.billIsVerified );
                        if (form.type == 'bill' && (form.action == 'view' || form.billIsVerified)) {
                            if (isDD()) dd_disableRightMenu(parent.window.dd);
                        }

                        let sheetCount = book.workSheetCount;
                        for (var si = 0; si < sheetCount; si++) {
                            var sheet = book.getWorkSheet(si);
                            var RC = sheet.rowCount;
                            var CC = sheet.columnCount;

                            for (let row = 0; row < RC; row++) {
                                for (let col = 0; col < CC; col++) {
                                    if (sheet.isCellNull(row, col)) continue;
                                    let cell = sheet.cells(row, col);
                                    if (cell.isMerged()) {
                                        if (cell.mergedBy() != cell) continue;
                                    }
                                    if (!cell.editable) continue;

                                    if (form.billIsVerified) cell.editable = false;
                                    // 更多的权限控制在下面
                                }
                            }
                        }


                        book.initOK = true; // 到这里，数据已经初始化完成了，可以启用计算列缓存，启用编辑 ，
											// 启用控件点击等事件

                        form.relativeDataQueryAndFillEnable = true; // 相关取数启用

                        hideInfoPane();

                        // 自动填充数据
                        if (ret.type != 'design') autoFillData(ret);
                        // 因为初始化时，不会触发 currentBindRowChanged事件 ，
                        // 所以在开始的时触发一下，此时子表会按需要刷新数据或插入缺省的行数
                        var dscs = book.getDataSources();
                        var n = dscs.length;
                        // 设置当前行
                        for (var i = 0; i < n; i++) {
                            var dsc = dscs[i];
                            if (dsc.dataSourceType == 2) {
                                var cr = dsc.dataStore.rowCount > 0 ? 0 : -1;
                                dsc.setCurrentBindRow(cr, true); // 原先如果也是cr行，此函数也会触发currentBindRowChanged事件
                                console.info("强制设置" + dsc.name + "当前行为：" + cr);
                            }

                        }


                        if (afterLoadCallback) afterLoadCallback(ret);


                        book.setAllSheetsPaintPermit(true);

                        if (ret.type != 'design') {

                            handleEvent('formOpen', null, arguments);
                            handleEvent('flowOpen', null, arguments);
                            
                            if (['new', 'view', 'edit'].contains(ret.action)) {
                                handleEvent(ret.action + 'Open', null, arguments);
                            }

                            handleEvent('afterOpen', null, arguments);

                            // 如果是对话框形式打开，那么向父窗口发送消息，请求参数
                            if (window.location.href.indexOf('dialog.jsp') > 0) {
                                if (window.parent)// 有要能是直接打开dialog.jsp，没有在表单中打开，
                                {
                                    window.parent.postMessage(JSON.stringify({action: 'requestParameter'}), '*');
                                }
                            }

                            //如果是单据打印页面，那么在加载好之后，反调打印
                            if (window.location.href.indexOf('h5-billprint.jsp') > 0) {
                                if (window.parent)//有要能是直接打开billprint.jsp，没有在表单中打开，
                                {
                                	if( window.parent.form)
                                	{
                                		window.parent.form.printBillWithFormat( urlArgs.id,urlArgs.sheet);  //单据编辑界面中打开打印页面
                                	}else
                                	{
                                		window.parent.printByAgent( urlArgs.id,urlArgs.sheet);//单据列表 界面打开打印界面
                                	}
                                }
                            }


                            // 强制自动检索,如果不是设计模式，那么自动智能检索

                            for (let dsc  in  dataSource) {

                                let one = dataSource[dsc];
                                let ds = book.getDataSource(dsc).dataStore;
                                if (one.autoretrieve) {
                                    showInfoPane("*正在检索...  </div>");
                                    setTimeout(function () {
                                        $form.smartRetrieve(book.activeSheet, dsc);
                                        hideInfoPane();
                                    }, 200);
                                }
                            }
                        }
                        console.info("all over" + (new Date()).Format("yyyy.MM.dd HH:mm:ss"));
                    }

                    

                }
            );

        }


        function updateLockedTimeForResource() {
            $rpc("formEngine", "formengine.SaveTemplate", "updateLockedTimeForResource",
                {
                    id: urlArgs.id,
                    table: "app_template"

                },
                function (retValue) {

                    setTimeout(updateLockedTimeForResource, 60 * 1000);

                });
        }

        /**
		 * 
		 * 
		 * 时间字段在第一个步骤里设置了自动赋值，然后新起草工作，把时间改成别的，保存后再打开， 时间又变成了当前时间
		 * 
		 * 这个问题是在起草状态和第一步提交状态时的自动填充。这两个步骤都是使用第一步的填 充数据设置。所以进去后会再次填充
		 * 
		 * 这个是合理的。 比如第一步交给第二步。 那么第二步受理时填充了数据，
		 * 但是他发现不应该由自己处理，于是退回给第一步，第一步又重新递交给另一个人受理第二步。 那么你说，
		 * 在此时受理第二步时，自动填充设置的数据还要不要重新进行数据填充 当然更完善的做法， 是多加几个设置：１ 退回是自动填充的数据自动清空。 ２
		 * 在同一个步骤中多次打开表单时，是每打开一次都重填入数据，还是仅第一次打开时填充
		 * 
		 */

        function autoFillData(ret) {

            // 如果是工作流，那么如果当前不能进行受理，那么就不要填充自动填充的数据


            var dsc = book.getDataSource(form.masterTableName);
            var dsMaster = null;

            if (dsc != null) {
                dsMaster = dsc.dataStore;
            }

            if (form.type == 'bill' && form.GUID == '' && dsMaster != null) {
                form.GUID = dsMaster.getString(0, "id");
            }


            // 把URL上参数自动填到主表上
            var sheetCount = book.getWorkSheetCount();
            for (var key in   urlArgs) {
                // 自动填充，id, gguid 忽略，因为单据的url中的id不是记录的ID，而是单据配置的ID，所以不能填
                if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("gguid")) continue;

                var value = urlArgs[key];

                if (dsMaster != null) {
                    // 2019.12 修正，参数并不一定在结果集中有对应的参数
                    if (dsMaster.col2Index(key) >= 0 && dsMaster.rowCount > 0) {
                        if (dsMaster.getPrimaryBuffer().getItemStatus(0, key) == ItemStatus.isNew) {
                            console.log("url参数：" + key + "值：" + value + " 填到主表" + form.masterTableName + "的字段：" + key + "中");
                            dsMaster.setValue(0, key, value);
                        }
                    }
                }

                // 如果是报表，那么把URL上的参数可以尝试填到表单上
                // 2019.08.14 改成每个Sheet都查找一遍，而不仅仅是sheet0

                if (ret.type == 'report') {

                    for (let si = 0; si < sheetCount; si++) {
                        var sheet = book.getWorkSheet(si);
                        var cell = sheet.cells(key);
                        if (cell != null) {
                            console.log("url参数：" + key + "值：" + value + " 填到单元格" + key + "中");
                            if (cell.Bind != null) {
                                cell.setValue(value, 0);
                            } else {
                                cell.setValue(value);
                            }
                        }
                    }
                }
            }

            
            //工作流步骤中如果有定义自动填充，那么
       
            window.commentFillback=null;  // 批注回填清空先
            
            var  dbRight= $TemplateConfig.dbRight;
            for( var dsname in dbRight)
            {
            	let oneDS= dbRight[dsname];
            	let dsc= book.getDataSource( dsname);
            	let ds= dsc.dataStore;
            	
            	for( let col in  oneDS)
            	{
            		let oneCol = oneDS[col];
            		let formula= oneCol.formula;
            		if( formula==undefined) continue;
            		formula=formula.trim();
            		
            		if (formula.startsWith("="))
    				{
    					var parsedValue = null;

    					for (let i = 0; i < ds.getRowCount(); i++)
    					{
    						if (ds.getString(i, col).length  > 0)
    						{
    							console.info(col + "在流程中定义了缺省值：" + formula + " 但是数据库中已经有了数据，所以忽略公式定义的缺省值");
    							continue; //有数据了公式就不要了
    						}
    						parsedValue = book.getWorkSheet(0).evaluate(formula, i);
    						console.info(col + "在流程中定义了缺省值：" + value + " ，解析结果为：" + (parsedValue == null ? "null" : parsedValue));
    						ds.setValue(i, col, parsedValue);
    					}

    				} else
    				{
    					console.info (" formula =" + formula);
    					let  isContent = formula.equals("content");
    					let value = realAutoValue(formula, $TemplateConfig.rightAction );
    					console.info(" formula value =" + value);
    					if (value == null) continue;
    					for (let i = 0; i < ds.getRowCount(); i++)
    					{
    						console.info(col + "在流程中定义了缺省值：" + value + " 此类非公式缺省值每次受理本步骤时都强制性覆盖填入");

    						//if ( ds.getString(i,col).length()>0) continue; //有数据了也还要覆盖，比如退回后，重新递交给不同的人，显然应该重新填入数据
    						//如果是回填批示，且当前已经有批内容了，那么就不要用同意进行覆盖
    						//如果手工修改了批示，它会再次自动回填
    						if (isContent)
    						{
    							console.info(col + "需同步为批注");
    							
    							// 其它内容都可以在打开表单时填入，只有批注是需要在递交前填入，所以这里登记了一个回调函数，在递交前回调。
    							//注册一个批注回填函数，在工作流提交前回填批注
    							window.commentFillback= function(comment)
    							{
    								ds.setValue(0,col , comment); 
    								ds.update(true);
    							}
    							
     						 
    						}else
    						{
    							ds.setValue(i, col, value);
    						}
    						
    					}
    				}//end if
            	
            	}//end of  for 
            }// end of  for 
            
            		

            // 下面的 getNextBillNo 需要调用脚本，在脚本中，可能需要用到表单上的数据，所以需要等上面的数据填充填完后，再填单据号

            if (dsMaster != null && form.type == 'bill') {

               

                if (dsMaster.getRowCount() == 0) dsMaster.insertRow(0);

                // 只在存在如下几个字段，那么显然应该是单据，但也可能是挂到工作流中的单据

                // [标记2019.09.03] 主表的ID保持与GGUID一至
                // 当新单据时，主表的ID是由缺省的randomGUID触发在插入行后自动赋值，但是它与GGUID不相同。
                // 所以必须对主表进行ID=GGUID的强制赋值，其它表则不需要
                if ([ItemStatus.isNewModified, ItemStatus.isNew].contains(dsMaster.getPrimaryBuffer().getItemStatus(0, "id"))) {
                    dsMaster.setValue(0, "id", form.GUID);
                }
                

                if (dsMaster.col2Index("billdate") >= 0 && dsMaster.col2Index("billno") >= 0 && dsMaster.col2Index("userid") >= 0 && dsMaster.col2Index("billtype") >= 0) {

                    if (dsMaster.getValue(0, "billdate") == null) dsMaster.setValue(0, "billdate", newDate());

                    if (dsMaster.getInt(0, "userid") == 0) dsMaster.setValue(0, "userid", ret.currentUserID);
                    if (dsMaster.getString(0, "username") == '') dsMaster.setValue(0, "username", ret.currentUserShowName);

                    if (dsMaster.getString(0, "billtype") == '') dsMaster.setValue(0, "billtype", ret.billType);

                    // 单据号需要等上面都设置值后，再取，因为在脚本中可能需要用到上述字段的数据
                    if (dsMaster.getString(0, "billno") == '') dsMaster.setValue(0, "billno", getNextBillNo());
                }
                
                // 2020.08.08 增加对工作流的支持
                if( book.getDataSource('oa_mywork')!=null)
                {
                	var oa_mywork_ds= book.getDataSource('oa_mywork').dataStore;
                	if( oa_mywork_ds.getString(0,"guid")=='')  
                	{
                		oa_mywork_ds.setValue(0,"guid", currentGUID());
                		oa_mywork_ds.setValue(0,"userid", currentUserId());
                		oa_mywork_ds.setValue(0,"rq", newDate());
                		oa_mywork_ds.setValue(0,"unit",1);
                		oa_mywork_ds.setValue(0,"flowid", $moduleConfig.flowConfig.id);
                		oa_mywork_ds.setValue(0,"flowname", $moduleConfig.flowConfig.name);
                		oa_mywork_ds.setValue(0,"templateid", $moduleConfig.flowConfig.template_id);
                										
                		
                	}
                }
            }

            // 对每个结果集，加载初始数据，如果字段状态是新或者新修改，且字段有定义缺省值
            // 时，自动将默认数据设置到字段中。因为新录入单据时 ，数据也是在服务端准备好之后，灌入前端结果中，
            // 所以，afterInsertRow 是不会触发的，也就不会把默认数据填入，所以此时此地就执行一下把默认值填入新行的动作
            var dscs = book.getDataSources();
            var n = dscs.length;


            for (let i = 0; i < n; i++) {
                let dsc = dscs[i];
                let ds = dsc.dataStore;
                let RC = ds.rowCount;
                let primaryBuffer = ds.primaryBuffer;
                // 把需要设置缺省值的字段先摘出来，避免在下面的循环中反复去获取配置
                
                
                let formulaAsDefaultValue = ret.bindCellHoldFormula[dsc.Name];
                if( formulaAsDefaultValue) {
                    console.info("单元格公式也视为默认值定义");
                    //console.info( JSON.stringify( formulaAsDefaultValue)); 因为 formulaAsDefaultValue包含sheet,会引起JSON.stringify 循环
                }


                let defaultValueConfig = {};
                let CC = ds.getColumnCount();
                for (let col = 0; col < CC; col++) {
                    let cp = ds.getColumnProperty(col);
                    let colName = cp.getDBName();
                    let defaultValue = cp.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue = defaultValue.trim();
                    if (defaultValue == '') continue;
                    defaultValueConfig[colName] = defaultValue;
                }

                console.info(  " 缺省值配置信息：" + JSON.stringify( defaultValueConfig));


                if( Object.getOwnPropertyNames(defaultValueConfig).length>0 || formulaAsDefaultValue!=undefined ) {
                    for (let row = 0; row < RC; row++) {

                        let rowStatus = primaryBuffer.m_Buffer[row].m_RowStatus; //直接访问内部数据结构，忽略边界检索，提高速度
                        //仅对新增加的数据行，设置缺省值，调取出来修改的数据，不再设置缺省值，即使字段没有数据，也不管
                        if (rowStatus == ItemStatus.isNew || rowStatus == ItemStatus.isNewModified) {
                            //仅仅设置当前行，不要触发currentBindRowChanged事件
                            //设置当前行，是为了让自动取数，能正确定位当前数据行
                            dsc.setCurrentBindRow(row, false);

                            //数据库中定义的缺省值，用计算列进行解析
                            for (let col in defaultValueConfig) {
                                let defaultValue = defaultValueConfig[col];
                                let value = defaultValue;
                                //id要特殊处理， 因为数据在服务器上准备时，对于 id ,它就已经填上了，如果此时再填一次，那么ID与form.GUID就不一至了
                                //但是id列的默认值 设置又不能丢，因为在新增一行后，又需要为ID埴上新的id
                                // 此处的默认值 ，应该视为初始化默认值，与插入无关，所以对ID要特别处理
                                if (col.equalsIgnoreCase('id')) continue;
                                if (value == '') continue;
                                if (defaultValue.startsWith("=")) {
                                    value = ds.evaluate(defaultValue, row); //带入行号解析
                                }

                                console.info(  dsc.Name+'.'+col + "缺省值定义：" + defaultValue + ",它被视为计算列来解析 ,实际填入数据：" + value);
                                ds.setValue(row, col, value);
                            }

                            //如果字段绑定的单元格同时也定义了公式，那么它的结果被做为初始值填入ß
                            if(formulaAsDefaultValue)
                            {
                                for (let col in formulaAsDefaultValue) {
                                    let defaultValue = formulaAsDefaultValue[col].value;
                                    let parseSheet= formulaAsDefaultValue[col].sheet;
                                    let value = defaultValue;

                                    if (col.equalsIgnoreCase('id')) continue;
                                    if (value == '') continue;
                                    if (defaultValue.startsWith("=")) {
                                        value = parseSheet.evaluate(  defaultValue, row); //带入行号解析
                                    }

                                    console.info(dsc.Name+'.'+col + "绑定的单元格同时定义了公式：" + defaultValue + "，它被当作公式来解析 ,实际填入数据：" + value);
                                    ds.setValue(row, col, value);
                                }
                            }

                        }
                    }
                }

            }

        }

        
         
        	//返回自动填充配置对应的数据
        	function   realAutoValue(  config,   nodeGuid)
        	{

        	 
        		if (config.equals("userid")) return currentUserId() ;
        		if (config.equals("username")) return currentUserName() ;
        		if (config.equals("usershowname")) return  currentUserShowName() ;
        		if (config.equals("userssoname")) return currentUserSsoName() ;
        		if (config.equals("content")) return ""; //缺省批注

        		if (config.equals("ownerid")) return $oa_mywork_ds.getInt(0,"userid") ;

        		if (config.equals("unitid")) return 1;
        		if (config.equals("unitname")) return  "wisesoft";

        		if (config.equals("groupid")) return  $TemplateConfig.groupid  ;
        		if (config.equals("groupname")) return  $TemplateConfig.groupname;

        		if (config.equals("departmentid")) return $TemplateConfig.departmentid  ;
        		if (config.equals("departmentname")) return  $TemplateConfig.departmentname  ;

        		if (config.equals("today"))
        		{
        			return  date2yyyymmdd( newDate());
        		}

        		if (config.equals("now"))
        		{
        			return newDate();
        		}

        		return null;
        	 
        }
        
        function getNextBillNo() {
            var billno = handleEvent('newBillNo', null, [form.masterTableName, form.billType], '');
            if (billno != null && billno != '') {
                console.info("脚本接管了单据号的生成，新的单据号是：" + billno);
                return billno;
            }

            var dbpool = book.getDataSource(form.masterTableName).DBPoolName;
            var billDate = book.getDataSource(form.masterTableName).dataStore.getString(0, "billdate");

            var ret = $ajax.rpc("formEngine", "formengine.Bill", "newBillNo",
                {
                    dbpool: dbpool,
                    billType: form.billType,
                    tableName: form.masterTableName,
                    billDate: billDate,
                    pattern: form.configInfo.billnorule
                });

            return ret.billno;
        }


        function createBook(type, containerID, designMode, ui, cfg) {


            var dataSource = cfg.datasource;

            book = new WorkBook({
                withGUI: true,
                paintPermit: false,
                noDebugging: cfg.noDebugging,
                containerID: containerID,
                sheets: ui.sheets
            });

            // 属性集中创建。后面初始化单元格时，只需要通过 propertyID 定位就可以了
            if (ui.propertyCache) {
                for (var propID in   ui.propertyCache) {
                    var prop = ui.propertyCache[propID];
                    var cellProp = new Property(true);
                    for (var p in prop) {
                        var v = prop[p];
                        cellProp.put(p, v);
                    }
                    cellProp.refCount = 9999;// 引用计数有问题，所以放大一点
                    book.propertyCache[propID] = cellProp;
                }
            }  // 属性统一起来存放

            // 属性ID的索引号恢复
            if (ui.propertyIdList) book.propertyIdList = ui.propertyIdList;


            book.setAllSheetsPaintPermit(false);

            book.initOK = false; // 禁用计算列缓存，禁止编辑 ， 禁止控件点击等事件


            // 增加下拉列表数据的加载支持
            book.EM.addListener({
                getDropDownData: function (es, cell) {
                    loadDDLBList(es, cell);
                },
                getDropDownDataForEdit: function (es, cell, innerRow) {
                    return loadDDLBListForEdit(es, cell, innerRow);
                },
                getTreeNodes: function (es, cell) {
                    loadTreeNodes(es, cell);
                },
                getTreeNodesForEdit: function (es, cell, innerRow) {
                    return loadTreeNodesForEdit(es, cell, innerRow);
                },

            });

            // 先初始化数据源
            if (dataSource) initDataSource(book, dataSource, designMode);

            book.undoEnabled = false; // 禁用undo


            var defaultEditable = true;
            if (type == 'bill') {


                if (['edit', 'new'].contains(urlArgs.action)) {
                    defaultEditable = true;
                } else {
                    defaultEditable = false;
                }
            }


            cfg.bindCellHoldFormula={};//如果绑定到数据库的单元格中也定义了公式，那么尝试把它当作默认值，在autoFillData中做填入

            book.autoQueryAndFillDataConfig = {};//
            //
            for (var i = 0; i < ui.sheets.length; i++) {
                var sheetConfig = ui.sheets[i];
                var sheet = book.getWorkSheet(sheetConfig.index);
                sheet.designMode = designMode;
                sheet.paintPermit = false;
                sheet.ignoreBeforeRowWhenPrinting = sheetConfig.ignoreBeforeRowWhenPrinting || 0;
                sheet.gridLineVisible = sheetConfig.gridLineVisible && designMode; // 如果不是设计模式，那么不显示网格线
                sheet.freezeCell(sheetConfig.freezedRow, sheetConfig.freezedCol);
                // 行高
                var rc = sheet.rowCount;
                var cc = sheet.columnCount;

                if (!designMode) {
                    sheet.CPM.columnHeadHeight = 0;
                    sheet.RPM.rowHeadWidth = 0;
                }

                for (var ri = 0; ri < sheetConfig.rows.length; ri++) {
                    var rowConfig = sheetConfig.rows[ri];
                    sheet.RPM.setRowHeight(rowConfig.index, parseInt(rowConfig.height));
                    var b = rowConfig.isColumnScrollEnabled;
                    if (b == undefined) b = true;
                    var stretchHeight = rowConfig.stretchHeight;
                    if (stretchHeight == undefined) stretchHeight = 0;
                    sheet.RPM.setColumnScrollEnable(rowConfig.index, b);
                    sheet.RPM.setRowStretchHeight(rowConfig.index, parseInt(stretchHeight));
                }

                for (var ci = 0; ci < sheetConfig.columns.length; ci++) {
                    var colConfig = sheetConfig.columns[ci];
                    sheet.CPM.setColumnWidth(colConfig.index, colConfig.width);
                    var w = colConfig.width2;
                    if (w == undefined) w = -1;
                    var stretchWidth = colConfig.stretchWidth;
                    if (stretchWidth == undefined) stretchWidth = 0;

                    sheet.CPM.setColumnWidth(colConfig.index, parseInt(colConfig.width));
                    sheet.CPM.setColumnWidth2(colConfig.index, parseInt(w));
                    sheet.CPM.setColumnStretchWidth(colConfig.index, parseInt(stretchWidth));
                    if (!designMode && w != -1) sheet.CPM.setColumnWidth(colConfig.index, parseInt(w));
                }
                // 先初始化别名
                for (var j = 0; j < sheetConfig.cells.length; j++) {
                    var cellConfig = sheetConfig.cells[j];
                    if (cellConfig == null) continue;
                    if (!cellConfig.alias) continue;
                    var cell = sheet.cells(cellConfig.row, cellConfig.col);

                    cell.alias = cellConfig.alias;
                }
            }


            //必须每一个Sheet的单元格别名都设置好，结束循环，新起一遍循环，再设置单元格属性，此时所有Sheet的单元格别名都已经ok了，下面的
            //公式或表达式解析，才不会找不到别名
            form.relativeDataQueryAndFillEnable = false; //禁用先
            // 再初始化单元格

            for (var i = 0; i < ui.sheets.length; i++) {
                var sheetConfig = ui.sheets[i];
                var sheet = book.getWorkSheet(sheetConfig.index);


                for (var j = 0; j < sheetConfig.cells.length; j++) {
                    var cellConfig = sheetConfig.cells[j];
                    if (cellConfig == null) continue;
                    var cell = sheet.cells(cellConfig.row, cellConfig.col);
                    // console.info(cellConfig.row + ' ' + cellConfig.col);
                    cell.serializeFrom(cellConfig);
                    // 有绑定时，需要控制可编辑属性，对于没有绑定字段的单元格，不需要再控制可编辑属性
                    if (cell.Bind != null) {
                        if (!defaultEditable && !designMode) cell.editable = false;
                        if (form.updatedisabledcolumns.contains(cell.Bind.dataSource + '.' + cell.Bind.DBCol)) {
                            console.info(cell.Bind.dataSource + '.' + cell.Bind.DBCol + " 在数据库定义中被设置成禁止保存，所以它被禁止编辑");
                            cell.editable = false;
                        }
                        
                        
                        if( cell.Define ||'' !='')
                        {
                            var  defaultDefine=  cfg.bindCellHoldFormula[ cell.Bind.dataSource];
                            if( defaultDefine==undefined)
                            {
                                defaultDefine= {};
                                cfg.bindCellHoldFormula[ cell.Bind.dataSource]=defaultDefine;
                            }
                            defaultDefine[ cell.Bind.DBCol.toLocaleString()] = {value:cell.Define , sheet:sheet };
                        }

                        
                    }


                    // 2019.04 增加： 当单元格值改变时，执行相关取数，并按设置好的对照关系，把相关数据填入
                    // 单元格如果没有绑定数据库，那么需要在cellValueChanged事件中做处理
                    // 如果绑定了数据库， 需要在DataStoreItemChanged事件中做处理

                    if (cell.appData) {
                        var name = "";
                        if (cell.Bind == null)  // 当单元格没有绑定数据库时，侦听
												// cellValueChanged事件
                        {
                            name = sheet.GUID + "." + cell.alias;
                        } else { // 如果有绑定 ，要转化成结果集变化后执行，那么需要侦听
									// DataStoreItemChanged事件，所以需要把配置整理出来
                            // 便于在DataStoreItemChanged事件中快速响应，而不是再去通过绑定的单元格，再查appData,那么做可能对性能有影响
                            let dsn = cell.Bind.dataSource;
                            let col = cell.Bind.DBCol;
                            name = dsn + '.' + col;
                        }

                        // 每个 dsn.col 可能会有多个取数定义 ，把它们整合放在一个数组里
                        let refConfig = undefined;


                        for (let ri = 1; ri <= 4; ri++) {
                            var q = cell.appData['valueChangedToQuery' + ri];
                            if (!q) continue;
                            var dbpool = cell.appData['valueChangedToQueryDBPool' + ri] || '';
                            var m = cell.appData['valueChangedCopyMap' + ri] || '';

                            refConfig = book.autoQueryAndFillDataConfig[name];
                            if (refConfig == undefined) {
                                refConfig = [];
                                book.autoQueryAndFillDataConfig[name] = refConfig;
                            }
                            refConfig.push({dbpool: dbpool, query: q, map: m});


                        }
                    }


                }

                if (designMode) sheet.setSelection(0, 0, 0, 0);


            }
            book.undoEnabled = designMode; // 在设计模式下，使用undo
            book.cellShowFormula = designMode; // 设计模式下，显示公式

            // 事件的支持
            book.EM.addListener({

                cellClicked: function (sheet, cell, innerRow) {
                	
                	var name= cell.alias;
                	 var key= sheet.guid+".cellclick."+name+".click.when."+ $TemplateConfig.rightAction;
                     var v=  $TemplateConfig.rightmap[key];
                     if(v!=undefined &&  v== false ) 
                     {
                     	toastr.error("在当前状态下禁止点击");
                     	return;
                     }
                     
                     name= "r"+ cell.rowIndex+"c"+ cell.columnIndex; 
                     key= sheet.guid+".cellclick."+name+".click.when."+ $TemplateConfig.rightAction;
                     var v=  $TemplateConfig.rightmap[key];
                     if(v!=undefined &&  v== false ) 
                     {
                     	toastr.error("在当前状态下禁止点击");
                     	return;
                     }
                      
                     
                    handleEvent('cellClicked', null, arguments);
                },

                cellFocusGained: function (sheet, row, col) {


                    if (designMode) {
                        var design = require('./design');
                        design.loadCellProperty(sheet, row, col);
                    }

                    handleEvent('cellFocusGained', null, arguments);

                },

                error: function (info) {

                    toastr.error(info);


                }
                ,
                nameChanged: function (sheet, oldName, newName) {
                    handleEvent('sheetNameChanged', null, arguments);
                },
                // 单元格的值将发生改变，接不接受改变

                cellValueChangeAccept: function (sheet, cell, oldValue, newValue, innerRow) {
                    return handleEvent('CellValueChangeAccept', null, arguments, true);
                },
                cellValueChanged: function (sheet, cell, oldValue, newValue, innerRow) {

                    // 自动执行相关取数，对于没有绑定数据库的单元格相关取数，在此事件中触发
                    if (form.relativeDataQueryAndFillEnable) {
                        let name = sheet.GUID + '.' + cell.alias;
                        let refConfig = book.autoQueryAndFillDataConfig[name];
                        if (refConfig) {
                            relativeDataQueryAndFill(refConfig, 0);// 在此触发，肯定是单元格没有绑定数据库，那么行号，要用0，而不是innerRow（它此时为
																	// -1）
                        }
                    }


                    handleEvent('CellValueChanged', null, arguments);
                },

                cellValueChangedByEdit: function (sheet, cell, newValue, innerRow) {
                    handleEvent('CellValueChangedByEdit', null, arguments);
                },

                cellPaint: function (sheet, cell, innerRow, g, rect, data, str, before) {
                    handleEvent('cellPaint', null, arguments);
                },


                // afterEditFocusLostAndBeforeWriteBackToCell: function (sheet,
				// cell, value, innerRow)
				// {handleEvent('afterEditFocusLostAndBeforeWriteBackToCell',
				// null,arguments);},


                // 焦点变化

                cellFocusLost: function (sheet, row, col) {
                    handleEvent('cellFocusLost', null, arguments);
                },

                cellDblClicked: function (sheet, cell, innerRow) {
                    handleEvent('cellDblClicked', null, arguments);
                },
                cellRightClicked: function (sheet, cell, innerRow) {
                    handleEvent('cellRightClicked', null, arguments);
                },


                buttonOnClick: function (sheet, cell, button) {
                    var name = button.name;
                    
                    var key= sheet.guid+".brick."+name+".click.when."+ $TemplateConfig.rightAction;
                    var v=  $TemplateConfig.rightmap[key];
                    if(v!=undefined &&  v== false ) 
                    	{
                    	toastr.error("在当前状态下禁止点击");
                    	return;
                    	}
                    handleEvent(name + '_onclick', null, arguments);
                    handleEvent('VirtualButtonClicked', null, arguments);

                    if (sheet.designMode) return; // 设计模式下，不要做动作

                    var action = button.config.action || '';

                    // 审核后，单据不允许再做插入删除操作
                    if (form.type == 'bill' && ['insertBefore', 'insertAfter', 'delete'].contains(action)) {
                        if (form.billIsVerified) {
                            toastr.error("已审核，不允许再执行本操作");
                            return;
                        }  // 如果单据已经审核了

                        if (form.action.equalsIgnoreCase('view')) {
                            toastr.error("单据查看状态，不允许执行本操作");
                            return;
                        }
                    }


                    if (action == 'insertBefore') {
                        var dsc = sheet.Book.getDataSource(button.config.dsn);
                        var row = dsc.currentBindRow;
                        var ds = dsc.dataStore;
                        ds.insertRow(row);
                    }
                    if (action == 'insertAfter') {
                        var dsc = sheet.Book.getDataSource(button.config.dsn);
                        var row = dsc.currentBindRow;
                        var ds = dsc.dataStore;
                        ds.insertRow(row + 1);
                    }
                    if (action == 'delete') {
                        var dsc = sheet.Book.getDataSource(button.config.dsn);
                        var row = dsc.currentBindRow;
                        if (row < 0) return;

                        var ds = dsc.dataStore;
                        if (ds.rowCount == 0) return;

                        $.confirm({
                            animation: 'zoom',
                            closeAnimation: 'scale',
                            boxWidth: '300px',
                            useBootstrap: false,
                            title: "提示",
                            content: "确信要删除吗?",
                            buttons: {
                                confirm:
                                    {
                                        text: "确定",
                                        action:
                                            function () {
                                                ds.deleteRow(row);
                                            }
                                    },
                                cancel:
                                    {
                                        text: "取消",
                                        action: function () {
                                        }
                                    }
                            }
                        });
                    }

                    if (action == 'retrieve') {
                        $form.smartRetrieve(sheet, button.config.dsn);
                    }


                    if (action == 'print') {
                        var printSheet = null;
                        var sheetGUID = button.config.sheetGUID;
                        if (sheetGUID != 'current') printSheet = book.getWorkSheet(sheetGUID);
                        $form.print_preview_byPrintAgent(printSheet);


                    }
                },

                // keyPressed: function (sheet, e, editingRow, editingCol,
				// dbRow) {},
                // keyReleased: function (sheet, e, editingRow, editingCol,
				// dbRow) {},
                beginEdit: function (sheet, row, col, dbRow) {
                    handleEvent('beginEdit', null, arguments);
                },
                endEdit: function (sheet, row, col, dbRow, enterKeyPressed,
                                   isShiftDown, isControlDown) {
                    handleEvent('endEdit', null, arguments);
                },


                // 单元格需要重新计算
                // cellNeedRecalculate: function (sheet, cell) {},

                // 单元格的属性发生改变
                cellPropertyChanged: function (sheet, cell, propertyName, oldPropertyValue, newPropertyValue) {
                    handleEvent('cellPropertyChanged', null, arguments);
                },

                // 新建一个Sheet
                afterNew: function (sheet) {
                    handleEvent('afterNewSheet', null, arguments);
                },
                // Sheet允许删除吗

                deletePermit: function (sheet) {
                    return handleEvent('sheetDeletePermit', null, arguments, true);
                },


                isCellEditable: function (sheet, cell, innerRow) {
                    return handleEvent('isCellEditable', null, arguments, true);
                },

                //2021.10.27 输出到PDF的适配
                printToPDF: function (msg, printAdapter) {
                    $rpc("fop", "pdf.SpreadSheet2PDF", "onPrintToPDF",
                        JSON.parse(msg)
                        , function (val) {
                            console.info(val);

                            var ret = JSON.parse(val);
                            if (ret.url) {
                                open(ret.url);
                                //模拟回发一个打印完成消息给打印适配器，参数 ISheetPrint.js中的 [标记2021.11.28]
                                if (printAdapter) printAdapter.onmessage({data: JSON.stringify({action: 'printover'})});
                                hideInfoPane();
                            }
                        });
                },
                
                loadPrintConfig: function (sheet ,printConfigSaveToKey) {
                    var ret = handleEvent('loadPrintConfig', null, arguments);
                    if (ret == null) ret = "";
                    if (ret != '') return ret;

                    // 按模板+sheetguid保存页面设置
                    var ret = $rpc("formEngine", "formengine.PageSetup", "loadPrintConfig",
                        {
                            templateid: book.templateId,
                            newQueryId: book.newQueryId,
                            sheetguid: printConfigSaveToKey
                        });

                    if (ret.success) return ret.config;
                    $.alert(ret.message);
                    return "";
                },

                savePrintConfig: function (sheet,printConfigSaveToKey, config) {

                    // 按模板+sheetguid保存页面设置
                    $rpc("formEngine", "formengine.PageSetup", "savePrintConfig",
                        {
                            templateid: book.templateId,
                            newQueryId: book.newQueryId,
                            sheetguid: printConfigSaveToKey,
                            config: config
                        },
                        function (v) {
                            var r = JSON.parse(v);
                            if (!r.success) {
                                $.alert(r.message);
                                return;
                            }

                        }
                    );

                    handleEvent('savePrintConfig', null, arguments);

                },


                canPrint: function (sheet) {
                    return handleEvent('sheetPrintPermit', null, arguments, true);
                },

                afterPrint: function (sheet) {
                    handleEvent('afterSheetPrint', null, arguments);
                },


                isSysContextMenuEnable: function (sheet) {
                    return isSysUser;
                },
                // chartDataDecorate: function (sheet, /*Chart*/ chart,
				// /*ArrayList*/ data) {},

                // buildDynamicDDLB: function ( ddlbConfig, innerRow) {},


                editFocusChanged: function (sheet, lastRow, lastCol, newRow, newCol) {
                    handleEvent('editFocusChanged', null, arguments);
                },

                sheetActiveStateChanged: function (activeSheet, deActiveSheet) {
                    handleEvent('sheetActiveStateChanged', null, arguments);
                },

                onMouseMove: function (/* View */  pView, cell, /* MouseEvent */  evt) {
                    handleEvent('onMouseMove', null, arguments);
                },

                onContextMenuClicked: function (sheet, cell, innerRow, menuName) {
                    handleEvent(menuName + '_onClick', null, arguments);
                    handleEvent('contextMenuOnClick', null, arguments);
                },

                currentBindRowChanged: function (dsname, row) {
                    handleEvent('currentBindRowChanged', null, arguments);
                },

                buildToolTip: function (sheet, cell, innerRow) {
                    handleEvent('buildToolTip', null, arguments);
                },

                popupedOnOK: function (sheet) {
                    handleEvent('popupedOnOK', null, arguments);
                },
                popupedOnCancel: function (sheet) {
                    handleEvent('popupedOnCancel', null, arguments);
                },

                onDragDrop: function (type, data, sheet, cell) {
                    handleEvent('onDragDrop', null, arguments);
                },


                onTreeSelectionChanged: function (treeName, group, text, data) {
                    handleEvent('onTreeSelectionChanged', null, arguments);
                },


                onScroll: function (sheet, dir) {
                    handleEvent('onScroll', null, arguments);
                },


                treeOnClick: function (zTreeObj, treeId, treeNode) {
                    handleEvent('treeOnClick', null, arguments);
                },

                treeOnCheck: function (zTreeObj, treeId, treeNode) {
                    handleEvent('treeOnCheck', null, arguments);
                },

                // isBalloonTipEditPermit: function ( dsname, dbcol, innerRow)
				// {},


                columnWidthChanged: function (sheet, col, oldWidth, newWidth) {
                    handleEvent('columnWidthChanged', null, arguments);
                },
                rowHeightChanged: function (sheet, row, oldHeight, newHeight) {
                    handleEvent('rowHeightChanged', null, arguments);
                },


                /**
				 * 划屏到顶部时的提示内容
				 * 
				 * @param sheet
				 */
                loadMoreTipInfoWhenScrollToTop: function (sheet) {
                    return handleEvent('loadMoreTipInfoWhenScrollToTop', null, arguments);
                },

                /**
				 * 划屏到顶部并松开手后触发的事件
				 * 
				 * @param sheet
				 */
                loadMoreWhenScrollToTop: function (sheet) {
                    handleEvent('loadMoreWhenScrollToTop', null, arguments);
                },
                /**
				 * 划屏到底部时的提示内容
				 * 
				 * @param sheet
				 */
                loadMoreTipInfoWhenScrollToBottom: function (sheet) {
                    return handleEvent('loadMoreTipInfoWhenScrollToBottom', null, arguments);
                },
                /**
				 * 划屏到底部并松开手后触发的事件
				 * 
				 * @param sheet
				 */
                loadMoreWhenScrollToBottom: function (sheet) {
                    handleEvent('loadMoreWhenScrollToBottom', null, arguments);
                },


                deleteAttachment: function (sheet, dbpool, logTable, attachmentData) {
                    // deleteUploadedFile 在 globalScript/upload.js中
                    return deleteUploadedFile(dbpool, logTable || 'app_fileupload', attachmentData.id);
                },

                attachmentOrderChanged: function (sheet, config, ids) {
                    form.attachmentOrderChanged(config, ids);
                }


            });

            // 如果是运行模式，且只有一个工作表，那么隐藏tab
            if (!designMode && book.workSheetCount == 1) book.getWorkBookView().setShowTabOnWhere("none");

            // 刷新一下显示，避免界面长时间没有反应

            book.activeSheet.setActive(true); // 强制再激活一下，让它重新调整卷滚条

            book.setAllSheetsPaintPermit(true);
        }

        /**
		 * 看看当前模板是不是一个单据表
		 */
        function perhapsIsBill() {
            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) return false;
            var ds = dsc.dataStore;
            if (ds.col2Index("billno") >= 0 && ds.col2Index("billdate") > 0 && ds.col2Index("userid") >= 0) return true;
            return false;
        }

        // 本函数应该是billEdit.jsp中使用
        function billIsVerified() {

            if (form.type != 'bill') return false;

            var dsc = book.getDataSource(form.masterTableName);
            if (dsc == null) return false;
            var ds = dsc.dataStore;

            return (ds.getInt(0, 'verifierid') > 0)

        }

        /**
		 * 把 col1:ds1.col1 col2:ds1.col2 这样的对应关系配置，转换成{col1: {ds:'ds1' ,
		 * col:'col1' } ....}这样的JSON键值对 如有修改，请同步 design.js中的同名函数
		 * 
		 * @param maps
		 */
        function buildColMap(maps) {
            return Tools.buildColMap(maps);
        }

        function relativeDataQueryAndFill(refConfig, innerRow) {

            if (!form.relativeDataQueryAndFillEnable) {
                console.info("自动取数功能被临时禁用了");
                return;
            }

            for (let i = 0; i < refConfig.length; i++) {
                let one = refConfig[i];
                let sql = one.query;
                let colMap = one.colMap;
                if (!colMap) {
                    colMap = buildColMap(one.map);
                    one.colMap = colMap;

                }

                // 创建DataStore缓存
                // 不要加到book.dataSource中去，
                if (form.relativeDataQueryAndFillDataStoreCache == undefined) form.relativeDataQueryAndFillDataStoreCache = {};
                var ds = form.relativeDataQueryAndFillDataStoreCache[sql];
                if (ds == undefined) {

                    ds = newDataStore(one.dbpool, sql);

                    ds.EM.addListener(
                        {

                            parseInnerParameter: function (expression) {
                                var sheet = book.activeSheet;
                                return sheet.evaluate(expression, ds.evaluateInnerRow); // ds.evaluateInnerRow
																						// 在使用时再赋值

                            }
                        });

                    ds.setOnceRetrieveCount(1);
                    form.relativeDataQueryAndFillDataStoreCache[sql] = ds;
                }

                ds.evaluateInnerRow = innerRow; //
                ds.retrieve();


                for (let ci = 0; ci < colMap.length; ci++) {
                    let cp = colMap[ci];
                    let v = ds.getValue(0, cp.source);
                    if (cp.target.alias) {
                        var toCell = book.activeSheet.cells(cp.target.alias);
                        if (toCell) {
                            toCell.setValue(v);
                        } else {
                            toastr.error(" 取数定义,不存" + cp.target.alias + "在此别名的单元格");
                        }
                    } else {
                        book.getDataSource(cp.target.ds).dataStore.setValue(innerRow, cp.target.col, v);
                    }
                }

            }
        }

        function initDataSource(book, dataSource, designMode) {

            // 开始使用 g_dbConfig= dataSource 这样不行，因为最后的 标记1处的return 先返回了
			// g_dbConfig
            // 现在重新赋值，也不能改变 标记1处的返回结果，只有把 g_dbConfig当作一个对象容器，再给它里面塞东西，是可以的
            g_dbConfig.dataSource = dataSource;

            var t = window.location.href;
            var homeURL = t.substring(0, t.lastIndexOf('/')  );
            
            if (designMode) $("#dsn").append("<option value=''>【无】</option>");


            for (var dsc  in  dataSource) {

                let one = dataSource[dsc];

                if (!one.select) {
                    $.alert(dsc + "可能没有成功创建。可能的原因是：1字段名不合法，比如重名，2 字段类型没有定义。请进入数据库设置，选中表，再点击“创建表”，查看日志提示以获取更详细的信息");
                    continue;
                }
                let dsLabel = one.label;

                let ds = new DataStore(one.dbpool, one.select, homeURL, one.dialect, one.column);

                ds.label = dsLabel; //
                ds.name = one.table;
                ds.id = one.tableid;
                ds.templateid = one.templateid;


                ds.setAsNoDataIfOnlySuchColumnsHoldData(one.AsNoDataIfOnlySuchColumnsHoldData);

                window['$' + dsc + "_ds"] = ds;

                // 2020.05.09 增加给主表的结果集增加一个全局别名 $master_ds
                // 给明细表结果集增加全局别名 $detail_ds ,如果有多个明细表，那么它指向最后一个明细表
                if(  dsc== form['masterTableName'] )
                {
                    window['$master_ds'] = ds;
                }else{
                    if (one.type == 'table' && one.isMultiRow) {
                        window['$detail_ds'] = ds;
                    }
                }


                // 计算列
                if (one.computer) {
                    for (var i = 0; i < one.computer.length; i++) {
                        var oneC = one.computer[i];
                        ds.createComputer(oneC.name, oneC.expression, oneC.fillback);
                    }
                }

                // 查询结果集，也可能是是允许更新的，如果定义了主键，通常是需要让查询结果集可以更新
                if (one.type == 'table') {
                    ds.setUpdateProperty(one.table, one.primaryKey, "*", one.primaryKey);
                } else {
                    if (one.updatedtable != '' && one.primaryKey != '') {
                        ds.setUpdateProperty(one.updatedtable, one.primaryKey, "*", one.primaryKey);
                    }
                }


                var  str2ArraySplitWithEnger =function( str) {
                    str = str.replace(/(\s)+_(\s)*\n/g, ''); // 把折行符号去掉
                    str = str.split('\n');
                    let w = [];
                    for (let wi = 0; wi < str.length; wi++) {
                        let s = str[wi].trim();
                        if (s.startsWith('--')) continue; // 这是一个注释行
                        if (s == '') continue;
                        w.push(s);
                    }
                    console.dir(w);
                    return w;
                }


                // 动态检索条件

                ds.dynamicWhere = str2ArraySplitWithEnger(  one.dynamicwhere || '') ;
                // 2020.04.20 后台动态检索条件评估时的上下文数据定义
                ds.dynamicWhereData2 = str2ArraySplitWithEnger(  one.dynamicwheredata2 || '') ;


                book.addDataSource(one.table, ds, one.isMultiRow ? 2 : 1); // 增加数据源
                // 注意，要在addDataSource之后，再检索数据，因为此时事件侦听已经注册，下面的retrieveFromData触发的事件book内建的事件侦听才能接收到
                // book内部有ds的事件接收处理器，它会在检索完成后重置卷滚条
                // ds.retrieveFromData(one.data, one.where);

                // 在下面事件注册前，先完成 数据检索，避免加载数据时触发事件，影响性能。
                if (!designMode) {
                    let dsname = one.table;

                    ds.EM.addListener(
                        {
                            itemChanged: function (row, col, oldValue, newValue) {

                                // 2019.04 增加对相关自动取数的支持
                                if (form.relativeDataQueryAndFillEnable) {
                                    let name = dsname + '.' + col;
                                    let refConfig = book.autoQueryAndFillDataConfig[name];
                                    if (refConfig) {
                                        relativeDataQueryAndFill(refConfig, row);
                                    }
                                }


                              // handleEvent('itemChanged', dsname,
								// arguments);
                                
                                handleEvent('DataStoreItemChanged', dsname, arguments);

                                // 2020.04.16 如果配置了自动保存，那么延时后自动保存
                                // || 的优化先比 == 低，所以需要 ( ) 再与'true'比较
                                if ( (window.$moduleConfig.autosave || '' )== 'true') {
                                    setTimeout(function () {
                                        form.save(false);
                                    }, window.$moduleConfig.autosavedelay * 1000);
                                }
                            },


                            itemChangeAccept: function (row, col, value) {
                               // return handleEvent('itemChangeAccept',
								// dsname, arguments, true);
                            	return handleEvent('DataStoreItemChangeAccpet', dsname, arguments, true); 
                            },


                            beforeRetrieve: function () {
                                return handleEvent('DataStoreBeforeRetrieve', dsname, arguments, true);
                            },

                            retrieveEnd: function (rowCount, withLastSelect) {
                                handleEvent('DataStoreRetrieveEnd', dsname, arguments);
                            },


                            retrieveOnceMoreEnd: function (retrieveTimes, rowCount) {
                                handleEvent('DataStoreRetrieveOnceMoreEnd', dsname, arguments);
                            },


                            computerChanged: function (row, computer) {
                                handleEvent('computerChanged', dsname, arguments);
                            },


                            afterDeleteRow: function (row) {
                                handleEvent('afterDeleteRow', dsname, arguments);
                            },

                            afterInsertRow: function (row) {
                                handleEvent('afterInsertRow', dsname, arguments);
                            },


                            deleteRowPermit: function (row) {
                                return handleEvent('deleteRowPermit', dsname, arguments, true);
                            },

                            getExportValue: function (row, col) {
                                var v = handleEvent('getExportValue', dsname, arguments, null);
                                if (v != null) return v;

                                var cells = book.getDataSource(dsname).DSEA.getAllCellsWhichBindTheCol(col);
                                if (cells == null) return null;
                                for (var i = 0; i < cells.length; i++) {
                                    var cell = cells[i];
                                    if (!cell.visible) continue;
                                    return cell.getShowText(row);
                                }

                                return null;
                            },

                            afterSort: function () {
                                handleEvent('afterSort', dsname, arguments);
                            },


                            validate: function (row) {

                                // 当在脚本中直接使用 ds.update时，可能会因为没有填入gguid 而有问题

                                if (ds.getString(row, "gguid").equals("")) ds.setValue(row, "gguid", form.GUID);

                                var b = handleEvent('validate', dsname, arguments, true);

                                return b;


                            },


                            sqlPreview: function (sql) {
                                handleEvent('sqlPreview', dsname, arguments);
                            },


                            afterFilter: function (primaryBufferRowCount, filterBufferRowCount) {
                                handleEvent('afterFilter', dsname, arguments);
                            },

                            orderByChanged: function () {
                                $form.smartRetrieve(book.activeSheet, dsname); // 执行智能检索
                                handleEvent('orderByChanged', dsname, arguments);
                            },


                            // parseInnerParameter: function (parameterName) {
                            // return handleEvent('parseInnerParameter', dsname,
							// arguments, null);
                            // },


                            autoCheckError: function (table, row, col, checkType, errorInfo) {


                                var cells = book.getDataSource(table).getAllCellsWhichBindTheCol(col);
                                if (cells.length == 0) {
                                    toastr.error(errorInfo);
                                } else {
                                    cells[0].grumble(errorInfo, 100, 2000);// 气泡提示
                                }


                                handleEvent('autoCheckError', dsname, arguments);
                            },


                            afterReset: function () {
                                handleEvent('afterReset', dsname, arguments);
                            },


                            beforeGetValue: function (row, col) {
                                handleEvent('beforeGetValue', dsname, arguments);
                            },


                            onError: function (code, description) {

                                handleEvent('onError', dsname, arguments);
                            
                                    if(  description.indexOf('unique' )> 0   )
                                   {
                                    	 handleEvent('duplicateKeyErrorOnUpdate', dsname, [description]);
                                    }
                                    	
                                
                            },


                            beforeDeleteRow: function (row) {
                                handleEvent('beforeDeleteRow', dsname, arguments);
                            },


                            insertRowPermit: function (row) {
                                return handleEvent('insertRowPermit', dsname, arguments, true);
                            }
                        });


                }


                if (designMode) {
                    // 数据源，及字段列表
                    $("#dsn").append("<option value='" + one.table + "'>【" + one.table + '】' + (one.table != one.label ? one.label : '') + "</option>");
                    var options = [];
                    options.push({label: "【无】", value: ""});
                    for (var i = 0; i < one.column.length; i++) {
                        var oneCol = one.column[i];
                        options.push({
                            label: "【" + oneCol.name + '】' + (oneCol.name != oneCol.label ? oneCol.label : ''),
                            value: oneCol.name
                        });
                    }
                    for (var i = 0; i < one.computer.length; i++) {
                        var oneCol = one.computer[i];
                        options.push({
                            value: oneCol.name,
                            label: "【" + oneCol.name + '】' + (oneCol.name != oneCol.label ? oneCol.label : '')
                        });
                    }

                    g_dsb2colselect[one.table] = options;
                }

            }


        }


// 加载列表清单
        function getAllDDLBNameList() {
            $rpc("formEngine", "formengine.DDLB", "getAllDDLBNameList", {},
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        g_ddlbNameList = ret.ddlbs;
                        if ($('#ddlbName')) {
                            $("#ddlbName").autocomplete({
                                delay: 200,
                                autoFocus: false,
                                source: ret.ddlbs,
                                minLength: 0,
                            }).focus(function () {
                                $(this).autocomplete("search");
                            });

                        }
                    } else {
                        toastr.error(ret.message);
                    }
                }
            );

        }


// 加载树清单
        function getAllTreeNameList() {
            $rpc("formEngine", "formengine.TREE", "getAllTreeNameList", {},
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        g_treeNameList = ret.trees;
                        if ($('#treeName')) {
                            $("#treeName").autocomplete({
                                delay: 200,
                                autoFocus: false,
                                source: ret.trees,
                                minLength: 0,
                            }).focus(function () {
                                $(this).autocomplete("search");
                            });

                        }
                    } else {
                        toastr.error(ret.message);
                    }
                }
            );

        }


// /////////////////////////////////////////////////////////////////
        var g_dropDownDataCache = {};
        var g_dropDownDataCacheIsLoading = {};


        function str2ddlbData(val) {

            if( val==null) return;
            var showText = [];
            var dataValue = [];
            var dropDownData = {showText: showText, dataValue: dataValue, inited: true};

            let t = val.split('\n');
            for (var i = 0; i < t.length; i++) {
                var one = t[i];

                var s = one.indexOf(';') > 0 ? one.split(';') : one.split(':');
                if (s.length == 1) {
                    if (s[0].trim() == '') continue;
                    dataValue.push(s[0]);
                    showText.push(s[0]);
                } else {
                    if (s[0].trim() == '') continue;
                    dataValue.push(s[0]);
                    showText.push(s[1]);
                }
            }
            return dropDownData;
        }

        function loadDDLBList(es, cell, showDebugInfo) {
            // ddlbName可能是空字符串，因此在拼key时，需要把ddlbInnerItems也拼上
            let key = es.ddlbName + es.ddlbInnerItems;
            if( key=='selfvalue')
            	{
            	var bind= cell.bind;
            	key= "selfvalue@"+ bind.dataSource+"@"+bind.DBCol ; 
            	}
            var ddd = g_dropDownDataCache[key];
            if (ddd != undefined) {
                if (showDebugInfo) console.info("从缓存中取得列表数据 " + es.ddlbName);
                es.dropDownData = ddd;
                // 加载完列表后，让cell重绘
                if (cell.Book) {
                    if (cell.Book.View) cell.repaint();
                }
                return;
            }

            // 2020.04.02 当多个单元格使用同一个列表时，因为列表是异步获取的，所以可能会现重复加载，需要避免
            if (g_dropDownDataCacheIsLoading[key]) {
                console.info(es.ddlbName + " 已经在获取中，无需重复获取，[" + cell.name + ']' + cell.alias + "静候结果, 100 ms后再从缓存加载...");
                setTimeout(function () {
                    loadDDLBList(es, cell, showDebugInfo);
                }, 100);
                return;
            }

            g_dropDownDataCacheIsLoading[key] = true;
            if (showDebugInfo) console.info("正在从服务器中取得列表数据 " + es.ddlbName);
            $rpc("formEngine", "formengine.DDLB", "getDDLBList", {name: es.ddlbName, ddlbInnerItems: es.ddlbInnerItems ,
            	    bind: cell.bind==null?{}: { dsn:  book.getDataSource( cell.bind.dataSource).DBPoolName , table:cell.bind.dataSource , col:cell.bind.DBCol} },
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        if (ret.type == 'formula') {
                            var sheet = cell.Sheet;
                            let val = sheet.evaluate(ret.formula, -1, false, null);
                            ret.dropDownData = str2ddlbData(val);
                        }

                        // 内建列表项目追加到列表尾部
                        var ddlbInnerItems = es.ddlbInnerItems || '';
                        var ts = ddlbInnerItems.split('\n');
                        for (let ti = 0; ti < ts.length; ti++) {
                            let one = ts[ti];
                            var pair = one.indexOf(';') > 0 ? one.split(';') : one.split(':');
                            if (pair.length == 0) continue;
                            if (pair.length == 1) pair.push(one);

                            let v = pair[0].trim();
                            let vs = pair[1].trim();

                            if (v == '') continue;
                            if (ret.dropDownData.dataValue.contains(v)) continue;
                            ret.dropDownData.dataValue.push(v);
                            ret.dropDownData.showText.push(vs);

                        }


                        g_dropDownDataCache[key] = ret.dropDownData;

                        es.ddlbType = ret.type; // 记下列表的类型
                        es.ddlbFormula = ret.formula;
                        es.minLenInput = ret.minLenInput;


                        loadDDLBList(es, cell, false);

                    }
                    else {
                        toastr.error(ret.message);
                    }
                    // 好了， 把正在加载中的标记删除
                    delete g_dropDownDataCacheIsLoading[key];

                }
            );
        }

// 有交互条件时，按交互条件构建编辑时的列表
        function loadDDLBListForEdit(es, cell, innerRow) {
            // return null 表示 不定制列表，而是使用初始化时的列表数据

            // 2019.09.11 增加，改用cell所在的sheet 来解析公式，而不是activeSheet ,因为
            var sheet = cell.Sheet;

            if (!sheet) sheet = book.activeSheet;


            if (es.ddlbFilterBy == null) return null;
            if (es.ddlbFilterBy == '') return null;


            var val = sheet.evaluate(es.ddlbFilterBy, innerRow, false, null);
            if (val == null) return null;

            var key = es.ddlbName + es.ddlbInnerItems + '-' + val;

            var ddd = g_dropDownDataCache[key];
            if (ddd != undefined) {
                console.info("从缓存中取得交互列表数据 " + key);
                return ddd;
            }

            if (es.ddlbType == 'formula') {

                let val = sheet.evaluate(ret.formula, innerRow, false, null);
                ret.dropDownData = str2ddlbData(val);
                g_dropDownDataCache[key] = ret.dropDownData;
                return ret.dropDownData
            }

            console.info("正在从服务器中取得列表数据 " + key);
            var ret = $rpc("formEngine", "formengine.DDLB", "getDDLBList", {
                name: es.ddlbName,
                filter: val,
                ddlbInnerItems: es.ddlbInnerItems
            });

            if (ret.success) {


                g_dropDownDataCache[key] = ret.dropDownData;
                return ret.dropDownData
            } else {
                toastr.error(ret.message);
                return null;
            }

        }

// ////////////////////////////////////////////////////////////////////////////

        var g_treeNodesCache = {};

        function str2treeNodes(val) {
            if (typeof val == 'string') return JSON.parse(val);
            return val;
        }

        function loadTreeNodes(es, cell, showDebugInfo) {
            var sheet = book.activeSheet;

            var ddd = g_treeNodesCache[es.treeName];
            // 增加对treeNodesInited的判断，因为在树中，可能点击了刷新按钮，将此变量设置成false ,强制重新获取
            // 标记20180902
            if (ddd != undefined && es.treeNodesInited) {
                if (showDebugInfo) console.info("从缓存中取得树数据 " + es.treeName);
                es.treeNodes = ddd;
                es.treeNodesInited = true;
                // 加载完树后，让cell重绘
                if (cell.Book) {
                    if (cell.Book.View) cell.repaint();
                }
                return;
            }

            if (showDebugInfo) console.info("正在从服务器中取得树数据 " + es.treeName);
            $rpc("formEngine", "formengine.TREE", "getTREENodes", {name: es.treeName},
                function (retValue) {
                    var ret = JSON.parse(retValue);
                    if (ret.success) {

                        if (ret.type == 'formula') {
                            let val = sheet.evaluate(ret.formula, -1, false, null);
                            ret.treeNodes = str2treeNodes(val);
                            if (ret.treeNodes == null) {
                                ret.treeNodes = [{id: "a", pid: "", name: ret.formula + "解析异常", open: true}];
                            }

                        }

                        g_treeNodesCache[es.treeName] = ret.treeNodes;

                        es.treeDataType = ret.type; // 记下树的类型
                        es.treeDataFormula = ret.formula;
                        es.treeNodesInited = true; // 很重要，下面的递归进去后，此变量正确设置才能保证不死循环，参看标记20180902

                        loadTreeNodes(es, cell, false);
                    } else {
                        toastr.error(ret.message);
                    }
                }
            );
        }


        /**
		 * 虽然有缓存处理，但要注意，如果树点了刷新，那么树需要重新初始化
		 * 
		 * @param es
		 * @param cell
		 * @param innerRow
		 * @returns {*}
		 */
        function loadTreeNodesForEdit(es, cell, innerRow) {
            // return null 表示 不定制树，而是使用初始化时的树数据

            var sheet = book.activeSheet;


            if (es.treeNodesInited) {
                if (es.treeFilterBy == null) return null;
                if (es.treeFilterBy == '') return null;
            }

            var val = sheet.evaluate(es.treeFilterBy, innerRow, false, null);
            if (val == null) return null;

            var key = es.treeName + '-' + val;

            var ddd = g_treeNodesCache[key];
            if (ddd != undefined && es.treeNodesInited) {
                console.info("从缓存中取得交互树数据 " + key);
                return ddd;
            }

            if (es.treeDataType == 'formula') {

                let val = sheet.evaluate(es.treeDataFormula, innerRow, false, null);
                es.treeNodes = str2treeNodes(val);
                g_treeNodesCache[key] = es.treeNodes;
                es.treeNodesInited = true;
                return es.treeNodes
            }

            console.info("正在从服务器中取得树数据 " + key);
            var ret = $rpc("formEngine", "formengine.TREE", "getTREENodes", {name: es.treeName, filter: val});

            if (ret.success) {


                g_treeNodesCache[key] = ret.treeNodes;
                es.treeNodesInited = true;

                return ret.treeNodes
            } else {
                toastr.error(ret.message);
                return null;
            }

        }


        return {   // 标记1
            getTemplateConfig: getTemplateConfig,
            getAllDDLBNameList: getAllDDLBNameList,
            getAllTreeNameList: getAllTreeNameList,
            getNextBillNo:getNextBillNo,
            g_dbConfig: g_dbConfig,
            g_dsb2colselect: g_dsb2colselect, // 数据源中的字段列表
            g_ddlbNameList: g_ddlbNameList,
            g_treeNameList: g_treeNameList

        };
    }
)
;

/**
 * @apiDefine UIGroup UI函数
 */


/**
 * @api {showInfoPane} 函数 showInfoPane
 * 
 * @apiDescription showInfoPane( info [,x ,y ]) <br>
 *                 <br>
 *                 显示一个提示信息，信息窗口按内容自动布局，显示于屏幕正中间 <br>
 * 
 * @apiName showInfoPane
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 * 
 * @apiParam {String} info 要输出显示的信息，可以是html
 * @apiParam {int} x x坐标。可选参数，如果为null表示让系统自动水平居中显示
 * @apiParam {int} y y坐标。可选参数，如果为null表示让系统自动垂直居中显示
 * @apiParam {int} delayMS 可选参数，如果定义了本参数，表明在delayMS毫秒后，关闭提示信息
 * 
 * 
 * 
 * @apiSuccess (返回值){void} - 无返回值
 * 
 * @apiExample {js}示例：
 * 
 * showInfoPane("<div style='width:300px;
 * padding:15px;text-align:center;'>正在检索...</div>");
 * 
 * showInfoPane("*正在检索..."); //试试这句的效果
 * 
 */


/**
 * @api {hideInfoPane} 函数 hideInfoPane
 * 
 * @apiDescription hideInfoPane( ) <br>
 *                 <br>
 *                 关闭信息显示窗口 <br>
 * 
 * @apiName hideInfoPane
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 * 
 * 
 * @apiSuccess (返回值){void} - 无返回值
 * 
 * @apiExample {js}示例：
 * 
 * showInfoPane("<div style='width:300px;
 * padding:15px;text-align:center;'>正在检索...</div>"); setTimeout( function() {
 * hideInfoPane(); },2000);
 * 
 */


/**
 * @api {toastr.info} 函数 toastr.info
 * 
 * @apiDescription toastr.info( info ) <br>
 *                 <br>
 *                 显示一段提示信息，并在2秒后自动关闭 <br>
 * 
 * @apiName toastr.info
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 * 
 * @apiParam {String} info 要显示的信息，
 * 
 * @apiSuccess (返回值){void} - 无返回值
 * 
 * @apiExample {js}示例：
 * 
 * toastr.info("成功完成");
 * 
 */


/**
 * @api {toastr.error} 函数 toastr.error
 * 
 * @apiDescription toastr.error( info ) <br>
 *                 <br>
 *                 显示一段异常信息，并在2秒后自动关闭 <br>
 * 
 * @apiName toastr.error
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 * 
 * @apiParam {String} info 要显示的信息，
 * 
 * @apiSuccess (返回值){void} - 无返回值
 * 
 * @apiExample {js}示例：
 * 
 * toastr.error("操作异常");
 * 
 */


/**
 * @api {toastr.warning} 函数 toastr.warning
 * 
 * @apiDescription toastr.warning( info ) <br>
 *                 <br>
 *                 显示一段警告信息，并在2秒后自动关闭 <br>
 * 
 * @apiName toastr.warning
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 * 
 * @apiParam {String} info 要显示的信息，
 * 
 * @apiSuccess (返回值){void} - 无返回值
 * 
 * @apiExample {js}示例：
 * 
 * toastr.warning("成功完成");
 * 
 */

