define(function (require) {

	
		var inited=false;

        const $ES =  spreadsheet.core.EditStyle;
        const Tools = spreadsheet.util.Tools;


        const CP = require('./colorPalette');
        const CP20 = require('./color20Palette');


        $(document).ready(function () {


          //  if ((urlArgs.type || '') != 'design') return;


            $(window).keydown(function (event) {

                if(!event.key) return;

                var keyName = event.key.toLocaleLowerCase();
                // 截获  Ctrl + S 保存模板

                if ((event.metaKey || event.ctrlKey) && event.keyCode == 83) {

                    event.stopPropagation();
                    event.preventDefault();

                    saveTemplate();

                    return false;

                }

                //Ctrl +D  清除

                if ((event.metaKey || event.ctrlKey) && event.keyCode == 68) {

                    event.stopPropagation();
                    event.preventDefault();

                    doInSelection(function (cell) {
                        cell.clear();
                    });

                    return false;

                }


                //Ctrl +C
                if ((event.metaKey || event.ctrlKey) && event.keyCode == 67) {

                    if (isFormControl(event)) return;

                    event.stopPropagation();
                    event.preventDefault();

                    book.activeSheet.copy();


                    return false;

                }


                //Ctrl +V
                if ((event.metaKey || event.ctrlKey) && event.keyCode == 86) {

                    if (isFormControl(event)) return;


                    event.stopPropagation();
                    event.preventDefault();

                    onPaste(event);


                    return false;

                }


                //Ctrl +X
                if ((event.metaKey || event.ctrlKey) && event.keyCode == 88) {

                    if (isFormControl(event)) return;

                    event.stopPropagation();
                    event.preventDefault();

                    eraseCells();

                    return false;

                }


                //Ctrl +Z   TODO spreadsheet 的  redo undo 有点问题
                if ((event.metaKey || event.ctrlKey) && event.keyCode == 90) {
                    if (form.type == 'bill') form.save();  //单据编辑，增加保存的快捷键
                    event.stopPropagation();
                    event.preventDefault();
                    //
                    book.activeSheet.CM.undo();
                    return false;

                }


                //Ctrl +Y

                if ((event.metaKey || event.ctrlKey) && event.keyCode == 89) {
                    if (form.type == 'bill') form.save();  //单据编辑，增加保存的快捷键
                    event.stopPropagation();
                    event.preventDefault();
                    //
                    book.activeSheet.CM.redo();
                    return false;

                }

                //Ctrl +B
                if ((event.metaKey || event.ctrlKey) && keyName == 'b') {

                    if (isFormControl(event)) return;

                    event.stopPropagation();
                    event.preventDefault();

                    setFontBold();

                    return false;

                }


                if (keyName == 'backspace' || keyName == 'delete') {

                    doErase(event);
                }


                return true;

            });


            function doErase(event) {
                if (event.target.tagName == 'CANVAS') {
                    event.stopPropagation();
                    event.preventDefault();
                    eraseCells();
                    return false;
                }
            }

            var isFormControl = function (event) {
                var tag = event.target.tagName;
                if (tag == 'INPUT') return true;
                if (tag == 'SELECT') return true;
                if (tag == 'INPUT') return true;
                if (tag == 'DIV') return true;
                if (tag == 'TEXTAREA') return true;

                return false;
            }

            var toolbar = getStringFromURL('formEngine/template_toolbar.html');
            $('#toolbarContainer').html(toolbar);

            var html = [];
            for (var i = 0; i < CP.length; i++) {
                html.push('<div class="colorCell  fontColor"  style="background-color:#' + CP[i] + '" title="#' + CP[i] + '"></div>');
            }
            $('#font-color-panel').html(html.join(''));

            html = [];
            for (var i = 0; i < CP20.length; i++) {
                html.push('<div class="colorCell  fontColor"  style="background-color:#' + CP[i] + '" title="#' + CP[i] + '"></div>');
            }
            $('#font-color-panel2').html(html.join(''));

            html = [];
            for (var i = 0; i < CP.length; i++) {
                html.push('<div class="colorCell  backColor"  style="background-color:#' + CP[i] + '" title="#' + CP[i] + '"></div>');
            }
            $('#back-color-panel').html(html.join(''));

            html = [];
            for (var i = 0; i < CP.length; i++) {
                html.push('<div class="colorCell  borderColor"  style="background-color:#' + CP[i] + '" title="#' + CP[i] + '"></div>');
            }
            $('#border-color-panel').html(html.join(''));


            $('#view_bordercolor').css('color', 'gray');

            //自定义颜色面板初始化

            var colorpickerInput = $("#font-color-panel-custom");

            colorpickerInput.spectrum({
                color: "#ffffff",
                flat: true,
                showInput: true,
                className: "full-spectrum",
                clickoutFiresChange: false,
                showInitial: true,
                showPalette: false,
                showSelectionPalette: true,
                maxPaletteSize: 10,
                preferredFormat: "hex",
                localStorageKey: "spectrum.example",
                move: function (color) {
                },
                show: function () {

                },
                change: function (c) {

                    setFontColor(null, c.toHexString());
                    $(document).trigger('click');

                },
                beforeShow: function () {
                    $('.sp-cancel').css('visibility', 'hidden');

                    $('.sp-input').css('background-color', 'white');
                    $('.sp-choose').text('确认');

                },
                hide: function (color) {
                }
            });

            //点击选择颜色，弹出面板后，把颜色回设置到颜色面板上
            $('#cb_textcolor').click(function () {
                setTimeout(loadTextColor, 100);
            });


            //自定义颜色面板初始化

            var bkcolorpickerInput = $("#back-color-panel-custom");

            bkcolorpickerInput.spectrum({
                color: "#ffffff",
                flat: true,
                showInput: true,
                className: "full-spectrum",
                clickoutFiresChange: false,
                showInitial: true,
                showPalette: false,
                showSelectionPalette: true,
                maxPaletteSize: 10,
                preferredFormat: "hex",
                localStorageKey: "spectrum.example",
                move: function (color) {
                },
                show: function () {

                },
                change: function (c) {

                    setBackColor(null, c.toHexString());
                    $(document).trigger('click');

                },
                beforeShow: function () {
                    $('.sp-cancel').css('visibility', 'hidden');
                    $('.sp-input').css('background-color', 'white');
                    $('.sp-choose').text('确认');

                },
                hide: function (color) {
                }
            });

            //点击选择颜色，弹出面板后，把颜色回设置到颜色面板上
            $('#cb_backcolor').click(function () {
                setTimeout(loadBackColor, 100);
            });


            //自定义颜色面板初始化

            var bordercolorpickerInput = $("#border-color-panel-custom");

            bordercolorpickerInput.spectrum({
                color: "#ffffff",
                flat: true,
                showInput: true,
                className: "full-spectrum",
                clickoutFiresChange: false,
                showInitial: true,
                showPalette: false,
                showSelectionPalette: true,
                maxPaletteSize: 10,
                preferredFormat: "hex",
                localStorageKey: "spectrum.example",
                move: function (color) {
                },
                show: function () {

                },
                change: function (c) {

                    setBorderColor(null, c.toHexString());
                    $(document).trigger('click');

                },
                beforeShow: function () {
                    $('.sp-cancel').css('visibility', 'hidden');

                    $('.sp-input').css('background-color', 'white');
                    $('.sp-choose').text('确认');

                },
                hide: function (color) {
                }
            });

            //点击选择颜色，弹出面板后，把颜色回设置到颜色面板上
            $('#cb_bordercolor').click(function () {
                setTimeout(loadBorderColor, 100);
            });


            setEditType();

            $('#cb_save').click(saveTemplate);


            $('#cb_newWorkSheet').click(function () {
                book.newWorkSheet();
            });
            $('#cb_deleteWorkSheet').click(function () {
                book.deleteWorkSheet(book.activeSheet.index);
            });


            $('#cb_cut').click(doCut);
            $('#cb_copy').click(doCopy);
            $('#cb_paste').click(doPaste);


            $('#cb_insertRow').click(insertRow);
            $('#cb_insertRow_before').click(insertRowBefore);

            $('#cb_deleteRow').click(deleteRow);

            $('#cb_insertColumn').click(insertColumn);
            $('#cb_insertColumn_before').click(insertColumnBefore);

            $('#cb_deleteColumn').click(deleteColumn);


            $('#cb_clear').click(eraseCells);

            $('#cb_autoSelectDblClickSortColumn').click(autoSelectDblClickSortColumn);

            $('#cb_fontbold').click(setFontBold);
            $('#cb_fontitalic').click(setFontItalic);
            $('#cb_fontunderline').click(setFontUnderline);
            $('#cb_fontwordwrap').click(setFontWordwrap);


            $('#cb_alignleft').click(setAlignLeft);
            $('#cb_aligncenter').click(setAlignCenter);
            $('#cb_alignright').click(setAlignRight);


            $('#cb_aligntop').click(setAlignTop);
            $('#cb_alignmiddle').click(setAlignMiddle);
            $('#cb_alignbottom').click(setAlignBottom);


            $('#cb_merge').click(setMerge);
            $('#cb_unmerge').click(setUnMerge);


            $('#barcodeType').change(setBarcodeType);
            $('#barcodeWidth').change(setBarcodeWidth);

            $('#barcodeCenterImageURL').change(setBarcodeCenterImageURL);

            $('#barcodeHeight').change(setBarcodeHeight);
            $('#barcodeTextMargin').change(setBarcodeTextMargin);
            $('#barcodeTextVisible').click(setBarcodeTextVisible);


            $('#font-family').change(setFontName);
            $('#font-size').change(setFontSize);


            $('.fontColor').click(setFontColor);
            $('.backColor').click(setBackColor);
            $('.borderColor').click(setBorderColor);


            $('#cb_alias_auto').click(autoSetAlias);


            $('#cb_border_all').click(setBorderAll);
            $('#cb_border_outer').click(setBorderOuter);
            $('#cb_border_inner').click(setBorderInner);


            $('#cb_border_left').click(setBorderLeft);
            $('#cb_border_top').click(setBorderTop);
            $('#cb_border_right').click(setBorderRight);
            $('#cb_border_bottom').click(setBorderBottom);

            $('#cb_border_bottom_dotted').click(setBorderBottomDotted);
            $('#cb_border_null').click(setBorderNull);

            $('#cb_gridline').click(setGridlineVisible);
            $('#cb_alias').click(setAliasVisible);
            $('#cb_bind').click(setBindVisible);
            $('#cb_formula').click(setFormulaVisible);

        
            $('#cb_db')[0].href =  "workbook_db_frame.jsp?type=form&id=" + urlArgs.id;
         //   $('#cb_template')[0].href = configHome + "/config_tree_main.jsp?table=app_template&leftwidth=0.1" +     "&limitWhere=id=%27" + urlArgs.id + "%27";


            $('#cb_clearBind').click(clearBind);
            $('#ddlb_jumpto').click(jumpToDDLBDefine);
            $('#tree_jumpto').click(jumpToTreeDefine);


            $('#alias').keydown(setAliasKeydown);
            $('#alias').blur(setAlias);

            $('#ignoreBeforeRowWhenPrinting').keydown(setIgnoreBeforeRowWhenPrintingKeydown);
            $('#ignoreBeforeRowWhenPrinting').blur(setIgnoreBeforeRowWhenPrinting);


            $('#define').keyup(setDefine);

            $('#cell_edittype').change(setEditType);

            $('.editstyle_submit').click(editStyleSubmit);
            $('#ddlb_refresh').click(ddlbRefresh);

            $('#tree_refresh').click(treeRefresh);


            $('#cellvaluetype').change(setValueType);
            $('#cellviewas').change(setViewAs);

            $('#cell_visiual').change(setVisible);
            $('#cell_editable').change(setEditable);

            $('#cell_cursorHand').change(setCursorName);


            $('#rowheight').change(setRowHeight);
            $('#columnwidth').change(setColumnWidth);

            $('#dsn').change(reloadColumn);

            $("#dbcol").autocomplete({
                delay: 200,
                autoFocus: false,
                source: [],
                minLength: 0,
                select: function (event, ui) {
                    setTimeout(function () {
                        setBind();
                    },100);
                    }
            }).focus(function () {
                $(this).autocomplete("search");
            });

            $("#dbcol").keydown(  setBindKeydown);





            //冻结相关
            $("#dropdownMenu_lock").on("show.bs.dropdown", function () {
                load_freezedProperty();
            });
            $('#freezeAt').click(freezeAt);
            $('#unFreeze').click(unFreeze);

            $('#cb_clear_backcolor').click(clearBackColor);

            //行属性
            //---------------------------------------------------------------------------------------------------------
            //用来控制点击后，不要关闭下拉菜单（面板）
            $('#rowPropertyContainer').on("click", function (event) {
                event.stopPropagation();
            });
            $("#dropdownMenu_rowProperty").on("show.bs.dropdown", function () {
                load_rowProperty();
            });

            $('#isColumnScrollEnabled').on("click", setColumnScrollEnabled);
            $('input[name="rowHeightStretch"]').on("click", setRowHeightStretch);

            //列属性
            //---------------------------------------------------------------------------------------------------------
            //用来控制点击后，不要关闭下拉菜单（面板）
            $('#columnPropertyContainer').on("click", function (event) {
                event.stopPropagation();
            });
            $("#dropdownMenu_columnProperty").on("show.bs.dropdown", function () {
                load_columnProperty();
            });

            $('#columnWidth2').change(setColumnWidth2);
            $('input[name="columnWidthStretch"]').on("click", setColumnWidthStretch);

            //控件面板下拉开始时
            $("#dropdownMenu_brick").on("show.bs.dropdown", function () {
                init_brickMenu();
            });

            $('#cb_addbrick_button').click(cb_addbrick_button);
            $('#cb_addbrick_dbpage').click(cb_addbrick_dbpage);
            $('#cb_addbrick_ckeditor').click(cb_addbrick_ckeditor);

            $('#cb_addbrick_insertBefore').click(cb_addbrick_insertBefore);
            $('#cb_addbrick_insertAfter').click(cb_addbrick_insertAfter);
            $('#cb_addbrick_delete').click(cb_addbrick_delete);
            $('#cb_addbrick_retrieve').click(cb_addbrick_retrieve);
            $('#cb_addbrick_print').click(cb_addbrick_print);

            $('#cb_addbrick_html').click(cb_addbrick_html);
            $('#cb_addbrick_echart').click(cb_addbrick_echart);
            $('#cb_addbrick_tree').click(cb_addbrick_tree);
            $('#cb_addbrick_sheetContainer').click(cb_addbrick_sheetContainer);
            $('#cb_addbrick_tab').click(cb_addbrick_tab);


            $('#cb_showColumnPanel').click(cb_showColumnPanel);
            $('#cb_addbrick_imgUpload').click(cb_addbrick_imgUpload);




            $('#cb_clearColumnFilterKey').click(cb_clearColumnFilterKey);
            $('#cb_showAllColumn').click(cb_showAllColumn);
            $('#columnFilterKey').keyup(cb_columnFilter);

            $('#cb_cellMoreProperty').click(cb_cellMoreProperty);

            $('#cellproperty_color_expression').keyup(setColorExpression);
            $('#cellproperty_backgroundcolor_expression').keyup(setBackgroundColorExpression);
            $('#cellproperty_passwordMask').keyup(setPasswordMask);

            $('#cellproperty_validateRule').keyup(setValidateRule);
            $('#cellproperty_validateTip').keyup(setValidateTip);


            $('#cellproperty_placeholder').keyup(setPlaceHolder);

            $('#cellproperty_placeholderonlyviewwhenediting').click(cellproperty_placeholderonlyviewwheneditingClick);

            $('#cellproperty_cellClickControl').click(cellproperty_cellClickControlClick);
            $('#cellproperty_cellClickControlTip').keyup(cellproperty_cellClickControlTipKeyUp);

            $('#cellproperty_leftPadding').keyup(setLeftPadding);
            $('#cellproperty_rightPadding').keyup(setRightPadding);
            $('#cellproperty_topPadding').keyup(setTopPadding);
            $('#cellproperty_bottomPadding').keyup(setBottomPadding);


            $('#cb_propPanel_submit').click(function () {
                toastr.info("设置成功");
                var e = {keyCode: 13};
                setColorExpression(e);
                setBackgroundColorExpression(e);
                setPasswordMask(e);
                setPlaceHolder(e);
                cellproperty_placeholderonlyviewwheneditingClick(e);
                cellproperty_cellClickControlTipKeyUp(e);
            });

            $('#cb_viewPanel_submit').click(function () {
                toastr.info("设置成功");
                var e = {keyCode: 13};
                setLeftPadding(e);
                setRightPadding(e);
                setTopPadding(e);
                setBottomPadding(e);
            });


            $('#cb_validatePanel_submit').click(function () {
                toastr.info("设置成功");
                var e = {keyCode: 13};
                setValidateRule(e);
                setValidateTip(e);
            });


            $('#cellproperty_dblclicksort').keyup(setDblClickSortColumn);
            $('#cellproperty_clickJumpToWhere').change(setClickJumpToWhere);
            $('#cellproperty_clickJumpTo').keyup(setClickJumpTo);
            $('#cellproperty_clickPopupDialogWidth').keyup(setClickPopupDialogWidth);
            $('#cellproperty_clickPopupDialogHeight').keyup(setClickPopupDialogHeight);
            $('#cellproperty_clickPopupDialogTitle').keyup(setClickPopupDialogTitle);


            $('#cb_actionPanel_submit').click(function () {
                toastr.info("设置成功");
                var e = {keyCode: 13};
                setDblClickSortColumn(e);
                setClickJumpToWhere(e);
                setClickJumpTo(e);
                setClickPopupDialogWidth(e);
                setClickPopupDialogHeight(e);
                setClickPopupDialogTitle(e);
            });


            $('.showColumnListForValueChangedToQuery').click(function (e) {
                showColumnListForValueChangedToQuery(e)
            });
            $('.sqlVerifyForValueChangedToQuery').click(function (e) {
                sqlVerifyForValueChangedToQuery(e)
            });
            $('.colMapVerifyForValueChangedToQuery').click(function (e) {
                colMapVerifyForValueChangedToQuery(e)
            });

            $('#cb_valueChangedToQuery_submit').click(cb_valueChangedToQuery_submit);


            $('#autocomplete_type_url').click(function () {
                autocomplete_type_change('url');
            });
            $('#autocomplete_type_script').click(function () {
                autocomplete_type_change('script');
            });
            $('#autocomplete_type_sql').click(function () {
                autocomplete_type_change('sql');
            });
            $('#autocomplete_type_none').click(function () {
                autocomplete_type_change('none');
            });
            $('#cb_valueChangedToAutoComplate_submit').click(cb_valueChangedToAutoComplate_submit);


            $('#cb_valueChangedToAutoCompleteScriptCode').click(cb_valueChangedToAutoCompleteScriptCode_click);


            //条码属性上点击，阻止事件冒泡，避免关闭属性面板
            $(".barcodeProperty").on("click", function (e) {
                e.stopPropagation();
            })


            inited=true; 
        });


        /**
         * 打开列表的定义
         */
        function jumpToDDLBDefine(evt) {
            var ddlb = $('#ddlbName').val();
            
            $rpc("formEngine", "formengine.DDLB", "getDDLBEditURL", {name:ddlb},
                    function (retValue) {
                        var ret = JSON.parse(retValue);
                        if (ret.success) {
                        	open ( ret.url);
                        } else {
                            toastr.error(ret.message);
                        }
                    }
                );
            
           
        }
 


        function onPaste(event) {

            var clipboard = (event.clipboardData || window.clipboardData);
            if (!clipboard) {
                book.activeSheet.paste();
                return;
            }

            var items = clipboard.items;


            if (items && items.length) {
                // 搜索剪切板items

                //从 wps 复制，items.length=0  分别是 text/plain , text/html , image/png

                var pasteExcel = false;

                for (var i = 0; i < items.length; i++) {

                    if (items[i].type == 'text/html') {
                        items[i].getAsString(function (s) {
                            //console.info(s);
                            var html = s;
                            var p = html.indexOf('<table');
                            if (p > 0) html = html.substring(p);
                            p = htm.indexOf("</table>");
                            if (p > 0) html = html.substring(0, p + 8);

                            alert(html);

                            if (true) {

                            } else {

                                book.activeSheet.paste();
                            }

                        });
                    }
                }
                book.activeSheet.paste();
            }
        }

        /**
         * 打开树的定义
         */
        function jumpToTreeDefine(evt) {
            var tree = $('#treeName').val();
            var where = (encodeURI("name='" + tree + "'"));
            var url = getServiceHomeURL('config') + "/config_tree_main.jsp?table=app_treedefine&leftwidth=0.1&limitWhere=" + where;

            var thisURL = window.location.href;
            var p = thisURL.indexOf("/", 8);
            var thisHome = thisURL.substring(0, p);

            p = url.indexOf("/", 8);
            var home = url.substring(0, p);

            //如果不在同一个域名中，那么在新窗口中打开，不然在iframe中打开会有同源限制
            if (evt.ctrlKey || evt.altKey || home != thisHome) {
                var a = $('#openInNewWindow')[0];
                a.href = url;
                a.click();
            } else {
                openDialogURL(ddlb, url, 960, 550);
            }

        }

        function cb_valueChangedToAutoCompleteScriptCode_click() {
            var scriptcode = $('#cellproperty_valueChangedToAutoCompleteScriptCode').val();
            if (scriptcode == '') {
                toastr.info("请先设置脚本代码");
                return;
            }
            var homePage = getServiceHomeURL("config");
            openWindow(homePage + "/config_tree_main.jsp?table=app_script&&limitWhere=code=%27" + scriptcode + "%27");


        }


        //取数规则生效
        function cb_valueChangedToQuery_submit() {
            toastr.info("设置成功");
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            if (cell.appData == undefined) cell.appData = {};

            //变化取数定义
            for (let i = 1; i <= 4; i++) {

                cell.appData['valueChangedToQueryDBPool' + i] = $('#cellproperty_valueChangedToQueryDBPool' + i).val() || '';  //select 可能没有选择，拼一个''
                cell.appData['valueChangedToQuery' + i] = $('#cellproperty_valueChangedToQuery' + i).val().trim();
                cell.appData['valueChangedCopyMap' + i] = $('#cellproperty_valueChangedCopyMap' + i).val().trim();

                //多余的属性删除掉，保存的时候，数据量小一些
                if (cell.appData['valueChangedToQueryDBPool' + i] == '') delete cell.appData['cellproperty_valueChangedToQueryDBPool' + i];
                if (cell.appData['valueChangedToQuery' + i] == '') delete cell.appData['valueChangedToQuery' + i];
                if (cell.appData['valueChangedCopyMap' + i] == '') delete cell.appData['valueChangedCopyMap' + i];

            }


        }

        //2019.09.16 取数SQL定义字段列表显示
        function showColumnListForValueChangedToQuery(e) {
            var n = $(e.target).attr("data");
            var sql = $('#cellproperty_valueChangedToQuery' + n).val() || '';
            if (sql.trim() == '') {
                toastr.info("请先定义查询语句");
                return
            }
            var dsn = $('#cellproperty_valueChangedToQueryDBPool' + n).val() || '';
            var ds = newDataStore(dsn, sql);

            if (ds.columnCount > 0) {
                var cols = [];
                for (var i = 0; i < ds.columnCount; i++) {
                    cols.push(ds.getColumnName(i));
                }

                $.alert("<div style='max-height:500px; overflow:auto;'>" + cols.join("<br>") + "</div>");
            } else {
                $.alert(ds.getSelectLastRetrieved() + "  <br>不合法 ");
            }
        }

        //2019，09.16 取数SQL合法性检测
        function sqlVerifyForValueChangedToQuery(e) {
            var n = $(e.target).attr("data");
            var sql = $('#cellproperty_valueChangedToQuery' + n).val() || '';
            if (sql.trim() == '') {
                toastr.info("请先定义查询语句");
                return
            }
            var dsn = $('#cellproperty_valueChangedToQueryDBPool' + n).val() || '';
            var ds = newDataStore(dsn, sql);
            ds.setOnceRetrieveCount(1);
            ds.retrieve();
            if (ds.columnCount > 0) {
                toastr.success("查询语句定义合法");
            } else {
                $.alert(ds.getSelectLastRetrieved() + "  <br>不合法 ");
            }
        }


        //2019，09.16 字段对应关系合法性检测
        function colMapVerifyForValueChangedToQuery(e) {
            var n = $(e.target).attr("data");
            var sql = $('#cellproperty_valueChangedToQuery' + n).val() || '';
            if (sql.trim() == '') {
                toastr.info("请先定义查询语句");
                return
            }
            var dsn = $('#cellproperty_valueChangedToQueryDBPool' + n).val() || '';
            var maps = $('#cellproperty_valueChangedCopyMap' + n).val() || '';

            colMapVerify(dsn, sql, maps);
        }

        function colMapVerify(dsn, sql, maps) {
            var colMap = buildColMap(maps);


            var ds = newDataStore(dsn, sql);
            ds.setOnceRetrieveCount(1);
            ds.retrieve();
            if (ds.columnCount > 0) {

                for (let ci = 0; ci < colMap.length; ci++) {
                    let cp = colMap[ci];
                    if (ds.col2Index(cp.source) < 0) {
                        toastr.error("第" + (ci + 1) + "行中的" + cp.source + "不存在");
                        return;
                    }

                    if (cp.target.alias) {
                        var toCell = book.activeSheet.cells(cp.target.alias);
                        if (!toCell) {
                            toastr.error("第" + (ci + 1) + "行中的" + cp.target.alias + " 不是合法的单元格名称或别名");
                            return;
                        }
                    } else {
                        var dss = book.getDataSource(cp.target.ds);
                        if (!dss) {
                            toastr.error("第" + (ci + 1) + "行中的" + cp.target.ds + " 不是合法目标结果集");
                            return;
                        }

                        if (dss.dataStore.col2Index(cp.target.col) < 0) {
                            toastr.error("第" + (ci + 1) + "行中的" + cp.target.col + " 在结果集" + cp.target.ds + "中不存在");
                            return;
                        }
                    }
                }
                toastr.success("对应关系定义合法");


            } else {
                $.alert(ds.getSelectLastRetrieved() + "  <br>不合法 ");
            }
        }


        /**
         * 把    col1:ds1.col1   col2:ds1.col2  这样的对应关系配置，转换成{col1: {ds:'ds1' , col:'col1' } ....}这样的JSON键值对
         * 如有修改，请同步 loadTemplate.js中的同名函数
         * @param maps
         */
        function buildColMap(maps) {
            return Tools.buildColMap(maps);
        }


        //补全规则生效
        function cb_valueChangedToAutoComplate_submit() {

            toastr.info("设置成功");
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            if (cell.appData == undefined) cell.appData = {};

            var types = $('.autocomplete_type')
            var type = 'none';
            for (let i = 0; i < types.length; i++) {
                if (types[i].checked) {
                    type = types[i].value;
                }
            }


            if (type == 'url') {
                cell.appData.valueChangedToAutoCompleteType = "url";
                cell.appData.valueChangedToAutoCompleteURL = $('#cellproperty_valueChangedToAutoCompleteURL').val() || '';
                cell.appData.valueChangedToAutoCompleteResultFunc = $('#cellproperty_valueChangedToAutoCompleteResultFunc').val() || '';

                cell.appData.valueChangedToAutoCompleteParam = $('#cellproperty_valueChangedToAutoCompleteParam').val() || '';


                delete cell.appData['valueChangedToAutoCompleteDBPool'];
                delete cell.appData['valueChangedToAutoCompleteQuery'];
                delete cell.appData['valueChangedToAutoCompleteScriptCode'];

            }

            if (type == 'script') {
                cell.appData.valueChangedToAutoCompleteType = "script";
                cell.appData.valueChangedToAutoCompleteScriptCode = $('#cellproperty_valueChangedToAutoCompleteScriptCode').val() || '';
                cell.appData.valueChangedToAutoCompleteParam = $('#cellproperty_valueChangedToAutoCompleteParam').val() || '';

                delete cell.appData['valueChangedToAutoCompleteDBPool'];
                delete cell.appData['valueChangedToAutoCompleteQuery'];
                delete cell.appData['valueChangedToAutoCompleteURL'];
                delete cell.appData['valueChangedToAutoCompleteResultFunc'];


            }

            if (type == 'sql') {
                cell.appData.valueChangedToAutoCompleteType = "sql";

                cell.appData.valueChangedToAutoCompleteDBPool = $('#cellproperty_valueChangedToAutoCompleteDBPool').val() || '';
                cell.appData.valueChangedToAutoCompleteQuery = $('#cellproperty_valueChangedToAutoCompleteQuery').val() || '';

                delete cell.appData['valueChangedToAutoCompleteURL'];
                delete cell.appData['valueChangedToAutoCompleteScriptCode'];
                delete cell.appData['valueChangedToAutoCompleteParam'];
                delete cell.appData['valueChangedToAutoCompleteResultFunc'];


            }

            //几种补全，都有的属性
            cell.appData.valueChangedToAutoCompleteMaxCount = $('#cellproperty_valueChangedToAutoCompleteMaxCount').val() || '20';
            cell.appData.valueChangedToAutoCompleteMinLen = $('#cellproperty_valueChangedToAutoCompleteMinLen').val() || '0';
            cell.appData.valueChangedToAutoCompleteCopyMap = $('#cellproperty_valueChangedToAutoCompleteCopyMap').val() || '';
            cell.appData.valueChangedToAutoCompleteRender = $('#cellproperty_valueChangedToAutoCompleteRender').val() || '';


            if (type == 'none') {
                delete cell.appData['valueChangedToAutoCompleteType'];
                delete cell.appData['valueChangedToAutoCompleteURL'];
                delete cell.appData['valueChangedToAutoCompleteResultFunc'];

                delete cell.appData['valueChangedToAutoCompleteScriptCode'];
                delete cell.appData['valueChangedToAutoCompleteParam'];

                delete cell.appData['valueChangedToAutoCompleteDBPool'];
                delete cell.appData['valueChangedToAutoCompleteQuery'];
                delete cell.appData['valueChangedToAutoCompleteMinLen'];
                delete cell.appData['valueChangedToAutoCompleteMaxCount'];

                delete cell.appData['valueChangedToAutoCompleteCopyMap'];
                delete cell.appData['valueChangedToAutoCompleteRender'];

            }

            toastr.info("设置成功");

        }

        function doCut() {
            this.blur();
            var sheet = book.activeSheet;
            sheet.cut();
        }

        function doCopy() {
            this.blur();
            var sheet = book.activeSheet;
            sheet.copy();
        }

        function doPaste() {
            this.blur();
            var sheet = book.activeSheet;
            sheet.paste();
        }


        function insertRow() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.insertMultiRow(r.endRow + 1, r.endRow + 1);
        }

        function insertRowBefore() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.insertMultiRow(r.startRow, r.startRow);
        }

        function deleteRow() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.deleteMultiRow(r.startRow, r.endRow);
        }


        function insertColumn() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.insertMultiColumn(r.endCol + 1, r.endCol + 1);
        }

        function insertColumnBefore() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.insertMultiColumn(r.startCol, r.startCol);
        }


        function deleteColumn() {
            this.blur();
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.deleteMultiColumn(r.startCol, r.endCol);
        }


        function setDblClickSortColumn(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);
                cell.dblClickSort = $('#cellproperty_dblclicksort').val();
            }
        }

        /**
         * 设置单元格双击对某个字段排序
         */
        function autoSelectDblClickSortColumn() {

            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            var rc = sheet.rowCount;
            for (var i = r.startRow + 1; i < rc; i++) {
                var tc = sheet.cells(i, r.startCol);
                if (tc.Bind == null) continue;
                if (book.getDataSource(tc.Bind.dataSource).dataSourceType != 2) continue;

                cell.dblClickSort = tc.Bind.dataSource + "." + tc.Bind.DBCol;
                //双击排序
                $('#cellproperty_dblclicksort').val(cell.dblClickSort);
                break;

            }

        }


        function load_columnProperty() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            $('#columnWidth2').val(sheet.CPM.getColumnWidth2(r.startCol));
            var v = sheet.CPM.getColumnStretchWidth(r.startCol);

            var objs = document.getElementsByName("columnWidthStretch");
            for (var i = 0; i < objs.length; i++) {
                if (objs[i].value == v) {
                    objs[i].checked = true;
                } else {
                    objs[i].checked = false;
                }
            }

        }

        function setColumnWidthStretch() {
            var objs = $('input[name="columnWidthStretch"]');
            var v = 0;
            for (var i = 0; i < objs.length; i++) {
                var obj = objs[i];
                if (obj.checked) v = parseInt(obj.value);
            }

            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.paintPermit = false;
            for (var col = r.startCol; col <= r.endCol; col++) {
                sheet.CPM.setColumnStretchWidth(col, v);
            }
            sheet.paintPermit = true;
        }


        //行的属性
        function load_rowProperty() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            $('#isColumnScrollEnabled')[0].checked = sheet.RPM.isColumnScrollEnabled(r.startRow);
            var v = sheet.RPM.getRowStretchHeight(r.startRow);

            var objs = document.getElementsByName("rowHeightStretch");
            for (var i = 0; i < objs.length; i++) {
                if (objs[i].value == v) {
                    objs[i].checked = true;
                } else {
                    objs[i].checked = false;
                }
            }


        }

        function cb_clearColumnFilterKey() {
            $('#columnFilterKey').val('');
            cb_columnFilter();

        }

        function cb_showAllColumn() {
            columnShowAll = !columnShowAll;
            cb_showColumnPanel(true, columnShowAll);

        }

        function cb_columnFilter() {

            var k = $('#columnFilterKey').val();

            var spans = $('.columnBlock');
            for (var i = 0; i < spans.length; i++) {
                var t = $(spans[i]).text();
                var v = "none";
                if (k == '' || t.indexOf(k) >= 0) v = "";
                $(spans[i]).css("display", v);
            }
        }

        function cb_cellMoreProperty() {
            $("#selectColumnPanel_dragHandle").css('display', '');
            $("#selectColumnPanel").css('display', '');

        }

        var columnPanelInited = false;
        var columnShowAll = false;

        //显示字段选择面板
        function cb_showColumnPanel(rebuild) {

            if (rebuild == undefined) rebuild = false;

            const LT = require('./loadTemplate');

            $("#selectColumnPanel_dragHandle").css('display', '');
            $("#selectColumnPanel").css('display', '');
            moveSelectColumnPanel();

            if (columnPanelInited && !rebuild) return;


            columnPanelInited = true;
            var html = [];


            var dataSource = LT.g_dbConfig.dataSource;
            for (var dsc  in  dataSource) {

                let one = dataSource[dsc];
                var title = "【" + one.table + '】' + (one.table != one.label ? one.label : '');
                html.push('<h3 style="border-radius: 0;margin:0; border:0;">' + title + '</h3>');
                html.push('<div style="border-radius:0; border:0;padding:3px;"><p>')


                var dsc = book.getDataSource(one.table);

                for (var i = 0; i < one.column.length; i++) {
                    var oneCol = one.column[i];
                    //已经
                    if (!columnShowAll) if (dsc.getAllCellsWhichBindTheCol(oneCol.name).length > 0) continue;
                    html.push('<span  class="columnBlock" id=' + one.table + '.' + oneCol.name + '.' + oneCol.label + '  draggable="true"    ' +
                        ' ondragstart="onColumnDrag(event);"  >' +
                        `【<a  href="javascript:onColumnBind('${one.table}','${oneCol.name}','${oneCol.label}');">` + oneCol.name + '</a>】' + (oneCol.name != oneCol.label ? oneCol.label : '') + "</span>");
                }
                for (var i = 0; i < one.computer.length; i++) {
                    var oneCol = one.computer[i];
                    if (!columnShowAll) if (dsc.getAllCellsWhichBindTheCol(oneCol.name).length > 0) continue;
                    html.push('<span  class="columnBlock" style="white-space: nowrap;display: inline-block"  id=' + one.table + '.' + oneCol.name + '.' + oneCol.label + '   draggable="true"   ' +
                        ' ondragstart="onColumnDrag(event);"    >' +
                        `【<a  href="javascript:onColumnBind('${one.table}','${oneCol.name}','${oneCol.label}');">` + oneCol.name + '</a>】' + (oneCol.name != oneCol.label ? oneCol.label : '') + "</span>");
                }


                html.push('</p></div>');

            }

            $('#selectColumnContainer').html('');
            $('#selectColumnContainer').html(html.join(''));

            //点满高度
            $("#selectColumnContainer").accordion({heightStyle: "fill"});
            //刷新布局

            setTimeout(function () {
                $("#selectColumnPanel_dragHandle").css({'width': $("#selectColumnPanel").width()});
                $("#selectColumnContainer").accordion("refresh");
            }, 100);

        }


        function setColumnScrollEnabled() {
            var checked = $('#isColumnScrollEnabled')[0].checked;
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.paintPermit = false;
            for (var row = r.startRow; row <= r.endRow; row++) {
                sheet.RPM.setColumnScrollEnable(row, checked);
            }
            sheet.paintPermit = true;

        }

        function setRowHeightStretch() {
            var objs = $('input[name="rowHeightStretch"]');
            var v = 0;
            for (var i = 0; i < objs.length; i++) {
                var obj = objs[i];
                if (obj.checked) v = parseInt(obj.value);
            }

            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.paintPermit = false;
            for (var row = r.startRow; row <= r.endRow; row++) {
                sheet.RPM.setRowStretchHeight(row, v);
            }
            sheet.paintPermit = true;
        }


        function init_brickMenu() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            var bricks = cell.getBricks();

            //之前增加的子菜单全部删除掉先
            $('.brickSubMenu').remove();

            var ul = $('#bricksMenu');
            for (let i = 0; i < bricks.length; i++) {
                let brick = bricks[i];
                ul.append(`<li class="brickSubMenu">
                                            <a href="javascript:design.editBrickProperty('${brick.name}');">
                                             <table width="100%" border="0">
                                             <tr><td align="left">${brick.name}</td>
                                             <td align="right">${brick.config.caption}</td>
                                             <td align="right">&nbsp;
                                             <i class="fa fa-trash-o" style="color:red;" onclick="design.deleteBrick('${brick.name}');"></i></td></tr></table>
                                           
                                      </a>
                                      </li>`);
            }


        }

        function cb_addbrick_insertBefore() {

            var dsn = '';
            for (var i = 0; i < book.getDataSourceCount(); i++) {
                var dsc = book.getDataSource(i);
                if (dsc.dataSourceType == 2) {
                    dsn = dsc.dataSource;
                }
            }

            var title = "前插按钮";
            var config = {
                DOMName: '',
                name: 'cb_insertBefore', action: 'insertBefore',
                caption: ' 前插', enable: true, visible: true,
                x: 1, y: 1, width: 60, height: -1,
                buttonStyle: 'alt', buttonColorStyle: 'primary',
                size: 1, leftIcon: 'fa-plus-circle', rightIcon: '', dsn: dsn
            };

            editBrick('button', title, config, 'dbtool');
        }


        function cb_addbrick_insertAfter() {

            var dsn = '';
            for (var i = 0; i < book.getDataSourceCount(); i++) {
                var dsc = book.getDataSource(i);
                if (dsc.dataSourceType == 2) {
                    dsn = dsc.dataSource;
                }
            }

            var title = "后插按钮";
            var config = {
                DOMName: '',
                name: 'cb_insertAfter', action: 'insertAfter',
                caption: ' 后插', enable: true, visible: true,
                x: 1, y: 1, width: 60, height: -1,
                buttonStyle: 'alt', buttonColorStyle: 'primary',
                size: 1, leftIcon: 'fa-arrow-circle-down', rightIcon: '', dsn: dsn
            };

            editBrick('button', title, config, 'dbtool');
        }

        function cb_addbrick_delete() {

            var dsn = '';
            for (var i = 0; i < book.getDataSourceCount(); i++) {
                var dsc = book.getDataSource(i);
                if (dsc.dataSourceType == 2) {
                    dsn = dsc.dataSource;
                }
            }

            var title = "删除按钮";
            var config = {
                DOMName: '',
                name: 'cb_delete', action: 'delete',
                caption: ' 删除', enable: true, visible: true,
                x: 1, y: 1, width: 60, height: -1,
                buttonStyle: 'alt', buttonColorStyle: 'primary',
                size: 1, leftIcon: 'fa-trash-o', rightIcon: '', dsn: dsn
            };

            editBrick('button', title, config, 'dbtool');
        }

        function cb_addbrick_retrieve() {

            var dsn = '';
            for (var i = 0; i < book.getDataSourceCount(); i++) {
                var dsc = book.getDataSource(i);
                if (dsc.dataSourceType == 2) {
                    dsn = dsc.dataSource;
                }
            }

            var title = "检索按钮";
            var config = {
                DOMName: '',
                name: 'cb_retrieve', action: 'retrieve',
                caption: ' 检索', enable: true, visible: true,
                x: 1, y: 1, width: 60, height: -1,
                buttonStyle: 'alt', buttonColorStyle: 'primary',
                size: 1, leftIcon: 'fa-search', rightIcon: '', dsn: dsn
            };

            editBrick('button', title, config, 'dbtool');
        }

        function cb_addbrick_print() {

            var title = "打印";
            var config = {
                DOMName: '',
                name: 'cb_sheetPrint', caption: '打印sheet',
                action: 'print',
                caption: ' 打印', enable: true, visible: true,
                x: 1, y: 1, width: 60, height: -1,
                buttonStyle: 'alt', buttonColorStyle: 'primary',
                size: 1, leftIcon: 'fa-print', rightIcon: '',
                x: 1, y: 1, width: -1, height: -1, sheetGUID: "",


            };

            editBrick('SheetPrint', title, config);


        }


        function cb_addbrick_dbpage() {
            var title = "分页导航条";
            var config = {
                DOMName: '',
                name: 'dbnav', caption: '分页导航条', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1,
                buttonStyle: 'default', buttonColorStyle: 'primary',
                size: 1,
                onceRetrieveRowCount: 100, dsn: '',
                countPerPagePermitToChange: true
            };

            editBrick('dbpage', title, config);
        }

        function cb_addbrick_ckeditor() {
            var title = "富文本编辑";
            var config = {
                DOMName: '',
                name: 'ckeditor', caption: '富文本编辑', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1,

                dbcol: '', dsn: ''
            };

            editBrick('ckeditor', title, config);
        }

        function cb_addbrick_button() {
            var title = "常规按钮";
            var config = {
                DOMName: '',
                name: 'cb', caption: '按钮', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1, buttonStyle: 'default', buttonColorStyle: 'primary',
                size: 1, leftIcon: '', rightIcon: ''
            };

            editBrick('button', title, config);
        }


        function cb_addbrick_echart() {
            var title = "图表Chart";
            var config = {
                DOMName: '',
                name: 'chart1', caption: '图表', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1,
                option:
                    {
                        title: {text: '销量情况'},
                        tooltip: {},
                        legend: {data: ['销量']},
                        xAxis: {
                            data: [
                                '衬衫',
                                '羊毛衫',
                                '雪纺衫',
                                '裤子'

                            ]
                        },
                        yAxis: {},
                        series: [{
                            name: '销量',
                            type: 'bar',
                            data: [
                                5,
                                20,
                                36,
                                10
                            ]
                        }]
                    }

            };

            editBrick('echart', title, config);
        }

        function cb_addbrick_tree() {
            var title = "树 Tree";
            var config = {
                DOMName: '',
                name: 'tree1', caption: '树', enable: true, visible: true,
                x: 1, y: 1, width: 0, height: -1, treeName: "", treeFilterBy: '', treeSelectMulti: false


            };

            editBrick('tree', title, config);
        }

        function cb_addbrick_sheetContainer() {
            var title = "嵌入WorkSheet";
            var config = {
                DOMName: '',
                name: 'sheetContainer1', caption: '嵌入sheet', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1, sheetGUID: ""


            };

            editBrick('SheetContainer', title, config);
        }

        function cb_addbrick_tab() {
            var title = "Tab容器";

            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.endRow + 1, r.startCol);
            var name = cell.alias;
            if (name == '') name = cell.name;

            var config = {
                DOMName: '',
                name: 'tab1', caption: 'Tab容器', enable: true, visible: true,
                x: 0, y: 0, width: 0, height: 0,
                style: 'round',
                position: 'top',
                skin: 'skin-asbestos',
                container: name,
                tabs: [
                    {
                        id: 'tab1', title: 'tab1', type: 'worksheet',
                        source: ''
                    },
                    {
                        id: 'tab2', title: 'tab2', type: 'worksheet',
                        source: ''
                    }
                ]


            };

            editBrick('Tab', title, config);
        }


    function cb_addbrick_imgUpload() {
        var title = "图片上传";


        var config = {
            DOMName: '',
            name: 'upload1', caption: '图片上传', enable: true, visible: true,
            x: 1, y: 1, width: -1, height: -1,
            action: '=currentAction()',
            serverIndex:1,
            dbpool: 'default',
            logTable: 'app_fileupload',
            blockSize:128,
            imgMaxSize:1920,
            columns:5,
            maxCount:5,
            groupName:'附件',
            tableName:'=currentMasterTableName()',
            path:'=currentMasterTableName()',

            gguid:'=currentGUID()',
            autoLoadFunction:'getImageListWithConfig',
            autoLoad:true

        };

        editBrick('uploadImage', title, config);
    }



    function cb_addbrick_html() {
            var title = "自定义HTML";
            var config = {
                DOMName: '',
                name: 'htmlsource', caption: 'HTML代码', enable: true, visible: true,
                x: 1, y: 1, width: -1, height: -1,
                html: ''
            };

            editBrick('html', title, config);
        }

        function editBrick(type, title, config, mb) {

            if (mb == undefined) mb = type;

            //属性补丁
            if (config.buttonStyle == undefined) config.buttonStyle = 'default';
            if (config.buttonColorStyle == undefined) config.buttonColorStyle = 'default';
            if (config.size == undefined) config.size = 1;
            if (config.align == undefined) config.align = 'center';

            //2019.09.01 patch
            if (type == 'dbpage') {
                if (config.countPerPagePermitToChange == undefined) config.countPerPagePermitToChange = true;
            }
            ;


            var html = TrimPath.processDOMTemplate("formEngine/template/template_brick_" + mb, config);

            $.confirm({
                animation: 'zoom',
                closeAnimation: 'scale',
                boxWidth: '700px',
                useBootstrap: false,
                title: title,
                content: html,
                buttons: {
                    confirm:
                        {
                            text: "确定",
                            btnClass: "btn-success",
                            action:
                                function () {
                                    return buttonApply();
                                }
                        },
                    cancel:
                        {
                            text: "取消",
                            btnClass: "btn-warning",
                            action: function () {
                            }
                        }
                }
            });

        }

        /**
         * 编辑控件
         * @param name
         */
        function editBrickProperty(name) {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            var brick = cell.getBrick(name);
            var config = brick.config;
            var type = brick.type;
            var mb = type;

            if (mb == 'button') {
                if (brick.config.action == undefined) mb = 'button';
                if (brick.config.action == 'insertBefore') mb = 'dbtool';
                if (brick.config.action == 'insertAfter') mb = 'dbtool';
                if (brick.config.action == 'delete') mb = 'dbtool';
                if (brick.config.action == 'retrieve') mb = 'dbtool';
                if (brick.config.action == 'print') mb = 'SheetPrint';


            }

            var title = brick.config.caption;
            if (!title) title = brick.config.name;
            editBrick(type, title, brick.config, mb);

        }

        /**
         * 删除控件
         * @param name
         */
        function deleteBrick(name) {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            cell.removeBrick(name);
            event.preventDefault();
        }

        function load_freezedProperty() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            if (sheet.freezedRow || 0 == 0 && sheet.freezedCol || 0 == 0) {
                $('#freezed_title').html('当前没有冻结');
                $('#unFreeze').css("disabled", "true");

                $('#freezeAt').html("在" + (r.startRow + 1) + "行" + (r.startCol + 1) + "列冻结");


            } else {
                $('#freezed_title').html("已在" + (sheet.freezedRow + 1) + "行" + (sheet.freezedCol + 1) + "列冻结");
                $('#unFreeze').css("disabled", "false");
                $('#freezeAt').html("改在" + (r.startRow + 1) + "行" + (r.startCol + 1) + "列冻结");

            }
        }

        function unFreeze() {
            var sheet = book.activeSheet;

            sheet.freezeCell(0, 0);
        }

        function freezeAt() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.freezeCell(r.startRow, r.startCol);
        }


        function setFontBold() {
            this.blur();
            var v = $(this).hasClass('btn-primary');
            if (v) {
                $(this).removeClass('btn-primary');
                $(this).addClass('btn-default');

            } else {
                $(this).removeClass('btn-default');
                $(this).addClass('btn-primary');
            }

            setSelectionProperty("font-bold", !v);

        }

        function setFontItalic() {
            this.blur();
            var v = $(this).hasClass('btn-primary');
            if (v) {
                $(this).removeClass('btn-primary');
                $(this).addClass('btn-default');

            } else {
                $(this).removeClass('btn-default');
                $(this).addClass('btn-primary');
            }

            setSelectionProperty("font-italic", !v);

        }

        function eraseCells() {
            doInSelection(function (cell) {
                cell.clear();
            });

        }

        function setFontUnderline() {
            this.blur();
            var v = $(this).hasClass('btn-primary');
            if (v) {
                $(this).removeClass('btn-primary');
                $(this).addClass('btn-default');

            } else {
                $(this).removeClass('btn-default');
                $(this).addClass('btn-primary');
            }

            setSelectionProperty("font-underline", !v);

        }

        function setFontWordwrap() {
            this.blur();
            var v = $(this).hasClass('btn-primary');
            if (v) {
                $(this).removeClass('btn-primary');
                $(this).addClass('btn-default');

            } else {
                $(this).removeClass('btn-default');
                $(this).addClass('btn-primary');
            }

            setSelectionProperty("word-wrap", !v);

        }


        function setAlignLeft() {
            this.blur();
            $('#cb_alignleft').removeClass('btn-default');
            $('#cb_alignleft').addClass('btn-primary');
            $('#cb_aligncenter').removeClass('btn-primary');
            $('#cb_aligncenter').addClass('btn-default');
            $('#cb_alignright').removeClass('btn-primary');
            $('#cb_alignright').addClass('btn-default');
            setSelectionProperty("text-align", 0);
        }

        function setAlignCenter() {
            this.blur();
            $('#cb_alignleft').removeClass('btn-primary');
            $('#cb_alignleft').addClass('btn-default');
            $('#cb_aligncenter').removeClass('btn-default');
            $('#cb_aligncenter').addClass('btn-primary');
            $('#cb_alignright').removeClass('btn-primary');
            $('#cb_alignright').addClass('btn-default');
            setSelectionProperty("text-align", 2);
        }

        function setAlignRight() {
            this.blur();
            $('#cb_alignleft').removeClass('btn-primary');
            $('#cb_alignleft').addClass('btn-default');
            $('#cb_aligncenter').removeClass('btn-primary');
            $('#cb_aligncenter').addClass('btn-default');
            $('#cb_alignright').removeClass('btn-default');
            $('#cb_alignright').addClass('btn-primary');
            setSelectionProperty("text-align", 1);
        }

        function setAlignTop() {
            this.blur();
            $('#cb_aligntop').removeClass('btn-default');
            $('#cb_aligntop').addClass('btn-primary');
            $('#cb_alignmiddle').removeClass('btn-primary');
            $('#cb_alignmiddle').addClass('btn-default');
            $('#cb_alignbottom').removeClass('btn-primary');
            $('#cb_alignbottom').addClass('btn-default');
            setSelectionProperty("vertical-align", 0);
        }

        function setAlignMiddle() {
            this.blur();
            $('#cb_aligntop').removeClass('btn-primary');
            $('#cb_aligntop').addClass('btn-default');
            $('#cb_alignmiddle').removeClass('btn-default');
            $('#cb_alignmiddle').addClass('btn-primary');
            $('#cb_alignbottom').removeClass('btn-primary');
            $('#cb_alignbottom').addClass('btn-default');
            setSelectionProperty("vertical-align", 2);
        }

        function setAlignBottom() {
            this.blur();
            $('#cb_aligntop').removeClass('btn-primary');
            $('#cb_aligntop').addClass('btn-default');
            $('#cb_alignmiddle').removeClass('btn-primary');
            $('#cb_alignmiddle').addClass('btn-default');
            $('#cb_alignbottom').removeClass('btn-default');
            $('#cb_alignbottom').addClass('btn-primary');
            setSelectionProperty("vertical-align", 1);
        }

        function setValueType() {
            var vt = $('#cellvaluetype').val();
            doInSelection(function (cell) {
                cell.setCellValueType(vt);
            });

        }

        function setViewAs() {
            var va = $('#cellviewas').val();
            doInSelection(function (cell) {
                cell.viewAs = va;
                if (va == 'barcode') loadCellBarcodeProperty(cell);
            });

            $('#dropdownMenu_barcodeProperty').css("display", va == 'barcode' ? '' : 'none');

        }


        function setVisible() {
            var v = $('#cell_visiual')[0].checked;
            doInSelection(function (cell) {
                cell.visible = v;
            });
        }

        function setEditable() {
            var v = $('#cell_editable')[0].checked;
            doInSelection(function (cell) {
                cell.editable = v;
            });
        }

        function setCursorName() {
            var v = $('#cell_cursorHand')[0].checked;
            doInSelection(function (cell) {
                cell.cursorName = v ? "hand" : "";
            });
        }


        function setMerge() {

            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.unMerge(r);
            sheet.merge(r);
        }

        function setUnMerge() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;
            sheet.unMerge(r);

        }

        function setRowHeight() {
            var h = $('#rowheight').val();
            if (isNaN(h)) return;
            if (h < 0) return;
            h = parseInt(h);
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var row = r.startRow; row <= r.endRow; row++) {
                    sheet.RPM.setRowHeight(row, h);
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }

        function setColumnWidth() {
            var w = $('#columnwidth').val();
            if (isNaN(w)) return;
            w = parseInt(w);
            if (w < 0) return;
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var col = r.startCol; col <= r.endCol; col++) {
                    sheet.CPM.setColumnWidth(col, w);
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }

        function setColumnWidth2() {
            var w = $('#columnWidth2').val();
            if (isNaN(w)) return;
            w = parseInt(w);
            if (w < 0) return;
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var col = r.startCol; col <= r.endCol; col++) {
                    sheet.CPM.setColumnWidth2(col, w);
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }

        function setSelectionProperty(propName, propValue) {
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var row = r.startRow; row <= r.endRow; row++) {
                    for (var col = r.startCol; col <= r.endCol; col++) {
                        sheet.cells(row, col).setPropertyValue(propName, propValue);
                    }
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;

            }
        }


        function doInSelection(callback) {
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var row = r.startRow; row <= r.endRow; row++) {
                    for (var col = r.startCol; col <= r.endCol; col++) {
                        callback(sheet.cells(row, col));
                    }
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }


        function clearBackColor() {
            setSelectionProperty("background-color", '');

        }

        function setFontSize() {
            var fontSize = $('#font-size').val();

            setSelectionProperty('font-size', fontSize);

        }

        function setBarcodeType() {
            var barcodeType = $('#barcodeType').val();
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeType = barcodeType;
                }
            });

            $('.notForQRCode').css("display", barcodeType == 'QRCode' ? "none" : "");
            $('.forQRCode').css("display", barcodeType != 'QRCode' ? "none" : "");

        }

        function setBarcodeWidth() {
            var v = $('#barcodeWidth').val();
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeWidth = v;
                }
            });
        }

        function setBarcodeCenterImageURL() {
            var v = $('#barcodeCenterImageURL').val();
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeCenterImageURL = v;
                }
            });
        }

        function setBarcodeHeight() {
            var v = $('#barcodeHeight').val();
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeHeight = parseInt(v);
                }
            });
        }

        function setBarcodeTextMargin() {
            var v = $('#barcodeTextMargin').val();
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeTextMargin = parseInt(v);
                }
            });
        }

        function setBarcodeTextVisible() {
            var v = $('#barcodeTextVisible')[0].checked ? true : false;
            doInSelection(function (cell) {
                if (cell.viewAs == 'barcode') {
                    cell.barcodeTextVisible = v;
                }
            });
        }


        function setFontName() {
            var fontName = $('#font-family').val();
            setSelectionProperty('font-family', fontName);

        }

        function loadTextColor() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var color = sheet.cells(r.startRow, r.startCol).getPropertyValue("color", "#000");

            $('#cb_textcolor  .sp-input').val(color);
            $('#cb_textcolor  .sp-input').trigger('change');

        }

        function loadBackColor() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var color = sheet.cells(r.startRow, r.startCol).getPropertyValue("background-color", "transparent");

            $('#cb_backcolor  .sp-input').val(color);
            $('#cb_backcolor  .sp-input').trigger('change');

        }

        function loadBorderColor() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            //var color= sheet.cells(r.startRow, r.startCol).getPropertyValue("color","#000");

            var color = $('#view_bordercolor').css('color');

            $('#cb_bordercolor  .sp-input').val(color);
            $('#cb_bordercolor  .sp-input').trigger('change');

        }

        //可以传入一个颜色，或取按钮的背景色
        function setFontColor(e, c) {

            $('#cb_textcolor').blur();
            var color = c || $(this).css('background-color');
            setTimeout(function () {
                setSelectionProperty("color", color);

            }, 100);

        }


        function setBackColor(e, c) {
            $('#cb_backcolor').blur();
            var color = c || $(this).css('background-color');
            setTimeout(function () {
                setSelectionProperty("background-color", color);

            }, 100);


        }

        function setBorderColor(e, c) {
            $('#cb_bordercolor').blur();
            var color = c || $(this).css('background-color');
            $('#view_bordercolor').css('color', color);

        }


        function setBorderAll() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 8, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderOuter() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 6, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderInner() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 7, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderLeft() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 0, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderTop() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 2, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderRight() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 1, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderBottom() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 3, 1, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderBottomDotted() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 3, 3, 1, $('#view_bordercolor').css('color'));

        }

        function setBorderNull() {
            this.blur();

            var sheet = book.activeSheet;
            var r = sheet.selection;

            sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 8, 0, 0, 'gray');

        }


        function setGridlineVisible() {
            this.blur();
            var sheet = book.activeSheet;
            sheet.gridLineVisible = !sheet.gridLineVisible;
        }

        function setAliasVisible() {
            this.blur();
            book.cellShowAlias = !book.cellShowAlias;

        }

        function setBindVisible() {
            this.blur();
            book.cellShowBind = !book.cellShowBind;

        }

        function setFormulaVisible() {
            this.blur();
            book.cellShowFormula = !book.cellShowFormula;

        }


        function setAliasKeydown(e) {
            if (e.keyCode == 13) setAlias();
        }

        function setAlias() {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            cell.alias = $('#alias').val();
        }

        function setIgnoreBeforeRowWhenPrintingKeydown(e) {
            if (e.keyCode == 13) setIgnoreBeforeRowWhenPrinting();
        }

        function setIgnoreBeforeRowWhenPrinting() {
            var sheet = book.activeSheet;
            var v = parseInt($('#ignoreBeforeRowWhenPrinting').val());
            sheet.ignoreBeforeRowWhenPrinting = v;

        }

        function setClickJumpToWhere(e) {

            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            cell.clickJumpToWhere = $('#cellproperty_clickJumpToWhere').val();
        }

        function setClickJumpTo(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);
                cell.clickJumpTo = $('#cellproperty_clickJumpTo').val();

            }
        }

        function setClickPopupDialogWidth(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);
                cell.clickPopupDialogWidth = $('#cellproperty_clickPopupDialogWidth').val();

            }
        }

        function setClickPopupDialogHeight(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);
                cell.clickPopupDialogHeight = $('#cellproperty_clickPopupDialogHeight').val();

            }
        }

        function setClickPopupDialogTitle(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);
                cell.clickPopupDialogTitle = $('#cellproperty_clickPopupDialogTitle').val();

            }
        }

        /**
         * 自动设置别名
         * @param e
         */

        function autoSetAlias(e) {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);
            var bind = cell.Bind;
            if (bind == null) {
                toastr.info("没有绑定到数据库，无法自动按绑定信息设置别名");
                return;
            }

            cell.alias = bind.DBCol;
            $('#alias').val(cell.alias);
            $("#cellproperty_name")[0].innerText = cell.alias;


        }


        function setDefine(e) {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);

            var define = $(this).val();
            if (define.startsWith('=')) {
                if (e.keyCode == 13) cell.setValue($(this).val());
            } else {
                cell.setValue($(this).val());
            }
        }


        function setColorExpression(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_color_expression').val().trim();
                if (!v.startsWith('=')) v = "=" + v;
				if( v=='=' )  v=''; 

                cell.setPropertyValue("color-expression", v);
            }
        }

        function setLeftPadding(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_leftPadding').val().trim();

                cell.setPropertyValue("padding-left", v);
            }
        }

        function setRightPadding(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_rightPadding').val().trim();

                cell.setPropertyValue("padding-right", v);
            }
        }

        function setTopPadding(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_topPadding').val().trim();

                cell.setPropertyValue("padding-top", v);
            }
        }

        function setBottomPadding(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_bottomPadding').val().trim();

                cell.setPropertyValue("padding-bottom", v);
            }
        }

        function setBackgroundColorExpression(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_backgroundcolor_expression').val().trim();
                if (!v.startsWith('=')) v = "=" + v;
				if( v=='=' )  v=''; 

                cell.setPropertyValue("background-color-expression", v);
            }
        }

        function setPasswordMask(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_passwordMask').val().trim();
                cell.passwordMask = v;
            }
        }

        function setValidateRule(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_validateRule').val().trim();
                cell.validateRule = v;
            }
        }

        function setValidateTip(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_validateTip').val().trim();
                cell.validateTip = v;
            }
        }


        function setPlaceHolder(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_placeholder').val().trim();
                cell.placeholder = v;
            }
        }


        function cellproperty_placeholderonlyviewwheneditingClick(e) {
            var sheet = book.activeSheet;
            var r = sheet.selection;
            var cell = sheet.cells(r.startRow, r.startCol);

            var v = $('#cellproperty_placeholderonlyviewwhenediting')[0].checked;
            cell.placeholderOnlyViewWhenEditing = v;

        }

        function cellproperty_cellClickControlClick(e) {
            cellproperty_cellClickControlTipKeyUp({keyCode: 13});

        }

        function cellproperty_cellClickControlTipKeyUp(e) {
            if (e.keyCode == 13) {
                var sheet = book.activeSheet;
                var r = sheet.selection;
                var cell = sheet.cells(r.startRow, r.startCol);

                var v = $('#cellproperty_cellClickControlTip').val().trim();
                if (cell.appData == undefined) cell.appData = {};
                cell.appData.clickControlEnabled = $('#cellproperty_cellClickControl')[0].checked;
                cell.appData.clickControlTip = $('#cellproperty_cellClickControlTip').val().trim();

                if (!cell.appData.clickControlEnabled) {
                    delete cell.appData ['clickControlEnabled'];
                    delete cell.appData ['clickControlTip'];

                }
            }

        }


        function $BOOL(v) {
            return v;
        }

        function $INT(v) {
            return v;
        }

        function setButtonChecked(button, v) {
            if (v) {
                $('#' + button).removeClass('btn-default');
                $('#' + button).addClass('btn-primary');

            } else {
                $('#' + button).removeClass('btn-primary');
                $('#' + button).addClass('btn-default');
            }
        }


        function reloadColumn() {

            const LT = require('./loadTemplate');

            var dsn = $('#dsn').val();

            $('#dbcol').html('');

            if (dsn == '') return;

            var options = LT.g_dsb2colselect[dsn];


            //重新设置候选字段清单
            $("#dbcol").autocomplete({
                delay: 200,
                autoFocus: false,
                source: options,
                minLength: 0
            }) ;


        }

    function setBindKeydown(e) {
        if (e.keyCode == 13) setBind();
    }

        function setBind() {
            var dsn = $('#dsn').val();
            var dbcol = $('#dbcol').val();
            var dbtype = $('#dbtype').val();

            if (col == '' || dsn == '') {
                clearBind();
                return;
            }

            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var row = r.startRow; row <= r.endRow; row++) {
                    for (var col = r.startCol; col <= r.endCol; col++) {
                        sheet.cells(row, col).setBind(dsn, dbcol, dbtype);
                        if (sheet.cells(dbcol) == null) {
                            sheet.cells(row, col).alias = dbcol;
                        } else if (sheet.cells(dsn + '_' + dbcol) == null) {
                            sheet.cells(row, col).alias = dsn + '_' + dbcol;
                        } else {

                        }
                    }
                }

                loadCellProperty(shet, r.startRow, r.startCol);

            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }


        function clearBind() {

          //  $('#dsn').val(''); 取消绑定，不要把结果集列表清除，因为只是它有值并不会进行绑定，
            $('#dbcol').val('');
            $('#dbtype').val('0');
            var sheet = book.activeSheet;
            try {
                sheet.paintPermit = false;
                var r = sheet.selection;
                for (var row = r.startRow; row <= r.endRow; row++) {
                    for (var col = r.startCol; col <= r.endCol; col++) {
                        sheet.cells(row, col).clearBind();
                    }
                }
            } catch (err) {
            }
            finally {
                sheet.paintPermit = true;
            }
        }

        function setEditType() {
            var et = $('#cell_edittype').val();
            var editPanels = $('.edit_detail_panel');
            for (var i = 0; i < editPanels.length; i++) {
                var editPanel = $(editPanels[i]);
                var t = editPanel.attr('type');
                if (t == null) t = '';
                var ts = t.split(',');
                ts.contains(et) ? editPanel.show() : editPanel.hide();

            }
            $('#editStyleContainer').show();
        }

        function editStyleSubmit() {
            this.blur();

            var et = parseInt($('#cell_edittype').val());

            switch (et) {


                case $ES.$MultiLine:
                    doInSelection(function (cell) {
                        book.setEditStyleMultiLine(cell);
                    });
                    break;

                case $ES.$Normal:

                    var inputAttribute = $('#inputAttribute').val();
                    doInSelection(function (cell) {
                        book.setEditStyleNormal(cell,inputAttribute);
                    });
                    break;

                case $ES.$Datetime: {
                    var dateformat = $('#dateformat').val();
                    if (dateformat == '') {
                        toastr.error("请先选择日期格式");
                        return;
                    }
                    doInSelection(function (cell) {
                        book.setEditStyleDate(cell, dateformat);
                    });
                    break;
                }

                case $ES.$Numeric: {
                    var showComma = $('#showComma')[0].checked;
                    var zeroVisible = !$('#zeroUnvisible')[0].checked;
                    var decimalCount = $('#decimalCount').val();
                    doInSelection(function (cell) {
                        book.setEditStyleNumeric(cell, showComma, decimalCount, zeroVisible);
                    });
                    break;
                }
                case $ES.$DDLB: {
                    var ddlbName = $('#ddlbName').val();
                    var dropDownListEditable = $('#dropDownListEditable')[0].checked;
                    var valueMustInDDLB = $('#valueMustInDDLB')[0].checked;
                    var ddlbFilterBy = $('#ddlbFilterBy').val();
                    var ddlbInnerItems = $('#ddlbInnerItems').val();
                    var showRealData = $('#showRealData')[0].checked;
                    doInSelection(function (cell) {
                        book.setEditStyleDDLB(cell, ddlbName, dropDownListEditable, valueMustInDDLB, ddlbFilterBy, ddlbInnerItems, showRealData);
                    });
                    break;


                }

                case $ES.$RadioButton: {
                    var ddlbName = $('#ddlbName').val();
                    var ddlbFilterBy = $('#ddlbFilterBy').val();
                    var ddlbInnerItems = $('#ddlbInnerItems').val();
                    var columnCount = $('#columnCount').val();
                    doInSelection(function (cell) {
                        book.setEditStyleRadio(cell, ddlbName, ddlbFilterBy, ddlbInnerItems, columnCount);
                    });
                    break;


                }
                case $ES.$MultiCheckBox: {
                    var ddlbName = $('#ddlbName').val();
                    var ddlbFilterBy = $('#ddlbFilterBy').val();
                    var ddlbInnerItems = $('#ddlbInnerItems').val();
                    var columnCount = $('#columnCount').val();
                    doInSelection(function (cell) {
                        book.setEditStyleMultiCheckbox(cell, ddlbName, ddlbFilterBy, ddlbInnerItems, columnCount);
                    });
                    break;


                }
                case $ES.$CheckBox: {

                    var checkOnValue = $('#checkOnValue').val();
                    var checkOffValue = $('#checkOffValue').val();
                    var checkCaption = $('#checkCaption').val();

                    doInSelection(function (cell) {
                        book.setEditStyleCheckbox(cell, checkOnValue, checkOffValue , checkCaption);
                    });
                    break;
                }
                case $ES.$Tree: {
                    var treeName = $('#treeName').val();
                    var treeWidth = $('#treeWidth').val() || 300;
                    var treeHeight = $('#treeHeight').val() || 300;
                    var treeSelectMulti = $('#treeSelectMulti')[0].checked;
                    var treeFilterBy = $('#ddlbFilterBy').val();
                    doInSelection(function (cell) {
                        book.setEditStyleTree(cell, treeName, treeWidth, treeHeight, treeSelectMulti, treeFilterBy);
                    });
                    break;
                }


            }
            toastr.info("设置成功");

        }

        function ddlbRefresh() {
            this.blur();
            const LT = require('./loadTemplate');
            LT.getAllDDLBNameList();
        }

        function treeRefresh() {
            this.blur();
            const LT = require('./loadTemplate');
            LT.getAllTreeNameList();
        }


        function loadCellBarcodeProperty(cell) {

            $('#barcodeType').val(cell.barcodeType || 'CODE128');
            $('#barcodeWidth').val(cell.barcodeWidth || 2);
            $('#barcodeHeight').val(cell.barcodeHeight || 30);
            $('#barcodeTextMargin').val(cell.barcodeTextMargin || 10);
            $('#barcodeTextVisible')[0].checked = cell.barcodeTextVisible;
            $('#barcodeCenterImageURL').val(cell.barcodeCenterImageURL);


            $('.notForQRCode').css("display", cell.barcodeType == 'QRCode' ? "none" : "");
            $('.forQRCode').css("display", cell.barcodeType != 'QRCode' ? "none" : "");

        }

        /**
         * 调取单元格的属性，让工具栏显示相应的值
         * @param sheet
         * @param row
         * @param col
         */
        function loadCellProperty(sheet, row, col) {

        	if(! inited) return; 
        	
            var fontname = sheet.getCellProperty(row, col, 'font-family');
            var font_size = sheet.getCellProperty(row, col, 'font-size');

            var fontbold = $BOOL(sheet.getCellProperty(row, col, 'font-bold'));
            var fontitalic = $BOOL(sheet.getCellProperty(row, col, 'font-italic'));
            var fontunderline = $BOOL(sheet.getCellProperty(row, col, 'font-underline'));
            var wordwrap = $BOOL(sheet.getCellProperty(row, col, 'word-wrap'));
            var halign = $INT(sheet.getCellProperty(row, col, 'text-align'));
            var valign = $INT(sheet.getCellProperty(row, col, 'vertical-align'));


            $('#font-family').val(fontname);
            $('#font-size').val(font_size);

            setButtonChecked('cb_fontbold', fontbold);
            setButtonChecked('cb_fontitalic', fontitalic);
            setButtonChecked('cb_fontunderline', fontunderline);
            setButtonChecked('cb_fontwordwrap', wordwrap);

            setButtonChecked('cb_alignleft', halign == 0);
            setButtonChecked('cb_alignright', halign == 1);
            setButtonChecked('cb_aligncenter', halign == 2);

            setButtonChecked('cb_aligntop', valign == 0);
            setButtonChecked('cb_alignbottom', valign == 1);
            setButtonChecked('cb_alignmiddle', valign == 2);


            $('#rowheight').val(sheet.RPM.getRowHeight(row));
            $('#columnwidth').val(sheet.CPM.getColumnWidth(col));

            $('#ignoreBeforeRowWhenPrinting').val(sheet.ignoreBeforeRowWhenPrinting);

            if (sheet.isCellNull(row, col)) {

                $("#cellname").val('R' + (row + 1) + "C" + (col + 1));
                $("#cellproperty_name")[0].innerText = ('R' + (row + 1) + "C" + (col + 1));

                $('#alias').val('');
                $('#define').val('');
                //清除绑定信息
                //$('#dsn').val('');  2020.02.26 不要把结果集列表清除，因为只是它有值并不会进行绑定，留着，方便其它单元格在同一个结果集上进行绑定
                $('#dbcol').val('');
                $('#dbtype').val('0');

                $('#cell_visiual')[0].checked = true;
                $('#cell_cursorHand')[0].checked = false;
                $('#cellvaluetype').val(99);
                $('#cellviewas').val('');
                $('#dropdownMenu_barcodeProperty').css("display", 'none');

                //编辑格式
                $('#cell_edittype').val(0);
                $('#ddlbFilterBy').val('');
                $('#ddlbInnerItems').val('');

                $('#ddlbName').val('');


                $('#cellproperty_passwordMask').val('*');
                $('#cellproperty_placeholder').val('');

                $('#cellproperty_validateRuler').val('');
                $('#cellproperty_validateTip').val('');


                $('#cellproperty_color_expression').val('');
                $('#cellproperty_backgroundcolor_expression').val('');

                $('#cellproperty_clickJumpToWhere').val('');
                $('#cellproperty_clickJumpTo').val('');
                $('#cellproperty_clickPopupDialogWidth').val('');
                $('#cellproperty_clickPopupDialogHeight').val('');
                $('#cellproperty_clickPopupDialogTitle').val('');

                $('#cellproperty_leftPadding').val('1');
                $('#cellproperty_rightPadding').val('1');
                $('#cellproperty_topPadding').val('1');
                $('#cellproperty_bottomPadding').val('1');


                setEditType();

                //变化取数定义
                for (let i = 1; i <= 4; i++) {
                    $('#cellproperty_valueChangedToQueryDBPool' + i).val('');
                    $('#cellproperty_valueChangedToQuery' + i).val('');
                    $('#cellproperty_valueChangedCopyMap' + i).val('');
                }

                $('#title_cellName').text($("#cellname").val());
                $('#info_cellBind').text('');


                //补全设置


                autocomplete_type_change('none');
                $('#cellproperty_valueChangedToAutoCompleteURL').val("");
                $('#cellproperty_valueChangedToAutoCompleteResultFunc').val("");

                $('#cellproperty_valueChangedToAutoCompleteDBPool').val("");
                $('#cellproperty_valueChangedToAutoCompleteQuery').val("");
                $('#cellproperty_valueChangedToAutoCompleteMinLen').val("1");
                $('#cellproperty_valueChangedToAutoCompleteMaxCount').val("20");
                $('#cellproperty_valueChangedToAutoCompleteCopyMap').val("");
                $('#cellproperty_valueChangedToAutoCompleteRender').val("");


                $('#cellproperty_cellClickControl')[0].checked = false;
                $('#cellproperty_placeholderonlyviewwhenediting')[0].checked = false;
                $('#cellproperty_cellClickControlTip').val('');

                $('#barcodeType').val('');
                $('#barcodeWidth').val('');

                $('#barcodeCenterImageURL').val('');
                $('#barcodeHeight').val('');
                $('#barcodeTextMargin').val('');
                $('#barcodeTextVisible')[0].checked = false;


            } else {
                var cell = sheet.cells(row, col);
                $('#cellname').val(cell.name);
                $('#title_cellName').text($("#cellname").val());

                $("#cellproperty_name")[0].innerText = (cell.name || cell.alias);

                $('#alias').val(cell.alias);
                $('#define').val(cell.define);
                $('#cellvaluetype').val(cell.getCellValueType());
                $('#cellviewas').val(cell.viewAs);


                if (cell.viewAs == 'barcode') {
                    loadCellBarcodeProperty(cell);

                } else {
                    $('#barcodeType').val('');
                    $('#barcodeWidth').val('');
                    $('#barcodeCenterImageURL').val('');

                    $('#barcodeHeight').val('');
                    $('#barcodeTextMargin').val('');
                    $('#barcodeTextVisible')[0].checked = false;
                }

                $('#dropdownMenu_barcodeProperty').css("display", cell.viewAs == 'barcode' ? '' : 'none');

                $('#cell_visiual')[0].checked = cell.visible;
                $('#cell_editable')[0].checked = cell.editable;
                $('#cell_cursorHand')[0].checked = cell.cursorName == 'hand';
                //绑定信息
                var bind = cell.Bind;
                if (bind == null) {
                   // $('#dsn').val('');   2020.02.26 不要把结果集列表清除，因为只是它有值并不会进行绑定，留着，方便其它单元格在同一个结果集上进行绑定
                    $('#dbcol').val('');
                    $('#dbtype').val('0');
                    $('#info_cellBind').text('');

                } else {
                    $('#dsn').val(bind.dataSource);
                    reloadColumn();
                    $('#dbcol').val(bind.DBCol);
                    $('#info_cellBind').text('绑定的' + bind.DBCol + '字段');

                    var dbtype = bind.dataSourceType;
                    if (dbtype != 4) dbtype = 0; //转成自动
                    $('#dbtype').val(dbtype);

                }

                //双击排序
                $('#cellproperty_dblclicksort').val(cell.dblClickSort);

                var passwordMask = cell.passwordMask;
                $('#cellproperty_passwordMask').val(passwordMask);

                $('#cellproperty_placeholder').val(cell.placeholder);
                $('#cellproperty_placeholderonlyviewwhenediting')[0].checked = cell.placeholderOnlyViewWhenEditing;

                var color_expression = sheet.getCellProperty(row, col, 'color-expression');
                var background_color_expression = sheet.getCellProperty(row, col, 'background-color-expression');

                $('#cellproperty_color_expression').val(color_expression);
                $('#cellproperty_backgroundcolor_expression').val(background_color_expression);


                $('#cellproperty_clickJumpToWhere').val(cell.clickJumpToWhere);
                $('#cellproperty_clickJumpTo').val(cell.clickJumpTo);
                $('#cellproperty_clickPopupDialogWidth').val(cell.clickPopupDialogWidth);
                $('#cellproperty_clickPopupDialogHeight').val(cell.clickPopupDialogHeight);
                $('#cellproperty_clickPopupDialogTitle').val(cell.clickPopupDialogTitle);

                //校验
                var validateRule = cell.validateRule;
                if (validateRule == null) validateRule = '';
                $('#cellproperty_validateRule').val(validateRule);

                var validateTip = cell.validateTip;
                if (validateTip == null) validateTip = '';
                $('#cellproperty_validateTip').val(validateTip);

                //view，更多的显示相关的属性

                $('#cellproperty_leftPadding').val(sheet.getCellProperty(row, col, 'padding-left'));
                $('#cellproperty_rightPadding').val(sheet.getCellProperty(row, col, 'padding-right'));
                $('#cellproperty_topPadding').val(sheet.getCellProperty(row, col, 'padding-top'));
                $('#cellproperty_bottomPadding').val(sheet.getCellProperty(row, col, 'padding-bottom'));

                //编辑 格式

                $('#ddlbFilterBy').val('');
                $('#ddlbInnerItems').val('');

                $('#ddlbName').val('');
                $('#treeName').val('');


                var es = cell.ES;
                if (es == null) {
                    $('#cell_edittype').val(0);
                    $('#inputAttribute').val('');
                    $('#checkCaption').val('');
                    setEditType();

                } else {

                    var et = es.ET;
                    $('#cell_edittype').val(et);


                    setEditType();
                    //编辑格式的面板已经准备好了，现在填充数据
                    switch (et) {
                        case $ES.$Normal:
                            $('#inputAttribute').val(es.inputAttribute || '');
                            break;
                        case $ES.$MultiLine:
                            break;
                        case $ES.$Datetime:
                            $('#dateformat').val(es.datetimeFormat);
                            break;
                        case $ES.$Numeric:
                            $('#showComma')[0].checked = es.showComma;
                            $('#zeroUnvisible')[0].checked = !es.zeroVisible;

                            $('#decimalCount').val(es.decimalCount);
                            break;
                        case $ES.$DDLB:
                        case $ES.$RadioButton:
                        case $ES.$MultiCheckBox:
                            $('#ddlbName').val(es.ddlbName);
                            $('#dropDownListEditable')[0].checked = es.dropDownListEditable;
                            $('#valueMustInDDLB')[0].checked = es.valueMustInDDLB;
                            $('#ddlbFilterBy').val(es.ddlbFilterBy);
                            $('#ddlbInnerItems').val(es.ddlbInnerItems);
                            $('#showRealData')[0].checked = es.showRealData;
                            $('#columnCount').val(es.columnCount);

                            break;
                        case $ES.$CheckBox:
                            $('#checkOnValue').val(es.checkOnValue);
                            $('#checkOffValue').val(es.checkOffValue);
                            $('#checkCaption').val(es.checkCaption);



                            break;
                        case $ES.$Tree:
                            $('#treeName').val(es.treeName);
                            $('#treeWidth').val(es.treeWidth || 300);
                            $('#treeHeight').val(es.treeHeight || 300);
                            $('#treeSelectMulti')[0].checked = es.treeSelectMulti;
                            $('#ddlbFilterBy').val(es.treeFilterBy);
                            break;

                    }
                }

                //取数定义
                var ref = cell.appData;
                if (ref != undefined) {
                    //变化取数定义
                    for (let i = 1; i <= 4; i++) {
                        $('#cellproperty_valueChangedToQueryDBPool' + i).val(ref['valueChangedToQueryDBPool' + i] || '');
                        $('#cellproperty_valueChangedToQuery' + i).val(ref['valueChangedToQuery' + i] || '');
                        $('#cellproperty_valueChangedCopyMap' + i).val(ref['valueChangedCopyMap' + i] || '');
                    }
                } else {
                    for (let i = 1; i <= 4; i++) {
                        $('#cellproperty_valueChangedToQueryDBPool' + i).val('');
                        $('#cellproperty_valueChangedToQuery' + i).val('');
                        $('#cellproperty_valueChangedCopyMap' + i).val('');
                    }
                }

                //
                //补全设置

                let appData = cell.appData || {};

                let at = appData.valueChangedToAutoCompleteType || 'none';

                autocomplete_type_change(at);

                $('#cellproperty_valueChangedToAutoCompleteURL').val(appData.valueChangedToAutoCompleteURL || '');
                $('#cellproperty_valueChangedToAutoCompleteResultFunc').val(appData.valueChangedToAutoCompleteResultFunc || '');

                $('#cellproperty_valueChangedToAutoCompleteScriptCode').val(appData.valueChangedToAutoCompleteScriptCode || '');
                $('#cellproperty_valueChangedToAutoCompleteParam').val(appData.valueChangedToAutoCompleteParam || '');

                $('#cellproperty_valueChangedToAutoCompleteDBPool').val(appData.valueChangedToAutoCompleteDBPool || '');
                $('#cellproperty_valueChangedToAutoCompleteQuery').val(appData.valueChangedToAutoCompleteQuery || '');
                $('#cellproperty_valueChangedToAutoCompleteMinLen').val(appData.valueChangedToAutoCompleteMinLen || '0');
                $('#cellproperty_valueChangedToAutoCompleteMaxCount').val(appData.valueChangedToAutoCompleteMaxCount || '20');

                $('#cellproperty_valueChangedToAutoCompleteCopyMap').val(appData.valueChangedToAutoCompleteCopyMap || '');
                $('#cellproperty_valueChangedToAutoCompleteRender').val(appData.valueChangedToAutoCompleteRender || '');

                //点击权限控制的配置
                let clickControl = cell.appData || {};
                $('#cellproperty_cellClickControl')[0].checked = clickControl.clickControlEnabled || false;
                $('#cellproperty_cellClickControlTip').val(clickControl.clickControlTip || '');


            }

        }


        function autocomplete_type_change(type) {
            $('.autocomplete_type').attr("checked", false);
            var obj = $('#autocomplete_type_' + type);
            if (obj.length > 0) obj[0].checked = true;

            $('.valueChangedToAutoComplete_panel_url').css("display", type == 'url' ? '' : 'none');
            $('.valueChangedToAutoComplete_panel_sql').css("display", type == 'sql' ? '' : 'none');
            $('.valueChangedToAutoComplete_panel_url_or_script').css("display", ['url', 'script'].contains(type) ? '' : 'none');
            $('.valueChangedToAutoComplete_panel_script').css("display", type == 'script' ? '' : 'none');
            $('.valueChangedToAutoComplete_panel_other').css("display", type == 'none' ? 'none' : '');

            $('#cb_valueChangedToAutoComplate_submit').css("display", type == 'none' ? 'none' : '');

        }

        function saveTemplate() {
            var ST = require('./saveTemplate');
            ST.saveTemplate(book, urlArgs.id);

        }

        return {
            loadCellProperty: loadCellProperty,
            editBrickProperty: editBrickProperty,
            deleteBrick: deleteBrick
        };
    }
)
;


