/***************************************************************************************************************
 * 作者：zengjun
 *
 *   基于json , jquery 的RPC方案
 *
 *  示例：同步调用,返回的是已经彩解析好的JSON对象
 *  　　　 var  ret= $rpc( "package.Class", "method", param);
 *                      alert ( ret.success);
 *
 * 　　异步调用，返回的是字符串，需自行解析
 *                      $rpc( "package.Class", "method", param , callback);
 *                      function callback(data)
 *                      {
 *                          var  ret=  JSON.parse(data);
 *                          alert ( ret.success);
 *                      }
 *
 ***************************************************************************************************************/

var $zrpc_inner_callback_data = null;
var $zrpc_inner_callback_raw_data = null;


/*
 *  当不提供　callback参数时，表示是同步调用，$rpc 的返回值即rpc调用的返回值
 *  如果提供了 callback参数，那么$rpc 返回"", 数据将在回调函数里以参数形式提供
 */
function $rpc(serviceName, className, method, jsonParamString, callback) {

    $zrpc_inner_callback_raw_data='';

    var timestamp = new Date().getTime();

    var paramString = jsonParamString;
    if (jsonParamString == undefined) paramString = {};  //可能没有参数

    if (callback === undefined) {
        $.ajaxSettings.async = false;//同步
        $zrpc_inner_callback_data = null;


        $.post("RPCRouter?timestamp=" + timestamp,
            JSON.stringify({  //需转成字符串，不然，会以 key ,value 的形式传递
                $servicename: serviceName,
                classname: className,
                methodname: method,
                parameter: paramString
            }),
            $zrpc_inner_callback);


        return $zrpc_inner_callback_data;
    } else {
        $.ajaxSettings.async = true; //异步
        $.post("RPCRouter?timestamp=" + timestamp,
            JSON.stringify({
                $servicename: serviceName,
                classname: className,
                methodname: method,
                parameter: paramString
            }),
            callback);
        return "";
    }

}

//同步调用使用本函数做回调函数，并把结果放到全局变量中，供$rpc函数做返回值
function $zrpc_inner_callback(data) {
    var d = JSON.parse(data);
    $zrpc_inner_callback_data = d;
}

function $zrpc_inner_raw_callback(data) {
    $zrpc_inner_callback_raw_data = data;
}



function getStringFromURL(url) {
    $zrpc_inner_callback_raw_data='';

    $.ajaxSettings.async = false;//同步
    $zrpc_inner_callback_data = null;
    var timestamp = new Date().getTime();
    if(url.indexOf('?')>0)
    {
        url=url+"&timestamp="+timestamp;
    }else {
        url=url+"?timestamp="+timestamp;
    }
    $.post(url, {}, $zrpc_inner_raw_callback);
    return $zrpc_inner_callback_raw_data;
}

