/**
 *   2019.08.07 增加断线重连， 心跳重连
 *
 *    2020.03.27  增加了 在 close() 中增加设置属性 shutdown ,这样，心跳可以通过判断 这个属性
 *    =true关闭。  断开重中发现 是shutdown了，那么也不可尝试重连。
 *
 *   一个chat对象，connect了， 又close了， 它就不建议再使用了， 丢弃，重新创建一个。
 *
 */

function Chat ( service , topic , callback , timeout) {

    if (timeout == undefined) timeout = 5 * 60 * 1000; //5分钟
    this.lockReconnect = false;  //避免ws重复连接

    this.service = service;
    this.topic = topic;
    this.callback = callback;
    this.socket = null;

    var url = window.location.href;
    var p = url.lastIndexOf("/");
    var t = url.substring(0, p);
    if (service == '') {
        this.init('ws' + t.substring(4),timeout);// 如果 t是 https:// ,那么 hoemURL就是 wss://
        return;
    }

    var that=this;
    getServiceHomeURL(service , function(val)
        {
            that.init( 'ws'+ val.substring(4),timeout);// 如果 t是 https:// ,那么 hoemURL就是 wss://
        });


}

Chat.prototype.init=function(homeURL ,timeout)
{
    this.homeURL =homeURL;

    // 监听窗口关闭事件，当窗口关闭时，主动去关闭websocket连接，防止连接还没断开就关闭窗口，server端会抛异常。
    $(window).on('beforeunload' ,function() {
           if( this.socket!=null)
           {
               try {

                   this.socket.close();
               }catch(err)
               {

               }
               this.socket=null;
           }
    }.bind(this) );



    var that=this;
    //心跳检测
    this.heartCheck = {
        timeout: timeout,
        timeoutObj: null,
        serverTimeoutObj: null,
        reset: function(){
            clearTimeout(this.timeoutObj);
            clearTimeout(this.serverTimeoutObj);
            return this;
        },
        start: function(){
            var self = this;
            this.timeoutObj = setTimeout(function(){
                //这里发送一个心跳，后端收到后，返回一个心跳消息，
                //onmessage拿到返回的心跳就说明连接正常
                that.ping();
                console.log("ping!")
                //收到消息后，会执行上面的reset 把 serverTimeoutObj清除，所以通常下面的that.close()是不可能执行的
                //除非在timeout内还没有收到服务器传过来的消息，可能是服务器异常了，那么断开，让它重连
                self.serverTimeoutObj = setTimeout(function(){//如果超过一定时间还没重置，说明后端主动断开了
                    that.close();     //如果onclose会执行reconnect，我们执行ws.close()就行了.如果直接执行reconnect 会触发onclose导致重连两次
                }, self.timeout)
            }, this.timeout)
        }
    }

    this.connect();

}


Chat.prototype.connect=function()
{

    if ('WebSocket' in window) {
        this.socket = new WebSocket(this.homeURL+'/websocket/chat');
    } else if ('MozWebSocket' in window) {
        this.socket = new MozWebSocket(this.homeURL+'/websocket/chat');
    } else {
        console.info('Error: WebSocket is not supported by this browser.');
        return;
    }

    this.shutdown=false;

    var that=this;
    this.socket.onopen = function () {
        that.shutdown=false;
        that.heartCheck.reset().start();
        that.sendMessage({action:"setTopic" , topic:that.topic});
        console.info('WebSocket 连接成功，关注的主题为'+that.topic );

    };

    this.socket.onclose = function () {
        if( that.shutdown) return; //如果是关闭了连接，那么不要重连
        console.info('WebSocket closed. 自动重连');
        that.reconnect();
    };

    this.socket.onerror = function () {
        that.reconnect();
        console.log("Websocket error , 自动重连");
    };


    this.socket.onmessage =function(msg)
    {
        that.heartCheck.reset().start(); ////拿到任何消息都说明当前连接是正常的
        if( msg.data && msg.data=='pong') return ; //服务端回馈的 pong消息，不需要给回调函数消费
        that.callback(msg);
    }

}

//重新连接
Chat.prototype.reconnect=function()
{
    if(this.lockReconnect) return;
    this.lockReconnect = true;
    console.info("尝试重连");
    setTimeout(function () {     //没连接上会一直重连，设置延迟避免请求过多
        this.connect();
        this.lockReconnect = false;
    }.bind(this), 2000);
}



Chat.prototype.close =  function( )
{
    if( this.socket)
    {
        this.shutdown=true;
        this.socket.close();
    }
}

Chat.prototype.sendMessage =  function( msg)
{
    var message = JSON.stringify(msg);
    this.socket.send(message);
}



Chat.prototype.sendChatMessage =  function( touserid , topic , info)
{
    var msg={userid:touserid, topic:topic ,message:info ,action:'sendMessage'};
    var message = JSON.stringify(msg);
    this.socket.send(message);
}

Chat.prototype.ping =  function( )
{
    //console.info("Websocket   ping ...");
    var msg={userid:-99, topic:'ping' ,message:'ping' ,action:'ping'};
    var message = JSON.stringify(msg);
    this.socket.send(message);
}
