/**
 * @apiDefine   UIGroup  UI函数
 */


/**
 * @api {getUrlArgs} 函数   getUrlArgs
 *
 * @apiDescription  getUrlArgs(   )
 * <br><br> URL地址中的参数访问
 * <br>
 *
 * @apiName  getUrlArgs
 * @apiGroup UIGroup
 * @apiVersion 1.0.0
 *
 *
 *
 * @apiSuccess (返回值){Object} - 返回一个对象 ， URL地址栏中的参数做为此对象的属性
 *
 * @apiExample   {js}示例：
 *
 *  //页面url为  http://server:port/formEngien/bill.jsp?id=abcd&code=1234
 *
 *  var p= getUrlArgs();
 *  alert( p.id);
 *  alert( p.code);
 *
 */
function getUrlArgs(url) {

    if (url == undefined) url = location.href;
    var arg = {};
    var reMatch;
    //先用正则把问号和井号之间的参数部分分离出来，如从  testjs.htm?p=1&t=1&u=1#test 中分出 p=1&t=1&u=1
    if (reMatch = url.match(/\?([^#]+)#?/)) {
        var querystring = reMatch[1];
        //用正则按 &  拆分到数组里，args 数组中依次是变量名和变量值，如p,1,t,2,u,24
        // 不能用 = 来拆分，因为可能有存在这样的  where= name='abc'  应该拆分成  urlArgs.where= "name='abc'";
        var args = querystring.split(/&/);

        for (var i = 0; i < args.length; i++) {
            var one = args[i];
            var p = one.indexOf("=");
            if (p < 0) {
                arg[one] = "";
            } else {
                var v = one.substring(p + 1);
                //2020.10.06 补丁，对汉字编码的判断：一个汉字编码后是3个%XX结构
                var  han=v.match( /(%[A-Za-z0-9]{2}){1,3}/);
                if (  han!=null ) {
                    try {
                        v = decodeURIComponent(v);  ////可能是被编码过的，需要解码一下
                    } catch (err) {
                        v = one.substring(p + 1); //也可能不是编码过的，那么重新取一下
                    }
                }
                v=v.replace(/~-~/g,' '); //space 
                arg[one.substring(0, p)] = v;
            }
        }

    }

    return arg;
}


var urlArgs = getUrlArgs();


function JSON2QueryString(json) {
    var ret = [];
    for (var p in json) {
        var v = json[p];
        ret.push(p + "=" + v);
    }
    return ret.join('&');
}

//
$(document).on("click", function () {

    var href = window.location.href;

    //如果没有上级窗口了，就不要再发送了
    if (window.parent != window) {
        //不是index.jsp， 应用的首页，那么
        if (href.indexOf('index.jsp') < 0 && !href.endsWith('/')) {

            window.parent.postMessage(JSON.stringify({action: "document-on-click"}), '*');
        }
    }
});


/**
 * 转还固定小数位数。 在IE中四舍五入有问题，所以需要补丁一下
 */
Number.prototype.toFixed = function (s) {

    return (parseInt(this * Math.pow(10, s) + (this == 0 ? 0 : (this > 0 ? 0.5 : -0.5))) / Math.pow(10, s)).toString();
}


//把ＨＴＭＬ中的标记去掉，留下文本
function html2txt(strS) {
    return strS.replace(/</g, "<").replace(/>/g, ">").replace(/ /g, " ").replace(/<br\/?>/g, "\r\n").replace(/&/g, "&").replace(/<.+?>/g, "");
}

function $E(id) {
    return document.getElementById(id);
}

function newGUID(splitChar) {
    return newGuid(splitChar);
}

function newGuid(splitChar) {
    if (splitChar == undefined) splitChar = "-";
    var guid = "";
    for (var i = 1; i <= 32; i++) {
        var n = Math.floor(Math.random() * 16.0).toString(16);
        guid += n;
        if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
            guid += splitChar;
    }
    return guid;
}


function getWindowSize() //函数：获取尺寸
{
    var winWidth = 0;
    var winHeight = 0;
    //获取窗口宽度
    if (window.innerWidth)
        winWidth = window.innerWidth;
    else if ((document.body) && (document.body.clientWidth))
        winWidth = document.body.clientWidth;

    //获取窗口高度
    if (window.innerHeight)
        winHeight = window.innerHeight;
    else if ((document.body) && (document.body.clientHeight))
        winHeight = document.body.clientHeight;


    //通过深入Document内部对body进行检测，获取窗口大小
    if (document.documentElement &&
        document.documentElement.clientHeight &&
        document.documentElement.clientWidth) {
        winHeight = document.documentElement.clientHeight;
        winWidth = document.documentElement.clientWidth;
    }
    return {width: winWidth, height: winHeight};
}


function string2Array(str) {
    if (str.indexOf('[') < 0) return [];
    try {
        var ret = JSON2.parse(str);
        return ret;
    } catch (err) {
        return [];
    }

}

function currentTimeStamp() {
    return new Date().getTime();
}


//以同步方式获取指定url文件的内容 ,
function getStringFromURL(url) {
    return $.ajax({url: url, async: false}).responseText;
}

function getServiceHomeURL(service, callback) {

    if (callback) {
        $rpc("", "util.ServiceUtil", "getServiceHomeURL",
            {
                service: service
            }, function (ret) {
                if (!ret) {
                    alert("getServiceHomeURL无法获取服务的可用地址  ");
                    return;
                }
                ret = JSON.parse(ret);
                callback(ret.value);
            }
        );
    } else {

        var ret = $rpc("", "util.ServiceUtil", "getServiceHomeURL",
            {
                service: service
            }
        );
        return ret.value;
    }
}


//生成n位长随机数
function mathRand(n) {
    var Num = "";
    for (var i = 0; i < n; i++) {
        Num += Math.floor(Math.random() * 10);
    }
    return Num;
}

function right(str, len) {
    var t = '0000' + str;
    return t.substring(t.length - len, t.length);
}

//得到 yyyy.mm.dd-hh.mm.ss-rrrr格式的字符串
function getNowFormatDate(needRand) {

    if (needRand == undefined) needRand = false;
    var date = new Date();
    var seperator1 = ".";
    var seperator2 = "-";
    var seperator3 = ".";

    var currentdate = date.getFullYear() + seperator1 + right(date.getMonth() + 1, 2) + seperator1 + right(date.getDate(), 2)
        + seperator2 + right(date.getHours(), 2) + seperator3 + right(date.getMinutes(), 2)
        + seperator3 + right(date.getSeconds(), 2) + (needRand ? (seperator1 + mathRand(4)) : '');

    return currentdate;
}

function trim(str) { //删除左右两端的空格
    return str.replace(/(^\s*)|(\s*$)/g, "");
}

function ltrim(str) { //删除左边的空格
    return str.replace(/(^\s*)/g, "");
}

function rtrim(str) { //删除右边的空格
    return str.replace(/(\s*$)/g, "");
}


// 判断各种浏览器，找到正确的方法
function launchFullScreen(element) {
    if (element.requestFullscreen) {
        element.requestFullscreen();
    } else if (element.mozRequestFullScreen) {
        element.mozRequestFullScreen();
    } else if (element.webkitRequestFullscreen) {
        element.webkitRequestFullscreen();
    } else if (element.msRequestFullscreen) {
        element.msRequestFullscreen();
    }
}

// 判断浏览器种类
function exitFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
}

/**
 * 文本框根据输入内容自适应高度
 * {HTMLElement}   输入框元素
 * {Number}        设置光标与输入框保持的距离(默认0)
 * {Number}        设置最大高度(可选)
 */
var autoTextarea = function (elem, extra, maxHeight) {
    extra = extra || 30;
    var isFirefox = !!document.getBoxObjectFor || 'mozInnerScreenX' in window,
        isOpera = !!window.opera && !!window.opera.toString().indexOf('Opera'),
        addEvent = function (type, callback) {
            elem.addEventListener ?
                elem.addEventListener(type, callback, false) :
                elem.attachEvent('on' + type, callback);
        },
        getStyle = elem.currentStyle ?
            function (name) {
                var val = elem.currentStyle[name];
                if (name === 'height' && val.search(/px/i) !== 1) {
                    var rect = elem.getBoundingClientRect();
                    return rect.bottom - rect.top -
                        parseFloat(getStyle('paddingTop')) -
                        parseFloat(getStyle('paddingBottom')) + 'px';
                }
                ;
                return val;
            } : function (name) {
                return getComputedStyle(elem, null)[name];
            },
        minHeight = parseFloat(getStyle('height'));
    elem.style.resize = 'both';//如果不希望使用者可以自由的伸展textarea的高宽可以设置其他值

    var change = function () {
        var scrollTop, height,
            padding = 0,
            style = elem.style;

        if (elem._length === elem.value.length) return;
        elem._length = elem.value.length;

        if (!isFirefox && !isOpera) {
            padding = parseInt(getStyle('paddingTop')) + parseInt(getStyle('paddingBottom'));
        }
        ;
        scrollTop = document.body.scrollTop || document.documentElement.scrollTop;

        elem.style.height = minHeight + 'px';
        if (elem.scrollHeight > minHeight) {
            if (maxHeight && elem.scrollHeight > maxHeight) {
                height = maxHeight - padding;
                style.overflowY = 'auto';
            } else {
                height = elem.scrollHeight - padding;
                style.overflowY = 'hidden';
            }
            ;
            style.height = height + extra + 'px';
            scrollTop += parseInt(style.height) - elem.currHeight;
            document.body.scrollTop = scrollTop;
            document.documentElement.scrollTop = scrollTop;
            elem.currHeight = parseInt(style.height);
        }
        ;
    };

    addEvent('propertychange', change);
    addEvent('input', change);
    addEvent('focus', change);
    change();
};


function $confirm(title, content, callback_ok, callback_cancel) {

    if (isMobile()) {
        //移动设备上，使用jquery-weui 库
        $.m_confirm({
            title: title,
            text: content,
            onOK: function () {
                callback_ok();
            },
            onCancel: function () {
                if (callback_cancel) callback_cancel();
            }
        });

        return;
    }

    //在PC桌面则使用 jquery-confirm 库
    $.confirm({
        title: title,
        content: content,
        buttons: {
            confirm: {
                text: "确定",
                action:
                callback_ok
            },
            cancel:
                {
                    text: "取消",
                    action: function () {
                        if (callback_cancel) callback_cancel();
                    }

                }
        }
    })
    ;
}


function $switch(title, content, ok_title, ok2_title, cancel_title, callback_ok, callback_ok2, callback_cancel, width) {
    if (width == undefined) width = 400;


    if (isMobile()) {
        $.m_modal({
            title: title,
            text: content,
            buttons: [
                {text: ok_title, onClick: callback_ok},
                {text: ok2_title, onClick: callback_ok2},
                {text: "取消", className: "default", onClick: callback_cancel}
            ]
        });


        return;
    }


    $.confirm({
        title: title,
        boxWidth: width + 'px',
        useBootstrap: false,
        content: content,
        buttons: {
            confirm: {
                text: ok_title,
                action:
                callback_ok
            },
            somethingElse: {
                text: ok2_title,
                btnClass_: 'btn-blue',
                action: callback_ok2
            },
            cancel:
                {
                    text: cancel_title,
                    action:
                    callback_cancel
                }
        }
    })
    ;
}

$prompt = function (title, tipInfo, defaultValue, placeholder, callback) {

    if (isMobile()) {
        $.m_prompt({
            title: title,
            text: tipInfo,
            input: defaultValue,
            empty: false, // 是否允许为空
            onOK: function (input) {
                callback(input);
            },
            onCancel: function () {
                //点击取消
            }
        });


        return;
    }


    $.confirm({
        title: title,
        content: '' +
            '<form action="" class="formName">' +
            '<div class="form-group">' +
            '<label>' + tipInfo + '</label>' +
            '<input type="text" value="' + defaultValue + '" placeholder="' + placeholder + '" class="name form-control" required />' +
            '</div>' +
            '</form>',
        buttons: {
            formSubmit: {
                text: '确认',
                btnClass: 'btn-blue',
                action: function () {
                    var name = this.$content.find('.name').val();
                    if (!name) {
                        toastr.error('必须输入内容');
                        return false;
                    }
                    callback(name);
                }
            },
            cancel:
                {
                    text: '取消',
                    action: function () {
                        //close
                    }
                },
        },
        onContentReady: function () {
            // bind to events
            var jc = this;
            this.$content.find('form').on('submit', function (e) {
                // if the user submits the form by pressing enter in the field.
                e.preventDefault();
                jc.$$formSubmit.trigger('click'); // reference the button and click it
            });
        }
    });
}


/**
 * 把数据填充到form中，以标签的ID(强制转换成小写)为变量名
 * @param data
 * @param formID
 */
function putDataTo(data, formID) {

    $(`#${formID}`)[0].reset();//清空内容

    var inputs = $(`#${formID} input`);

    for (var i = 0; i < inputs.length; i++) {
        var input = inputs[i];
        if (!input.id) continue;//如果没有定义ID，那么忽略
        let v = data[input.id.toLowerCase()];
        if (v == undefined) continue;

        if (input.type == 'checkbox' || input.type == 'radio') {
            input.checked = ['1', 1, 'Y', 'y', 'T', 't', 'true', 'TRUE'].contains(v);
            continue;
        }

        $(input).val(v);
    }


    //select
    var selects = $(`#${formID} select`);
    for (var i = 0; i < selects.length; i++) {
        var select = selects[i];
        let v = data[select.id.toLowerCase()];
        if (v == undefined) continue;
        select.value = v;

    }

    //textarea
    var textareas = $(`#${formID} textarea`);
    for (var i = 0; i < textareas.length; i++) {
        var textarea = textareas[i];
        let v = data[textarea.id.toLowerCase()];
        if (v == undefined) continue;
        textarea.value = v;

    }
}


function getDataFrom(formID) {
    var inputs = $(`#${formID} input`);
    var data = {};

    for (var i = 0; i < inputs.length; i++) {
        var input = inputs[i];
        if (!input.id) continue;//如果没有定义ID，那么忽略

        if (input.type == 'checkbox') {
            data[input.id.toLowerCase()] = input.checked;
            continue;
        }
        if (input.type == 'radio') {
            if (input.checked) data[input.name.toLowerCase()] = input.value;
            continue;
        }

        data[input.id.toLowerCase()] = input.value;
    }

    //select
    var selects = $(`#${formID} select`);
    for (var i = 0; i < selects.length; i++) {
        var select = selects[i];
        data[select.id.toLowerCase()] = select.value;

    }

    //textarea
    var textareas = $(`#${formID} textarea`);
    for (var i = 0; i < textareas.length; i++) {
        var textarea = textareas[i];
        data[textarea.id.toLowerCase()] = textarea.value;

    }


    console.dir(data);
    return data;
}


function $setClipboard(text) {

    var textArea = document.createElement("textarea");
    textArea.style.position = 'fixed';
    textArea.style.top = '0';
    textArea.style.left = '0';
    textArea.style.width = '2em';
    textArea.style.height = '2em';
    textArea.style.padding = '0';
    textArea.style.border = 'none';
    textArea.style.outline = 'none';
    textArea.style.boxShadow = 'none';
    textArea.style.background = 'transparent';
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.select();

    try {
        var successful = document.execCommand('copy');
        if (!successful) alert('浏览器不支持复制功能');

    } catch (err) {
        alert('浏览器不支持复制功能');
    }

    document.body.removeChild(textArea);
}


function $getClipboard() {

    var textArea = document.createElement("textarea");
    textArea.style.position = 'fixed';
    textArea.style.top = '0';
    textArea.style.left = '0';
    textArea.style.width = '2em';
    textArea.style.height = '2em';
    textArea.style.padding = '0';
    textArea.style.border = 'none';
    textArea.style.outline = 'none';
    textArea.style.boxShadow = 'none';
    textArea.style.background = 'transparent';
    textArea.value = '';
    document.body.appendChild(textArea);

    try {
        var successful = document.execCommand('paste');
        if (!successful) alert('浏览器不支持粘贴功能');

    } catch (err) {
        alert('浏览器不支持粘贴功能');
    }

    var val = textArea.value;
    document.body.removeChild(textArea);
    return val;
}


var infoPane = function () {


    var tipDOM = null;


    function createTipDOM() {
        if (tipDOM != null) return;

        tipDOM = $(` 
                    <div  style=" position:fixed;
                                color: #fff;
                                padding:10px;
                                border-radius:5px;
                                z-index: 999999;
                                top:100px;
                                left:100px;
                                font-size:14px;
                               
                                background-color:rgba(60, 60, 20, 0.65); 
                                vertical-align: center;
                                display:none;
                                "  >
                   </div> 
                `).appendTo('body');
    }


    window.showInfoPane = function (info, left, top, delayMS) {

        createTipDOM();
        if (info.startsWith("*")) {
            info = info.substring(1);
            info = `<table border='0'><tr><td><i class='fa fa-cog fa-spin fa-2x fa-fw'></i></td>
                            <td>${info}</td></tr></table>`;

        }
        tipDOM.html(info);

        if (!left) left = (window.innerWidth - tipDOM.width()) / 2;
        if (!top) top = (window.innerHeight - tipDOM.height()) / 2;

        moveInfoPane(left, top);

        if (delayMS != undefined) {
            setTimeout(function () {
                hideInfoPane();
            }, delayMS);
        }

    }


    window.moveInfoPane = function (left, top) {


        let scrollBarSize = 16;

        var w = tipDOM.width();
        var h = tipDOM.height();

        var ww = window.innerWidth;
        var wh = window.innerHeight;

        if (left + w > ww - scrollBarSize - 5) left = ww - scrollBarSize - 5 - w;

        if (top + h > wh - scrollBarSize - 5) top = wh - scrollBarSize - 5 - h;

        tipDOM.css({"left": left + "px", "top": top + "px", "display": ""});


    }


    window.hideInfoPane = function () {
        createTipDOM();
        tipDOM.css("display", "none");
    };

    return {
        showInfoPane: showInfoPane,
        moveInfoPane: moveInfoPane,
        hideInfoPane: hideInfoPane
    };

}();


function isMobile() {


    if (navigator.userAgent.indexOf('Android') > 0
        || navigator.userAgent.indexOf('webOS') > 0
        || navigator.userAgent.indexOf('iPhone') > 0
        || navigator.userAgent.indexOf('iPad').index > 0
        || navigator.userAgent.indexOf('iPod') > 0
        || navigator.userAgent.indexOf('BlackBerry') > 0
        || navigator.userAgent.indexOf('Windows Phone') > 0
    ) return true;
    return false;

}


var g_is_dingtalk = null;

function isDD() {
    if (g_is_dingtalk != null) return g_is_dingtalk;
    var sUserAgent = navigator.userAgent.toLowerCase();
    return sUserAgent.indexOf('dingtalk') >= 0;
}


