
/*
 * 把参数按顺序从后往前覆盖。注意：不是多个对象合并，是覆盖。后面对象存在的属性则覆盖前面对象，
 * 后面对象不存在的属性则保持前一对象的属性。
 * 比如　$merge(  { a:1 , b:[3] , d:4} ,  { a:2, b:[1,2] , c:3} )  =  { a:2, b:[1,2] , c:3 , d:4 }
 * 　后面对象的　a, b, 覆盖了前面的a,b , c是追加的　，　d 是前面对象有而后面对象没有的，　则保持不变
 *  即：用后面对象的属性覆盖前面对象的属性。如果后面对象中不存在某属性则忽略（比如d）,如果有，　则覆盖前面的属性
 * */
function $merge(){
	var mix = {};
	for (var i = 0, l = arguments.length; i < l; i++){
		var object = arguments[i];
		if ($type(object) != 'object') continue;
		for (var key in object){
			var op = object[key];
			var mp = mix[key];
			
			if( op==undefined) continue;
			
			if( mp==undefined)
			{
				//println("追加"+key);
				mix[key] =   $unlink(op);
				continue;
			}
			
			if(  $type(op) == 'object' && $type(mp) == 'object'  )
			{
				　//println("递归"+key);
					mix[key] =   $merge(mp, op)	;
			}else
			{　
					//println("覆盖"+key);
						mix[key] =   $unlink(op);
			}
		}
	}
	return mix;
}


function $defined(obj){
	return (obj != undefined);
};

function $empty(){};

function $arguments(i){
	return function(){
		return arguments[i];
	};
};

function $lambda(value){
	return (typeof value == 'function') ? value : function(){
		return value;
	};
} 

function $extend(original, extended){
	for (var key in (extended || {})) original[key] = extended[key];
	return original;
} 

function $unlink(object){
	var unlinked = null;
	//alert( 'unlink '+ JSON.toString( object) + $type(object));
	switch ($type(object)){
		case 'object':
			unlinked = {};
			for (var p in object) unlinked[p] = $unlink(object[p]);
		break;
		case 'array':
			unlinked = [];
			for (var i = 0, l = object.length; i < l; i++) unlinked[i] = $unlink(object[i]);
		break;
		default: return object;
	}
	
	return unlinked;
}



function $type(obj)
{
	var ret= typeof obj;
	if( ret=='object')
	{
		if(obj instanceof Array) return "array";
		if(javaClassName(obj)!='') ret="javaObject";
	}
	return ret;
};



function javaClassName(v) {

	try {
		if (v['hashCode'] && v['notifyAll'] && v['toString'] && v['wait'] && v['equals']) {
			var javaClass = v.getClass().getName();
			return '' + javaClass;
		}
		return '';
	} catch (err) {
		return '';
	}

}


