/**
 * @apiDefine  UserManage 用户及角色
 *
 */



/**
 * @api {grantRoleToUser} 函数   grantRoleToUser
 *
 * @apiDescription   grantRoleToUser( userid, roleid)
 * <br><br> 将角色 roleid 授与 userid ,如果userid已经具有roleid角色，那么什么都不会发生
 * <br>
 *     <span style='color:red'>提示：本函数仅允许在服务端执行</span>
 *<br>
 *
 * @apiName  grantRoleToUser
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {int} userid 操作员ID
 * @apiParam {String} roleid  角色ID ,在后台管理中的角色管理中，可以查看角色的ID
 *
 * @apiSuccess (返回值){String} - 成功则返回空字符串， 否则返回异常信息
 *
 * @apiExample   {js}示例：
 *
 *   grantRoleToUser(currentUserId() ,  roleName2RoleId('合同管理员') );
 *
 */

function  grantRoleToUser( userid, roleid)
{


	return  "本函数在客户端禁用";

}

/**
 * @api {revokeRoleFromUser} 函数   revokeRoleFromUser
 *
 * @apiDescription   revokeRoleFromUser( userid, roleid)
 * <br><br> 取消userid的 roleid角色，如果userid本来就没有roleid,那么什么都不会发生。
 * <br><span  style=' background-color:yellow; color:red;'>如果userid 是部门管理员。并且某些用户是由他注册的，当该userid用户的某个角色被取消时，由他
 * 注册的所有用户的roleid角色也会被强制取消</span>
 * <br>
 *     <br>
 *     <span style="color:red">参看 ：</span><a href="/docview?path=F5ZGK4DFOJ2G64TZF5WGSYTSMFZHSL3EN5RS6OJZF3T3HO7HXOP6PLVB46IIML7HX2SOPO4E46XKDZ4QQYXG2ZA"
 *     target="blank" >部门管理员</a>
 *    <br>
 * <br>
 *     <span style='color:red'>提示：本函数仅允许在服务端执行</span>
 *<br>
 *
 *
 * @apiName  revokeRoleFromUser
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {int} userid 操作员ID
 * @apiParam {String} roleid  角色ID ,在后台管理中的角色管理中，可以查看角色的ID
 *
 * @apiSuccess (返回值){String} - 成功则返回空字符串， 否则返回异常信息
 *
 * @apiExample   {js}示例：
 *
 *   revokeRoleFromUser(currentUserId() ,  roleName2RoleId('合同管理员') );
 *
 */
function revokeRoleFromUser( userid, roleid)
{
    return  "本函数在客户端禁用";

}



/**
 * @api {getUserRoles} 函数   getUserRoles
 *
 * @apiDescription getUserRoles(userid)
 * <br><br> 得到指定人员的角色清单
 *
 * @apiName  getUserRoles
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {int} userid 用户的ID
 *
 * @apiSuccess (返回值){Array} - 返回角色ID的数组
 *
 *
 * @apiExample   {js}示例：
 *
 *
 *  var roles= getUserRoles( currentUserId());
 *
 *
 */
 

/**
 * @api {roleName2RoleId} 函数   roleName2RoleId
 *
 * @apiDescription  roleName2RoleId( info )
 * <br><br> 把角色名称转换成角色ID
 *
 *
 * @apiName  roleName2RoleId
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {variant} info  要输出显示的信息，
 *
 * @apiSuccess (返回值){String} - 角色的ID
 *
 * @apiExample   {js}示例：
 *
 *  var roleId= roleName2RoleId('基本角色');
 *  var b=  isRoleGrantedToUser( currentUserId() , roleId);
 *
 */
 

/**
 * @api {isRoleGrantedToUser} 函数   isRoleGrantedToUser
 *
 * @apiDescription isRoleGrantedToUser( userid, roleIdOrName)
 * <br><br> 判断某个用户是否有某个角色
 *
 *
 * @apiName  isRoleGrantedToUser
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {int} userid 操作员ID
 * @apiParam {String} roleIdOrName  角色ID或角色名称 ,在后台管理中的角色管理中，可以查看角色的ID
 *
 *
 *
 * @apiSuccess (返回值){boolean} - true表示userid对应的用户被授与了roleIdOrName对应的角色
 *
 *
 * @apiExample   {js}示例：
 *
 *  if (! isRoleGrantedToUser(currentUserId() , "xaseadsaeae1fafaaedfgnh")) alert('sorry');
 *
 */
 



/**
 * @api {isDepartmentMaster} 函数   isDepartmentMaster
 *
 * @apiDescription isDepartmentMaster( userId,departmentId)
 * <br><br> 判断某个用户是否是指定部门的部门管理员
 * <br>
 *     <span style="color:red">参看 ：</span><a href="/docview?path=F5ZGK4DFOJ2G64TZF5WGSYTSMFZHSL3EN5RS6OJZF3T3HO7HXOP6PLVB46IIML7HX2SOPO4E46XKDZ4QQYXG2ZA"
 *     target="blank" >部门管理员</a>
 *    <br>
 *
 *
 * @apiName  isDepartmentMaster
 * @apiGroup UserManage
 * @apiVersion 1.0.0
 *
 * @apiParam {int} userid 操作员ID
 * @apiParam {String} departmentId  部门的ID
 *
 *
 *
 * @apiSuccess (返回值){boolean} - true表示userid对应的用户被授与了roleIdOrName对应的角色
 *
 *
 * @apiExample   {js}示例：
 *
 *  if (! isRoleGrantedToUser(currentUserId() , "xaseadsaeae1fafaaedfgnh")) alert('sorry');
 *
 */
function isDepartmentMaster(userId,departmentId)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "userFunction",
        {
            method: 'isDepartmentMaster',
            userid:userId,
            departmentId:departmentId
        }
    );
    return  ret.value ;

}