/**
 *  上传文件 ,本函数是定制的，不建议使用
 * @param FileUploaded  上传好一个文件后的回调函数
 * @param UploadComplete 全部上传完成后的回调函数
 *
 *  示例
 *
 *  uploadFileToOSS( function(url)
 *      {
 *          alert(url);  //上传后文件访问的URL
 *      },
 *      function(dlg)
 *       {
 *         dlg.close(); //关闭上传对话框
 *      }
 *  );
 *
 */
function uploadFileToOSS(FileUploaded, UploadComplete) {

    var id = new Date().getTime();
    var p = {
        lazyOpen: true,
        theme: 'light',
        closeIcon: true,
        useBootstrap: false,
        boxWidth: '800px',
        closeIconClass: 'fa fa-close',
        animation: 'zoom',
        closeAnimation: 'scale',
        title: "上传文件",
        content: `<iframe  id="uploadFrame"    frameborder=0  ' +
        ' style="width:100%; height:340px; border:0px solid lightgray;" ' +
        ' src="ui/plupload/upload2.html?id=${id}"></iframe>`
    };


    var dlg = $.dialog(p);
    dlg.open();

    window['FileUploaded' + id] = FileUploaded;
    window['UploadComplete' + id] = UploadComplete;
    window['uploadFileDialog' + id] = dlg;

}


/**
 * @api {uploadFile} 函数   uploadFile
 *
 * @apiDescription  uploadFile( config ,callback   )
 * <br><br> 上传文件到服务器<br>
 *  上传客户端文件到文件服务器， 默认情况下，系统内建一个简易的文件服务，提供文件存储及访问服务。
 *  服务在启动时，可以通过 appFileRoot 指明一个目录，该目录被系统做为应用中需要生成文件的根目录。
 *   appFileRoot/FileRoot 做为默认文件服务根目录。当在Docker中部署时，需要将 /usr/local/appFileRoot
 *   映射到宿主机的目录。
 *  更好的方案是使用成熟的分布式文件服务，比如Minio . 本函数并不选择服务器，由系统在服务端适配
 *  文件服务器 。
 *  <ul>
 *   <li>本函数被系统用于单据附件上传，但它并不局限于单据附件上传，可以通过tableName  + gguid  来规定附件的关联关系 </li>
 *   <li>默认情况下，文件上传的日志信息记录在系统表app_fileupload中，但不局限于此，可以按需要指定上传日志保存到哪个数据库哪个表，
 *   自定义的表，建议提供与app_fileload 类似的表结构，相关的字段信息会自动填入</li>
 *   <li>在记录上传日志的同时，还可以保存额外的信息，详见下面的config.data 的说明</li>
 *   <li>在日志表中查询到 bucketName ,  objectName , fileName , 可以通过如下地址直接访问文件
 *    http://server:port/formEngine/fileServer?bucketName={bucketName}&objectName={objectName}&fileName={fileName}&action=view
 *
 *    注意两点：1 {fileName}注意进行编码  2  action=view表示在线查看  =download 表示下载
 *
 *    </li>
 *
 *    <li>上述访问上传的文件方式，仅适用于少量文件的应用 。如果上传文件较多，请使用成熟的分布式文件管理服务。 </li>
 *
 *
 *    </ul>
 *
 *
 * <br>
 *
 * @apiName  uploadFile
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {Object} config  它是一个JSON对象 ，用来配置上传文件的配置信息
 * <ul>
 * <li>serverIndex  上传到哪个对象存储服务器。系统允许设置5个对象存储服务，本参数表明文件将上传到哪个对象存储服务器上。默认为1 </li>
 *  <li>fileType   上传文件的类型， *.* 表示所有类型的文件 。可以使用用逗号隔开的文件扩展名或的用逗号隔开MIME 类型列表(比如：  audio/mp4,video/mp4  ，
 *  更多在类型可搜索“file accept ” )来表明仅允许上传特定的文件， 多个类型之间用逗号分隔。 如果不提供本设置项，则默认为 "jpg,jpeg,png,gif,bmp"</li>
 * <li>bucketName  存储分片名称，或者称为存储桶，它与文件服务器相关，如果不提供本设置项，则使用默认值：Attachment ，如果它不存在，则自动创建 </li>
 * <li>logTable  上传后，记录上传详细信息的表，每上传一个文件，就记录一个日志。如果不提供本设置项，则使用默认值：app_fileupload </li>
 * <li>dbpool   logTable 保存在哪个数据库连接池中。如果不提供本设置项，则使用默认值：default 即系统主数据库 </li>
 * <li>tableName  上传的文件与哪个表相关。比如单据模块中的上传附件，此设置项即单据主表名称 </li>
 * <li>gguid  上传的文件与表{tableName} 的哪条记录相关</li>
 * <li>path  文件上传到哪个子路径中，可以是多级目录，目录如果不存在，则自动创建。如果不提供本设置项，则使用默认值： {tableName}/年/月/日/ </li>
 * <li>thumbnailBucketName  如果附件是图片，允许同时生成一个缩略图，本参数指定缩略图放在哪个存储分片中，如果不提供本设置项，表明使用 {bucketName} 相同的存储分区</li>
 * <li> maxThumbnailSize 缩略图的最大尺寸。当图片宽度大于高度时，它表明缩略图的宽度，反之则表明缩略图的高度。如果不提供本设置项，默认使用256 (单位：像素) </li>
 *  <li>data  是一个JSON对象，其中的属性值会保存到表 {tableName}中同名的字段中 。 详见示例
 * </ul>
 *
 * @apiParam {Function} callback  上传成功后的回调函数 ，它是如下格式的函数 <br>
 *     function  callbck( info) {   }
 *    参数 info 记录了上传文件在服务器上的存储相关的信息。它就是上传成功后，在logTable中保存的信息。如果是使用系统默认的app_fileupload表， 其中如下几项比较重要
 *    <ul>
 <li>id  本记录的ID </li>
 <li>userid  int 上传人ID </li>
 <li>usershowname varchar(100) null, --上传人姓名 </li>
 <li>serverindex   int   NULL , -- 哪个对象存储服务器 </li>
 <li>filename    varchar (255)  NULL , 文件原始名称 </li>
 <li>filesize    int null, --文件大小 ，字节数</li>
 <li>filesizetip  varchar(40) null, </li>
 <li>fileextname   varchar(10) null, -- 文件扩展名</li>
 <li>imagewidth  int null,  --图片宽度</li>
 <li>imageheight int null,  --图片高度</li>
 <li>thumbnailwidth int null,  --</li>
 <li>thumbnailheight int null,</li>
 <li>bucketname    varchar(100) NULL ,  -- 存储分片名称</li>
 <li>objectname   varchar(1000) NULL ,  --对象存储路径</li>
 <li>thumbnailbucketname    varchar(100) NULL ,   --缩微图分片名称</li>
 <li>thumbnailobjectname   varchar(1000) NULL ,  --缩微图对象存储路径</li>
 <li>tablename   varchar(40) null,  --是哪个单据上传的 </li>
 <li>gguid  varchar(40) null,     -- 表示本附件与 tablename.gguid 相关联。即 本表.gguid= {tablename}.gguid  </li>
 <li>info1  varchar(100) null,     --自定义附加信息 </li>
 <li>info2  varchar(200) null,     -- 自定义附加信息 </li>
 <li>info3  varchar(500) null,     -- 自定义附加信息 </li>
 <li>info4  varchar(1000) null,     -- 自定义附加信息 </li>


 *        </ul>
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例1：
 *
 *    //上传word或 excel文件
 *    uploadFile (  { fileType: "doc,xls,docx,xlsx" } ,  function(info){ alert( JSON.stringify(info);)} } ;
 *
 *    //上传到指定分区下
 *
 *    uploadFile (  { fileType: "doc,xls,docx,xlsx"
 *                        bucketName: '存档' } ,  function(info){ alert( JSON.stringify(info);)} } ;
 *
 *    //指定缩略图大小
 *
 *    uploadFile (  { fileType: "jpg,jpeg,png,gif,bmp",
 *                        maxThumbnailSize: 64} ,  function(info){ alert( JSON.stringify(info);)} } ;
 *
 *   //上传日志记录到另外的表中
 *
 *   uploadFile (  {   serverIndex:2 ,  // 上传到第2个对象存储服务器上
 *                         fileType: "jpg,jpeg,png,gif,bmp" ,
 *                        dbpool:'pool1' ,
 *                        logFile: 'my_uploadLog' ,
 *                        tableName: 'test1' ,
 *                        data:{ col1: 'value1' , col2: 'value2' } ,  -- 上传日志中同时保存两个字段col1, col2
 *                        maxThumbnailSize: 64} ,  function(info){ alert( JSON.stringify(info);)} } ;
 *
 *
 *
 *   @apiExample   {js}示例2：自定义日志表：
 *       //上传结果，系统保存在主数据库的app_fileupload表中， 如果需要保存到另外的数据库及自定义名称的表中，建议该表至少需要如下字段
 *
 id varchar(40)   NOT NULL ,
 userid int  null,  --上传人ID
 usershowname varchar(100) null, --上传人姓名
 filename    varchar (255)  NULL ,
 filesize    int null, --文件大小 ，字节数
 filesizetip  varchar(40) null,
 fileextname   varchar(10) null, -- 文件扩展名
 imagewidth  int null,  --图片宽度
 imageheight int null,  --图片高度
 thumbnailwidth int null,  --
 thumbnailheight int null,
 bucketname    varchar(100) NULL ,  -- 存储分片名称
 objectname   varchar(1000) NULL ,  --对象存储路径
 thumbnailbucketname    varchar(100) NULL ,   --缩微图分片名称
 thumbnailobjectname   varchar(1000) NULL ,  --缩微图对象存储路径
 tablename   varchar(40) null,  --是哪个单据上传的
 gguid  varchar(40) null,     -- 单据的ID


 */

function uploadFile(config, callback) {

    //simpleUpload.html在提交后，返回页回调父窗口的 workBookUploadFileCallback函数，
    window['workBookUploadFileCallback'] = function (info) {
        if (callback) callback(info);
    }

    var fileType = config.fileType || '';
    var maxSize = config.maxSize || 100; //MB
    var iframe = $('#upload_iframe')[0];
    var timestamp = new Date().getTime();
    var t = base32Encode(JSON.stringify(config));


    $('#uploadData').val(t);


    if (fileType == "") fileType = 'jpg,jpeg,png,gif,bmp';
    fileType = fileExtType2acceptType(fileType);

    var input = $('#uploadFile');
    input.attr('accept', fileType);

    document.querySelector('#uploadFile').click();


}


/**
 * @api {deleteUploadedFile} 函数   deleteUploadedFile
 *
 * @apiDescription  deleteUploadedFile( dbpool, logTable, attachmentID)
 * <br><br> 删除上传的文件。 本函数先从上传文件的日志记录中找到该文件实际存放的地址， 然后把文件删除，如果有缩略图，则一并删除。
 * 最后删除该文件的上传日志
 * <br>
 *
 * @apiName  deleteUploadedFile
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} dbpool  删除的文件信息记录在哪个连接池中，''表示当前主数据库
 * @apiParam {String} logTable  删除的文件信息记录在哪个表中，'' 表示默认表app_fileupload
 * @apiParam {String} attachmentID  删除的文件信息记录的ID，
 *
 *
 * @apiSuccess (返回值){JSON} -  {success:true, message:'提示信息'}  success: true 表示删除成功，否则在 message中记录了错误提示
 *
 * @apiExample   {js}示例：
 *
 *  var b= deleteUploadedFile('','', 'xxeaifslfafafsaeaadsgp938df' );
 *
 */
function deleteUploadedFile(dbpool, logTable, attachmentID) {


    var ret = $rpc("formEngine", "formengine.AttachmentManage", "deleteUploadedFile", {
        id: attachmentID,
        dbpool: dbpool,
        logTable: logTable,
        //模板信息，用于后端脚本做删除前的检测
        authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
        authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

    });
    return ret;

}


function fileExtType2acceptType(fileType) {

    var map = {

        'gif': 'image/gif',
        'jpeg': 'image/jpeg',
        'jpg': 'image/jpeg',
        'mpeg': 'video/mpeg',
        'mpg': 'video/mpeg',
        'pdf': 'applicatapplication/pdf',
        'png': 'image/png',

        'tif': 'image/tiff',
        'tiff': 'image/tiff',
        'txt': 'text/plain',
        'wdb': 'applicatapplication/vnd.ms-works',
        'wps': 'applicatapplication/vnd.ms-works',

        'xml': 'text/xml, applicatapplication/xml',
        'zip': 'applicatapplication/zip',

        doc: 'application/msword',
        dot: 'application/msword',
        docx: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        dotx: 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
        docm: 'application/vnd.ms-word.document.macroEnabled.12',
        dotm: 'application/vnd.ms-word.template.macroEnabled.12',
        xls: 'application/vnd.ms-excel',
        xlt: 'application/vnd.ms-excel',
        xla: 'application/vnd.ms-excel',
        xlsx: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        xltx: 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
        xlsm: 'application/vnd.ms-excel.sheet.macroEnabled.12',
        xltm: 'application/vnd.ms-excel.template.macroEnabled.12',
        xlam: 'application/vnd.ms-excel.addin.macroEnabled.12',
        xlsb: 'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
        ppt: 'application/vnd.ms-powerpoint',
        pot: 'application/vnd.ms-powerpoint',
        pps: 'application/vnd.ms-powerpoint',
        ppa: 'application/vnd.ms-powerpoint',
        pptx: 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        potx: 'application/vnd.openxmlformats-officedocument.presentationml.template',
        ppsx: 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
        ppam: 'application/vnd.ms-powerpoint.addin.macroEnabled.12',
        pptm: 'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
        potm: 'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
        ppsm: 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12'
    };


    var t = fileType.split(',');
    for (var i = 0; i < t.length; i++) {
        var s = t[i].trim().toLowerCase().replace(/%20/g, ''); //空格变成了 %20 要替换掉

        if (map[s] != null) t[i] = map[s];
    }

    var ret = t.join(',');

    return ret;
}
