/**
 * @apiDefine   SystemGroup 系统函数
 */




function newGuid()
{
    return newGUID();
}

function newGUID()
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "utilFunction",
        {
            method: 'newGUID'
        }
    );
    return ret.value;
}


function currentUnitProperty( propertyName , defaultValue)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "utilFunction",
        {
            method: 'currentUnitProperty',
            propertyName:propertyName,
            defaultValue:defaultValue
        }
    );
    return ret.value;
}


//Java版datastore中使用的是此函数，为了与它兼容，增加了此别名
function randomGuid()
{
    return  newGuid();
}


/**
 * @api {isMobileDevice} 函数   isMobileDevice
 *
 * @apiDescription  isMobileDevice(   )
 * <br><br> 当前客户端环境是移动设备吗
 * <br>
 *
 * @apiName  isMobileDevice
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {variant} info  要输出显示的信息，
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  var b= isMobileDevice();
 *
 */
var g_is_mobile_device=null;

function isMobileDevice()
{
    if( g_is_mobile_device!=null) return g_is_mobile_device;

    var sUserAgent = navigator.userAgent.toLowerCase();
    var bIsIpad = sUserAgent.match(/ipad/i) == "ipad";
    var bIsIphoneOs = sUserAgent.match(/iphone os/i) == "iphone os";
    var bIsMidp = sUserAgent.match(/midp/i) == "midp";
    var bIsUc7 = sUserAgent.match(/rv:1.2.3.4/i) == "rv:1.2.3.4";
    var bIsUc = sUserAgent.match(/ucweb/i) == "ucweb";
    var bIsAndroid = sUserAgent.match(/android/i) == "android";
    var bIsCE = sUserAgent.match(/windows ce/i) == "windows ce";
    var bIsWM = sUserAgent.match(/windows mobile/i) == "windows mobile";

    if (bIsIpad || bIsIphoneOs || bIsMidp || bIsUc7 || bIsUc || bIsAndroid || bIsCE || bIsWM) {
        g_is_mobile_device=true;
    } else {
        g_is_mobile_device=false;
    }
    return g_is_mobile_device;
}

var g_is_dingtalk =null;
function isDD()
{
    if( g_is_dingtalk!=null) return g_is_dingtalk;
    var sUserAgent = navigator.userAgent.toLowerCase();
    return sUserAgent.indexOf('dingtalk')>=0;
}

function println(s)
{
    if( isMobileDevice)
    {
        $ajax.rpc("formEngine", "formengine.Util", "mobilePrintln",
            {
                info:s
            },function(ret){});
    }else {
        console.info(s);
    }
}

function runTask( taskCode , param , callback)
{
	if( typeof (param)=='object') param=JSON.stringify(param);
	
	  var ret = $ajax.rpc("script", "debug.ScriptAgent", "utilFunction",
		        {
		            method: 'runTask',
		            taskCode:taskCode,
		            args:param  
		        }
		    );
		    return ret.value;
		    
    //return book.runTask( taskCode , param , callback);
}


function newDataStore( con , sql)
{
    return $app.newDataStore(con, sql);
}


function httpPost(  url,  config , callback)
{
    if( config==undefined) config={};
    if( typeof config =='object') config=JSON.stringify(config);
    var ret= $app.httpPost(url, config ,callback);
    return ret;

}

function newGUID()
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "utilFunction",
        {
            method: 'newGUID'
        }
    );
    return ret.value;
}


/**
 * @api {iif} 函数   iif
 *
 * @apiDescription  iif( boolExpression , trueValue , falseValue )
 * <br><br> 根据表达式的值的真假，返回相应的数据
 * <br> 主要用于表单公式中。在脚本中，通常使用  (boolExpression?trueValue:falseValue)的方式
 *
 * @apiName  iif
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {bool} boolExpression  一个条件表达式，结果是boolean型
 * @apiParam {Variant} trueValue  当表达式值为true是的返回值
 *@apiParam {Variant} falseValue  当表达式值为false是的返回值
 *
 *
 * @apiSuccess (返回值){Variant} - 任意类型
 *
 * @apiExample   {js}示例：
 *
 *   iif(  a1>10 ,   'abc', 'def')
 *
 *   iif( a1>10 , rgb(255,255 ,0)  , 'red')
 *
 *
 *
 */
function iif( b , v1,v2)
{
    if(b) return v1;
    return v2;

}

/**
 * @api {rgb} 函数   rgb
 *
 * @apiDescription  println( info )
 * <br><br> 将字段串转换成小写
 * <br>
 *
 * @apiName  println
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {variant} info  要输出显示的信息，
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  println( "ABC");
 *
 */
function rgb(r,g,b)
{
    var color= new Color(r,g,b ,1);
    return '#'+Color.toHex( color.color);
}

function rgba (r,g,b,a)
{
    if( a==undefined) a=1;
    var color= new Color(r,g,b ,a);
    return '#'+Color.toHex( color.color);
}


/**
 * @api {getUrlParameter} 函数   getUrlParameter
 *
 * @apiDescription  getUrlParameter( name , defaultValue)
 * <br><br> 得到URL地址上的指定的参数值，如果不存在该参数，则返回defaultValue
 * <br>
 *
 * @apiName  getUrlParameter
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} name  参数名称
 * @apiParam {String} defaultValue  默认值
 *
 *
 * @apiSuccess (返回值){String} - 返回参数的值，如果不存在指定的参数，则返回defaultValue
 *
 * @apiExample   {js}示例：
 *
 *  getUrlParameter("abc", "1");
 *
 *
 */
function getUrlParameter( name , defaultValue)
{
    if( urlArgs[name]==undefined) return defaultValue;
    return urlArgs[name];
}




/**
 * @api {updateAll} 函数   updateAll
 *
 * @apiDescription  updateAll( ds1,ds2,ds3,ds4,ds5)
 * <br><br> 将多个结果集对象在一个事务中保存，要么都成功，要每都失败
 * <br>
 *
 * @apiName  updateAll
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {ds1} DataStore  要保存的结果集（必选参数）
 * @apiParam {ds2} DataStore  要保存的结果集（必选参数）
 * @apiParam {ds3} DataStore  要保存的结果集（可选参数）
 * @apiParam {ds4} DataStore  要保存的结果集（可选参数）
 * @apiParam {ds5} DataStore  要保存的结果集（可选参数）
 *
 * @apiSuccess (返回值){String} - 如果保存成功，返回空字符串'' , 否则返回错误信息
 *
 * @apiExample   {js}示例：
 *
 *  var err= updateAll( ds1, ds2 , ds3);
 *  if( err=='')
 *  {
 *      toastr.info("保存成功");
 *  }else
 *  {
 *      toastr.error( err);
 *  }
 *
 */
function updateAll( ds1,ds2,ds3,ds4,ds5)
{


    function update() {

        var sqlMap = {};
        // 得到所有的更新语句
        var err = getUpdateSQL(sqlMap ,[ds1,ds2,ds3,ds4,ds5]); //

        if (err != '') return err;

        //注意，不是用全局的$rpc ，因为那是异步的， 这里用的是同步的调用
        var ret = $ajax.rpc("formEngine", "formengine.ExecuteBatch", "execute",
            {

                sql: sqlMap,
                table: form.masterTableName,
                // save 调用 本update ,save函数可能在单据列表，单据编辑，报表中调用 ，
                // 所以就使用当前模板的ID，即单据列表使用的列表模板ID，编辑单据使用的是单据编辑模板ID，报表使用报表模板ID
                templateid: form.configInfo.templateid,
                // 下面的是用来权限校验的， 防止在客户端随意注入sql
                authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')

            });

        return ret.message;

    }


    // 得到所有的更新语句
    function getUpdateSQL(sqlMap , dscs) {
        var ok;
        var i, n;

        n = dscs.length;
        for (i = 0; i < n; i++) {
            var ds = dscs[i].dataStore;
            if( ds==undefined) continue;
            var dbpool = ds.DBPoolName;
            if (dbpool == '') dbpool = "default";

            if (ds.isUpdatable()) {
                var list = [];

                if (!ds.getUpdateSQL(list)) {
                    return (  "构建SQL失败:" + ds.error.message);

                }

                if (list.length == 0) continue;

                var listlist = sqlMap[dbpool];
                if (!listlist) {
                    listlist = [];
                    sqlMap[dbpool] = listlist;
                }

                listlist.push(list);

            } else {
                return (  "第"+(i+1)+"个ds被设置成不可更新");
            }
        }
        return "";

    }


    function resetUpdate(dscs) {

        var n = dscs.length;
        for (var i = 0; i < n; i++) {

            var ds = dscs[i];
            if( ds==undefined) continue;
            if (ds.isUpdatable()) ds.resetUpdate();
        }

    }

    //函数主体内容
    var ret = update();
    if (  ret =="")     resetUpdate();
    return ret;

}

//下面的一组函数仅仅是为了兼容性而设置
function updateAll2(ds1, ds2) {
    return updateAll(ds1, ds2);
}

function updateAll3(ds1, ds2, ds3) {
    return updateAll(ds1, ds2, ds3);
}

function updateAll(ds1, ds2, ds3, ds4) {

    return updateAll(ds1, ds2, ds3, ds4);
}

function updateAll5(ds1, ds2, ds3, ds4, ds5) {
    return updateAll5(ds1, ds2, ds3, ds4, ds5);
}



function MD5(str ,charset)
{
    if (charset == undefined) charset = "UTF-8";
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'MD5',
            charset:charset,
            str: str
        }
    );
    return ret.value;
}


function json2xml(str)
{
    if( typeof str =='object')  str= JSON.stringify(str);
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'json2xml',
            str: str
        }
    );
    return ret.value;
}


function xml2json(str)
{
    if( typeof str =='object')  str= JSON.stringify(str);
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'xml2json',
            str: str
        }
    );
    return ret.value;
}

function appendWhere( w1,w2,andOr)
{

    if( w1==null ) w1="";
    w1=w1.trim();
    if( w1=='') return w2;

    if( w2==null ) w2="";
    w2=w2.trim();
     if(w2=="") return w1;
     return "("+w1+") " + andOr+" ("+w2+")";

}



function buildBillNo(  dsn,   tableName,  col ,  pattern ,  billDateCol ,  billDate,    where)
{

    if( where==null) where="";
    if( billDate==null)  billDate= date2yyyymmdd(newDate());
    if( typeof billDate =='object')  billDate= formatDate( billDate , 'yyyy.MM.dd');

    if( typeof str =='object')  str= JSON.stringify(str);
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'newBillNo',
            dsn: dsn,
            tableName:tableName,
            col:col,
            billDate:billDate,
            billDateCol:billDateCol,
            pattern:pattern,
            where:where
        }
    );
    return ret.value;
}


function getUserInfo(  userid,   what)
{
	return   getValueFromSQL("select "+what+ "  from  news_user  where id="+ userid);
}

function  iif( bool , t, f)
{
	return bool?t:f; 
}

