

/****************************************************************************************************************************
将字符串转化成小写
****************************************************************************************************************************/
function lower(str)
{
	var ret=  ''+str;
	return ret.toLowerCase();
}

/****************************************************************************************************************************
将字符串转化成大写
****************************************************************************************************************************/
function upper(str)
{
	var ret=  ''+str;
	return ret.toUpperCase();
}

/****************************************************************************************************************************
对象内第一次出现子字符串的字符位置。
****************************************************************************************************************************/

function  indexOf(str , subString, startIndex)
{
	if (str==null) return -1;
	if (subString==null) return -1; 
	str=''+str;
    if (startIndex==null) startIndex=0; 
	return str.indexOf(subString , startIndex);
}

/****************************************************************************************************************************
对象内最后一次出现子字符串的字符位置。
****************************************************************************************************************************/

function  lastIndexOf(str , subString)
{
	if (str==null) return -1;
	if (subString==null) return -1; 
	str=''+str;
	subString=''+subString;


	return str.lastIndexOf(subString );
}

function trim(str)
{
	if ( str==null)  return "";
	str=''+str;
	var ret=str.replace(/(^\s+)|(\s+$)/g, "");
	return ret;
} 

function len(str)
{
	if ( str==null)  return "";
	str=''+str;
	return str.length ;
}


function substring( str , begin, end)
{
		var n=len(str);
		if ( begin>n-1) return "";
		if ( end>n) end=n; 
		if ( begin>end) begin=end; 

		return str.substring( begin, end);

}

function mid( str , begin, end)
{
	return substring( str, begin, end)
}

/****************************************************************************************************************************
把字符串增１
****************************************************************************************************************************/
function stringInc( str)
{
    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'stringInc',
            str: str
        }
    );
    return ret.value;

}


function html2text(html)
{
    if ( html==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'html2text',
            html: html
        }
    );
    return ret.value;
}

//js中的字符串正常显示在HTML页面中  
function text2Html(str) 
{
    //将字符串转换成数组  
    var strArr = str.split('');  
    //HTML页面特殊字符显示，空格本质不是，但多个空格时浏览器默认只显示一个，所以替换  
    var htmlChar="&<>";  
    for(var i = 0; i< str.length;i++){  
        //查找是否含有特殊的HTML字符  
        if(htmlChar.indexOf(str.charAt(i)) !=-1){  
            //如果存在，则将它们转换成对应的HTML实体  
            switch (str.charAt(i)) {                          
                case '<':  
                    strArr.splice(i,1,'&#60;');  
                    break;  
                case '>':  
                    strArr.splice(i,1,'&#62;');  
                    break;  
                case '&':  
                    strArr.splice(i,1,'&#38;');  
            }  
        }  
    }  
    return strArr.join('');  
} 

function extractValue( str , varName)
{
	str=""+str;
	varName=""+varName;
    var p1= str.indexOf("<"+varName+">");
    if(p1<0) return "";
    var p2= str.indexOf("</"+varName+">");
    if(p2<0) return "";
    return str.substring( p1+varName.length+2, p2);
    
}

function getFirstSpell( str)
{
    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'getFirstSpell',
            str: str
        }
    );
    return ret.value;

}

function getFullSpell( str)
{
    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'getFullSpell',
            str: str
        }
    );
    return ret.value;

}

//去除所有空格
function  removeAllSpace( s)
{
	var s=''+s;
	s = s.replace( /\s/g , ""); //去掉空格
	return s;
}


function right(s , n)
{
	var t=''+s;
	if( t.length<=n) return t;
	return t.substring(t.length-n , t.length);
}

/*
 * 如果是以c结果，那么去掉它
 */
function  removeEndChar( s ,c)
{
	s=''+s;
	c=''+c;
	if(  s.substring( s.length - c.length , s.length) ==c )
	{
		s=s.substring(0, s.length-c.length);
	}
	return s;
		
}

function stringZip(str)
{
    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'stringZip',
            str: str
        }
    );
    return ret.value;
}

function stringUnZip(str)
{
    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'stringUnZip',
            str: str
        }
    );
    return ret.value;
}


function encrypt(str, key)
{
	var n=len(key);

    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'encrypt',
            str: str,
			key:key
        }
    );
    return ret.value;
}


function decrypt(str, key)
{
	var n=len(key);

    if ( str==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'decrypt',
            str: str,
			key:key
        }
    );
    return ret.value;
}


function DESencode(str, key)
{
    if ( str==null) return null;
    if ( key==null) return null;

    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'DESencode',
            str: str,
            key:key
        }
    );
    return ret.value;
}

function DESdecode(str, key)
{
    if ( str==null) return null;
    if ( key==null) return null;
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'DESdecode',
            str: str,
            key:key
        }
    );
    return ret.value;
}


function isValidIdentify( value)
{ 
	var s=''+value;
	var t=s.match( /[A-Za-z][A-Za-z0-9_]*/ ); //字母开头，并由字母数字_组成，
	if(!t) return false;
	if( t==s ) return true;  //表示整个字符串整体匹配，而不是局部匹配
	 return false;
}




function base32Encode( s)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'base32Encode',
            s: s
        }
    );
    return ret.value;
}

function base32Decode( s)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'base32Decode',
            s: s
        }
    );
    return ret.value;
}

function base64Encode( s)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'base64Encode',
            s: s
        }
    );
    return ret.value;
}

function base64Decode( s)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'base64Decode',
            s: s
        }
    );
    return ret.value;
}




function  urlDecoder( str,  charset)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'urlDecoder',
            str: str,
            charset:charset
        }
    );
    return ret.value;
}

function  urlEncoder( str,  charset)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'urlEncoder',
            str: str,
            charset:charset
        }
    );
    return ret.value;
}


function safeURL(url)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'safeURL',
            url:url
        }
    );
    return ret.value;
}


function  escapeXml( str)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'escapeXml',
            str: str
        }
    );
    return ret.value;
}

function  unescapeXml( str)
{
    var ret = $ajax.rpc("script", "debug.ScriptAgent", "stringFunction",
        {
            method: 'unescapeXml',
            str: str
        }
    );
    return ret.value;
}

