/**
 * @apiDefine   MessageGroup 消息函数
 */


/**
 * @api {onPushMessage} 函数   onPushMessage
 *
 * @apiDescription  onPushMessage( topic , callback )
 * <br><br> 关注服务器或其它用户推送来的关于topic 的消息
 * <br>
 *
 * @apiName  onPushMessage
 * @apiGroup MessageGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} topic  关注的消息主题
 * @apiParam {Function} callback  收到消息后的回调函数   函数原型:   function onMsg( msg) {}
 * @apiParam {String} service  连接到哪个服务 ，如果未指定，则默认为 "script" ,通常不用指定
 * @apiParam {boolean} oneOff  [可选参数]默认是false，  true表示连接是一次性的,即收到消息后，立即自动关闭连接
 *@apiParam {int} timeout [可选参数]超时时间，单位：秒。默认是30秒， 当oneOff ==true时，如果在指定时间内没有收到消息，那么就强制断开， 当oneOff==off时，本参数无效
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 * function formOpen()
 * {
 *
 *      onPushMessage("test1" , function(msg){ alert ( msg);} );
 *
 * }
 *
 *  //在服务端脚本中或某个模板中使用 postMessage( "test1", "aaa",1); 发送消息 ，上面的脚本就能接收消息
 *
 */
function onPushMessage(topic, callback, service, oneOff, timeout ) {

    if(oneOff==undefined)  oneOff=false;
    if( timeout==undefined)  timeout=30;//
    if (service == undefined) service = 'app';
    //连接到script服务中，因为消息通常是脚本引擎推送过来的
    let chat = new Chat(service, topic, function (msg) {

        if (msg.data) callback(msg.data);
        if( oneOff)
        {
            console.info("一次性的连接，收到消息后，自动关闭 ");
            chat.close();
        }
    });

    if( oneOff)
    {
        setTimeout( function()
        {
            chat.close();
        }, timeout*1000);
    }
    return chat;

}


function pushMessage(topic, msg, toWhom) {

    if (toWhom == undefined) toWhom = currentUserId();
    if (typeof msg == 'object') msg = JSON.stringify(msg);

    var ret = $ajax.rpc("app", "workspace.WorkSpace", "pushMessage",
        {

            topic: topic,
            message: msg,
            toWhom: toWhom
        }
    );
    return ret.value;

}


/**
 * @api {openInMainFrame} 函数   openInMainFrame
 *
 * @apiDescription  openInMainFrame( url, newWindow, img, name )
 * <br><br>  在报表或单据模板中通知系统工作台打开一个新的工作tab窗口。执行本函数的模板，并不一定必须位于工作台Tab页中，
 * 在新窗口中打开的表单也能执行本函数。本函数是通过服务器向客户端推送消息来实现消息传递的。基于如下理由：
 * <ul>
 *     <li>在工作台tab页中打开的表单，与工作台可能并不属于一个域名下，所以不能通过 parent.parent......这样的链路来访问工作台页面</li>
 *    <li>当表单是在新窗口中打开时，无法访问工作台所在的窗口</li>
 *     </ul>
 * <br>
 *     由于实现是基于消息推送，所以一个负作用是，当以同一个帐号在不同电脑上登录，一台电脑上执行本函数，则所有相同帐号登录的电脑上都会打开页面
 *
 * @apiName  openInMainFrame
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} url  需要打开的URL地址，它可以系统工作台上的地址，也可以是其它任意的URL地址
 * @apiParam {boolean} newWindow   true表示在新窗口中打开， false表示在系统工作台的新tab页中打开
 * @apiParam {String} img  显示在tab左角的图标，比如  'fa-pencil', 'fa-cog'  , 可用的字体图标，参看 http://www.fontawesome.com.cn/faicons/
 * @apiParam {String} name  如果在工作台Tab页中打开， name表示tab页的标题文字，如果名称为name的tab页已经打开，那么激活该页，否则打开它。
 *   即使多次调用函数，只要name对应的tab页已打开，就不会重复再打开。
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 function cb1_onClick()
 {

  openInMainFrame('https://www.qq.com' , false, 'fa-pencil', 'QQ' );

}

 function cb2_onClick()
 {

  openInMainFrame('report.jsp?id=postgres_page' , false, 'fa-pencil', '呵呵了' );

}


 */

function openInMainFrame(url, newWindow, img, name) {

    pushMessage("workspaceCommand",
        {
            command: 'openInMainFrame',
            url: url,
            newWindow: newWindow,
            img:
            img,
            name:
            name
        },
        currentUserId()
    );
}


function chatWith(userid, info) {
    $rpc("sso", 'sso.Chat', 'chat',
        {
            toUserId: userid,
            topic: "chat",
            message: info
        },

        function (retValue) {
            var ret = JSON.parse(retValue);
            if (ret.success) {
            } else {
                toastr.error(ret.message);
            }
        }
    );
}


