/**
 * @apiDefine   H5APP 移动应用函数
 */


/**
 * @api {barcodeScan} 函数   barcodeScan
 *
 * @apiDescription  barcodeScan(   )
 * <br><br> 调用移动设备的扫码功能
 * <br>
 *
 * @apiName  barcodeScan
 * @apiGroup H5APP
 * @apiVersion 1.0.0
 *
 * @apiParam {String} type  条码类型。type为qrCode(二维码)、barCode(条形码)、all(全部)。若有qrCode、barCode扫描不出来，请修改type为all
 * @apiParam {Function} callback  回调函数，扫描的内容做为参数代入执行此回调函数
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *   barcodeScan('all',  function(val) { alert(val);} );
 *
 *
 */
function barcodeScan(type, callback) {


    var $scan = function (ddd, type, callback) {
        ddd.ready(function () {
            ddd.biz.util.scan({
                type: 'all',
                onSuccess: function (data) {
                    callback(data.text);
                },
                onFail: function (err) {
                    $alert(err);
                }
            });
        });
    }


    if (isDD()) { //如果在钉钉里

        var ddd= getDD();
        $scan( ddd , type, callback);
        return;
    }

    toastr.error("尚未适配本应用");

}


