/*
* 实现客户端调用服务端函数
*
*
* 2019.09.03修正 ：如果后端函数没有返回值， 要注意获取返回
* */


function functionProxy(templateid, funcName, funcParam, callback) {



    //注意，不是用全局的$rpc ，因为那是异步的， 这里用的是同步的调用

    if (callback) {
        $ajax.rpc("formEngine", "formengine.FunctionProxy", "execute",
            {
                function: funcName,
                arguments: funcParam, //funcParam是字符串化后的Array
                templateid: templateid,
                currentGUID: $('meta[name="currentGUID"]').attr('content'),
                // 下面的是用来权限校验的， 防止在客户端搞鬼
                authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')
            }, function (ret) {
                var retVal = null;
                try {

                    retVal = JSON.parse(JSON.parse(ret).returnValue).value;
                } catch (err) {

                }
                callback(retVal);
            });


    } else {
        var ret = $ajax.rpc("formEngine", "formengine.FunctionProxy", "execute",
            {
                function: funcName,
                arguments: funcParam, //funcParam是字符串化后的Array
                templateid: templateid,
                currentGUID: $('meta[name="currentGUID"]').attr('content'),
                // 下面的是用来权限校验的， 防止在客户端搞鬼
                authorizationURL: $('meta[name="AuthorizationURL"]').attr('content'),
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr('content')
            });

        //为什么要搞这么复杂，转几道。
        // 这里的JS是浏览器中执行，它的数据需要传递到服务端，此时数据就需要调制过，便于传输，且到了服务端
        // 也无法直接传递一个JSON对象过去，因为 Java中没有原生的JSON对象，并且，也没法直接把一个JSON对象传入到Rhino中
        //只能以字符串化的数据进行传递。
        //服务端在Rhino中执行函数后的返回值不知道它是一个什么类型，可能是简单类型，也可能是对象
        //因此在服务端引擎中，把它包装成一个对象 { value: funcReturnValue } 再转换成字符串，回到Java中
        //Java中再返回到客户端浏览器中，returnValue 就是那个字符串后的数据， 把它对象化后，再取value
        // 此时的 value 可以是简单值，也可以是JSON对象 ， 不需要再做对象化转换
        var retVal = null;
        try {
            retVal = JSON.parse(ret.returnValue).value;
        } catch (err) {

        }
        return retVal;
    }

}

