/**
 * @apiDefine   DialogGroup 弹窗函数
 */


function openReportDialog(title, width,height, id, param , callback)
{
	openDialog( title, "dialog", id, width, height, param, "wiseoaDialogParameter="+ base32Encode( JSON.stringify(param)) , callback);
}


function  getDialogParameter()
{
	return  form.wiseoaDialogParameter;
}


/*

请保持本脚本与 formEngine\globalscript\dialog.js一至

2018.04

本库提供以对话框方式打开一个报表或单据的功能

细节：
1 由于主表单与openDialog打开的表单，可能在不同的域中，因为主表单与Dialog表单不能直接访问，存在跨域问题。因此
需要使用postMessage来进行异步消息传递

2 当 dialog.jsp的 formOpen事件后，需要向主表单发送一个消息，主表单接收这个消息后，把param放在消息中，回传给dlaolg页
dialog页触发 dialogOpen事件 ，完成了主页面向dialog页面传参数的动作

3 当主页面的对话框按钮confirm按下时，发送消息给dialog.jsp ，参数它要准备返回了

4 dialog.jsp接收到要返回的消息后，触发 dialogOnOK

 */

/**
 * @api {openDialog} 函数   openDialog
 *
 * @apiDescription  openDialog( title, type, id, width, height, param, urlParamString, callback)
 * <br><br> 在弹出窗口中显示一个模板界面
 * <br>
 *
 * @apiName  openDialog
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} title  窗口标题
 * @apiParam {String} type  模板类型 可以是
 * <ul><li>"billlist" :表示是单据列表模板 </li>
 * <li>"bill"  : 表示是单据模板</li>
 * <li>"report"  : 表示是报表模板 </li>
 * </ul>
 * @apiParam {String} id  单据或报表的ID，注意不是模板ID
 * @apiParam {number} width  窗口宽度
 * @apiParam {number} height  窗口高度
 * @apiParam {Object} param  传入的数据，是一个JSON对象
 * @apiParam {String} urlParamString  拼接到URL中的参数
 * @apiParam {Function} callback  当弹出的窗口点击确认关闭窗口后执行此回调函数 ,如果不提供本参数，则对话框不显示下面的确认及关闭按钮
 *
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  openDialog( "选择人员" ,"report" , "xxcsxxxx" , 700,500, {a:1,b:2} , "code=1&name=abc" , function(val){alert(val);});
 *
 */
function openDialog(title, type, id, width, height, param, urlParamString, callback) {
    //应该可以更优雅的实现，比如生成一个ID给dialog ,并把param, callback缓存在key=id的缓存中
    window['junzeng_dialog_param'] = param;
    window['junzeng_dialog_callback'] = callback;
    if (!urlParamString) urlParamString = '';


    var p = {
        theme: 'light',
        closeIcon: true,
        draggable : true,
        closeIconClass: 'fa fa-close',
        animation: 'zoom',
        closeAnimation: 'scale',
        title: title,
        content: '<iframe  id="dialogFrame"  name="dialogFrame" frameborder=0  ' +
            ' style="width:100%; height:' + height + 'px; border:0px solid lightgray;" ' +
            ' src="h5-dialog.jsp?type=' + type + '&id=' + id + '&' + urlParamString + '"></iframe>'} ;

    if( callback)
    {

        p.buttons= {
            confirm:
                {
                    text: "&nbsp;&nbsp;&nbsp;确&nbsp;&nbsp;&nbsp;定&nbsp;&nbsp;&nbsp;",
                    btnClass: "btn-success",
                    action:
                        function () {
                            $sendMessageToDialog({action: 'dialogOnOK'});
                            window['junzeng_dialog'] = this;
                            return false;
                        }
                },
            cancel:
                {
                    text: "&nbsp;取&nbsp;&nbsp;消&nbsp;",
                    btnClass: "btn-warning",
                    action: function () {
                    }
                }
        };
    }

    if ((width + '').indexOf("%") > 0) {
        p.boxWidth = width;
        p.useBootstrap = false;
    } else if (width <= 12) {
        p.columnClass = 'col-md-' + width;
    } else {
        p.boxWidth = width + "px";
        p.useBootstrap = false;
    }

    if( callback) {
        $.confirm(p);
    }else {
        $.dialog(p);
    }

}


//主页面发送消息给对话框
var $sendMessageToDialog = function (msg) {
    var f = window.frames['dialogFrame'];
    if (f.postMessage) {
        f.postMessage(JSON.stringify(msg), '*');
    } else {
        f.contentWindow.postMessage(JSON.stringify(msg), '*');
    }
};
//对话框发送消息给主页面
var $sentMessageToMainForm = function (msg) {
    window.parent.postMessage(JSON.stringify(msg), '*');
};


window.addEventListener('message', function (e) {


        try {
            var msg = JSON.parse(e.data);

            //这里的消息，通常中主页面收到的消息
            //如果收到dialog发来的请求参数的消息，那么把参数传给它
            if (msg.action == 'requestParameter') //参看 loadTemplate.js
            {
                $sendMessageToDialog({action: 'responseParameter', data: window['junzeng_dialog_param']});
                return;
            }

            if (msg.action == 'dialogReturn') //参看 loadTemplate.js
            {
                var dlg = window['junzeng_dialog'];
                dlg.close(); //关闭对话框
                var callback = window['junzeng_dialog_callback'];
                callback(msg.data);  //把数据代入回调
                return;
            }

            if (msg.action == 'closeDialogAndRun') //参看 form.js中的 refreshRetrieveList
            {
                var dlg = window['junzeng_dialog'];
                dlg.close(); //关闭对话框
                var script = msg.script;
                try {

                    if (script != '') eval(script);
                } catch (Err) {

                }
                return;
            }

            if (msg.action == 'parentWindowRun') //参看form.js中的$backToBillList
            {

                var script = msg.script;
                eval(script);
                return;
            }


            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //下面的消息通常是dialog.jsp收到的消息
            if (msg.action == 'responseParameter') //参看 loadTemplate.js
            {
                if( form) {
                    form.handleEvent('dialogOpen', null, [msg.data]);
                }
                return;
            }

            if (msg.action == 'dialogOnOK') //参看 loadTemplate.js
            {
                if ("undefined" != typeof form) {
                    var ret = form.handleEvent('dialogOnOK', null, []);
                    if (ret == null) return;
                    $sentMessageToMainForm({action: 'dialogReturn', data: ret});
                } else {
                    //20180904 注意，要放在else中，因为模板中写的脚本也会加到window中，所以下面是一定存在的
                    //如果窗口中有dialogOnOK函数 ，那么触发它
                    if (window['dialogOnOK']) {
                        var ret = dialogOnOK();
                        if (ret == null) return;
                        $sentMessageToMainForm({action: 'dialogReturn', data: ret});
                    }
                }

            }

            //下面的消息是 tab切换

            if (msg.action == 'pageActive') //参看 app/tabmain.jsp
            {
                if( form) {
                    form.handleEvent('pageActive', null, []);
                }
                return;
            }

            if (msg.action == 'pageDeactive') //参看 app/tabmain.jsp
            {
                if( form) {
                    form.handleEvent('pageDeactive', null, []);
                }
                return;
            }

            if (msg.action == 'pageClose') //参看 app/tabmain.jsp
            {
                if( form) {
                    form.handleEvent('pageClose', null, []);
                }
                return;
            }


        } catch (err) {
            console.dir(err);
        }
    }
);


/**
 * @api {inputBox} 函数   inputBox
 *
 * @apiDescription  inputBox( title , prompt ,defaultValue , placeHolder , callback)
 * <br><br> 弹出一个模态窗口，允许输入一个数据
 * <br>
 *
 * @apiName  inputBox
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} title  标题
 * @apiParam {String} prompt  提示信息
 * @apiParam {String} defaultValue  默认值
 * @apiParam {String} placeHolder  输入框中的提示
 * @apiParam {Function} callback 回调函数
 *@apiParam {boolean} nullable [可先参数] 输入的内容是否允许为空字符串，默认是false
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *   inputBox("提示", "请输入名称", "","" , function(val){alert(val);});
 *
 */
function inputBox(title, prompt, defaultValue, placeHolder, callback,nullable) {
    if( nullable==undefined) nullable=false;
    $.confirm({
        title: title || '' ,
        useBootstrap:false,
        draggable : true,
        boxWidth:'400px',
        content: '' +
            '<form action="" class="formName">' +
            '<div class="form-group" style="overflow:hidden;">' +
            '<label>' + prompt + '</label>' +
            '<input type="text" placeholder="' + placeHolder + '" class="name form-control" required  value="' + defaultValue + '"  style="width:100%;" />' +
            '</div>' +
            '</form>',
        buttons: {
            formSubmit: {
                text: '确认',
                btnClass: 'btn-blue',
                action: function () {
                    var name = this.$content.find('.name').val();
                    if( name==null) name=='';
                    if ( name =='' && ! nullable) {

                        $.alert('必须输入内容');
                        return false;
                    }

                    setTimeout(function () {
                        callback(name);
                    }, 10);
                }
            },
            cancel:
                {
                    text: '放弃',
                    action: function () {
                        //close
                    }
                },
        },
        onContentReady: function () {
            // bind to events
            var jc = this;
            this.$content.find('form').on('submit', function (e) {
                // if the user submits the form by pressing enter in the field.
                e.preventDefault();
                jc.$$formSubmit.trigger('click'); // reference the button and click it
            });
        }
    });
}


/**
 * @api {openDialogURL} 函数   openDialogURL
 *
 * @apiDescription  openDialogURL( title, url, width, height ,callback)
 * <br><br> 将指定的URL在一个模态弹出窗口中显示
 * <br>
 *
 * @apiName  println
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} title  标题
 * @apiParam {String} url  在窗口中打开的URL地址
 * @apiParam {number} width  窗口宽度
 * @apiParam {number} height  窗口高度
 * @apiParam {Function} callback  当弹出的窗口点击确认关闭窗口后执行此回调函数
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  openDialogURL("选择用户" , homePage+"/selectUser.jsp?style=multi", 850, 500, function(val){ alert( val);});
 *
 */
function openDialogURL(title, url, width, height, callback, nobutton) {

    window['junzeng_dialog_callback'] = callback;


    var p = {
        theme: 'light',
        closeIcon: true,
        closeIconClass: 'fa fa-close',
        draggable : true,
        animation: 'zoom',
        closeAnimation: 'scale',
        title: title || '',
        content: '<iframe  id="dialogFrame"  name="dialogFrame" frameborder=0  ' +
            ' style="width:100%; height:' + height + 'px; border:0px solid lightgray;" ' +
            ' src="' + url + '"></iframe>',

        buttons:

                    callback == undefined ? {
                        cancel:
                            {
                                text: "&nbsp;关&nbsp;&nbsp;闭&nbsp;",
                                btnClass: "btn-warning",
                                action: function () {
                                }
                            }
                    } : {

                        confirm:
                            {
                                text: "&nbsp;&nbsp;&nbsp;确&nbsp;&nbsp;&nbsp;定&nbsp;&nbsp;&nbsp;",
                                btnClass: "btn-success",
                                action:
                                    function () {
                                        $sendMessageToDialog({action: 'dialogOnOK'});
                                        window['junzeng_dialog'] = this;
                                        return false;
                                    }
                            },
                        cancel:
                            {
                                text: "&nbsp;取&nbsp;&nbsp;消&nbsp;",
                                btnClass: "btn-warning",
                                action: function () {
                                }
                            }
                    }

    };



    if ((width + '').indexOf("%") > 0) {
        p.boxWidth = width;
        p.useBootstrap = false;
    } else if (width <= 12) {
        p.columnClass = 'col-md-' + width;
    } else {
        p.boxWidth = width + "px";
        p.useBootstrap = false;
    }


    $.confirm(p);

}


/**
 * @api {openWindow} 函数   openWindow
 *
 * @apiDescription  openWindow( url )
 * <br><br>  在新的窗口中打开指定的URL地址
 *
 * 当使用本系统开发钉钉H5微应用时，可以在单据编辑，单据列表及报表窗口中使用本函数实现在新窗口上打开链接
 * 当本函数在PC端执行时， 它是新打开一个浏览器级的Tab页
 * <br>
 *
 * @apiName  openWindow
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} url  要打开的地址，可以是相对地址，也可以是绝对地址
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  openWindow( "bill.jsp?id=abc");
 *  openWindow("http://www.jssheet.cn");
 *
 *
 */
function openWindow(url) {
    var a = $('#openInNewWindow')[0];
    a.href = url;
    a.click();
}

/**
 * @api {openSelectUserDialog} 函数   openSelectUserDialog
 *
 * @apiDescription  openSelectUserDialog( callback )
 * <br><br> 弹出显示一个选择人员的模态窗口
 * <br>
 *
 * @apiName  openSelectUserDialog
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {Function} callback  选择人员后的回调函数
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  openSelectUserDialog( function(selectedUsers}{ console.dir( selectedUsers);});
 *
 */
function openSelectUserDialog(callback) {
    //从eureka获取sso服务的地址
    var homePage = getServiceHomeURL("sso");
    openDialogURL("选择用户", homePage + "/selectUser.jsp?style=multi", 850, 500, callback);
}



/**
 * @api {showInfo} 函数   showInfo
 *
 * @apiDescription  showInfo( info )
 * <br><br> 弹出显示一个模态的提示信息窗口
 * <br><ul>
 *     <li>它并不阻塞脚本的执行，但是屏蔽了用户的鼠标键盘操作.  与showInfoPane不同的是，showInfoPane并不阻塞界面，
 * 用户仍可以操作UI</li>
 * <li>与toastr.info 不同的是，无论执行多少次 showInfo ,只需要一次 hideInfo 即可关闭提示信息小窗口。因为每次showInfo执行时，会自动将上次
 * 的信息窗口关闭。而 toastr.info 会将每个信息都显示出来，并自动排版它们的位置，并逐一自动关闭
 * <li> showInfo 不会自动关闭，除非 调用 hideInfo( ) </li>
 * </ul>
 *
 * @apiName  showInfo
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} info  要显示的提示信息，
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *   showInfo("*正在处理中... ");
 *   showInfo(" 正在下载");
 *
 *   hideInfo();
 *
 *
 */
function showInfo(info)
{

    hideInfo();
    if (info.startsWith("*")) {
        info = info.substring(1);
        info = `<table border='0'><tr><td><i class='fa fa-cog fa-spin fa-2x fa-fw'></i></td>
                            <td>${info}</td></tr></table>`;

    }

    var p = {
        theme: 'light',
        lazyOpen: true,
        closeIcon:false,
        useBootstrap:false,
        boxWidth:'400px',
        draggable: true,
        animation: 'zoom',
        closeAnimation: 'scale',
        title: '',
        content: '<div class="text-center" style="font-size:14px;">' + info +"</div>",
     };

    var dlg = $.dialog(p);
    dlg.open();
    window['global_info_dlg'] =dlg;

}


/**
 * @api {hideInfo} 函数   hideInfo
 *
 * @apiDescription  hideInfo(   )
 * <br><br> 关闭由showInfo 打开的模态提示信息窗口
 * <br>
 * @apiName  hideInfo
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *   showInfo("*正在处理中... ");
 *
 *
 *   hideInfo();
 *
 *
 */
function hideInfo()
{
    var dlg=window['global_info_dlg'];
    if(dlg) dlg.close();
}

/**
 * @api {$.confirm} 函数   $.confirm
 *
 * @apiDescription  $.confirm( config )
 * <br><br> 显示一个带有指定消息和 OK 及取消按钮的对话框
 * <br>
 *
 * @apiName  $.confirm
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {Object} config  设置信息，详见示例
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *

 $.confirm({
    title: '提示!',
    content: '删除无法恢复，确信要删除吗?',
    buttons: {
        confirm: {
            text: "确定",
            action: function () {
                 // 按下确定按钮后执行
            }

        },
        cancel: {
            text: '取消',
            action: function () {
                  // 按下确定按钮后执行
            }
        }
    }
});

 */


/**
 * @api {$.alert} 函数  $.alert
 *
 * @apiDescription  $.alert( info )
 * <br><br> 显示一个提示信息（异步显示，并不阻塞脚本的继续执行) 如果要在点击关闭后再执行
 * 一点什么，请使用 $alert 函数
 * <br>
 *
 * @apiName  $.alert
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} info  要显示的信息
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *     alert("1"); //同步显示的，在关闭前，脚本处于阻塞状态
 *     $.alert("2"); //异步的，所以下面的3会先显示
 *     alert("3");
 *
 *     //上述示例，将弹出显示 1， 3 ， 最后显示 2
 */


/**
 * @api {$alert} 函数  $alert
 *
 * @apiDescription  $alert( title, info ,callback )
 * <br><br> 显示一个提示信息（异步显示，并不阻塞脚本的继续执行。并在点击关闭后，执行
 * 一个回调函数
 * <br>
 *
 * @apiName  $alert
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} title  标题
 * @apiParam {String} info  要显示的信息
 *@apiParam {Function} callback  点击关闭后的回调函数
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *    $alert('提示','保存成功' , function() {  alert('ok');} );
 *
 */


function $alert( title, content , callback) {
    $.confirm({
        title: title || '',
        content: content || '',
        closeButton:false,
        buttons: {

            cancel: {
                text: '关闭',
                action: function () {
                    if(callback) callback();
                }
            }
        }
    });
}




/**
 * @api {$confirm} 函数   $confirm
 *
 * @apiDescription  $confirm( title, info , callback_ok , callback_cancel )
 * <br><br> 显示一个带有指定消息和 OK 及取消按钮的对话框 ， 本函数是对$.confirm的简化
 * <br>
 *
 * @apiName  $confirm
 * @apiGroup SystemGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} title  标题
 * @apiParam {String} info 提示信息
 *@apiParam {Function} callback_ok  点击确认后执行的回调函数
 *@apiParam {Function} callback_cancel  点击取消后执行的回调函数，可选参数
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  $confirm("提示","确信要删除吗?", function(){ delete();}   function(){alert("cancel")});
 *
 */


/**
 * @api {showAttachmentList} 函数   showAttachmentList
 *
 * @apiDescription  showAttachmentList(  tableName , gguid , width ,height , readOnly)
 * <br><br> 显示附件列表
 * <br>
 *
 * @apiName  showAttachmentList
 * @apiGroup DialogGroup
 * @apiVersion 1.0.0
 *
 * @apiParam {String} tableName  主表名称
 * @apiParam {String} gguid  数据记录的GGUID
 *@apiParam {int} width 窗口宽度
 *@apiParam {int} height 窗口高度
 * @apiParam {boolean} readOnly  只读
 *
 *
 * @apiSuccess (返回值){void} - 无返回值
 *
 * @apiExample   {js}示例：
 *
 *  showAttachmentList( "abc" , "xafaed-sfafaefa-aseer2s454" , 700,400, true);
 *
 *
 */
function  showAttachmentList( tableName , gguid , width ,height , readOnly)
{
    openDialogURL("附件清单 ",'attachmentlist.jsp?gguid='+gguid+'&tableName='+tableName+"&readOnly="+readOnly,width,height,null  );
}